/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard.fromdb;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.SourceGroupUISupport;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EntityResourcesSetupPanelVisual
extends JPanel
implements AbstractPanel.Settings {
    private Project project;
    private List<ChangeListener> listeners;
    private WizardDescriptor wizard;
    private JComboBox converterPackageComboBox;
    private JLabel converterPackageLabel;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JComboBox resourcePackageComboBox;
    private JLabel resourcePackageLabel;

    public EntityResourcesSetupPanelVisual(String string) {
        this.initComponents();
        this.setName(string);
        this.listeners = new ArrayList<ChangeListener>();
        this.resourcePackageComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                EntityResourcesSetupPanelVisual.this.fireChange();
            }
        });
        this.converterPackageComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                EntityResourcesSetupPanelVisual.this.fireChange();
            }
        });
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.resourcePackageLabel = new JLabel();
        this.resourcePackageComboBox = new JComboBox();
        this.converterPackageLabel = new JLabel();
        this.converterPackageComboBox = new JComboBox();
        this.setName("null");
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntityResourcesSetupPanelVisual.this.locationComboBoxActionPerformed(actionEvent);
            }
        });
        this.resourcePackageLabel.setLabelFor(this.resourcePackageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.resourcePackageLabel, (String)NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"LBL_Package"));
        this.resourcePackageComboBox.setEditable(true);
        this.resourcePackageComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EntityResourcesSetupPanelVisual.this.resourcePackageComboBoxItemStateChanged(itemEvent);
            }
        });
        this.resourcePackageComboBox.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EntityResourcesSetupPanelVisual.this.resourcePackageComboBoxPropertyChange(propertyChangeEvent);
            }
        });
        this.converterPackageLabel.setLabelFor(this.converterPackageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.converterPackageLabel, (String)NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"LBL_ResourceDir"));
        this.converterPackageComboBox.setEditable(true);
        this.converterPackageComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EntityResourcesSetupPanelVisual.this.converterPackageComboBoxItemStateChanged(itemEvent);
            }
        });
        this.converterPackageComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntityResourcesSetupPanelVisual.this.converterPackageComboBoxActionPerformed(actionEvent);
            }
        });
        this.converterPackageComboBox.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EntityResourcesSetupPanelVisual.this.converterPackageComboBoxPropertyChange(propertyChangeEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.projectLabel).add(48, 48, 48).add((Component)this.projectTextField, -1, 393, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.converterPackageLabel, -1, -1, Short.MAX_VALUE).add((Component)this.resourcePackageLabel).add((Component)this.locationLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.locationComboBox, 0, 369, Short.MAX_VALUE).add((Component)this.resourcePackageComboBox, 0, 369, Short.MAX_VALUE).add(2, (Component)this.converterPackageComboBox, 0, 369, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectTextField, -2, -1, -2).add((Component)this.projectLabel)).add(32, 32, 32).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.locationComboBox, -2, 25, -2).add((Component)this.locationLabel)).add(32, 32, 32).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.resourcePackageComboBox, -2, -1, -2).add((Component)this.resourcePackageLabel)).add(40, 40, 40).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.converterPackageComboBox, -2, -1, -2).add((Component)this.converterPackageLabel)).addContainerGap(69, Short.MAX_VALUE)));
        this.projectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"Project"));
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_Project"));
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"Project"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_Project"));
        this.locationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"Location"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_Location"));
        this.resourcePackageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"ResourcePackage"));
        this.resourcePackageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.resourcePackageComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"ResourcePackage"));
        this.resourcePackageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.converterPackageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"ConverterPackage"));
        this.converterPackageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_ConverterPackage"));
        this.converterPackageComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"ConverterPackage"));
        this.converterPackageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_ConverterPackage"));
    }

    private void converterPackageComboBoxItemStateChanged(ItemEvent itemEvent) {
    }

    private void resourcePackageComboBoxItemStateChanged(ItemEvent itemEvent) {
    }

    private void locationComboBoxActionPerformed(ActionEvent actionEvent) {
        this.locationChanged();
    }

    private void resourcePackageComboBoxPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireChange();
    }

    private void converterPackageComboBoxPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireChange();
    }

    private void converterPackageComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        AbstractPanel.clearErrorMessage(wizardDescriptor);
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.project);
        if (sourceGroupArray == null || sourceGroupArray.length < 1) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_NoJavaSourceRoots");
        } else {
            if (!Util.isValidPackageName(this.getResourcePackage())) {
                AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_InvalidResourcePackageName");
                return false;
            }
            if (!Util.isValidPackageName(this.getConverterPackage())) {
                AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_InvalidConverterPackageName");
                return false;
            }
        }
        return true;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getResourcePackage() {
        return ((JTextComponent)this.resourcePackageComboBox.getEditor().getEditorComponent()).getText();
    }

    public String getConverterPackage() {
        return ((JTextComponent)this.converterPackageComboBox.getEditor().getEditorComponent()).getText();
    }

    private void setResourcePackage(String string) {
        ((JTextComponent)this.resourcePackageComboBox.getEditor().getEditorComponent()).setText(string);
    }

    private void setConverterPackage(String string) {
        ((JTextComponent)this.converterPackageComboBox.getEditor().getEditorComponent()).setText(string);
    }

    private void locationChanged() {
        this.updateSourceGroupPackages();
        this.fireChange();
    }

    public void read(WizardDescriptor wizardDescriptor) {
        if (this.project != null) {
            return;
        }
        this.wizard = wizardDescriptor;
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroupArray);
        this.resourcePackageComboBox.setRenderer(PackageView.listRenderer());
        this.converterPackageComboBox.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)wizardDescriptor);
        SourceGroup sourceGroup = null;
        if (fileObject == null) {
            sourceGroup = this.getSourceGroup();
            fileObject = sourceGroup.getRootFolder();
        } else {
            sourceGroup = SourceGroupSupport.findSourceGroupForFile(sourceGroupArray, fileObject);
            this.setSourceGroup(sourceGroup);
        }
        String string = SourceGroupSupport.getPackageForFolder(sourceGroup, fileObject);
        string = string.length() == 0 ? "" : string + ".";
        String string2 = string + "service";
        this.setResourcePackage(string2);
        String string3 = string + "converter";
        this.setConverterPackage(string3);
        this.addComboBoxListener(this.resourcePackageComboBox);
        this.addComboBoxListener(this.converterPackageComboBox);
    }

    public void store(WizardDescriptor wizardDescriptor) {
        if (Templates.getTargetFolder((WizardDescriptor)wizardDescriptor) == null) {
            Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)this.getSourceGroup().getRootFolder());
        }
        wizardDescriptor.putProperty("resourcePackage", (Object)this.getResourcePackage());
        wizardDescriptor.putProperty("converterPackage", (Object)this.getConverterPackage());
    }

    private void addComboBoxListener(JComboBox jComboBox) {
        JTextComponent jTextComponent = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        jTextComponent.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel comboBoxModel = PackageView.createListView((SourceGroup)sourceGroup);
            if (comboBoxModel.getSize() > 0) {
                comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
            }
            this.resourcePackageComboBox.setModel(comboBoxModel);
            comboBoxModel = PackageView.createListView((SourceGroup)sourceGroup);
            if (comboBoxModel.getSize() > 0) {
                comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
            }
            this.converterPackageComboBox.setModel(comboBoxModel);
        }
    }

    private SourceGroup getSourceGroup() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    private void setSourceGroup(SourceGroup sourceGroup) {
        this.locationComboBox.setSelectedItem(sourceGroup);
    }
}

