/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.java.platform.PlatformInstall;
import org.netbeans.spi.mobility.cldcplatform.CustomCLDCPlatformConfigurator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LocationChooser
extends JFileChooser
implements PropertyChangeListener {
    private static final Dimension PREFERRED_SIZE = new Dimension(600, 340);
    private WizardDescriptor.InstantiatingIterator<WizardDescriptor> iterator;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private PlatformFileView platformFileView;

    public LocationChooser(File file) {
        super(file);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setName(NbBundle.getMessage(LocationChooser.class, (String)"Title_FindPanel_Choose_To_Search"));
        this.setFileSelectionMode(1);
        this.setMultiSelectionEnabled(false);
        this.setControlButtonsAreShown(false);
        this.setFileFilter(new PlatformFileFilter());
        this.platformFileView = new PlatformFileView(this.getFileSystemView());
        this.setFileView(this.platformFileView);
        this.addPropertyChangeListener(this);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LocationChooser.class, (String)"AD_LocationChooser"));
        this.getActionMap().put("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Container container = LocationChooser.this.getParent();
                while ((container = container.getParent()) != null && !(container instanceof Window)) {
                }
                if (container != null) {
                    ((Window)container).setVisible(false);
                }
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.setBorder(null);
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            PlatformInstall platformInstall;
            FileObject fileObject;
            this.iterator = null;
            File file = this.getSelectedFile();
            if (file != null && (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)(file = FileUtil.normalizeFile((File)file))))) != null && (platformInstall = this.platformFileView.getPlatformInstall()) != null && platformInstall.accept(fileObject)) {
                this.iterator = platformInstall.createIterator(fileObject);
            }
            this.cs.fireChange();
        }
    }

    private static class PlatformFileView
    extends FileView {
        private final Icon BADGE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/java/platform/resources/platformBadge.gif"));
        private final Icon EMPTY = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/java/platform/resources/empty.gif"));
        private FileSystemView fsv;
        private Icon lastOriginal;
        private Icon lastMerged;
        private PlatformInstall platformInstall;

        public PlatformFileView(FileSystemView fileSystemView) {
            this.fsv = fileSystemView;
        }

        public Icon getIcon(File file) {
            File file2 = FileUtil.normalizeFile((File)file);
            Icon icon = this.fsv.getSystemIcon(file2);
            if (icon == null) {
                icon = this.EMPTY;
            }
            if (this.isPlatformDir(file2)) {
                if (icon.equals(this.lastOriginal)) {
                    return this.lastMerged;
                }
                this.lastOriginal = icon;
                this.lastMerged = new MergedIcon(icon, this.BADGE, -1, -1);
                return this.lastMerged;
            }
            return icon;
        }

        public void setPlatformInstall(PlatformInstall platformInstall) {
            this.platformInstall = platformInstall;
        }

        public PlatformInstall getPlatformInstall() {
            return this.platformInstall;
        }

        private boolean isPlatformDir(File file) {
            FileObject fileObject;
            int n = Utilities.getOperatingSystem();
            if (n == 8 || n == 256) {
                return false;
            }
            FileObject fileObject2 = fileObject = file != null ? PlatformFileView.convertToValidDir(file) : null;
            if (fileObject != null) {
                try {
                    if (Utilities.isUnix() && (fileObject.getParent() == null || fileObject.getFileSystem().getRoot().equals(fileObject.getParent()))) {
                        return false;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return false;
                }
                return this.isPossibleJ2MEPlatform(FileUtil.toFile((FileObject)fileObject));
            }
            return false;
        }

        public boolean isPossibleJ2MEPlatform(File file) {
            Collection collection = Lookup.getDefault().lookupAll(CustomCLDCPlatformConfigurator.class);
            for (CustomCLDCPlatformConfigurator customCLDCPlatformConfigurator : collection) {
                if (!customCLDCPlatformConfigurator.isPossiblePlatform(file)) continue;
                return true;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            return fileObject != null && J2MEPlatform.findTool("emulator", Collections.singletonList(fileObject)) != null && J2MEPlatform.findTool("preverify", Collections.singletonList(fileObject)) != null;
        }

        private static FileObject convertToValidDir(File file) {
            File file2 = new File(file.getPath());
            if (file2 == null || file2.getParent() == null) {
                return null;
            }
            if (!file2.isDirectory()) {
                return null;
            }
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            return fileObject;
        }
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon, Icon icon2, int n, int n2) {
            this.icon1 = icon;
            this.icon2 = icon2;
            if (n == -1) {
                n = icon.getIconWidth() - icon2.getIconWidth();
            }
            if (n2 == -1) {
                n2 = icon.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = n;
            this.yMerge = n2;
        }

        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon1.paintIcon(component, graphics, n, n2);
            this.icon2.paintIcon(component, graphics, n + this.xMerge, n2 + this.yMerge);
        }
    }

    private static class PlatformFileFilter
    extends FileFilter {
        private PlatformFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }

        public String getDescription() {
            return NbBundle.getMessage(LocationChooser.class, (String)"TXT_PlatformFolder");
        }
    }
}

