/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.util;

import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.deep.CsmCaseStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmTracer {
    private static final String NULL_TEXT = "null";
    private final int step = 4;
    private StringBuilder indentBuffer = new StringBuilder();
    private boolean deep = true;
    private boolean testUniqueName = false;
    private PrintStream printStream;
    private boolean dumpTemplateParameters = false;
    private final Object modelChangeEventLock = new Object();

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    public CsmTracer() {
        this.printStream = System.out;
    }

    public CsmTracer(boolean bl) {
        this.printStream = bl ? System.err : System.out;
    }

    public CsmTracer(PrintStream printStream) {
        this.printStream = printStream;
    }

    public void setDeep(boolean bl) {
        this.deep = bl;
    }

    public void setDumpTemplateParameters(boolean bl) {
        this.dumpTemplateParameters = bl;
    }

    public void setTestUniqueName(boolean bl) {
        this.testUniqueName = bl;
    }

    public void indent() {
        this.setupIndentBuffer(this.indentBuffer.length() + 4);
    }

    public void unindent() {
        this.setupIndentBuffer(this.indentBuffer.length() - 4);
    }

    private void setupIndentBuffer(int n) {
        if (n <= 0) {
            this.indentBuffer.setLength(0);
        } else {
            this.indentBuffer.setLength(n);
            for (int i = 0; i < n; ++i) {
                this.indentBuffer.setCharAt(i, ' ');
            }
        }
    }

    public void print(String string) {
        this.print(string, true);
    }

    protected PrintStream getStream() {
        return this.printStream;
    }

    public void print(String string, boolean bl) {
        PrintStream printStream = this.getStream();
        if (bl) {
            printStream.print('\n');
            printStream.print(this.indentBuffer.toString());
        }
        printStream.print(string);
    }

    public static String toString(CsmObject csmObject) {
        String string = CsmKindUtilities.isMacro(csmObject) ? CsmTracer.toString((CsmMacro)csmObject) : (CsmKindUtilities.isInclude(csmObject) ? CsmTracer.toString((CsmInclude)csmObject) : (CsmKindUtilities.isNamespace(csmObject) ? CsmTracer.toString((CsmNamespace)csmObject) : (CsmKindUtilities.isClassifier(csmObject) ? CsmTracer.toString((CsmClassifier)csmObject) : (CsmKindUtilities.isFunction(csmObject) ? CsmTracer.toString((CsmFunction)csmObject) : (CsmKindUtilities.isVariable(csmObject) ? CsmTracer.toString((CsmVariable)csmObject) : (CsmKindUtilities.isDeclaration(csmObject) ? CsmTracer.toString((CsmDeclaration)csmObject) : (CsmKindUtilities.isType(csmObject) ? "TYPE " + CsmTracer.toString((CsmType)csmObject, true) : (CsmKindUtilities.isExpression(csmObject) ? CsmTracer.toString((CsmExpression)csmObject, true) : (CsmKindUtilities.isStatement(csmObject) ? CsmTracer.toString((CsmStatement)csmObject) : (CsmKindUtilities.isOffsetable(csmObject) ? CsmTracer.getOffsetString(csmObject, true) : (CsmKindUtilities.isFile(csmObject) ? "FILE " + CsmTracer.toString((CsmFile)csmObject) : (csmObject == null ? "" : "UNKNOWN CSM OBJECT ") + csmObject)))))))))));
        return string;
    }

    public static String toString(CsmNamespace csmNamespace) {
        if (csmNamespace == null) {
            return NULL_TEXT;
        }
        return "NS " + csmNamespace.getQualifiedName();
    }

    public static String toString(CsmMacro csmMacro) {
        if (csmMacro == null) {
            return NULL_TEXT;
        }
        return "MACROS " + csmMacro;
    }

    public static String toString(CsmInclude csmInclude) {
        if (csmInclude == null) {
            return NULL_TEXT;
        }
        return "INCLUDE " + csmInclude;
    }

    public static String toString(CsmStatement csmStatement) {
        if (csmStatement == null) {
            return NULL_TEXT;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("STMT ").append((Object)csmStatement.getKind()).append(" ");
        stringBuilder.append("text='");
        stringBuilder.append(csmStatement.getText());
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    public static String toString(CsmExpression csmExpression, boolean bl) {
        if (csmExpression == null) {
            return NULL_TEXT;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("EXPR ").append((Object)csmExpression.getKind()).append(" ");
        }
        stringBuilder.append("text='");
        stringBuilder.append(csmExpression.getText());
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    public static String toString(CsmInheritance csmInheritance) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CLASS=");
        CsmClassifier csmClassifier = csmInheritance.getClassifier();
        stringBuilder.append(csmClassifier == null ? NULL_TEXT : csmClassifier.getQualifiedName());
        stringBuilder.append(" VISIBILITY==" + (Object)((Object)csmInheritance.getVisibility()));
        stringBuilder.append(" virtual==" + csmInheritance.isVirtual());
        stringBuilder.append(" text='");
        stringBuilder.append(csmInheritance.getText());
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    public static String toString(CsmCondition csmCondition) {
        if (csmCondition == null) {
            return NULL_TEXT;
        }
        StringBuilder stringBuilder = new StringBuilder(csmCondition.getKind().toString());
        stringBuilder.append(' ');
        if (csmCondition.getKind() == CsmCondition.Kind.EXPRESSION) {
            stringBuilder.append(CsmTracer.toString(csmCondition.getExpression(), false));
        } else {
            CsmVariable csmVariable = csmCondition.getDeclaration();
            stringBuilder.append(CsmTracer.toString(csmVariable, false));
        }
        return stringBuilder.toString();
    }

    public static String toString(CsmDeclaration csmDeclaration) {
        return (Object)((Object)csmDeclaration.getKind()) + " " + CsmTracer.toString(csmDeclaration, true);
    }

    private static String toString(CsmDeclaration csmDeclaration, boolean bl) {
        if (csmDeclaration == null) {
            return NULL_TEXT;
        }
        return csmDeclaration.getQualifiedName() + CsmTracer.getOffsetString(csmDeclaration, bl);
    }

    public static String toString(CsmClassifier csmClassifier) {
        return (Object)((Object)csmClassifier.getKind()) + " " + CsmTracer.toString(csmClassifier, true);
    }

    private static String toString(CsmClassifier csmClassifier, boolean bl) {
        if (csmClassifier == null) {
            return NULL_TEXT;
        }
        return csmClassifier.getQualifiedName() + CsmTracer.getOffsetString(csmClassifier, bl);
    }

    private static String toString(CsmType csmType, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (csmType == null) {
            stringBuilder.append(NULL_TEXT);
        } else {
            CsmClassifier csmClassifier;
            if (csmType.isTemplateBased()) {
                // empty if block
            }
            if (csmType.isConst()) {
                stringBuilder.append("const ");
            }
            if (csmType.isPointer()) {
                for (int i = 0; i < csmType.getPointerDepth(); ++i) {
                    stringBuilder.append("*");
                }
            }
            if (csmType.isReference()) {
                stringBuilder.append("&");
            }
            if ((csmClassifier = csmType.getClassifier()) != null) {
                stringBuilder.append(csmClassifier.getQualifiedName());
            } else {
                stringBuilder.append("<*no_classifier*>");
            }
            for (int i = 0; i < csmType.getArrayDepth(); ++i) {
                stringBuilder.append("[]");
            }
            stringBuilder.append(" TEXT=" + csmType.getText());
        }
        if (csmType instanceof CsmOffsetable) {
            stringBuilder.append(' ');
            stringBuilder.append(CsmTracer.getOffsetString(csmType, bl));
        }
        return stringBuilder.toString();
    }

    public static String toString(CsmFile csmFile) {
        if (csmFile == null) {
            return NULL_TEXT;
        }
        File file = new File(((Object)csmFile.getAbsolutePath()).toString()).getParentFile();
        return (file != null ? file.getName() + "/" : "") + csmFile.getName();
    }

    public static String toString(CsmVariable csmVariable) {
        return (Object)((Object)csmVariable.getKind()) + " " + CsmTracer.toString(csmVariable, true);
    }

    private static String toString(CsmVariable csmVariable, boolean bl) {
        if (csmVariable == null) {
            return NULL_TEXT;
        }
        StringBuilder stringBuilder = new StringBuilder(csmVariable.getName());
        stringBuilder.append(CsmTracer.getOffsetString(csmVariable, bl));
        stringBuilder.append("  TYPE: " + CsmTracer.toString(csmVariable.getType(), false));
        stringBuilder.append("  INIT: " + CsmTracer.toString(csmVariable.getInitialValue(), false));
        stringBuilder.append("  " + CsmTracer.getScopeString(csmVariable));
        return stringBuilder.toString();
    }

    public static String toString(CsmFunction csmFunction) {
        return (Object)((Object)csmFunction.getKind()) + " " + CsmTracer.toString(csmFunction, true);
    }

    private static String toString(CsmFunction csmFunction, boolean bl) {
        if (csmFunction == null) {
            return NULL_TEXT;
        }
        return (bl ? ((Object)csmFunction.getSignature()).toString() : ((Object)csmFunction.getName()).toString()) + ' ' + CsmTracer.getOffsetString(csmFunction, bl);
    }

    public void dumpModel(CsmFunction csmFunction) {
        this.print("FUNCTION " + csmFunction.getName() + CsmTracer.getOffsetString(csmFunction, false) + ' ' + this.getBriefClassName(csmFunction) + ' ' + CsmTracer.getScopeString(csmFunction));
        if (csmFunction instanceof CsmFunctionDefinition && this.deep) {
            this.dumpStatement(((CsmFunctionDefinition)csmFunction).getBody());
        }
        this.indent();
        this.print("DEFINITION: " + CsmTracer.toString(csmFunction.getDefinition(), false));
        this.print("SIGNATURE " + csmFunction.getSignature());
        this.print("UNIQUE NAME " + csmFunction.getUniqueName());
        if (csmFunction instanceof CsmFriendFunction) {
            this.print("REFERENCED FRIEND FUNCTION: " + CsmTracer.toString(((CsmFriendFunction)csmFunction).getReferencedFunction(), false));
        }
        if (this.dumpTemplateParameters && CsmKindUtilities.isTemplate(csmFunction)) {
            this.dumpTemplateParameters((CsmTemplate)((Object)csmFunction));
        }
        this.dumpParameters(csmFunction.getParameters());
        this.print("RETURNS " + CsmTracer.toString(csmFunction.getReturnType(), false));
        this.unindent();
    }

    public void dumpModel(CsmFunctionDefinition csmFunctionDefinition) {
        CsmFunction csmFunction = csmFunctionDefinition.getDeclaration();
        this.print("FUNCTION DEFINITION " + csmFunctionDefinition.getName() + ' ' + CsmTracer.getOffsetString(csmFunctionDefinition, false) + ' ' + this.getBriefClassName(csmFunctionDefinition) + ' ' + CsmTracer.getScopeString(csmFunctionDefinition));
        this.indent();
        this.print("SIGNATURE " + csmFunctionDefinition.getSignature());
        this.print("UNIQUE NAME " + csmFunctionDefinition.getUniqueName());
        this.print("DECLARATION: " + CsmTracer.toString(csmFunction, false));
        if (this.dumpTemplateParameters && CsmKindUtilities.isTemplate(csmFunctionDefinition)) {
            this.dumpTemplateParameters((CsmTemplate)((Object)csmFunctionDefinition));
        }
        this.dumpParameters(csmFunctionDefinition.getParameters());
        this.print("RETURNS " + CsmTracer.toString(csmFunctionDefinition.getReturnType(), false));
        if (this.deep) {
            this.dumpStatement((CsmStatement)csmFunctionDefinition.getBody());
        }
        this.unindent();
    }

    public static String getScopeString(CsmScopeElement csmScopeElement) {
        StringBuilder stringBuilder = new StringBuilder("SCOPE: ");
        int n = stringBuilder.length();
        CsmScope csmScope = csmScopeElement.getScope();
        if (csmScope == null) {
            stringBuilder.append(NULL_TEXT);
        } else {
            if (CsmKindUtilities.isFile(csmScope)) {
                stringBuilder.append(((CsmFile)csmScope).getName());
            } else if (CsmKindUtilities.isNamedElement(csmScope)) {
                stringBuilder.append(((CsmNamedElement)((Object)csmScope)).getName());
                stringBuilder.append(' ');
            } else {
                if (CsmKindUtilities.isStatement(csmScope)) {
                    CsmStatement csmStatement = (CsmStatement)((Object)csmScope);
                    stringBuilder.append("Stmt ");
                }
                if (CsmKindUtilities.isOffsetable(csmScope)) {
                    stringBuilder.append(CsmTracer.getOffsetString(csmScope, false));
                }
            }
            if (stringBuilder.length() == n) {
                stringBuilder.append("???");
            }
        }
        return stringBuilder.toString();
    }

    public static String getOffsetString(CsmObject csmObject, boolean bl) {
        if (!CsmKindUtilities.isOffsetable(csmObject)) {
            return "";
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        return " [" + csmOffsetable.getStartPosition() + '-' + csmOffsetable.getEndPosition() + ']' + (bl ? " " + CsmTracer.toString(csmOffsetable.getContainingFile()) : "");
    }

    public String getBriefClassName(Object object) {
        return this.getBriefClassName(object.getClass());
    }

    public String getBriefClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void dumpParameters(Collection collection) {
        this.print("PARAMETERS:");
        if (collection != null && collection.size() > 0) {
            this.indent();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.print(CsmTracer.toString((CsmParameter)iterator.next(), false));
            }
            this.unindent();
        }
    }

    public void dumpStatement(CsmStatement csmStatement) {
        if (csmStatement == null) {
            this.print("STATEMENT is null");
            return;
        }
        this.print("STATEMENT " + (Object)((Object)csmStatement.getKind()) + ' ' + CsmTracer.getOffsetString(csmStatement, false) + ' ' + CsmTracer.getScopeString(csmStatement));
        this.indent();
        CsmStatement.Kind kind = csmStatement.getKind();
        if (kind == CsmStatement.Kind.COMPOUND) {
            this.dumpStatement((CsmCompoundStatement)csmStatement);
        } else if (kind == CsmStatement.Kind.IF) {
            this.dumpStatement((CsmIfStatement)csmStatement);
        } else if (kind == CsmStatement.Kind.TRY_CATCH) {
            this.dumpStatement((CsmTryCatchStatement)csmStatement);
        } else if (kind == CsmStatement.Kind.CATCH) {
            this.dumpStatement((CsmExceptionHandler)csmStatement);
        } else if (kind == CsmStatement.Kind.DECLARATION) {
            this.dumpStatement((CsmDeclarationStatement)csmStatement);
        } else if (kind == CsmStatement.Kind.WHILE || kind == CsmStatement.Kind.DO_WHILE) {
            this.dumpStatement((CsmLoopStatement)csmStatement);
        } else if (kind == CsmStatement.Kind.FOR) {
            this.dumpStatement((CsmForStatement)csmStatement);
        } else if (kind == CsmStatement.Kind.SWITCH) {
            this.dumpStatement((CsmSwitchStatement)((Object)csmStatement));
        } else if (kind == CsmStatement.Kind.CASE) {
            this.dumpStatement((CsmCaseStatement)csmStatement);
        } else if (kind != CsmStatement.Kind.BREAK && kind != CsmStatement.Kind.CONTINUE && kind != CsmStatement.Kind.DEFAULT) {
            if (kind == CsmStatement.Kind.EXPRESSION) {
                this.print(" text: '" + csmStatement.getText() + '\'', false);
            } else if (kind == CsmStatement.Kind.GOTO) {
                this.print(" text: '" + csmStatement.getText() + '\'', false);
            } else if (kind == CsmStatement.Kind.LABEL) {
                this.print(" text: '" + csmStatement.getText() + '\'', false);
            } else if (kind == CsmStatement.Kind.RETURN) {
                this.print(" text: '" + csmStatement.getText() + '\'', false);
            } else {
                this.print("unexpected statement kind");
            }
        }
        this.unindent();
    }

    public void dumpStatement(CsmCompoundStatement csmCompoundStatement) {
        if (csmCompoundStatement != null) {
            Iterator<CsmStatement> iterator = csmCompoundStatement.getStatements().iterator();
            while (iterator.hasNext()) {
                this.dumpStatement(iterator.next());
            }
        }
    }

    public void dumpStatement(CsmTryCatchStatement csmTryCatchStatement) {
        this.print("TRY:");
        this.dumpStatement(csmTryCatchStatement.getTryStatement());
        this.print("HANDLERS:");
        Iterator<CsmExceptionHandler> iterator = csmTryCatchStatement.getHandlers().iterator();
        while (iterator.hasNext()) {
            this.dumpStatement((CsmStatement)iterator.next());
        }
    }

    public void dumpStatement(CsmExceptionHandler csmExceptionHandler) {
        this.print("PARAMETER: " + CsmTracer.toString(csmExceptionHandler.getParameter(), false));
        this.dumpStatement((CsmCompoundStatement)csmExceptionHandler);
    }

    public void dumpStatement(CsmIfStatement csmIfStatement) {
        this.print("CONDITION " + CsmTracer.toString(csmIfStatement.getCondition()));
        this.print("THEN: ");
        this.indent();
        this.dumpStatement(csmIfStatement.getThen());
        this.unindent();
        this.print("ELSE: ");
        this.indent();
        this.dumpStatement(csmIfStatement.getElse());
        this.unindent();
    }

    public void dumpStatement(CsmDeclarationStatement csmDeclarationStatement) {
        Iterator<CsmDeclaration> iterator = csmDeclarationStatement.getDeclarators().iterator();
        while (iterator.hasNext()) {
            this.dumpModel(iterator.next());
        }
    }

    public void dumpStatement(CsmLoopStatement csmLoopStatement) {
        this.print("CONDITION: " + CsmTracer.toString(csmLoopStatement.getCondition()) + " isPostCheck()=" + csmLoopStatement.isPostCheck());
        this.print("BODY:");
        this.indent();
        this.dumpStatement(csmLoopStatement.getBody());
        this.unindent();
    }

    public void dumpStatement(CsmForStatement csmForStatement) {
        this.print("INIT:");
        this.indent();
        this.dumpStatement(csmForStatement.getInitStatement());
        this.unindent();
        this.print("ITERATION: " + CsmTracer.toString(csmForStatement.getIterationExpression(), false));
        this.print("CONDITION: " + CsmTracer.toString(csmForStatement.getCondition()));
        this.print("BODY:");
        this.indent();
        this.dumpStatement(csmForStatement.getBody());
        this.unindent();
    }

    public void dumpStatement(CsmSwitchStatement csmSwitchStatement) {
        this.print("CONDITION: " + CsmTracer.toString(csmSwitchStatement.getCondition()));
        this.print("BODY:");
        this.indent();
        this.dumpStatement(csmSwitchStatement.getBody());
        this.unindent();
    }

    public void dumpStatement(CsmCaseStatement csmCaseStatement) {
        this.print(" EXPRESSION: " + CsmTracer.toString(csmCaseStatement.getExpression(), false), false);
    }

    public void dumpNamespaceDefinitions(CsmNamespace csmNamespace) {
        this.print("NAMESPACE DEFINITIONS for " + csmNamespace.getName() + " (" + csmNamespace.getQualifiedName() + ") ");
        this.indent();
        for (CsmNamespaceDefinition csmNamespaceDefinition : csmNamespace.getDefinitions()) {
            this.print(((Object)csmNamespaceDefinition.getContainingFile().getName()).toString() + ' ' + CsmTracer.getOffsetString(csmNamespaceDefinition, false));
        }
        this.unindent();
    }

    public void dumpModel(CsmProject csmProject) {
        CsmNamespace csmNamespace = csmProject.getGlobalNamespace();
        this.print("\n========== Dumping model of PROJECT " + csmProject.getName(), true);
        this.dumpModel(csmNamespace);
    }

    public void dumpModel(CsmNamespace csmNamespace) {
        if (!csmNamespace.isGlobal()) {
            this.dumpNamespaceDefinitions(csmNamespace);
            this.print("NAMESPACE " + csmNamespace.getName() + " (" + csmNamespace.getQualifiedName() + ") ");
            this.indent();
        }
        Iterator<CsmQualifiedNamedElement> iterator = this.getSortedDeclarations(csmNamespace);
        while (iterator.hasNext()) {
            this.dumpModel(iterator.next());
        }
        iterator = this.getSortedNestedNamespaces(csmNamespace);
        while (iterator.hasNext()) {
            this.dumpModel((CsmNamespace)iterator.next());
        }
        if (!csmNamespace.isGlobal()) {
            this.unindent();
        }
    }

    private Iterator<CsmOffsetableDeclaration> getSortedDeclarations(CsmNamespace csmNamespace) {
        TreeMap<String, CsmOffsetableDeclaration> treeMap = new TreeMap<String, CsmOffsetableDeclaration>();
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmNamespace.getDeclarations()) {
            treeMap.put(CsmTracer.getSortKey(csmOffsetableDeclaration), csmOffsetableDeclaration);
        }
        return treeMap.values().iterator();
    }

    private Iterator<CsmNamespace> getSortedNestedNamespaces(CsmNamespace csmNamespace) {
        TreeMap<CharSequence, CsmNamespace> treeMap = new TreeMap<CharSequence, CsmNamespace>(CharSequenceKey.Comparator);
        for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
            treeMap.put(csmNamespace2.getQualifiedName(), csmNamespace2);
        }
        return treeMap.values().iterator();
    }

    private static String getSortKey(CsmDeclaration csmDeclaration) {
        StringBuilder stringBuilder = new StringBuilder();
        if (csmDeclaration instanceof CsmOffsetable) {
            stringBuilder.append(((CsmOffsetable)((Object)csmDeclaration)).getContainingFile().getAbsolutePath());
            int n = ((CsmOffsetable)((Object)csmDeclaration)).getStartOffset();
            String string = Integer.toString(n);
            int n2 = 8 - string.length();
            while (n2-- > 0) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            stringBuilder.append(csmDeclaration.getName());
        } else {
            stringBuilder.append(csmDeclaration.getUniqueName());
        }
        return stringBuilder.toString();
    }

    public void dumpModel(CsmFile csmFile) {
        this.dumpModel(csmFile, "\n========== Dumping model of FILE " + csmFile.getName());
    }

    public void dumpModel(CsmFile csmFile, String string) {
        Object object;
        this.print(string);
        Collection<CsmInclude> collection2 = csmFile.getIncludes();
        this.print("Includes:");
        if (collection2.size() > 0) {
            for (CsmInclude collection3 : collection2) {
                this.print(collection3.toString());
            }
        } else {
            this.indent();
            this.print("<no includes>");
            this.unindent();
        }
        Collection<CsmMacro> collection4 = csmFile.getMacros();
        this.print("Macros:");
        if (collection4.size() > 0) {
            Iterator iterator = collection4.iterator();
            while (iterator.hasNext()) {
                object = (CsmMacro)iterator.next();
                this.print(object.toString());
            }
        } else {
            this.indent();
            this.print("<no macros>");
            this.unindent();
        }
        Collection<CsmOffsetableDeclaration> collection = csmFile.getDeclarations();
        object = collection.iterator();
        while (object.hasNext()) {
            this.dumpModel((CsmDeclaration)object.next());
        }
    }

    public void dumpModel(CsmVariable csmVariable) {
        this.print((csmVariable.isExtern() ? "EXTERN " : "") + "VARIABLE " + CsmTracer.toString(csmVariable, false));
        CsmVariableDefinition csmVariableDefinition = csmVariable.getDefinition();
        if (csmVariableDefinition != null) {
            this.indent();
            this.print("DEFINITION: " + CsmTracer.toString(csmVariableDefinition, false));
            this.unindent();
        }
    }

    public void dumpModel(CsmVariableDefinition csmVariableDefinition) {
        CsmVariable csmVariable = csmVariableDefinition.getDeclaration();
        this.print("VARIABLE DEFINITION " + CsmTracer.toString(csmVariableDefinition, false));
        this.indent();
        this.print("DECLARATION: " + CsmTracer.toString(csmVariable, false));
        this.unindent();
    }

    public void dumpModel(CsmField csmField) {
        StringBuilder stringBuilder = new StringBuilder("FIELD ");
        stringBuilder.append(csmField.getVisibility().toString());
        if (csmField.isStatic()) {
            stringBuilder.append(" static");
        }
        stringBuilder.append(" ");
        stringBuilder.append(CsmTracer.toString(csmField, false));
        this.print(stringBuilder.toString());
        CsmVariableDefinition csmVariableDefinition = csmField.getDefinition();
        if (csmVariableDefinition != null) {
            this.indent();
            this.print("DEFINITION: " + CsmTracer.toString(csmVariableDefinition, false));
            this.unindent();
        }
    }

    public void checkUniqueName(CsmDeclaration csmDeclaration) {
        CharSequence charSequence = csmDeclaration.getUniqueName();
        if (csmDeclaration instanceof CsmOffsetableDeclaration && this.needsCheckUniqueName(csmDeclaration)) {
            CsmProject csmProject = ((CsmOffsetable)((Object)csmDeclaration)).getContainingFile().getProject();
            CsmDeclaration csmDeclaration2 = csmProject.findDeclaration(charSequence);
            if (csmDeclaration2 == null) {
                this.print("Unique name check failed: cant't find in project: " + charSequence);
            } else if (csmDeclaration2 != csmDeclaration) {
                this.print("Unique name check failed: declaration found in project differs " + charSequence);
            }
        }
        if (!((Object)charSequence).toString().startsWith(csmDeclaration.getKind().toString())) {
            this.print("Warning: unique name '" + charSequence + "' desn't start with " + csmDeclaration.getKind().toString());
        }
    }

    protected boolean needsCheckUniqueName(CsmDeclaration csmDeclaration) {
        if (csmDeclaration.getName().length() == 0) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.USING_DECLARATION) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.USING_DIRECTIVE) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.ASM) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.BUILT_IN) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.VARIABLE_DEFINITION) {
            return false;
        }
        if (csmDeclaration.getKind() == CsmDeclaration.Kind.VARIABLE) {
            if (CsmKindUtilities.isLocalVariable(csmDeclaration)) {
                return false;
            }
            if (CsmKindUtilities.isFileLocalVariable(csmDeclaration)) {
                return false;
            }
        }
        return true;
    }

    public void dumpModel(CsmDeclaration csmDeclaration) {
        if (this.testUniqueName && csmDeclaration instanceof CsmOffsetableDeclaration) {
            this.checkUniqueName(csmDeclaration);
        }
        if (CsmKindUtilities.isClass(csmDeclaration)) {
            this.dumpModel((CsmClass)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.ENUM) {
            this.dumpModel((CsmEnum)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            this.dumpModel((CsmNamespaceDefinition)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION) {
            this.dumpModel((CsmFunction)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
            this.dumpModel((CsmFunctionDefinition)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.VARIABLE) {
            this.dumpModel((CsmVariable)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.VARIABLE_DEFINITION) {
            this.dumpModel((CsmVariableDefinition)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            this.dumpModel((CsmNamespaceAlias)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.USING_DECLARATION) {
            this.dumpModel((CsmUsingDeclaration)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.USING_DIRECTIVE) {
            this.dumpModel((CsmUsingDirective)csmDeclaration);
        } else if (csmDeclaration.getKind() == CsmDeclaration.Kind.TYPEDEF) {
            this.dumpModel((CsmTypedef)csmDeclaration);
        } else {
            String string = CsmTracer.getOffsetString(csmDeclaration, false);
            this.print("" + (Object)((Object)csmDeclaration.getKind()) + ' ' + csmDeclaration.getName() + string);
        }
    }

    public void dumpModel(CsmNamespaceAlias csmNamespaceAlias) {
        CsmNamespace csmNamespace = csmNamespaceAlias.getReferencedNamespace();
        String string = csmNamespace == null ? NULL_TEXT : ((Object)csmNamespace.getQualifiedName()).toString();
        this.print("ALIAS " + csmNamespaceAlias.getAlias() + ' ' + string + ' ' + CsmTracer.getOffsetString(csmNamespaceAlias, false) + ' ' + CsmTracer.getScopeString(csmNamespaceAlias));
    }

    public void dumpModel(CsmUsingDeclaration csmUsingDeclaration) {
        CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)csmUsingDeclaration.getReferencedDeclaration();
        String string = csmOffsetableDeclaration == null ? NULL_TEXT : ((Object)csmOffsetableDeclaration.getQualifiedName()).toString();
        this.print("USING DECL. " + csmUsingDeclaration.getName() + ' ' + CsmTracer.getOffsetString(csmUsingDeclaration, false) + "; REF DECL: " + string + ' ' + CsmTracer.getOffsetString(csmOffsetableDeclaration, false) + ' ' + CsmTracer.getScopeString(csmUsingDeclaration));
    }

    public void dumpModel(CsmTypedef csmTypedef) {
        this.print("TYPEDEF " + csmTypedef.getName() + ' ' + CsmTracer.getOffsetString(csmTypedef, false) + " TYPE: " + CsmTracer.toString(csmTypedef.getType(), false) + ' ' + CsmTracer.getScopeString(csmTypedef));
    }

    public void dumpModel(CsmUsingDirective csmUsingDirective) {
        CsmNamespace csmNamespace = csmUsingDirective.getReferencedNamespace();
        this.print("USING NAMESPACE. " + csmUsingDirective.getName() + ' ' + CsmTracer.getOffsetString(csmUsingDirective, false) + "; REF NS: " + (csmNamespace == null ? NULL_TEXT : csmNamespace.getQualifiedName()) + ' ' + CsmTracer.getScopeString(csmUsingDirective));
    }

    public void dumpTemplateParameters(CsmTemplate csmTemplate) {
        this.indent();
        this.print("TEMPLATE PARAMETERS:");
        this.indent();
        for (CsmTemplateParameter csmTemplateParameter : csmTemplate.getTemplateParameters()) {
            this.print(((Object)csmTemplateParameter.getName()).toString());
        }
        this.unindent();
        this.unindent();
    }

    public void dumpModel(CsmClass csmClass) {
        String string = csmClass.getKind() == CsmDeclaration.Kind.CLASS ? "CLASS" : (csmClass.getKind() == CsmDeclaration.Kind.STRUCT ? "STRUCT" : (csmClass.getKind() == CsmDeclaration.Kind.UNION ? "UNION" : "<unknown-CsmClass-kind>"));
        CharSequence charSequence = CsmKindUtilities.isTemplate(csmClass) ? ((CsmTemplate)((Object)csmClass)).getDisplayName() : csmClass.getName();
        this.print(string + ' ' + charSequence + " (" + csmClass.getQualifiedName() + " )" + CsmTracer.getOffsetString(csmClass, false) + " lcurly=" + csmClass.getLeftBracketOffset() + ' ' + CsmTracer.getScopeString(csmClass));
        if (this.dumpTemplateParameters && CsmKindUtilities.isTemplate(csmClass)) {
            this.dumpTemplateParameters((CsmTemplate)((Object)csmClass));
        }
        this.indent();
        this.print("BASE CLASSES:");
        this.indent();
        for (CsmInheritance collection2 : csmClass.getBaseClasses()) {
            this.print(CsmTracer.toString(collection2));
        }
        this.unindent();
        this.print("MEMBERS:");
        this.indent();
        Collection<CsmMember> collection3 = csmClass.getMembers();
        Iterator iterator = collection3.iterator();
        while (iterator.hasNext()) {
            CsmMember csmMember = (CsmMember)iterator.next();
            if (CsmKindUtilities.isClass(csmMember)) {
                this.dumpModel((CsmClass)((Object)csmMember));
                continue;
            }
            if (csmMember.getKind() == CsmDeclaration.Kind.ENUM) {
                this.dumpModel((CsmEnum)((Object)csmMember));
                continue;
            }
            if (csmMember.getKind() == CsmDeclaration.Kind.VARIABLE) {
                this.dumpModel((CsmField)csmMember);
                continue;
            }
            if (csmMember.getKind() == CsmDeclaration.Kind.FUNCTION) {
                this.dumpModel((CsmFunction)((Object)csmMember));
                continue;
            }
            if (csmMember.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
                this.dumpModel((CsmFunctionDefinition)((Object)csmMember));
                continue;
            }
            if (csmMember.getKind() == CsmDeclaration.Kind.TYPEDEF) {
                this.dumpModel((CsmTypedef)((Object)csmMember));
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder(csmMember.getKind().toString());
            stringBuilder.append(' ');
            stringBuilder.append(csmMember.getVisibility().toString());
            if (csmMember.isStatic()) {
                stringBuilder.append(" static");
            }
            stringBuilder.append(' ');
            stringBuilder.append(csmMember.getName());
            stringBuilder.append(CsmTracer.getOffsetString(csmMember, false));
            stringBuilder.append(' ');
            stringBuilder.append(this.getBriefClassName(csmMember));
            this.print(stringBuilder.toString());
        }
        this.unindent();
        Collection<CsmFriend> collection = csmClass.getFriends();
        if (!collection.isEmpty()) {
            this.print("FRIENDS:");
            this.indent();
            for (CsmFriend csmFriend : collection) {
                if (csmFriend.getKind() == CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION) {
                    CsmFriendClass csmFriendClass = (CsmFriendClass)csmFriend;
                    StringBuilder stringBuilder = new StringBuilder(csmFriendClass.getKind().toString());
                    stringBuilder.append(' ');
                    stringBuilder.append(csmFriend.getName());
                    stringBuilder.append(CsmTracer.getOffsetString(csmFriend, false));
                    stringBuilder.append(' ');
                    stringBuilder.append(this.getBriefClassName(csmFriend));
                    this.print(stringBuilder.toString());
                    this.indent();
                    CsmClass csmClass2 = csmFriendClass.getReferencedClass();
                    this.print("REFERENCED CLASS: " + csmClass2 == null ? "*UNRESOLVED*" : ((Object)csmClass2.getUniqueName()).toString());
                    this.unindent();
                    continue;
                }
                if (csmFriend.getKind() == CsmDeclaration.Kind.FUNCTION) {
                    this.dumpModel((CsmFunction)((Object)csmFriend));
                    continue;
                }
                if (csmFriend.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
                    this.dumpModel((CsmFunctionDefinition)((Object)csmFriend));
                    continue;
                }
                assert (false) : "unexpected friend object " + csmFriend;
            }
            this.unindent();
        }
        this.unindent();
    }

    public void dumpModel(CsmEnum csmEnum) {
        this.print("ENUM " + csmEnum.getName() + CsmTracer.getOffsetString(csmEnum, false) + ' ' + CsmTracer.getScopeString(csmEnum));
        this.indent();
        for (CsmEnumerator csmEnumerator : csmEnum.getEnumerators()) {
            StringBuilder stringBuilder = new StringBuilder(csmEnumerator.getName());
            if (csmEnumerator.getExplicitValue() != null) {
                stringBuilder.append(' ');
                stringBuilder.append(csmEnumerator.getExplicitValue().getText() + CsmTracer.getOffsetString(csmEnumerator, false));
            }
            this.print(stringBuilder.toString());
        }
        this.unindent();
    }

    public void dumpModel(CsmNamespaceDefinition csmNamespaceDefinition) {
        this.print("NAMESPACE DEFINITOIN " + csmNamespaceDefinition.getName() + CsmTracer.getOffsetString(csmNamespaceDefinition, false) + ' ' + CsmTracer.getScopeString(csmNamespaceDefinition));
        this.indent();
        Iterator<CsmOffsetableDeclaration> iterator = csmNamespaceDefinition.getDeclarations().iterator();
        while (iterator.hasNext()) {
            this.dumpModel(iterator.next());
        }
        this.unindent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpModelChangeEvent(CsmChangeEvent csmChangeEvent) {
        Object object = this.modelChangeEventLock;
        synchronized (object) {
            this.print("Model Changed Event:");
            this.dumpFilesCollection(csmChangeEvent.getNewFiles(), "New files");
            this.dumpFilesCollection(csmChangeEvent.getRemovedFiles(), "Removed files");
            this.dumpFilesCollection(csmChangeEvent.getChangedFiles(), "Changed files");
            this.dumpDeclarationsCollection(csmChangeEvent.getNewDeclarations(), "New declarations");
            this.dumpDeclarationsCollection(csmChangeEvent.getRemovedDeclarations(), "Removed declarations");
            this.dumpDeclarationsCollection(csmChangeEvent.getChangedDeclarations().keySet(), "Changed declarations");
            this.dumpNamespacesCollection(csmChangeEvent.getNewNamespaces(), "New namespaces");
            this.dumpNamespacesCollection(csmChangeEvent.getRemovedNamespaces(), "Removed namespaces");
            this.print("");
        }
    }

    public void dumpFilesCollection(Collection collection, String string) {
        if (!collection.isEmpty()) {
            this.print(string);
            this.indent();
            this.dumpFilesCollection(collection);
            this.unindent();
        }
    }

    public void dumpFilesCollection(Collection collection) {
        if (!collection.isEmpty()) {
            for (CsmFile csmFile : collection) {
                this.print(csmFile == null ? NULL_TEXT : ((Object)csmFile.getAbsolutePath()).toString());
            }
        }
    }

    public void dumpDeclarationsCollection(Collection collection, String string) {
        if (!collection.isEmpty()) {
            this.print(string);
            this.indent();
            this.dumpDeclarationsCollection(collection);
            this.unindent();
        }
    }

    public void dumpDeclarationsCollection(Collection collection) {
        if (!collection.isEmpty()) {
            for (CsmDeclaration csmDeclaration : collection) {
                this.print(csmDeclaration == null ? NULL_TEXT : csmDeclaration.getUniqueName() + " of kind: " + (Object)((Object)csmDeclaration.getKind()));
            }
        }
    }

    public void dumpNamespacesCollection(Collection collection, String string) {
        if (!collection.isEmpty()) {
            this.print(string);
            this.indent();
            this.dumpNamespacesCollection(collection);
            this.unindent();
        }
    }

    public void dumpNamespacesCollection(Collection collection) {
        if (!collection.isEmpty()) {
            for (CsmNamespace csmNamespace : collection) {
                this.print(csmNamespace == null ? NULL_TEXT : ((Object)csmNamespace.getQualifiedName()).toString());
            }
        }
    }
}

