/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmSortUtilities {
    public static final Comparator CLASS_NAME_COMPARATOR = new DefaultClassNameComparator();
    public static final Comparator INSENSITIVE_CLASS_NAME_COMPARATOR = new InsensitiveClassNameComparator();
    public static final Comparator NATURAL_MEMBER_NAME_COMPARATOR = new NaturalMemberNameComparator(true);
    public static final Comparator INSENSITIVE_NATURAL_MEMBER_NAME_COMPARATOR = new NaturalMemberNameComparator();
    public static final Comparator NATURAL_NAMESPACE_MEMBER_COMPARATOR = new NsNaturalMemberNameComparator(true);
    public static final Comparator INSENSITIVE_NATURAL_NAMESPACE_MEMBER_COMPARATOR = new NsNaturalMemberNameComparator(false);

    private CsmSortUtilities() {
    }

    public static boolean matchName(CharSequence charSequence, CharSequence charSequence2) {
        return CsmSortUtilities.matchName(charSequence, charSequence2, false);
    }

    public static boolean matchName(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return CsmSortUtilities.matchName(charSequence, charSequence2, bl, false);
    }

    public static boolean matchName(CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2) {
        int n = charSequence.length();
        if (n == 0) {
            return false;
        }
        int n2 = charSequence2.length();
        int n3 = 0;
        for (int i = 0; n3 < n && i < n2; ++n3, ++i) {
            char c;
            char c2 = charSequence.charAt(n3);
            if (c2 == (c = charSequence2.charAt(i))) continue;
            if (!bl2 && !bl) {
                if ((c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
                return false;
            }
            return false;
        }
        if (bl) {
            return n == n2;
        }
        return n >= n2;
    }

    public static List<CsmNamedElement> filterList(Collection<? extends CsmDeclaration> collection, CharSequence charSequence, boolean bl, boolean bl2) {
        return CsmSortUtilities.filterList(collection.iterator(), charSequence, bl, bl2);
    }

    public static List<CsmNamedElement> filterList(Iterator<? extends CsmDeclaration> iterator, CharSequence charSequence, boolean bl, boolean bl2) {
        ArrayList<CsmNamedElement> arrayList = new ArrayList<CsmNamedElement>();
        while (iterator.hasNext()) {
            CsmDeclaration csmDeclaration = iterator.next();
            if (!CsmKindUtilities.isNamedElement((Object)csmDeclaration) || !CsmSortUtilities.matchName(((CsmNamedElement)csmDeclaration).getName(), charSequence, bl, bl2)) continue;
            arrayList.add(csmDeclaration);
        }
        return arrayList;
    }

    public static List sortClasses(List list, boolean bl) {
        if (bl) {
            Collections.sort(list, CLASS_NAME_COMPARATOR);
        } else {
            Collections.sort(list, INSENSITIVE_CLASS_NAME_COMPARATOR);
        }
        return list;
    }

    public static List sortMembers(List list, boolean bl) {
        return CsmSortUtilities.sortMembers(list, true, bl);
    }

    public static List sortMembers(List list, boolean bl, boolean bl2) {
        if (bl2) {
            Collections.sort(list, NATURAL_MEMBER_NAME_COMPARATOR);
        } else {
            Collections.sort(list, INSENSITIVE_NATURAL_MEMBER_NAME_COMPARATOR);
        }
        return list;
    }

    public static List sortNamespaceMembers(List list, boolean bl) {
        if (bl) {
            Collections.sort(list, NATURAL_NAMESPACE_MEMBER_COMPARATOR);
        } else {
            Collections.sort(list, INSENSITIVE_NATURAL_NAMESPACE_MEMBER_COMPARATOR);
        }
        return list;
    }

    private static int compareNames(CsmNamedElement csmNamedElement, CsmNamedElement csmNamedElement2, boolean bl) {
        int n = bl ? CharSequenceKey.Comparator.compare(csmNamedElement.getName(), csmNamedElement2.getName()) : CharSequenceKey.ComparatorIgnoreCase.compare(csmNamedElement.getName(), csmNamedElement2.getName());
        return n;
    }

    private static int compareVariables(CsmVariable csmVariable, CsmVariable csmVariable2, boolean bl) {
        int n = CsmSortUtilities.compareNames(csmVariable, csmVariable2, bl);
        int n2 = CharSequenceKey.Comparator.compare(csmVariable.getName(), csmVariable2.getName());
        if (n == 0 && n2 != 0) {
            n = n2;
        }
        return n;
    }

    private static int compareEnumerators(CsmEnumerator csmEnumerator, CsmEnumerator csmEnumerator2, boolean bl) {
        int n = CsmSortUtilities.compareNames(csmEnumerator, csmEnumerator2, bl);
        int n2 = CharSequenceKey.Comparator.compare(csmEnumerator.getName(), csmEnumerator2.getName());
        if (n == 0 && n2 != 0) {
            n = n2;
        }
        return n;
    }

    private static int compareFunctions(CsmFunction csmFunction, CsmFunction csmFunction2, boolean bl) {
        int n = CsmSortUtilities.compareNames(csmFunction, csmFunction2, bl);
        if (n == 0) {
            CsmParameter[] csmParameterArray = csmFunction.getParameters().toArray(new CsmParameter[0]);
            CsmParameter[] csmParameterArray2 = csmFunction2.getParameters().toArray(new CsmParameter[0]);
            int n2 = Math.min(csmParameterArray.length, csmParameterArray2.length);
            for (int i = 0; i < n2; ++i) {
                block6: {
                    try {
                        n = bl ? CharSequenceKey.Comparator.compare(csmParameterArray[i].getType().getText(), csmParameterArray2[i].getType().getText()) : CharSequenceKey.ComparatorIgnoreCase.compare(csmParameterArray[i].getType().getText(), csmParameterArray2[i].getType().getText());
                    }
                    catch (NullPointerException nullPointerException) {
                        n = 0;
                        if (csmParameterArray[i].isVarArgs() != csmParameterArray2[i].isVarArgs()) {
                            n = csmParameterArray[i].isVarArgs() ? -1 : 1;
                        }
                        if (csmParameterArray[i].isVarArgs()) break block6;
                        System.err.println("CsmSortUtilities.compareFunctions: error while checking parameter " + i + "of functions" + csmFunction + " and " + csmFunction2);
                        nullPointerException.printStackTrace(System.err);
                    }
                }
                if (n == 0) continue;
                return n;
            }
            n = csmParameterArray.length - csmParameterArray2.length;
        }
        int n3 = CharSequenceKey.Comparator.compare(csmFunction.getName(), csmFunction2.getName());
        if (n == 0 && n3 != 0) {
            n = n3;
        }
        return n;
    }

    private static int compareMacros(CsmMacro csmMacro, CsmMacro csmMacro2, boolean bl) {
        int n = CsmSortUtilities.compareNames(csmMacro, csmMacro2, bl);
        if (n == 0) {
            int n2 = 0;
            if (csmMacro.getParameters() != null) {
                n2 = csmMacro.getParameters().size();
            }
            int n3 = 0;
            if (csmMacro2.getParameters() != null) {
                n3 = csmMacro2.getParameters().size();
            }
            n = n2 - n3;
        }
        return n;
    }

    public static final class NsNaturalMemberNameComparator
    implements Comparator {
        private boolean sensitive;

        public NsNaturalMemberNameComparator() {
            this(false);
        }

        private NsNaturalMemberNameComparator(boolean bl) {
            this.sensitive = bl;
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (CsmKindUtilities.isCsmObject(object) && CsmKindUtilities.isCsmObject(object2)) {
                CsmObject csmObject = (CsmObject)object;
                CsmObject csmObject2 = (CsmObject)object2;
                boolean bl = CsmKindUtilities.isNamespace(csmObject);
                boolean bl2 = CsmKindUtilities.isNamespace(csmObject2);
                if (bl || bl2) {
                    if (bl && bl2) {
                        return CsmSortUtilities.compareNames((CsmNamespace)csmObject, (CsmNamespace)csmObject2, this.sensitive);
                    }
                    if (bl) {
                        return -1;
                    }
                    assert (bl2);
                    return 1;
                }
                boolean bl3 = CsmKindUtilities.isClassifier(csmObject);
                boolean bl4 = CsmKindUtilities.isClassifier(csmObject2);
                if (bl3 || bl4) {
                    if (bl3 && bl4) {
                        return CsmSortUtilities.compareNames((CsmClassifier)csmObject, (CsmClassifier)csmObject2, this.sensitive);
                    }
                    if (bl3) {
                        return -1;
                    }
                    assert (bl4);
                    return 1;
                }
                boolean bl5 = CsmKindUtilities.isVariable(csmObject);
                boolean bl6 = CsmKindUtilities.isVariable(csmObject2);
                if (bl5 || bl6) {
                    if (bl5 && bl6) {
                        return CsmSortUtilities.compareVariables((CsmVariable)csmObject, (CsmVariable)csmObject2, this.sensitive);
                    }
                    if (bl5) {
                        return -1;
                    }
                    assert (bl6);
                    return 1;
                }
                boolean bl7 = CsmKindUtilities.isFunction(csmObject);
                boolean bl8 = CsmKindUtilities.isFunction(csmObject2);
                if (bl7 || bl8) {
                    if (bl7 && bl8) {
                        return CsmSortUtilities.compareFunctions((CsmFunction)csmObject, (CsmFunction)csmObject2, this.sensitive);
                    }
                    if (bl7) {
                        return -1;
                    }
                    assert (bl8);
                    return 1;
                }
            }
            return 0;
        }
    }

    public static final class NaturalMemberNameComparator
    implements Comparator {
        private boolean sensitive;

        public NaturalMemberNameComparator() {
            this(false);
        }

        private NaturalMemberNameComparator(boolean bl) {
            this.sensitive = bl;
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (CsmKindUtilities.isCsmObject(object) && CsmKindUtilities.isCsmObject(object2)) {
                CsmObject csmObject = (CsmObject)object;
                CsmObject csmObject2 = (CsmObject)object2;
                boolean bl = CsmKindUtilities.isVariable(csmObject);
                boolean bl2 = CsmKindUtilities.isVariable(csmObject2);
                if (bl || bl2) {
                    if (bl && bl2) {
                        return CsmSortUtilities.compareVariables((CsmVariable)csmObject, (CsmVariable)csmObject2, this.sensitive);
                    }
                    if (bl) {
                        return -1;
                    }
                    assert (bl2);
                    return 1;
                }
                boolean bl3 = CsmKindUtilities.isEnumerator(csmObject);
                boolean bl4 = CsmKindUtilities.isEnumerator(csmObject2);
                if (bl3 || bl4) {
                    if (bl3 && bl4) {
                        return CsmSortUtilities.compareEnumerators((CsmEnumerator)csmObject, (CsmEnumerator)csmObject2, this.sensitive);
                    }
                    if (bl3) {
                        return -1;
                    }
                    assert (bl4);
                    return 1;
                }
                boolean bl5 = CsmKindUtilities.isFunction(csmObject);
                boolean bl6 = CsmKindUtilities.isFunction(csmObject2);
                if (bl5 || bl6) {
                    if (bl5 && bl6) {
                        return CsmSortUtilities.compareFunctions((CsmFunction)csmObject, (CsmFunction)csmObject2, this.sensitive);
                    }
                    if (bl5) {
                        return -1;
                    }
                    assert (bl6);
                    return 1;
                }
                boolean bl7 = CsmKindUtilities.isMacro(csmObject);
                boolean bl8 = CsmKindUtilities.isMacro(csmObject2);
                if (bl7 || bl8) {
                    if (bl7 && bl8) {
                        return CsmSortUtilities.compareMacros((CsmMacro)csmObject, (CsmMacro)csmObject2, this.sensitive);
                    }
                    if (bl7) {
                        return -1;
                    }
                    assert (bl8);
                    return 1;
                }
            }
            return 0;
        }
    }

    public static final class InsensitiveClassNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (CsmKindUtilities.isCsmObject(object) && CsmKindUtilities.isCsmObject(object2)) {
                if (CsmKindUtilities.isClass((CsmObject)object) && CsmKindUtilities.isClass((CsmObject)object2)) {
                    return CharSequenceKey.ComparatorIgnoreCase.compare(((CsmClass)object).getName(), ((CsmClass)object2).getName());
                }
                if (CsmKindUtilities.isNamespace((CsmObject)object) && CsmKindUtilities.isNamespace((CsmObject)object2)) {
                    return CharSequenceKey.ComparatorIgnoreCase.compare(((CsmNamespace)object).getName(), ((CsmNamespace)object2).getName());
                }
            }
            return 0;
        }
    }

    public static final class DefaultClassNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (CsmKindUtilities.isCsmObject(object) && CsmKindUtilities.isCsmObject(object2)) {
                if (CsmKindUtilities.isClass((CsmObject)object) && CsmKindUtilities.isClass((CsmObject)object2)) {
                    return CharSequenceKey.Comparator.compare(((CsmClass)object).getName(), ((CsmClass)object2).getName());
                }
                if (CsmKindUtilities.isNamespace((CsmObject)object) && CsmKindUtilities.isNamespace((CsmObject)object2)) {
                    return CharSequenceKey.Comparator.compare(((CsmNamespace)object).getName(), ((CsmNamespace)object2).getName());
                }
            }
            return 0;
        }
    }
}

