/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.ParserSource;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxParserListener;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyntaxParser {
    private static final Logger LOGGER = Logger.getLogger(SyntaxParser.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final int PARSER_DELAY = 1000;
    private final Document doc;
    private final LanguagePath languagePath;
    private final TokenHierarchy hi;
    private final RequestProcessor.Task parserTask;
    private final ArrayList<SyntaxParserListener> listeners = new ArrayList();
    private final TokenHierarchyListener tokenHierarchyListener = new TokenHierarchyListener(){

        public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
            if (tokenHierarchyEvent.type() == TokenHierarchyEventType.MODIFICATION) {
                SyntaxParser.this.restartParser();
            }
        }
    };
    private List<SyntaxElement> EMPTY_ELEMENTS_LIST = Collections.emptyList();
    private List<SyntaxElement> parsedElements;
    private boolean isSuccessfulyParsed = false;
    protected ParserSource parserSource;
    private static final int S_INIT = 0;
    private static final int S_TAG_OPEN_SYMBOL = 1;
    private static final int S_TAG = 2;
    private static final int S_TAG_ATTR = 3;
    private static final int S_TAG_VALUE = 4;
    private static final int S_COMMENT = 5;
    private static final int S_DECLARATION = 6;
    private static final int S_DOCTYPE_DECLARATION = 7;
    private static final int S_DOCTYPE_AFTER_ROOT_ELEMENT = 8;
    private static final int S_DOCTYPE_PUBLIC_ID = 9;
    private static final int S_DOCTYPE_FILE = 10;
    private int state;
    private int start;
    private TokenSequence ts;
    private Token<HTMLTokenId> token;
    private List<SyntaxElement> elements;
    private boolean openTag = true;
    private String tagName = null;
    private Token attrib = null;
    private ArrayList<Token> attr_keys = null;
    private ArrayList<List<Token>> attr_values = null;
    private String root_element;
    private String doctype_public_id;
    private String doctype_file;

    public static synchronized SyntaxParser get(Document document, LanguagePath languagePath) {
        SyntaxParser syntaxParser = (SyntaxParser)document.getProperty(SyntaxParser.class);
        if (syntaxParser == null) {
            syntaxParser = new SyntaxParser(document, languagePath);
            document.putProperty(SyntaxParser.class, syntaxParser);
        }
        return syntaxParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SyntaxElement> parseImmutableSource(final CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("Parser source cannot be null!");
        }
        SyntaxParser syntaxParser = new SyntaxParser(charSequence);
        syntaxParser.parserSource = new ParserSource(){

            public CharSequence getText(int n, int n2) throws BadLocationException {
                return charSequence.subSequence(n, n + n2);
            }
        };
        try {
            List<SyntaxElement> list = syntaxParser.parseDocument();
            return list;
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.WARNING, "Error during parsing html content", badLocationException);
            List<SyntaxElement> list = null;
            return list;
        }
        finally {
            syntaxParser.parserSource = null;
        }
    }

    private SyntaxParser(CharSequence charSequence) {
        this.parserTask = null;
        this.doc = null;
        this.parsedElements = this.EMPTY_ELEMENTS_LIST;
        this.languagePath = LanguagePath.get((Language)HTMLTokenId.language());
        this.hi = TokenHierarchy.create((CharSequence)charSequence, (Language)HTMLTokenId.language());
    }

    private SyntaxParser(Document document, LanguagePath languagePath) {
        this.doc = document;
        this.languagePath = languagePath;
        this.hi = TokenHierarchy.get((Document)this.doc);
        if (this.hi == null) {
            String string = (String)this.doc.getProperty("mimeType");
            if (string == null) {
                string = "unknown";
            }
            throw new IllegalStateException("Cannot obtain TokenHierarchy instance for document " + document + " with " + string + " mimetype.");
        }
        this.parserSource = new ParserSource(){

            public String getText(int n, int n2) throws BadLocationException {
                return SyntaxParser.this.doc.getText(n, n2);
            }
        };
        this.parsedElements = this.EMPTY_ELEMENTS_LIST;
        this.parserTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SyntaxParser.this.parse();
            }
        });
        this.hi.addTokenHierarchyListener(this.tokenHierarchyListener);
        this.restartParser();
    }

    public void addSyntaxParserListener(SyntaxParserListener syntaxParserListener) {
        this.listeners.add(syntaxParserListener);
    }

    public void removeSyntaxParserListener(SyntaxParserListener syntaxParserListener) {
        this.listeners.remove(syntaxParserListener);
    }

    void forceParse() {
        this.parserTask.cancel();
        this.parse();
    }

    public List<SyntaxElement> elements() {
        return this.parsedElements;
    }

    private void restartParser() {
        if (!this.parserTask.isFinished()) {
            this.parserTask.cancel();
        }
        this.parserTask.schedule(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void parse() {
        BaseDocument baseDocument = (BaseDocument)this.doc;
        baseDocument.readLock();
        try {
            List<SyntaxElement> list = this.parseDocument();
            this.parsedElements = list;
            this.isSuccessfulyParsed = true;
        }
        catch (BadLocationException badLocationException) {
            this.isSuccessfulyParsed = false;
            LOGGER.log(Level.WARNING, "Error during parsing html content", badLocationException);
        }
        finally {
            baseDocument.readUnlock();
        }
        if (this.isSuccessfulyParsed) {
            this.notifyParsingFinished();
        }
    }

    private void notifyParsingFinished() {
        if (!this.parsedElements.isEmpty()) {
            if (LOG) {
                for (SyntaxElement object : this.parsedElements) {
                    LOGGER.log(Level.FINE, object.toString());
                    System.out.println(object.toString());
                }
            }
            for (SyntaxParserListener syntaxParserListener : this.listeners) {
                syntaxParserListener.parsingFinished(this.parsedElements);
            }
        }
    }

    private void entityReference() {
        this.elements.add(new SyntaxElement(this.parserSource, this.start, this.token.offset(this.hi) + this.token.length() - this.start, 6));
    }

    private void comment() {
        this.elements.add(new SyntaxElement(this.parserSource, this.start, this.token.offset(this.hi) + this.token.length() - this.start, 0));
    }

    private void declaration() {
        this.elements.add(new SyntaxElement.Declaration(this.parserSource, this.start, this.token.offset(this.hi) + this.token.length() - this.start, this.root_element, this.doctype_public_id, this.doctype_file));
    }

    private void tag(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.attr_keys.size(); ++i) {
            Token token3;
            Object object;
            Token token2 = this.attr_keys.get(i);
            List<Token> list = this.attr_values.get(i);
            StringBuffer stringBuffer = new StringBuffer();
            if (list == null) {
                object = new SyntaxElement.TagAttribute(((Object)token2.text()).toString().intern(), stringBuffer.toString().intern(), token2.offset(this.hi), token2.offset(this.hi) + token2.length(), 0);
                arrayList.add(object);
                continue;
            }
            for (Token token3 : list) {
                stringBuffer.append(token3.text());
            }
            object = list.get(0);
            token3 = list.get(list.size() - 1);
            SyntaxElement.TagAttribute tagAttribute = new SyntaxElement.TagAttribute(((Object)token2.text()).toString().intern(), stringBuffer.toString().intern(), token2.offset(this.hi), object.offset(this.hi), token3.offset(this.hi) + token3.length() - object.offset(this.hi));
            arrayList.add(tagAttribute);
        }
        this.elements.add(new SyntaxElement.Tag(this.parserSource, this.start, this.token.offset(this.hi) + this.token.length() - this.start, this.tagName.intern(), arrayList.isEmpty() ? null : arrayList, this.openTag, bl));
        this.tagName = null;
        this.attrib = null;
        this.attr_keys = new ArrayList();
        this.attr_values = new ArrayList();
    }

    private void reset() {
        this.state = 0;
        this.start = -1;
        this.backup(1);
    }

    private void backup(int n) {
        for (int i = 0; i < n; ++i) {
            this.ts.movePrevious();
            this.token = this.ts.token();
        }
    }

    private List<SyntaxElement> parseDocument() throws BadLocationException {
        this.elements = new ArrayList<SyntaxElement>();
        List list = this.hi.tokenSequenceList(this.languagePath, 0, Integer.MAX_VALUE);
        this.state = 0;
        this.start = -1;
        this.attr_keys = new ArrayList();
        this.attr_values = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TokenSequence tokenSequence;
            this.ts = tokenSequence = (TokenSequence)iterator.next();
            while (this.ts.moveNext()) {
                this.token = this.ts.token();
                HTMLTokenId hTMLTokenId = (HTMLTokenId)this.token.id();
                block0 : switch (this.state) {
                    case 0: {
                        switch (hTMLTokenId) {
                            case CHARACTER: {
                                this.start = this.ts.offset();
                                this.entityReference();
                                this.state = 0;
                                this.start = -1;
                                break block0;
                            }
                            case TAG_OPEN_SYMBOL: {
                                this.start = this.ts.offset();
                                this.state = 1;
                                break block0;
                            }
                            case BLOCK_COMMENT: {
                                this.start = this.ts.offset();
                                this.state = 5;
                                break block0;
                            }
                            case DECLARATION: {
                                this.start = this.ts.offset();
                                if (((Object)this.token.text()).toString().equals("<!DOCTYPE")) {
                                    this.root_element = null;
                                    this.doctype_public_id = null;
                                    this.doctype_file = null;
                                    this.state = 7;
                                    break block0;
                                }
                                this.state = 6;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (hTMLTokenId) {
                            case TAG_OPEN: {
                                this.state = 2;
                                this.openTag = true;
                                this.tagName = ((Object)this.token.text()).toString();
                                break block0;
                            }
                            case TAG_CLOSE: {
                                this.state = 2;
                                this.openTag = false;
                                this.tagName = ((Object)this.token.text()).toString();
                                break block0;
                            }
                        }
                        this.reset();
                        break;
                    }
                    case 2: {
                        switch (hTMLTokenId) {
                            case WS: 
                            case EOL: 
                            case ERROR: {
                                break block0;
                            }
                            case ARGUMENT: {
                                this.state = 3;
                                this.attrib = this.token;
                                break block0;
                            }
                            case TAG_CLOSE_SYMBOL: {
                                boolean bl = "/>".equals(((Object)this.token.text()).toString());
                                this.tag(bl);
                                this.state = 0;
                                this.start = -1;
                                break block0;
                            }
                        }
                        this.reset();
                        break;
                    }
                    case 3: {
                        switch (hTMLTokenId) {
                            case WS: 
                            case OPERATOR: {
                                break block0;
                            }
                            case VALUE: 
                            case VALUE_JAVASCRIPT: {
                                this.backup(1);
                                this.state = 4;
                                break block0;
                            }
                            case ARGUMENT: 
                            case TAG_CLOSE_SYMBOL: {
                                this.attr_keys.add(this.attrib);
                                this.attr_values.add(null);
                                this.state = 2;
                                this.backup(1);
                                break block0;
                            }
                        }
                        this.reset();
                        break;
                    }
                    case 4: {
                        switch (hTMLTokenId) {
                            case VALUE: 
                            case VALUE_JAVASCRIPT: {
                                int n = this.attr_keys.indexOf(this.attrib);
                                if (n == -1) {
                                    ArrayList<Token<HTMLTokenId>> arrayList = new ArrayList<Token<HTMLTokenId>>();
                                    arrayList.add(this.token);
                                    this.attr_keys.add(this.attrib);
                                    this.attr_values.add(arrayList);
                                    break block0;
                                }
                                this.attr_values.get(n).add(this.token);
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.state = 2;
                        break;
                    }
                    case 5: {
                        switch (hTMLTokenId) {
                            case BLOCK_COMMENT: 
                            case WS: 
                            case EOL: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.comment();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 6: {
                        switch (hTMLTokenId) {
                            case DECLARATION: 
                            case WS: 
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 7: {
                        switch (hTMLTokenId) {
                            case DECLARATION: {
                                this.root_element = ((Object)this.token.text()).toString();
                                this.state = 8;
                                break block0;
                            }
                            case WS: 
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 8: {
                        switch (hTMLTokenId) {
                            case DECLARATION: {
                                if (((Object)this.token.text()).toString().equals("PUBLIC")) {
                                    this.doctype_public_id = new String();
                                    this.state = 9;
                                    break block0;
                                }
                                if (((Object)this.token.text()).toString().equals("SYSTEM")) {
                                    this.state = 10;
                                    this.doctype_file = new String();
                                    break block0;
                                }
                                this.backup(1);
                                this.declaration();
                                this.state = 0;
                                this.start = -1;
                                break block0;
                            }
                            case WS: 
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 9: {
                        switch (hTMLTokenId) {
                            case DECLARATION: 
                            case WS: {
                                String string = ((Object)this.token.text()).toString();
                                if (string.startsWith("\"")) {
                                    string = string.substring(1);
                                }
                                if (string.endsWith("\"")) {
                                    string = string.substring(0, string.length() - 1);
                                    this.doctype_public_id = this.doctype_public_id + string;
                                    this.doctype_public_id = this.doctype_public_id.trim();
                                    this.state = 10;
                                    break block0;
                                }
                                this.doctype_public_id = this.doctype_public_id + string;
                                break block0;
                            }
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                        break;
                    }
                    case 10: {
                        switch (hTMLTokenId) {
                            case DECLARATION: {
                                this.doctype_file = ((Object)this.token.text()).toString();
                                this.state = 6;
                                break block0;
                            }
                            case WS: 
                            case EOL: 
                            case SGML_COMMENT: {
                                break block0;
                            }
                        }
                        this.backup(1);
                        this.declaration();
                        this.state = 0;
                        this.start = -1;
                    }
                }
            }
        }
        if (this.state != 0) {
            switch (this.state) {
                case 5: {
                    this.comment();
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.declaration();
                }
            }
        }
        return this.elements;
    }
}

