/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.openide.util.Exceptions;

public class HtmlIndenter {
    private static final Logger LOGGER = Logger.getLogger(HtmlIndenter.class.getName());
    private final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public static synchronized void indentEndTag(Document document, LanguagePath languagePath, int n, String string) {
        try {
            SyntaxElement syntaxElement;
            if (string != null) {
                --n;
            }
            if ((syntaxElement = HTMLSyntaxSupport.get(document).getElementChain(n)) == null || syntaxElement.getType() != 5) {
                LOGGER.info("Unexpected SyntaxElement at position " + n + ": " + syntaxElement);
                return;
            }
            Stack<String> stack = new Stack<String>();
            SyntaxElement syntaxElement2 = null;
            block2: do {
                SyntaxElement.Named named;
                if (syntaxElement.getType() == 4) {
                    named = (SyntaxElement.Tag)syntaxElement;
                    if (((SyntaxElement.Tag)named).isEmpty()) continue;
                    for (int i = stack.size() - 1; i >= 0; --i) {
                        String string2 = (String)stack.elementAt(i);
                        if (!string2.equals(named.getName())) continue;
                        if (i == 0) {
                            syntaxElement2 = named;
                            break block2;
                        }
                        stack.remove(i);
                        continue block2;
                    }
                } else {
                    if (syntaxElement.getType() != 5) continue;
                    named = (SyntaxElement.Named)syntaxElement;
                    stack.push(named.getName());
                }
            } while ((syntaxElement = syntaxElement.getPrevious()) != null);
            if (syntaxElement2 != null) {
                HtmlIndenter.changeRowIndent(document, syntaxElement2.getElementOffset(), n);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static void changeRowIndent(Document document, int n, int n2) {
        try {
            int n3 = Utilities.getRowIndent((BaseDocument)((BaseDocument)document), (int)n);
            LOGGER.fine("Paired open tag indent level=" + n3);
            String string = IndentUtils.createIndentString((Document)document, (int)n3);
            int n4 = Utilities.getRowStart((BaseDocument)((BaseDocument)document), (int)n2);
            int n5 = Utilities.getFirstNonWhiteFwd((BaseDocument)((BaseDocument)document), (int)n4);
            document.remove(n4, n5 - n4);
            document.insertString(n4, string, null);
        }
        catch (BadLocationException badLocationException) {
            LOGGER.log(Level.INFO, "Error changing row indent", badLocationException);
        }
    }
}

