/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;

public class HTMLCompletionItemPC
extends JPanel {
    static final String PACKAGE = "org/netbeans/modules/editor/resources/completion/defaultFolder.gif";
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int iconTextGap = 5;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static String str;
    private static final String[] frequentWords;
    public static final Color KEYWORD_COLOR;
    public static final Color TYPE_COLOR;

    public HTMLCompletionItemPC() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    public void setString(String string) {
        str = string;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    protected void setDeprecated(boolean bl) {
        this.isDeprecated = bl;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    protected Icon getIcon() {
        return null;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
    }

    protected void draw(Graphics graphics) {
    }

    protected void drawIcon(Graphics graphics, Icon icon) {
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX = insets.left;
            this.drawY = insets.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (graphics != null) {
                icon.paintIcon(this, graphics, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        if (insets != null) {
            this.drawHeight += insets.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics graphics, String string) {
        this.drawString(graphics, string, false);
    }

    protected void drawString(Graphics graphics, String string, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getForeground());
        }
        this.drawStringToGraphics(graphics, string, null, bl);
    }

    protected void drawString(Graphics graphics, String string, Color color) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
        }
        this.drawStringToGraphics(graphics, string);
    }

    protected void drawString(Graphics graphics, String string, Color color, Font font, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
            graphics.setFont(font);
        }
        this.drawStringToGraphics(graphics, string, font, bl);
        if (graphics != null) {
            graphics.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics graphics, String string, Color color) {
        if (graphics == null) {
            this.drawString(graphics, "   ");
            this.drawString(graphics, string, color);
        } else {
            int n = this.getWidth(" ");
            this.drawX = this.getWidth() - this.getWidth(string) < this.drawX ? (this.drawX += n * 2) : this.getWidth() - this.getWidth(string) - 4;
            this.drawString(graphics, string, color);
        }
    }

    protected void drawStringToGraphics(Graphics graphics, String string) {
        this.drawStringToGraphics(graphics, string, null, false);
    }

    protected void drawStringToGraphics(Graphics graphics, String string, Font font, boolean bl) {
        if (graphics != null) {
            if (!bl) {
                graphics.drawString(string, this.drawX, this.drawY);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
                graphics2D.drawString(attributedString.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(string, font);
    }

    protected int getWidth(String string) {
        Integer n = (Integer)this.widths.get(string);
        if (n != null) {
            return n;
        }
        if (string == null) {
            string = "";
        }
        return this.fontMetrics.stringWidth(string);
    }

    protected int getWidth(String string, Font font) {
        if (font == null) {
            return this.getWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    protected Color getColor(String string, Color color) {
        return this.isSelected ? this.getForeground() : color;
    }

    private void storeWidth(String string) {
        this.fontMetrics.stringWidth(string);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        this.setFont(font);
        this.draw(graphics);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX += insets.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return this.drawX;
    }

    static {
        frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", THROWS};
        KEYWORD_COLOR = Color.darkGray;
        TYPE_COLOR = Color.black;
    }

    public static class StringPaintComponent
    extends HTMLCompletionItemPC {
        private Color c;

        public StringPaintComponent(Color color) {
            this.c = color;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, str, this.c);
        }
    }
}

