/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class SetConfigurationAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    private static final String PROJECT_KEY = "org.netbeans.modules.cnd.makeproject.ui.ConfigurationItem";
    private JMenu subMenu;
    private Project project;

    public SetConfigurationAction(Project project) {
        super(NbBundle.getMessage(SetConfigurationAction.class, (String)"LBL_SetConfigurationAction_Name"), null);
        this.project = project;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JMenuItem getPopupPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    public JMenuItem getMenuPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    private void createSubMenu() {
        Object object;
        if (this.subMenu == null) {
            object = NbBundle.getMessage(SetConfigurationAction.class, (String)"LBL_SetConfigurationAction_Name");
            this.subMenu = new JMenu((String)object);
        }
        this.subMenu.removeAll();
        object = new MenuItemActionListener();
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (configurationDescriptorProvider == null) {
            return;
        }
        ConfigurationDescriptor configurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        Configuration[] configurationArray = configurationDescriptor.getConfs().getConfs();
        for (int i = 0; i < configurationArray.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(configurationArray[i].getName(), configurationArray[i].isDefault());
            this.subMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.putClientProperty(PROJECT_KEY, configurationDescriptor);
            jRadioButtonMenuItem.addActionListener((ActionListener)object);
        }
        this.subMenu.add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(SetConfigurationAction.class, (String)"LBL_ConfigurationsAction_Name"));
        this.subMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonProjectActions.customizeProjectAction().actionPerformed(new ActionEvent(this, -1, null));
            }
        });
        this.subMenu.setEnabled(configurationArray.length > 0);
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem;
            ConfigurationDescriptor configurationDescriptor;
            if (actionEvent.getSource() instanceof JMenuItem && (configurationDescriptor = (ConfigurationDescriptor)(jMenuItem = (JMenuItem)actionEvent.getSource()).getClientProperty(SetConfigurationAction.PROJECT_KEY)) != null) {
                configurationDescriptor.getConfs().setActive(jMenuItem.getText());
            }
        }
    }
}

