/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.packaging.DummyPackager;

public class ConfigurationMakefileWriter {
    private MakeConfigurationDescriptor projectDescriptor;

    public ConfigurationMakefileWriter(MakeConfigurationDescriptor makeConfigurationDescriptor) {
        this.projectDescriptor = makeConfigurationDescriptor;
    }

    public void write() {
        this.cleanup();
        this.writeMakefileImpl();
        Configuration[] configurationArray = this.projectDescriptor.getConfs().getConfs();
        for (int i = 0; i < configurationArray.length; ++i) {
            this.writeMakefileConf((MakeConfiguration)configurationArray[i]);
            this.writePackagingScript((MakeConfiguration)configurationArray[i]);
        }
    }

    private void cleanup() {
        File file = new File(this.projectDescriptor.getBaseDir() + '/' + "nbproject");
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().startsWith("Makefile-")) {
                fileArray[i].delete();
            }
            if (!fileArray[i].getName().startsWith("Package-")) continue;
            fileArray[i].delete();
        }
    }

    private void writeMakefileImpl() {
        Object object;
        String string = "/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile-impl.mk";
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            object = new URL("nbresloc:" + string);
            inputStream = ((URL)object).openStream();
        }
        catch (Exception exception) {
            inputStream = MakeConfigurationDescriptor.class.getResourceAsStream(string);
        }
        object = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Makefile-impl.mk";
        try {
            fileOutputStream = new FileOutputStream((String)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (inputStream == null || fileOutputStream == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        String string2 = IpeUtils.getBaseName((String)this.projectDescriptor.getBaseDir());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.projectDescriptor.getConfs().getConfs().length; ++i) {
            stringBuilder.append(this.projectDescriptor.getConfs().getConfs()[i].getName());
            stringBuilder.append(" ");
        }
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf("<PN>") >= 0) {
                    string3 = string3.replaceFirst("<PN>", string2);
                } else if (string3.indexOf("<CNS>") >= 0) {
                    string3 = string3.replaceFirst("<CNS>", stringBuilder.toString());
                } else if (string3.indexOf("<CN>") >= 0) {
                    string3 = string3.replaceFirst("<CN>", this.projectDescriptor.getConfs().getConf(0).getName());
                }
                bufferedWriter.write(string3 + "\n");
            }
            bufferedReader.close();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeMakefileConf(MakeConfiguration makeConfiguration) {
        String string = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Makefile-" + makeConfiguration.getName() + ".mk";
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        try {
            this.writePrelude(makeConfiguration, bufferedWriter);
            this.writeBuildTarget(makeConfiguration, bufferedWriter);
            this.writeCleanTarget(makeConfiguration, bufferedWriter);
            this.writeDependencyChecking(makeConfiguration, bufferedWriter);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writePrelude(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter) throws IOException {
        CCompilerConfiguration cCompilerConfiguration = makeConfiguration.getCCompilerConfiguration();
        CCCompilerConfiguration cCCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
        FortranCompilerConfiguration fortranCompilerConfiguration = makeConfiguration.getFortranCompilerConfiguration();
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return;
        }
        BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(0);
        BasicCompiler basicCompiler2 = (BasicCompiler)compilerSet.getTool(1);
        BasicCompiler basicCompiler3 = (BasicCompiler)compilerSet.getTool(2);
        String string = "";
        String string2 = "";
        String string3 = "";
        if (basicCompiler != null) {
            string = cCompilerConfiguration.getTool().getModified() ? cCompilerConfiguration.getTool().getValue() : basicCompiler.getName();
        }
        if (basicCompiler2 != null) {
            string2 = cCCompilerConfiguration.getTool().getModified() ? cCCompilerConfiguration.getTool().getValue() : basicCompiler2.getName();
        }
        if (basicCompiler3 != null) {
            string3 = fortranCompilerConfiguration.getTool().getModified() ? fortranCompilerConfiguration.getTool().getValue() : basicCompiler3.getName();
        }
        bufferedWriter.write("#\n");
        bufferedWriter.write("# Generated Makefile - do not edit!\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("# Edit the Makefile in the project folder instead (../Makefile). Each target\n");
        bufferedWriter.write("# has a -pre and a -post target defined where you can add customized code.\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("# This makefile implements configuration specific macros and targets.\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Environment\n");
        bufferedWriter.write("MKDIR=mkdir\n");
        bufferedWriter.write("CP=cp\n");
        bufferedWriter.write("CCADMIN=CCadmin\n");
        bufferedWriter.write("RANLIB=ranlib\n");
        bufferedWriter.write("CC=" + string + "\n");
        bufferedWriter.write("CCC=" + string2 + "\n");
        bufferedWriter.write("CXX=" + string2 + "\n");
        bufferedWriter.write("FC=" + string3 + "\n");
        if (makeConfiguration.getArchiverConfiguration().getTool().getModified()) {
            bufferedWriter.write("AR=" + makeConfiguration.getArchiverConfiguration().getTool().getValue() + "\n");
        }
        bufferedWriter.write("\n");
        bufferedWriter.write("# Macros\n");
        bufferedWriter.write("PLATFORM=" + makeConfiguration.getVariant() + "\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Include project Makefile\n");
        bufferedWriter.write("include " + this.projectDescriptor.getProjectMakefileName() + "\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Object Directory\n");
        bufferedWriter.write("OBJECTDIR=" + ConfigurationMakefileWriter.getObjectDir(makeConfiguration) + "\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Object Files\n");
        bufferedWriter.write("OBJECTFILES=" + this.getObjectFiles(this.projectDescriptor, makeConfiguration) + "\n");
        bufferedWriter.write("\n");
        if (basicCompiler != null) {
            bufferedWriter.write("# C Compiler Flags\n");
            bufferedWriter.write("CFLAGS=" + makeConfiguration.getCCompilerConfiguration().getCFlags(basicCompiler) + "\n");
            bufferedWriter.write("\n");
        }
        if (basicCompiler2 != null) {
            bufferedWriter.write("# CC Compiler Flags\n");
            bufferedWriter.write("CCFLAGS=" + makeConfiguration.getCCCompilerConfiguration().getCCFlags(basicCompiler2) + "\n");
            bufferedWriter.write("CXXFLAGS=" + makeConfiguration.getCCCompilerConfiguration().getCCFlags(basicCompiler2) + "\n");
            bufferedWriter.write("\n");
        }
        if (basicCompiler3 != null) {
            bufferedWriter.write("# Fortran Compiler Flags\n");
            bufferedWriter.write("FFLAGS=" + makeConfiguration.getFortranCompilerConfiguration().getFFlags(basicCompiler3) + "\n");
            bufferedWriter.write("\n");
        }
        bufferedWriter.write("# Link Libraries and Options\n");
        bufferedWriter.write("LDLIBSOPTIONS=" + makeConfiguration.getLinkerConfiguration().getLibraryItems() + "\n");
        bufferedWriter.write("\n");
    }

    private void writeBuildTarget(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter) throws IOException {
        String string = this.getOutput(makeConfiguration);
        bufferedWriter.write("# Build Targets\n");
        if (makeConfiguration.isCompileConfiguration()) {
            bufferedWriter.write(".build-conf: ${BUILD_SUBPROJECTS}\n");
            bufferedWriter.write("\t${MAKE} " + MakeOptions.getInstance().getMakeOptions() + " -f nbproject/Makefile-" + makeConfiguration.getName() + ".mk " + string + "\n\n");
            if (makeConfiguration.isLinkerConfiguration()) {
                this.writeLinkTarget(makeConfiguration, bufferedWriter, string);
            }
            if (makeConfiguration.isArchiverConfiguration()) {
                this.writeArchiveTarget(makeConfiguration, bufferedWriter, string);
            }
            if (makeConfiguration.isCompileConfiguration()) {
                this.writeCompileTargets(makeConfiguration, bufferedWriter);
            }
        } else if (makeConfiguration.isMakefileConfiguration()) {
            bufferedWriter.write(".build-conf: ${BUILD_SUBPROJECTS}\n");
            this.writeMakefileTargets(makeConfiguration, bufferedWriter);
        }
        this.writeSubProjectBuildTargets(makeConfiguration, bufferedWriter);
        bufferedWriter.write("\n");
    }

    private void writeLinkTarget(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter, String string) throws IOException {
        LibraryItem[] libraryItemArray;
        LinkerConfiguration linkerConfiguration = makeConfiguration.getLinkerConfiguration();
        String string2 = "";
        string2 = linkerConfiguration.getTool().getModified() ? string2 + linkerConfiguration.getTool().getValue() + " " : (makeConfiguration.hasCPPFiles(this.projectDescriptor) ? string2 + "${LINK.cc} " : (makeConfiguration.hasFortranFiles(this.projectDescriptor) ? string2 + "${LINK.f} " : string2 + "${LINK.c} "));
        string2 = string2 + linkerConfiguration.getOptions() + " ";
        string2 = string2 + "${OBJECTFILES} ";
        string2 = string2 + "${LDLIBSOPTIONS} ";
        String[] stringArray = linkerConfiguration.getAdditionalDependencies().getValues();
        for (int i = 0; i < stringArray.length; ++i) {
            bufferedWriter.write(string + ": " + stringArray[i] + "\n\n");
        }
        for (LibraryItem libraryItem : libraryItemArray = linkerConfiguration.getLibrariesConfiguration().getLibraryItemsAsArray()) {
            String string3 = libraryItem.getPath();
            if (string3 == null || string3.length() <= 0) continue;
            bufferedWriter.write(string + ": " + IpeUtils.escapeOddCharacters((String)string3) + "\n\n");
        }
        bufferedWriter.write(string + ": ${OBJECTFILES}\n");
        String string4 = IpeUtils.getDirName((String)string);
        if (string4 != null) {
            bufferedWriter.write("\t${MKDIR} -p " + string4 + "\n");
        }
        bufferedWriter.write("\t" + string2 + "\n");
    }

    private void writeArchiveTarget(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter, String string) throws IOException {
        ArchiverConfiguration archiverConfiguration = makeConfiguration.getArchiverConfiguration();
        String string2 = "${AR} ";
        string2 = string2 + archiverConfiguration.getOptions() + " ";
        string2 = string2 + "${OBJECTFILES} ";
        bufferedWriter.write(string + ": " + "${OBJECTFILES}" + "\n");
        String string3 = IpeUtils.getDirName((String)string);
        if (string3 != null) {
            bufferedWriter.write("\t${MKDIR} -p " + string3 + "\n");
        }
        bufferedWriter.write("\t${RM} " + string + "\n");
        bufferedWriter.write("\t" + string2 + "\n");
        if (archiverConfiguration.getRunRanlib().getValue()) {
            bufferedWriter.write("\t" + archiverConfiguration.getRunRanlib().getOption() + " " + string + "\n");
        }
    }

    private void writeCompileTargets(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter) throws IOException {
        Item[] itemArray = this.projectDescriptor.getProjectItems();
        if (makeConfiguration.isCompileConfiguration()) {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            for (int i = 0; i < itemArray.length; ++i) {
                Object object;
                CompilerSet compilerSet;
                ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue() || (compilerSet = makeConfiguration.getCompilerSet().getCompilerSet()) == null) continue;
                string3 = IpeUtils.escapeOddCharacters((String)compilerSet.normalizeDriveLetter(itemArray[i].getPath()));
                string4 = "";
                string5 = null;
                string6 = null;
                if (itemConfiguration.isCompilerToolConfiguration()) {
                    object = (BasicCompiler)compilerSet.getTool(itemConfiguration.getTool());
                    BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
                    string = basicCompilerConfiguration.getOutputFile(itemArray[i], makeConfiguration, false);
                    if (object != null) {
                        String string7 = "";
                        if (makeConfiguration.getConfigurationType().getValue() == 2 && makeConfiguration.getLinkerConfiguration().getPICOption().getValue()) {
                            string7 = " " + makeConfiguration.getLinkerConfiguration().getPICOption(compilerSet);
                        }
                        string4 = string4 + basicCompilerConfiguration.getOptions((BasicCompiler)((Object)object)) + string7 + " ";
                        if (makeConfiguration.getDependencyChecking().getValue() && ((BasicCompiler)((Object)object)).getDependencyGenerationOption().length() > 0) {
                            string4 = "${RM} $@.d\n\t" + string4 + ((BasicCompiler)((Object)object)).getDependencyGenerationOption() + " ";
                        }
                        if (itemArray[i].hasHeaderOrSourceExtension(false, false)) {
                            String string8 = ((BasicCompiler)((Object)object)).getDescriptor().getPrecompiledHeaderFlags();
                            if (string8 == null) {
                                string4 = "# command to precompile header ";
                                string5 = "Current compiler does not support header precompilation";
                            } else {
                                string4 = string4 + ((BasicCompiler)((Object)object)).getDescriptor().getPrecompiledHeaderFlags() + " ";
                            }
                        } else {
                            string4 = string4 + "-o " + string + " ";
                        }
                        string4 = string4 + IpeUtils.escapeOddCharacters((String)itemArray[i].getPath(true));
                    }
                    string6 = basicCompilerConfiguration.getAdditionalDependencies().getValue();
                } else if (itemConfiguration.getTool() == 3) {
                    object = itemConfiguration.getCustomToolConfiguration();
                    if (!((CustomToolConfiguration)object).getModified()) continue;
                    string = ((CustomToolConfiguration)object).getOutputs().getValue(" + ");
                    string4 = ((CustomToolConfiguration)object).getCommandLine().getValue();
                    string5 = ((CustomToolConfiguration)object).getDescription().getValue();
                    string6 = ((CustomToolConfiguration)object).getAdditionalDependencies().getValue();
                } else assert (false);
                string2 = IpeUtils.getDirName(string);
                bufferedWriter.write("\n");
                if (string6 != null) {
                    bufferedWriter.write(string + ": " + string3 + " " + string6 + "\n");
                } else {
                    bufferedWriter.write(string + ": " + string3 + "\n");
                }
                if (string2 != null) {
                    bufferedWriter.write("\t${MKDIR} -p " + string2 + "\n");
                }
                if (string5 != null) {
                    bufferedWriter.write("\t@echo " + string5 + "\n");
                }
                bufferedWriter.write("\t" + string4 + "\n");
            }
        }
    }

    private void writeMakefileTargets(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter) throws IOException {
        MakefileConfiguration makefileConfiguration = makeConfiguration.getMakefileConfiguration();
        String string = makefileConfiguration.getOutput().getValue();
        String string2 = makefileConfiguration.getBuildCommandWorkingDirValue();
        String string3 = makefileConfiguration.getBuildCommand().getValue();
        bufferedWriter.write("\tcd " + IpeUtils.escapeOddCharacters((String)string2) + " && " + string3 + "\n");
    }

    private void writeSubProjectBuildTargets(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter) throws IOException {
        Object object;
        Object object2;
        int n;
        LibraryItem[] libraryItemArray;
        bufferedWriter.write("\n");
        bufferedWriter.write("# Subprojects\n");
        bufferedWriter.write(".build-subprojects:\n");
        LibrariesConfiguration librariesConfiguration = null;
        if (makeConfiguration.isLinkerConfiguration()) {
            librariesConfiguration = makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration();
            libraryItemArray = librariesConfiguration.getLibraryItemsAsArray();
            for (n = 0; n < libraryItemArray.length; ++n) {
                if (!(libraryItemArray[n] instanceof LibraryItem.ProjectItem)) continue;
                object2 = (LibraryItem.ProjectItem)libraryItemArray[n];
                object = ((LibraryItem.ProjectItem)object2).getMakeArtifact();
                String string = ((MakeArtifact)object).getWorkingDirectory();
                if (!((MakeArtifact)object).getBuild()) continue;
                bufferedWriter.write("\tcd " + IpeUtils.escapeOddCharacters((String)string) + " && " + ((MakeArtifact)object).getBuildCommand() + "\n");
            }
        }
        libraryItemArray = makeConfiguration.getRequiredProjectsConfiguration().getRequiredProjectItemsAsArray();
        for (n = 0; n < libraryItemArray.length; ++n) {
            object2 = ((LibraryItem.ProjectItem)libraryItemArray[n]).getMakeArtifact();
            object = ((MakeArtifact)object2).getWorkingDirectory();
            if (!((MakeArtifact)object2).getBuild()) continue;
            bufferedWriter.write("\tcd " + IpeUtils.escapeOddCharacters((String)object) + " && " + ((MakeArtifact)object2).getBuildCommand() + "\n");
        }
    }

    private void writeSubProjectCleanTargets(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter) throws IOException {
        Object object;
        Object object2;
        int n;
        LibraryItem[] libraryItemArray;
        bufferedWriter.write("\n");
        bufferedWriter.write("# Subprojects\n");
        bufferedWriter.write(".clean-subprojects:\n");
        LibrariesConfiguration librariesConfiguration = null;
        if (makeConfiguration.isLinkerConfiguration()) {
            librariesConfiguration = makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration();
            libraryItemArray = librariesConfiguration.getLibraryItemsAsArray();
            for (n = 0; n < libraryItemArray.length; ++n) {
                if (!(libraryItemArray[n] instanceof LibraryItem.ProjectItem)) continue;
                object2 = (LibraryItem.ProjectItem)libraryItemArray[n];
                object = ((LibraryItem.ProjectItem)object2).getMakeArtifact();
                String string = ((MakeArtifact)object).getWorkingDirectory();
                if (!((MakeArtifact)object).getBuild()) continue;
                bufferedWriter.write("\tcd " + IpeUtils.escapeOddCharacters((String)string) + " && " + ((MakeArtifact)object).getCleanCommand() + "\n");
            }
        }
        libraryItemArray = makeConfiguration.getRequiredProjectsConfiguration().getRequiredProjectItemsAsArray();
        for (n = 0; n < libraryItemArray.length; ++n) {
            object2 = ((LibraryItem.ProjectItem)libraryItemArray[n]).getMakeArtifact();
            object = ((MakeArtifact)object2).getWorkingDirectory();
            if (!((MakeArtifact)object2).getBuild()) continue;
            bufferedWriter.write("\tcd " + IpeUtils.escapeOddCharacters((String)object) + " && " + ((MakeArtifact)object2).getCleanCommand() + "\n");
        }
    }

    private void writeCleanTarget(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("# Clean Targets\n");
        if (this.hasSubprojects(makeConfiguration)) {
            bufferedWriter.write(".clean-conf: ${CLEAN_SUBPROJECTS}\n");
        } else {
            bufferedWriter.write(".clean-conf:\n");
        }
        if (makeConfiguration.isCompileConfiguration()) {
            bufferedWriter.write("\t${RM} -r build/" + makeConfiguration.getName() + "\n");
            bufferedWriter.write("\t${RM} " + this.getOutput(makeConfiguration) + "\n");
            if (makeConfiguration.getCompilerSet().getCompilerSet() != null && makeConfiguration.getCompilerSet().getCompilerSet().isSunCompiler() && makeConfiguration.hasCPPFiles(this.projectDescriptor)) {
                bufferedWriter.write("\t${CCADMIN} -clean\n");
            }
            if (makeConfiguration.hasFortranFiles(this.projectDescriptor)) {
                bufferedWriter.write("\t${RM} *.mod\n");
            }
            Item[] itemArray = this.projectDescriptor.getProjectItems();
            for (int i = 0; i < itemArray.length; ++i) {
                ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue() || itemConfiguration.getTool() != 3 || !itemConfiguration.getCustomToolConfiguration().getModified()) continue;
                bufferedWriter.write("\t${RM} " + itemConfiguration.getCustomToolConfiguration().getOutputs().getValue() + "\n");
            }
        } else if (makeConfiguration.isMakefileConfiguration()) {
            MakefileConfiguration makefileConfiguration = makeConfiguration.getMakefileConfiguration();
            String string = makefileConfiguration.getOutput().getValue();
            String string2 = makefileConfiguration.getBuildCommandWorkingDirValue();
            String string3 = makefileConfiguration.getCleanCommand().getValue();
            bufferedWriter.write("\tcd " + IpeUtils.escapeOddCharacters((String)string2) + " && " + string3 + "\n");
        }
        this.writeSubProjectCleanTargets(makeConfiguration, bufferedWriter);
    }

    private void writeDependencyChecking(MakeConfiguration makeConfiguration, BufferedWriter bufferedWriter) throws IOException {
        if (makeConfiguration.getDependencyChecking().getValue() && !makeConfiguration.isMakefileConfiguration()) {
            bufferedWriter.write("\n");
            bufferedWriter.write("# Enable dependency checking\n");
            bufferedWriter.write(".dep.inc: .depcheck-impl\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("include .dep.inc\n");
        }
    }

    private String getOutput(MakeConfiguration makeConfiguration) {
        if (makeConfiguration.isLinkerConfiguration()) {
            String string = makeConfiguration.getLinkerConfiguration().getOutputValue();
            if (makeConfiguration.isApplicationConfiguration() && makeConfiguration.getPlatform().getValue() == 3) {
                string = string + ".exe";
            }
            return string;
        }
        if (makeConfiguration.isArchiverConfiguration()) {
            return makeConfiguration.getArchiverConfiguration().getOutputValue();
        }
        if (makeConfiguration.isMakefileConfiguration()) {
            return makeConfiguration.getMakefileConfiguration().getOutput().getValue();
        }
        assert (false);
        return null;
    }

    public static String getObjectDir(MakeConfiguration makeConfiguration) {
        return "build/" + makeConfiguration.getName() + '/' + "${PLATFORM}";
    }

    private String getObjectFiles(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration) {
        Item[] itemArray = makeConfigurationDescriptor.getProjectItems();
        StringBuilder stringBuilder = new StringBuilder();
        if (makeConfiguration.isCompileConfiguration()) {
            for (int i = 0; i < itemArray.length; ++i) {
                ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue() || !itemConfiguration.isCompilerToolConfiguration() || itemArray[i].hasHeaderOrSourceExtension(false, false)) continue;
                BasicCompilerConfiguration basicCompilerConfiguration = itemConfiguration.getCompilerConfiguration();
                stringBuilder.append(" \\\n\t");
                stringBuilder.append(basicCompilerConfiguration.getOutputFile(itemArray[i], makeConfiguration, false));
            }
        }
        return stringBuilder.toString();
    }

    private boolean hasSubprojects(MakeConfiguration makeConfiguration) {
        LibrariesConfiguration librariesConfiguration = makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration();
        LibraryItem[] libraryItemArray = librariesConfiguration.getLibraryItemsAsArray();
        for (int i = 0; i < libraryItemArray.length; ++i) {
            if (!(libraryItemArray[i] instanceof LibraryItem.ProjectItem)) continue;
            return true;
        }
        return false;
    }

    private void writePackagingScript(MakeConfiguration makeConfiguration) {
        String string = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Package-" + makeConfiguration.getName() + ".bash";
        if (makeConfiguration.getPackagingConfiguration().getFiles().getValue().size() == 0) {
            return;
        }
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(makeConfiguration.getPackagingConfiguration().getType().getValue());
        if (packagerDescriptor == null || packagerDescriptor instanceof DummyPackager) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        try {
            this.writePackagingScriptBody(bufferedWriter, makeConfiguration);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writePackagingScriptBody(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration) throws IOException {
        String string = "tmp-packaging";
        String string2 = ConfigurationMakefileWriter.getObjectDir(makeConfiguration) + "/" + string;
        PackagingConfiguration packagingConfiguration = makeConfiguration.getPackagingConfiguration();
        String string3 = packagingConfiguration.getOutputValue();
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(packagingConfiguration.getType().getValue());
        bufferedWriter.write("#!/bin/bash");
        if (makeConfiguration.getPackagingConfiguration().getVerbose().getValue()) {
            bufferedWriter.write(" -x");
        }
        bufferedWriter.write("\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("# Generated - do not edit!\n");
        bufferedWriter.write("#\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Macros\n");
        bufferedWriter.write("TOP=`pwd`\n");
        bufferedWriter.write("PLATFORM=" + makeConfiguration.getVariant() + "\n");
        bufferedWriter.write("TMPDIR=" + string2 + "\n");
        bufferedWriter.write("TMPDIRNAME=" + string + "\n");
        String string4 = makeConfiguration.getOutputValue();
        if (string4 == null || string4.length() == 0) {
            string4 = "MissingOutputInProject";
        }
        bufferedWriter.write("OUTPUT_PATH=" + string4 + "\n");
        bufferedWriter.write("OUTPUT_BASENAME=" + IpeUtils.getBaseName((String)string4) + "\n");
        bufferedWriter.write("PACKAGE_TOP_DIR=" + (packagingConfiguration.getTopDirValue().length() > 0 ? packagingConfiguration.getTopDirValue() + "/" : "") + "\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Functions\n");
        bufferedWriter.write("function checkReturnCode\n");
        bufferedWriter.write("{\n");
        bufferedWriter.write("    rc=$?\n");
        bufferedWriter.write("    if [ $rc != 0 ]\n");
        bufferedWriter.write("    then\n");
        bufferedWriter.write("        exit $rc\n");
        bufferedWriter.write("    fi\n");
        bufferedWriter.write("}\n");
        bufferedWriter.write("function makeDirectory\n");
        bufferedWriter.write("# $1 directory path\n");
        bufferedWriter.write("# $2 permission (optional)\n");
        bufferedWriter.write("{\n");
        bufferedWriter.write("    mkdir -p \"$1\"\n");
        bufferedWriter.write("    checkReturnCode\n");
        bufferedWriter.write("    if [ \"$2\" != \"\" ]\n");
        bufferedWriter.write("    then\n");
        bufferedWriter.write("      chmod $2 \"$1\"\n");
        bufferedWriter.write("      checkReturnCode\n");
        bufferedWriter.write("    fi\n");
        bufferedWriter.write("}\n");
        bufferedWriter.write("function copyFileToTmpDir\n");
        bufferedWriter.write("# $1 from-file path\n");
        bufferedWriter.write("# $2 to-file path\n");
        bufferedWriter.write("# $3 permission\n");
        bufferedWriter.write("{\n");
        bufferedWriter.write("    cp \"$1\" \"$2\"\n");
        bufferedWriter.write("    checkReturnCode\n");
        bufferedWriter.write("    if [ \"$3\" != \"\" ]\n");
        bufferedWriter.write("    then\n");
        bufferedWriter.write("        chmod $3 \"$2\"\n");
        bufferedWriter.write("        checkReturnCode\n");
        bufferedWriter.write("    fi\n");
        bufferedWriter.write("}\n");
        bufferedWriter.write("\n");
        bufferedWriter.write("# Setup\n");
        bufferedWriter.write("cd \"${TOP}\"\n");
        if (packagerDescriptor.isOutputAFolder()) {
            bufferedWriter.write("mkdir -p " + string3 + "\n");
        } else {
            bufferedWriter.write("mkdir -p " + IpeUtils.getDirName((String)string3) + "\n");
        }
        bufferedWriter.write("rm -rf ${TMPDIR}\n");
        bufferedWriter.write("mkdir -p ${TMPDIR}\n");
        bufferedWriter.write("\n");
        packagerDescriptor.getShellFileWriter().writeShellScript(bufferedWriter, makeConfiguration, packagingConfiguration);
        bufferedWriter.write("# Cleanup\n");
        bufferedWriter.write("cd \"${TOP}\"\n");
        bufferedWriter.write("rm -rf ${TMPDIR}\n");
    }
}

