/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.RequiredProjectsConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonConfigurationXMLCodec
extends XMLDecoder
implements XMLEncoder {
    public static final int CURRENT_VERSION = 51;
    protected static final String PROJECT_DESCRIPTOR_ELEMENT = "projectDescriptor";
    protected static final String DEBUGGING_ELEMENT = "justfordebugging";
    protected static final String CONFIGURATION_DESCRIPTOR_ELEMENT = "configurationDescriptor";
    protected static final String DEFAULT_CONF_ELEMENT = "defaultConf";
    protected static final String CONFS_ELEMENT = "confs";
    protected static final String CONF_ELEMENT = "conf";
    protected static final String DIRECTORY_PATH_ELEMENT = "directoryPath";
    protected static final String FOLDER_PATH_ELEMENT = "folderPath";
    protected static final String SOURCE_FOLDERS_ELEMENT = "sourceFolders";
    protected static final String LOGICAL_FOLDER_ELEMENT = "logicalFolder";
    protected static final String ITEM_PATH_ELEMENT = "itemPath";
    protected static final String PROJECT_MAKEFILE_ELEMENT = "projectmakefile";
    protected static final String REQUIRED_PROJECTS_ELEMENT = "requiredProjects";
    protected static final String SOURCE_ROOT_LIST_ELEMENT = "sourceRootList";
    protected static final String SOURCE_ENCODING_ELEMENT = "sourceEncoding";
    protected static final String TOOLS_SET_ELEMENT = "toolsSet";
    protected static final String DEVELOPMENT_SERVER_ELEMENT = "developmentServer";
    protected static final String COMPILER_SET_ELEMENT = "compilerSet";
    protected static final String C_REQUIRED_ELEMENT = "cRequired";
    protected static final String CPP_REQUIRED_ELEMENT = "cppRequired";
    protected static final String FORTRAN_REQUIRED_ELEMENT = "fortranRequired";
    protected static final String PLATFORM_ELEMENT = "platform";
    protected static final String DEPENDENCY_CHECKING = "dependencyChecking";
    protected static final String NEO_CONF_ELEMENT = "neoConf";
    protected static final String COMPILE_TYPE_ELEMENT = "compileType";
    protected static final String EXT_CONF_ELEMENT = "extConf";
    protected static final String MAKEFILE_TYPE_ELEMENT = "makefileType";
    protected static final String MAKETOOL_ELEMENT = "makeTool";
    protected static final String BUILD_COMMAND_ELEMENT = "buildCommand";
    protected static final String BUILD_COMMAND_WORKING_DIR_ELEMENT = "buildCommandWorkingDir";
    protected static final String CLEAN_COMMAND_ELEMENT = "cleanCommand";
    protected static final String EXECUTABLE_PATH_ELEMENT = "executablePath";
    protected static final String COMMANDLINE_TOOL_ELEMENT = "commandlineTool";
    protected static final String ADDITIONAL_DEP_ELEMENT = "additionalDep";
    protected static final String ADDITIONAL_OPTIONS_ELEMENT = "additionalOptions";
    protected static final String OUTPUT_ELEMENT = "output";
    protected static final String INHERIT_INC_VALUES_ELEMENT = "inheritIncValues";
    protected static final String INHERIT_PRE_VALUES_ELEMENT = "inheritPreValues";
    protected static final String INCLUDE_DIRECTORIES_ELEMENT = "includeDirectories";
    protected static final String COMPILERTOOL_ELEMENT = "compilerTool";
    protected static final String DEBUGGING_SYMBOLS_ELEMENT = "debuggingSymbols";
    protected static final String OPTIMIZATION_LEVEL_ELEMENT = "optimizationLevel";
    protected static final String DEVELOPMENT_MODE_ELEMENT = "developmentMode";
    protected static final String COMMAND_LINE_ELEMENT = "commandLine";
    protected static final String STRIP_SYMBOLS_ELEMENT = "stripSymbols";
    protected static final String SIXTYFOUR_BITS_ELEMENT = "sixtyfourBits";
    protected static final String ARCHITECTURE_ELEMENT = "architecture";
    protected static final String PREPROCESSOR_ELEMENT = "preprocessor";
    protected static final String PREPROCESSOR_LIST_ELEMENT = "preprocessorList";
    protected static final String SUPRESS_WARNINGS_ELEMENT = "supressWarnings";
    protected static final String WARNING_LEVEL_ELEMENT = "warningLevel";
    protected static final String MT_LEVEL_ELEMENT = "mtLevel";
    protected static final String STANDARDS_EVOLUTION_ELEMENT = "standardsEvolution";
    protected static final String LANGUAGE_EXTENSION_ELEMENT = "languageExtension";
    protected static final String SUN_CCOMPILERTOOL_OLD_ELEMENT = "sunCCompilerTool";
    protected static final String CCOMPILERTOOL_ELEMENT = "cCompilerTool";
    protected static final String CONFORMANCE_LEVEL_ELEMENT = "conformanceLevel";
    protected static final String CPP_STYLE_COMMENTS_ELEMENT = "cppstylecomments";
    protected static final String SUN_CCCOMPILERTOOL_OLD_ELEMENT = "sunCCCompilerTool";
    protected static final String CCCOMPILERTOOL_ELEMENT = "ccCompilerTool";
    protected static final String COMPATIBILITY_MODE_ELEMENT = "compatibilityMode";
    protected static final String LIBRARY_LEVEL_ELEMENT = "libraryLevel";
    protected static final String FORTRANCOMPILERTOOL_ELEMENT = "fortranCompilerTool";
    protected static final String CUSTOMTOOL_ELEMENT = "customTool";
    protected static final String CUSTOMTOOL_COMMANDLINE_ELEMENT = "customToolCommandline";
    protected static final String CUSTOMTOOL_DESCRIPTION_ELEMENT = "customToolDescription";
    protected static final String CUSTOMTOOL_OUTPUTS_ELEMENT = "customToolOutputs";
    protected static final String CUSTOMTOOL_ADDITIONAL_DEP_ELEMENT = "customToolAdditionalDep";
    protected static final String LINKERTOOL_ELEMENT = "linkerTool";
    protected static final String LINKER_KPIC_ELEMENT = "linkerKpic";
    protected static final String LINKER_NORUNPATH_ELEMENT = "linkerNorunpath";
    protected static final String LINKER_ASSIGN_ELEMENT = "linkerAssign";
    protected static final String LINKER_ADD_LIB_ELEMENT = "linkerAddLib";
    protected static final String LINKER_DYN_SERCH_ELEMENT = "linkerDynSerch";
    protected static final String LINKER_LIB_ELEMENT = "linkerLib";
    protected static final String LINKER_LIB_ITEMS_ELEMENT = "linkerLibItems";
    protected static final String LINKER_LIB_PROJECT_ITEM_ELEMENT = "linkerLibProjectItem";
    protected static final String LINKER_LIB_STDLIB_ITEM_ELEMENT = "linkerLibStdlibItem";
    protected static final String LINKER_LIB_LIB_ITEM_ELEMENT = "linkerLibLibItem";
    protected static final String LINKER_LIB_FILE_ITEM_ELEMENT = "linkerLibFileItem";
    protected static final String LINKER_LIB_OPTION_ITEM_ELEMENT = "linkerOptionItem";
    protected static final String MAKE_ARTIFACT_ELEMENT = "makeArtifact";
    protected static final String MAKE_ARTIFACT_PL_ELEMENT = "PL";
    protected static final String MAKE_ARTIFACT_CT_ELEMENT = "CT";
    protected static final String MAKE_ARTIFACT_CN_ELEMENT = "CN";
    protected static final String MAKE_ARTIFACT_AC_ELEMENT = "AC";
    protected static final String MAKE_ARTIFACT_BL_ELEMENT = "BL";
    protected static final String MAKE_ARTIFACT_WD_ELEMENT = "WD";
    protected static final String MAKE_ARTIFACT_BC_ELEMENT = "BC";
    protected static final String MAKE_ARTIFACT_CC_ELEMENT = "CC";
    protected static final String MAKE_ARTIFACT_OP_ELEMENT = "OP";
    protected static final String ARCHIVERTOOL_ELEMENT = "archiverTool";
    protected static final String ARCHIVERTOOL_RUN_RANLIB_ELEMENT = "runRanlib";
    protected static final String ARCHIVERTOOL_VERBOSE_ELEMENT = "archiverVerbose";
    protected static final String ARCHIVERTOOL_SUPRESS_ELEMENT = "archiverSupress";
    protected static final String VERSION_ATTR = "version";
    protected static final String TYPE_ATTR = "type";
    protected static final String NAME_ATTR = "name";
    protected static final String SET_ATTR = "set";
    protected static final String DISPLAY_NAME_ATTR = "displayName";
    protected static final String PROJECT_FILES_ATTR = "projectFiles";
    protected static final String VALUE_ATTR = "value";
    protected static final String MANDATORY_ATTR = "mandatory";
    protected static final String TO_ATTR = "to";
    protected static final String FROM_ATTR = "from";
    protected static final String PERM_ATTR = "perm";
    protected static final String OWNER_ATTR = "owner";
    protected static final String GROUP_ATTR = "group";
    protected static final String TRUE_VALUE = "true";
    protected static final String FALSE_VALUE = "false";
    protected static final String LIST_ELEMENT = "Elem";
    protected static final String VERBOSE_ELEMENT = "verbose";
    protected static final String PACK_ELEMENT = "packaging";
    protected static final String PACK_TYPE_ELEMENT = "packType";
    protected static final String PACK_FILES_LIST_ELEMENT = "packFileList";
    protected static final String PACK_FILE_LIST_ELEMENT = "packFileListElem";
    protected static final String PACK_INFOS_LIST_ELEMENT = "packInfoList";
    protected static final String PACK_INFO_LIST_ELEMENT = "packInfoListElem";
    protected static final String PACK_TOPDIR_ELEMENT = "packTopDir";
    private ConfigurationDescriptor projectDescriptor;
    private boolean publicLocation;

    protected CommonConfigurationXMLCodec(ConfigurationDescriptor configurationDescriptor, boolean bl) {
        this.projectDescriptor = configurationDescriptor;
        this.publicLocation = bl;
    }

    public void encode(XMLEncoderStream xMLEncoderStream) {
        xMLEncoderStream.elementOpen(CONFIGURATION_DESCRIPTOR_ELEMENT, 51);
        if (this.publicLocation) {
            this.writeLogicalFolders(xMLEncoderStream);
            this.writeSourceRoots(xMLEncoderStream);
        }
        xMLEncoderStream.element(PROJECT_MAKEFILE_ELEMENT, ((MakeConfigurationDescriptor)this.projectDescriptor).getProjectMakefileName());
        if (!this.publicLocation) {
            xMLEncoderStream.element(DEFAULT_CONF_ELEMENT, "" + this.projectDescriptor.getConfs().getActiveAsIndex());
        }
        this.writeConfsBlock(xMLEncoderStream);
        xMLEncoderStream.elementClose(CONFIGURATION_DESCRIPTOR_ELEMENT);
    }

    private void writeConfsBlock(XMLEncoderStream xMLEncoderStream) {
        xMLEncoderStream.elementOpen(CONFS_ELEMENT);
        Configurations configurations = this.projectDescriptor.getConfs();
        for (int i = 0; i < configurations.size(); ++i) {
            XMLEncoder xMLEncoder;
            ConfigurationAuxObject configurationAuxObject;
            int n;
            ConfigurationAuxObject[] configurationAuxObjectArray;
            MakeConfiguration makeConfiguration = (MakeConfiguration)configurations.getConf(i);
            xMLEncoderStream.elementOpen(CONF_ELEMENT, new AttrValuePair[]{new AttrValuePair(NAME_ATTR, "" + makeConfiguration.getName()), new AttrValuePair(TYPE_ATTR, "" + makeConfiguration.getConfigurationType().getValue())});
            if (this.publicLocation) {
                this.writeToolsSetBlock(xMLEncoderStream, makeConfiguration);
                if (makeConfiguration.isCompileConfiguration()) {
                    this.writeCompiledProjectConfBlock(xMLEncoderStream, makeConfiguration);
                }
                if (makeConfiguration.isMakefileConfiguration()) {
                    this.writeMakefileProjectConfBlock(xMLEncoderStream, makeConfiguration);
                }
                CommonConfigurationXMLCodec.writePackaging(xMLEncoderStream, makeConfiguration.getPackagingConfiguration());
                configurationAuxObjectArray = configurations.getConf(i).getAuxObjects();
                for (n = 0; n < configurationAuxObjectArray.length; ++n) {
                    configurationAuxObject = configurationAuxObjectArray[n];
                    if (!configurationAuxObject.shared()) continue;
                    xMLEncoder = configurationAuxObject.getXMLEncoder();
                    xMLEncoder.encode(xMLEncoderStream);
                }
            } else {
                configurationAuxObjectArray = configurations.getConf(i).getAuxObjects();
                for (n = 0; n < configurationAuxObjectArray.length; ++n) {
                    configurationAuxObject = configurationAuxObjectArray[n];
                    if (configurationAuxObject.shared()) continue;
                    xMLEncoder = configurationAuxObject.getXMLEncoder();
                    xMLEncoder.encode(xMLEncoderStream);
                }
            }
            xMLEncoderStream.elementClose(CONF_ELEMENT);
        }
        xMLEncoderStream.elementClose(CONFS_ELEMENT);
    }

    private void writeToolsSetBlock(XMLEncoderStream xMLEncoderStream, MakeConfiguration makeConfiguration) {
        xMLEncoderStream.elementOpen(TOOLS_SET_ELEMENT);
        xMLEncoderStream.element(DEVELOPMENT_SERVER_ELEMENT, makeConfiguration.getDevelopmentHost().getName());
        xMLEncoderStream.element(COMPILER_SET_ELEMENT, "" + makeConfiguration.getCompilerSet().getNameAndFlavor());
        if (makeConfiguration.getCRequired().getValue() != makeConfiguration.getCRequired().getDefault()) {
            xMLEncoderStream.element(C_REQUIRED_ELEMENT, "" + makeConfiguration.getCRequired().getValue());
        }
        if (makeConfiguration.getCppRequired().getValue() != makeConfiguration.getCppRequired().getDefault()) {
            xMLEncoderStream.element(CPP_REQUIRED_ELEMENT, "" + makeConfiguration.getCppRequired().getValue());
        }
        if (makeConfiguration.getFortranRequired().getValue() != makeConfiguration.getFortranRequired().getDefault()) {
            xMLEncoderStream.element(FORTRAN_REQUIRED_ELEMENT, "" + makeConfiguration.getFortranRequired().getValue());
        }
        xMLEncoderStream.element(PLATFORM_ELEMENT, "" + makeConfiguration.getPlatform().getValue());
        if (makeConfiguration.getDependencyChecking().getModified()) {
            xMLEncoderStream.element(DEPENDENCY_CHECKING, "" + makeConfiguration.getDependencyChecking().getValue());
        }
        xMLEncoderStream.elementClose(TOOLS_SET_ELEMENT);
    }

    private void writeCompiledProjectConfBlock(XMLEncoderStream xMLEncoderStream, MakeConfiguration makeConfiguration) {
        xMLEncoderStream.elementOpen(COMPILE_TYPE_ELEMENT);
        CommonConfigurationXMLCodec.writeCCompilerConfiguration(xMLEncoderStream, makeConfiguration.getCCompilerConfiguration());
        CommonConfigurationXMLCodec.writeCCCompilerConfiguration(xMLEncoderStream, makeConfiguration.getCCCompilerConfiguration());
        CommonConfigurationXMLCodec.writeFortranCompilerConfiguration(xMLEncoderStream, makeConfiguration.getFortranCompilerConfiguration());
        if (makeConfiguration.isLinkerConfiguration()) {
            CommonConfigurationXMLCodec.writeLinkerConfiguration(xMLEncoderStream, makeConfiguration.getLinkerConfiguration());
        }
        if (makeConfiguration.isArchiverConfiguration()) {
            CommonConfigurationXMLCodec.writeArchiverConfiguration(xMLEncoderStream, makeConfiguration.getArchiverConfiguration());
        }
        xMLEncoderStream.elementClose(COMPILE_TYPE_ELEMENT);
    }

    private void writeMakefileProjectConfBlock(XMLEncoderStream xMLEncoderStream, MakeConfiguration makeConfiguration) {
        xMLEncoderStream.elementOpen(MAKEFILE_TYPE_ELEMENT);
        xMLEncoderStream.elementOpen(MAKETOOL_ELEMENT);
        xMLEncoderStream.element(BUILD_COMMAND_WORKING_DIR_ELEMENT, makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().getValue());
        xMLEncoderStream.element(BUILD_COMMAND_ELEMENT, makeConfiguration.getMakefileConfiguration().getBuildCommand().getValue());
        xMLEncoderStream.element(CLEAN_COMMAND_ELEMENT, makeConfiguration.getMakefileConfiguration().getCleanCommand().getValue());
        xMLEncoderStream.element(EXECUTABLE_PATH_ELEMENT, makeConfiguration.getMakefileConfiguration().getOutput().getValue());
        CommonConfigurationXMLCodec.writeCCompilerConfiguration(xMLEncoderStream, makeConfiguration.getCCompilerConfiguration());
        CommonConfigurationXMLCodec.writeCCCompilerConfiguration(xMLEncoderStream, makeConfiguration.getCCCompilerConfiguration());
        CommonConfigurationXMLCodec.writeFortranCompilerConfiguration(xMLEncoderStream, makeConfiguration.getFortranCompilerConfiguration());
        xMLEncoderStream.elementClose(MAKETOOL_ELEMENT);
        CommonConfigurationXMLCodec.writeRequiredProjects(xMLEncoderStream, makeConfiguration.getRequiredProjectsConfiguration());
        xMLEncoderStream.elementClose(MAKEFILE_TYPE_ELEMENT);
    }

    private void writeLogicalFolders(XMLEncoderStream xMLEncoderStream) {
        this.writeLogicalFolder(xMLEncoderStream, ((MakeConfigurationDescriptor)this.projectDescriptor).getLogicalFolders());
    }

    private void writeLogicalFolder(XMLEncoderStream xMLEncoderStream, Folder folder) {
        xMLEncoderStream.elementOpen(LOGICAL_FOLDER_ELEMENT, new AttrValuePair[]{new AttrValuePair(NAME_ATTR, "" + folder.getName()), new AttrValuePair(DISPLAY_NAME_ATTR, "" + folder.getDisplayName()), new AttrValuePair(PROJECT_FILES_ATTR, "" + folder.isProjectFiles())});
        Folder[] folderArray = folder.getFoldersAsArray();
        for (int i = 0; i < folderArray.length; ++i) {
            this.writeLogicalFolder(xMLEncoderStream, folderArray[i]);
        }
        Item[] itemArray = folder.getItemsAsArray();
        for (int i = 0; i < itemArray.length; ++i) {
            xMLEncoderStream.element(ITEM_PATH_ELEMENT, itemArray[i].getPath());
        }
        xMLEncoderStream.elementClose(LOGICAL_FOLDER_ELEMENT);
    }

    private void writeSourceRoots(XMLEncoderStream xMLEncoderStream) {
        this.writeSourceRoots(xMLEncoderStream, ((MakeConfigurationDescriptor)this.projectDescriptor).getSourceRoots());
    }

    private void writeSourceRoots(XMLEncoderStream xMLEncoderStream, List<String> list) {
        if (list.size() > 0) {
            xMLEncoderStream.elementOpen(SOURCE_ROOT_LIST_ELEMENT);
            for (String string : list) {
                xMLEncoderStream.element(LIST_ELEMENT, string);
            }
            xMLEncoderStream.elementClose(SOURCE_ROOT_LIST_ELEMENT);
        }
    }

    public static void writeCCompilerConfiguration(XMLEncoderStream xMLEncoderStream, CCompilerConfiguration cCompilerConfiguration) {
        if (!cCompilerConfiguration.getModified()) {
            return;
        }
        xMLEncoderStream.elementOpen(CCOMPILERTOOL_ELEMENT);
        if (cCompilerConfiguration.getDevelopmentMode().getModified()) {
            xMLEncoderStream.element(DEVELOPMENT_MODE_ELEMENT, "" + cCompilerConfiguration.getDevelopmentMode().getValue());
        }
        if (cCompilerConfiguration.getStrip().getModified()) {
            xMLEncoderStream.element(STRIP_SYMBOLS_ELEMENT, "" + cCompilerConfiguration.getStrip().getValue());
        }
        if (cCompilerConfiguration.getSixtyfourBits().getModified()) {
            xMLEncoderStream.element(ARCHITECTURE_ELEMENT, "" + cCompilerConfiguration.getSixtyfourBits().getValue());
        }
        if (cCompilerConfiguration.getTool().getModified()) {
            xMLEncoderStream.element(COMMANDLINE_TOOL_ELEMENT, "" + cCompilerConfiguration.getTool().getValue());
        }
        if (cCompilerConfiguration.getIncludeDirectories().getModified()) {
            CommonConfigurationXMLCodec.writeDirectories(xMLEncoderStream, INCLUDE_DIRECTORIES_ELEMENT, cCompilerConfiguration.getIncludeDirectories().getValueAsArray());
        }
        if (cCompilerConfiguration.getStandardsEvolution().getModified()) {
            xMLEncoderStream.element(STANDARDS_EVOLUTION_ELEMENT, "" + cCompilerConfiguration.getStandardsEvolution().getValue());
        }
        if (cCompilerConfiguration.getLanguageExt().getModified()) {
            xMLEncoderStream.element(LANGUAGE_EXTENSION_ELEMENT, "" + cCompilerConfiguration.getLanguageExt().getValue());
        }
        if (cCompilerConfiguration.getInheritIncludes().getModified()) {
            xMLEncoderStream.element(INHERIT_INC_VALUES_ELEMENT, "" + cCompilerConfiguration.getInheritIncludes().getValue());
        }
        if (cCompilerConfiguration.getCommandLineConfiguration().getModified()) {
            xMLEncoderStream.element(COMMAND_LINE_ELEMENT, "" + cCompilerConfiguration.getCommandLineConfiguration().getValue());
        }
        if (cCompilerConfiguration.getPreprocessorConfiguration().getModified()) {
            CommonConfigurationXMLCodec.writeList(xMLEncoderStream, PREPROCESSOR_LIST_ELEMENT, cCompilerConfiguration.getPreprocessorConfiguration().getValueAsArray());
        }
        if (cCompilerConfiguration.getInheritPreprocessor().getModified()) {
            xMLEncoderStream.element(INHERIT_PRE_VALUES_ELEMENT, "" + cCompilerConfiguration.getInheritPreprocessor().getValue());
        }
        if (cCompilerConfiguration.getWarningLevel().getModified()) {
            xMLEncoderStream.element(WARNING_LEVEL_ELEMENT, "" + cCompilerConfiguration.getWarningLevel().getValue());
        }
        if (cCompilerConfiguration.getMTLevel().getModified()) {
            xMLEncoderStream.element(MT_LEVEL_ELEMENT, "" + cCompilerConfiguration.getMTLevel().getValue());
        }
        if (cCompilerConfiguration.getAdditionalDependencies().getModified()) {
            xMLEncoderStream.element(ADDITIONAL_DEP_ELEMENT, "" + cCompilerConfiguration.getAdditionalDependencies().getValue());
        }
        xMLEncoderStream.elementClose(CCOMPILERTOOL_ELEMENT);
    }

    public static void writeCCCompilerConfiguration(XMLEncoderStream xMLEncoderStream, CCCompilerConfiguration cCCompilerConfiguration) {
        if (!cCCompilerConfiguration.getModified()) {
            return;
        }
        xMLEncoderStream.elementOpen(CCCOMPILERTOOL_ELEMENT);
        if (cCCompilerConfiguration.getDevelopmentMode().getModified()) {
            xMLEncoderStream.element(DEVELOPMENT_MODE_ELEMENT, "" + cCCompilerConfiguration.getDevelopmentMode().getValue());
        }
        if (cCCompilerConfiguration.getStrip().getModified()) {
            xMLEncoderStream.element(STRIP_SYMBOLS_ELEMENT, "" + cCCompilerConfiguration.getStrip().getValue());
        }
        if (cCCompilerConfiguration.getSixtyfourBits().getModified()) {
            xMLEncoderStream.element(ARCHITECTURE_ELEMENT, "" + cCCompilerConfiguration.getSixtyfourBits().getValue());
        }
        if (cCCompilerConfiguration.getTool().getModified()) {
            xMLEncoderStream.element(COMMANDLINE_TOOL_ELEMENT, "" + cCCompilerConfiguration.getTool().getValue());
        }
        if (cCCompilerConfiguration.getIncludeDirectories().getModified()) {
            CommonConfigurationXMLCodec.writeDirectories(xMLEncoderStream, INCLUDE_DIRECTORIES_ELEMENT, cCCompilerConfiguration.getIncludeDirectories().getValueAsArray());
        }
        if (cCCompilerConfiguration.getStandardsEvolution().getModified()) {
            xMLEncoderStream.element(STANDARDS_EVOLUTION_ELEMENT, "" + cCCompilerConfiguration.getStandardsEvolution().getValue());
        }
        if (cCCompilerConfiguration.getLanguageExt().getModified()) {
            xMLEncoderStream.element(LANGUAGE_EXTENSION_ELEMENT, "" + cCCompilerConfiguration.getLanguageExt().getValue());
        }
        if (cCCompilerConfiguration.getInheritIncludes().getModified()) {
            xMLEncoderStream.element(INHERIT_INC_VALUES_ELEMENT, "" + cCCompilerConfiguration.getInheritIncludes().getValue());
        }
        if (cCCompilerConfiguration.getCommandLineConfiguration().getModified()) {
            xMLEncoderStream.element(COMMAND_LINE_ELEMENT, "" + cCCompilerConfiguration.getCommandLineConfiguration().getValue());
        }
        if (cCCompilerConfiguration.getPreprocessorConfiguration().getModified()) {
            CommonConfigurationXMLCodec.writeList(xMLEncoderStream, PREPROCESSOR_LIST_ELEMENT, cCCompilerConfiguration.getPreprocessorConfiguration().getValueAsArray());
        }
        if (cCCompilerConfiguration.getInheritPreprocessor().getModified()) {
            xMLEncoderStream.element(INHERIT_PRE_VALUES_ELEMENT, "" + cCCompilerConfiguration.getInheritPreprocessor().getValue());
        }
        if (cCCompilerConfiguration.getWarningLevel().getModified()) {
            xMLEncoderStream.element(WARNING_LEVEL_ELEMENT, "" + cCCompilerConfiguration.getWarningLevel().getValue());
        }
        if (cCCompilerConfiguration.getMTLevel().getModified()) {
            xMLEncoderStream.element(MT_LEVEL_ELEMENT, "" + cCCompilerConfiguration.getMTLevel().getValue());
        }
        if (cCCompilerConfiguration.getLibraryLevel().getModified()) {
            xMLEncoderStream.element(LIBRARY_LEVEL_ELEMENT, "" + cCCompilerConfiguration.getLibraryLevel().getValue());
        }
        if (cCCompilerConfiguration.getAdditionalDependencies().getModified()) {
            xMLEncoderStream.element(ADDITIONAL_DEP_ELEMENT, "" + cCCompilerConfiguration.getAdditionalDependencies().getValue());
        }
        xMLEncoderStream.elementClose(CCCOMPILERTOOL_ELEMENT);
    }

    public static void writeFortranCompilerConfiguration(XMLEncoderStream xMLEncoderStream, FortranCompilerConfiguration fortranCompilerConfiguration) {
        if (!fortranCompilerConfiguration.getModified()) {
            return;
        }
        xMLEncoderStream.elementOpen(FORTRANCOMPILERTOOL_ELEMENT);
        if (fortranCompilerConfiguration.getDevelopmentMode().getModified()) {
            xMLEncoderStream.element(DEVELOPMENT_MODE_ELEMENT, "" + fortranCompilerConfiguration.getDevelopmentMode().getValue());
        }
        if (fortranCompilerConfiguration.getStrip().getModified()) {
            xMLEncoderStream.element(STRIP_SYMBOLS_ELEMENT, "" + fortranCompilerConfiguration.getStrip().getValue());
        }
        if (fortranCompilerConfiguration.getSixtyfourBits().getModified()) {
            xMLEncoderStream.element(ARCHITECTURE_ELEMENT, "" + fortranCompilerConfiguration.getSixtyfourBits().getValue());
        }
        if (fortranCompilerConfiguration.getTool().getModified()) {
            xMLEncoderStream.element(COMMANDLINE_TOOL_ELEMENT, "" + fortranCompilerConfiguration.getTool().getValue());
        }
        if (fortranCompilerConfiguration.getCommandLineConfiguration().getModified()) {
            xMLEncoderStream.element(COMMAND_LINE_ELEMENT, "" + fortranCompilerConfiguration.getCommandLineConfiguration().getValue());
        }
        if (fortranCompilerConfiguration.getWarningLevel().getModified()) {
            xMLEncoderStream.element(WARNING_LEVEL_ELEMENT, "" + fortranCompilerConfiguration.getWarningLevel().getValue());
        }
        if (fortranCompilerConfiguration.getAdditionalDependencies().getModified()) {
            xMLEncoderStream.element(ADDITIONAL_DEP_ELEMENT, "" + fortranCompilerConfiguration.getAdditionalDependencies().getValue());
        }
        xMLEncoderStream.elementClose(FORTRANCOMPILERTOOL_ELEMENT);
    }

    public static void writeCustomToolConfiguration(XMLEncoderStream xMLEncoderStream, CustomToolConfiguration customToolConfiguration) {
        if (!customToolConfiguration.getModified()) {
            return;
        }
        xMLEncoderStream.elementOpen(CUSTOMTOOL_ELEMENT);
        if (customToolConfiguration.getCommandLine().getModified()) {
            xMLEncoderStream.element(CUSTOMTOOL_COMMANDLINE_ELEMENT, "" + customToolConfiguration.getCommandLine().getValue());
        }
        if (customToolConfiguration.getDescription().getModified()) {
            xMLEncoderStream.element(CUSTOMTOOL_DESCRIPTION_ELEMENT, "" + customToolConfiguration.getDescription().getValue());
        }
        if (customToolConfiguration.getOutputs().getModified()) {
            xMLEncoderStream.element(CUSTOMTOOL_OUTPUTS_ELEMENT, "" + customToolConfiguration.getOutputs().getValue());
        }
        if (customToolConfiguration.getAdditionalDependencies().getModified()) {
            xMLEncoderStream.element(CUSTOMTOOL_ADDITIONAL_DEP_ELEMENT, "" + customToolConfiguration.getAdditionalDependencies().getValue());
        }
        xMLEncoderStream.elementClose(CUSTOMTOOL_ELEMENT);
    }

    public static void writeLinkerConfiguration(XMLEncoderStream xMLEncoderStream, LinkerConfiguration linkerConfiguration) {
        xMLEncoderStream.elementOpen(LINKERTOOL_ELEMENT);
        if (linkerConfiguration.getOutput().getModified()) {
            xMLEncoderStream.element(OUTPUT_ELEMENT, linkerConfiguration.getOutput().getValue());
        }
        if (linkerConfiguration.getAdditionalLibs().getModified()) {
            CommonConfigurationXMLCodec.writeDirectories(xMLEncoderStream, LINKER_ADD_LIB_ELEMENT, linkerConfiguration.getAdditionalLibs().getValueAsArray());
        }
        if (linkerConfiguration.getDynamicSearch().getModified()) {
            CommonConfigurationXMLCodec.writeDirectories(xMLEncoderStream, LINKER_DYN_SERCH_ELEMENT, linkerConfiguration.getDynamicSearch().getValueAsArray());
        }
        if (linkerConfiguration.getStripOption().getModified()) {
            xMLEncoderStream.element(STRIP_SYMBOLS_ELEMENT, "" + linkerConfiguration.getStripOption().getValue());
        }
        if (linkerConfiguration.getPICOption().getModified()) {
            xMLEncoderStream.element(LINKER_KPIC_ELEMENT, "" + linkerConfiguration.getPICOption().getValue());
        }
        if (linkerConfiguration.getNorunpathOption().getModified()) {
            xMLEncoderStream.element(LINKER_NORUNPATH_ELEMENT, "" + linkerConfiguration.getNorunpathOption().getValue());
        }
        if (linkerConfiguration.getNameassignOption().getModified()) {
            xMLEncoderStream.element(LINKER_ASSIGN_ELEMENT, "" + linkerConfiguration.getNameassignOption().getValue());
        }
        if (linkerConfiguration.getAdditionalDependencies().getModified()) {
            xMLEncoderStream.element(ADDITIONAL_DEP_ELEMENT, "" + linkerConfiguration.getAdditionalDependencies().getValue());
        }
        if (linkerConfiguration.getTool().getModified()) {
            xMLEncoderStream.element(COMMANDLINE_TOOL_ELEMENT, linkerConfiguration.getTool().getValue());
        }
        CommonConfigurationXMLCodec.writeLibrariesConfiguration(xMLEncoderStream, linkerConfiguration.getLibrariesConfiguration());
        if (linkerConfiguration.getCommandLineConfiguration().getModified()) {
            xMLEncoderStream.element(COMMAND_LINE_ELEMENT, "" + linkerConfiguration.getCommandLineConfiguration().getValue());
        }
        xMLEncoderStream.elementClose(LINKERTOOL_ELEMENT);
    }

    public static void writeLibrariesConfiguration(XMLEncoderStream xMLEncoderStream, LibrariesConfiguration librariesConfiguration) {
        xMLEncoderStream.elementOpen(LINKER_LIB_ITEMS_ELEMENT);
        LibraryItem[] libraryItemArray = librariesConfiguration.getLibraryItemsAsArray();
        for (int i = 0; i < libraryItemArray.length; ++i) {
            if (libraryItemArray[i] instanceof LibraryItem.ProjectItem) {
                xMLEncoderStream.elementOpen(LINKER_LIB_PROJECT_ITEM_ELEMENT);
                CommonConfigurationXMLCodec.writeMakeArtifact(xMLEncoderStream, ((LibraryItem.ProjectItem)libraryItemArray[i]).getMakeArtifact());
                xMLEncoderStream.elementClose(LINKER_LIB_PROJECT_ITEM_ELEMENT);
                continue;
            }
            if (libraryItemArray[i] instanceof LibraryItem.StdLibItem) {
                xMLEncoderStream.element(LINKER_LIB_STDLIB_ITEM_ELEMENT, ((LibraryItem.StdLibItem)libraryItemArray[i]).getName());
                continue;
            }
            if (libraryItemArray[i] instanceof LibraryItem.LibItem) {
                xMLEncoderStream.element(LINKER_LIB_LIB_ITEM_ELEMENT, ((LibraryItem.LibItem)libraryItemArray[i]).getLibName());
                continue;
            }
            if (libraryItemArray[i] instanceof LibraryItem.LibFileItem) {
                xMLEncoderStream.element(LINKER_LIB_FILE_ITEM_ELEMENT, ((LibraryItem.LibFileItem)libraryItemArray[i]).getPath());
                continue;
            }
            if (!(libraryItemArray[i] instanceof LibraryItem.OptionItem)) continue;
            xMLEncoderStream.element(LINKER_LIB_OPTION_ITEM_ELEMENT, ((LibraryItem.OptionItem)libraryItemArray[i]).getLibraryOption());
        }
        xMLEncoderStream.elementClose(LINKER_LIB_ITEMS_ELEMENT);
    }

    public static void writeRequiredProjects(XMLEncoderStream xMLEncoderStream, RequiredProjectsConfiguration requiredProjectsConfiguration) {
        LibraryItem.ProjectItem[] projectItemArray = requiredProjectsConfiguration.getRequiredProjectItemsAsArray();
        xMLEncoderStream.elementOpen(REQUIRED_PROJECTS_ELEMENT);
        for (int i = 0; i < projectItemArray.length; ++i) {
            CommonConfigurationXMLCodec.writeMakeArtifact(xMLEncoderStream, projectItemArray[i].getMakeArtifact());
        }
        xMLEncoderStream.elementClose(REQUIRED_PROJECTS_ELEMENT);
    }

    private static void writePackaging(XMLEncoderStream xMLEncoderStream, PackagingConfiguration packagingConfiguration) {
        if (!packagingConfiguration.isModified()) {
            return;
        }
        xMLEncoderStream.elementOpen(PACK_ELEMENT);
        xMLEncoderStream.element(PACK_TYPE_ELEMENT, "" + packagingConfiguration.getName());
        if (packagingConfiguration.getVerbose().getModified()) {
            xMLEncoderStream.element(VERBOSE_ELEMENT, "" + packagingConfiguration.getVerbose().getValue());
        }
        if (packagingConfiguration.getOutput().getModified()) {
            xMLEncoderStream.element(OUTPUT_ELEMENT, packagingConfiguration.getOutput().getValue());
        }
        if (packagingConfiguration.getTool().getModified()) {
            xMLEncoderStream.element(COMMANDLINE_TOOL_ELEMENT, packagingConfiguration.getTool().getValue());
        }
        if (packagingConfiguration.getOptions().getModified()) {
            xMLEncoderStream.element(ADDITIONAL_OPTIONS_ELEMENT, packagingConfiguration.getOptions().getValue());
        }
        if (packagingConfiguration.getTopDir().getModified()) {
            xMLEncoderStream.element(PACK_TOPDIR_ELEMENT, packagingConfiguration.getTopDir().getValue());
        }
        xMLEncoderStream.elementOpen(PACK_FILES_LIST_ELEMENT);
        List list = packagingConfiguration.getFiles().getValue();
        for (Object object : list) {
            xMLEncoderStream.element(PACK_FILE_LIST_ELEMENT, new AttrValuePair[]{new AttrValuePair(TYPE_ATTR, "" + ((PackagerFileElement)object).getType().toString()), new AttrValuePair(TO_ATTR, "" + ((PackagerFileElement)object).getTo()), new AttrValuePair(FROM_ATTR, "" + ((PackagerFileElement)object).getFrom()), new AttrValuePair(PERM_ATTR, "" + ((PackagerFileElement)object).getPermission()), new AttrValuePair(OWNER_ATTR, "" + ((PackagerFileElement)object).getOwner()), new AttrValuePair(GROUP_ATTR, "" + ((PackagerFileElement)object).getGroup())});
        }
        xMLEncoderStream.elementClose(PACK_FILES_LIST_ELEMENT);
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(packagingConfiguration.getType().getValue());
        if (packagerDescriptor.hasInfoList()) {
            Object object;
            xMLEncoderStream.elementOpen(PACK_INFOS_LIST_ELEMENT);
            object = packagingConfiguration.getHeaderSubList(packagingConfiguration.getType().getValue());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                PackagerInfoElement packagerInfoElement = (PackagerInfoElement)iterator.next();
                xMLEncoderStream.element(PACK_INFO_LIST_ELEMENT, new AttrValuePair[]{new AttrValuePair(NAME_ATTR, "" + packagerInfoElement.getName()), new AttrValuePair(VALUE_ATTR, "" + packagerInfoElement.getValue()), new AttrValuePair(MANDATORY_ATTR, "" + packagerInfoElement.isMandatory())});
            }
            xMLEncoderStream.elementClose(PACK_INFOS_LIST_ELEMENT);
        }
        xMLEncoderStream.elementClose(PACK_ELEMENT);
    }

    public static void writeMakeArtifact(XMLEncoderStream xMLEncoderStream, MakeArtifact makeArtifact) {
        xMLEncoderStream.elementOpen(MAKE_ARTIFACT_ELEMENT, new AttrValuePair[]{new AttrValuePair(MAKE_ARTIFACT_PL_ELEMENT, makeArtifact.getProjectLocation()), new AttrValuePair(MAKE_ARTIFACT_CT_ELEMENT, "" + makeArtifact.getConfigurationType()), new AttrValuePair(MAKE_ARTIFACT_CN_ELEMENT, makeArtifact.getConfigurationName()), new AttrValuePair(MAKE_ARTIFACT_AC_ELEMENT, "" + makeArtifact.getActive()), new AttrValuePair(MAKE_ARTIFACT_BL_ELEMENT, "" + makeArtifact.getBuild()), new AttrValuePair(MAKE_ARTIFACT_WD_ELEMENT, makeArtifact.getWorkingDirectory()), new AttrValuePair(MAKE_ARTIFACT_BC_ELEMENT, makeArtifact.getBuildCommand()), new AttrValuePair(MAKE_ARTIFACT_CC_ELEMENT, makeArtifact.getCleanCommand()), new AttrValuePair(MAKE_ARTIFACT_OP_ELEMENT, makeArtifact.getOutput())});
        xMLEncoderStream.elementClose(MAKE_ARTIFACT_ELEMENT);
    }

    public static void writeArchiverConfiguration(XMLEncoderStream xMLEncoderStream, ArchiverConfiguration archiverConfiguration) {
        xMLEncoderStream.elementOpen(ARCHIVERTOOL_ELEMENT);
        if (archiverConfiguration.getOutput().getModified()) {
            xMLEncoderStream.element(OUTPUT_ELEMENT, archiverConfiguration.getOutput().getValue());
        }
        if (archiverConfiguration.getRunRanlib().getModified()) {
            xMLEncoderStream.element(ARCHIVERTOOL_RUN_RANLIB_ELEMENT, "" + archiverConfiguration.getRunRanlib().getValue());
        }
        if (archiverConfiguration.getVerboseOption().getModified()) {
            xMLEncoderStream.element(ARCHIVERTOOL_VERBOSE_ELEMENT, "" + archiverConfiguration.getVerboseOption().getValue());
        }
        if (archiverConfiguration.getSupressOption().getModified()) {
            xMLEncoderStream.element(ARCHIVERTOOL_SUPRESS_ELEMENT, "" + archiverConfiguration.getSupressOption().getValue());
        }
        if (archiverConfiguration.getAdditionalDependencies().getModified()) {
            xMLEncoderStream.element(ADDITIONAL_DEP_ELEMENT, "" + archiverConfiguration.getAdditionalDependencies().getValue());
        }
        if (archiverConfiguration.getTool().getModified()) {
            xMLEncoderStream.element(COMMANDLINE_TOOL_ELEMENT, "" + archiverConfiguration.getTool().getValue());
        }
        if (archiverConfiguration.getCommandLineConfiguration().getModified()) {
            xMLEncoderStream.element(COMMAND_LINE_ELEMENT, "" + archiverConfiguration.getCommandLineConfiguration().getValue());
        }
        xMLEncoderStream.elementClose(ARCHIVERTOOL_ELEMENT);
    }

    public static void writeList(XMLEncoderStream xMLEncoderStream, String string, String[] stringArray) {
        CommonConfigurationXMLCodec.writeList(xMLEncoderStream, string, LIST_ELEMENT, stringArray);
    }

    public static void writeDirectories(XMLEncoderStream xMLEncoderStream, String string, String[] stringArray) {
        CommonConfigurationXMLCodec.writeList(xMLEncoderStream, string, DIRECTORY_PATH_ELEMENT, stringArray);
    }

    public static void writeList(XMLEncoderStream xMLEncoderStream, String string, String string2, String[] stringArray) {
        if (stringArray.length == 0) {
            return;
        }
        xMLEncoderStream.elementOpen(string);
        for (int i = 0; i < stringArray.length; ++i) {
            xMLEncoderStream.element(string2, stringArray[i]);
        }
        xMLEncoderStream.elementClose(string);
    }
}

