/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainProject;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.loaders.CCDataLoader;
import org.netbeans.modules.cnd.loaders.CDataLoader;
import org.netbeans.modules.cnd.loaders.HDataLoader;
import org.netbeans.modules.cnd.makeproject.MakeActionProvider;
import org.netbeans.modules.cnd.makeproject.MakeProjectConfigurationProvider;
import org.netbeans.modules.cnd.makeproject.MakeProjectEncodingQueryImpl;
import org.netbeans.modules.cnd.makeproject.MakeProjectOperations;
import org.netbeans.modules.cnd.makeproject.MakeProjectType;
import org.netbeans.modules.cnd.makeproject.MakeSharabilityQuery;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.modules.cnd.makeproject.MakeTemplateListener;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifactProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.OperationListener;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MakeProject
implements Project,
AntProjectListener {
    private static final Icon MAKE_PROJECT_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif"));
    private static final String HEADER_EXTENSIONS = "header-extensions";
    private static final String C_EXTENSIONS = "c-extensions";
    private static final String CPP_EXTENSIONS = "cpp-extensions";
    private static final String MAKE_PROJECT_TYPE = "make-project-type";
    private static MakeTemplateListener templateListener = null;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private ConfigurationDescriptorProvider projectDescriptorProvider;
    private int projectType = -1;
    private MakeProject thisMP;
    private Set<String> headerExtensions = MakeProject.createExtensionSet();
    private Set<String> cExtensions = MakeProject.createExtensionSet();
    private Set<String> cppExtensions = MakeProject.createExtensionSet();
    private String sourceEncoding = null;
    private List<Runnable> openedTasks;

    MakeProject(AntProjectHelper antProjectHelper) throws IOException {
        this.helper = antProjectHelper;
        this.eval = this.createEvaluator();
        AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(antProjectHelper, auxiliaryConfiguration, this.eval);
        this.projectDescriptorProvider = new ConfigurationDescriptorProvider(antProjectHelper.getProjectDirectory());
        this.genFilesHelper = new GeneratedFilesHelper(antProjectHelper);
        this.lookup = this.createLookup(auxiliaryConfiguration);
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
        this.thisMP = this;
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagName(MAKE_PROJECT_TYPE);
        if (nodeList.getLength() == 1) {
            nodeList = nodeList.item(0).getChildNodes();
            String string = nodeList.item(0).getNodeValue();
            this.projectType = new Integer(string);
        }
        this.readProjectExtension(element, HEADER_EXTENSIONS, this.headerExtensions);
        this.readProjectExtension(element, C_EXTENSIONS, this.cExtensions);
        this.readProjectExtension(element, CPP_EXTENSIONS, this.cppExtensions);
        this.sourceEncoding = this.getSourceEncodingFromProjectXml();
        if (templateListener == null) {
            templateListener = new MakeTemplateListener();
            DataLoaderPool.getDefault().addOperationListener((OperationListener)templateListener);
        }
    }

    private void readProjectExtension(Element element, String string, Set<String> set) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1) {
            String string2 = nodeList.item(0).getNodeValue();
            for (String string3 : string2.split(",")) {
                set.add(string3);
            }
        }
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "MakeProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        return this.helper.getStandardPropertyEvaluator();
    }

    PropertyEvaluator evaluator() {
        return this.eval;
    }

    ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createLookup(AuxiliaryConfiguration auxiliaryConfiguration) {
        MakeSubprojectProvider makeSubprojectProvider = new MakeSubprojectProvider();
        return Lookups.fixed((Object[])new Object[]{new Info(), auxiliaryConfiguration, this.helper.createCacheDirectoryProvider(), makeSubprojectProvider, new MakeActionProvider(this), new MakeLogicalViewProvider(this, makeSubprojectProvider), new MakeCustomizerProvider(this, this.projectDescriptorProvider), new MakeArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), new ProjectOpenedHookImpl(), new MakeSharabilityQuery(FileUtil.toFile((FileObject)this.getProjectDirectory())), new MakeSources(this, this.helper), new AntProjectHelperProvider(), this.projectDescriptorProvider, new MakeProjectConfigurationProvider(this, this.projectDescriptorProvider), new NativeProjectProvider(this, this.projectDescriptorProvider), new RecommendedTemplatesImpl(), new MakeProjectOperations(this), new FolderSearchInfo(this.projectDescriptorProvider), new MakeProjectType(), new MakeProjectEncodingQueryImpl(this), new RemoteProjectImpl(), new ToolchainProjectImpl()});
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        if (antProjectEvent.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    public void addAdditionalHeaderExtensions(Collection<String> collection) {
        Set<String> set = MakeProject.getHeaderSuffixes();
        Set<String> set2 = MakeProject.getSourceSuffixes();
        Set<String> set3 = MakeProject.createExtensionSet();
        for (String string : collection) {
            if (string.length() <= 0 || set.contains(string) || set2.contains(string)) continue;
            set3.add(string);
        }
        if (set3.size() > 0 && this.addNewExtensionDialog(set3, "H")) {
            HDataLoader.getInstance().addExtensions(set3);
            this.headerExtensions.addAll(set3);
            this.saveAdditionalExtensions();
        }
    }

    private Set<String> getUnknownExtensions(Set<String> set, Set<String> set2) {
        Set<String> set3 = MakeProject.createExtensionSet();
        for (String string : set2) {
            if (string.length() <= 0 || set.contains(string)) continue;
            set3.add(string);
        }
        return set3;
    }

    private void checkNeededExtensions() {
        Set<String> set = this.getUnknownExtensions(MakeProject.getCSuffixes(), this.cExtensions);
        if (set.size() > 0 && this.addNewExtensionDialog(set, "C")) {
            CDataLoader.getInstance().addExtensions(set);
        }
        if ((set = this.getUnknownExtensions(MakeProject.getCppSuffixes(), this.cppExtensions)).size() > 0 && this.addNewExtensionDialog(set, "CPP")) {
            CCDataLoader.getInstance().addExtensions(set);
        }
        if ((set = this.getUnknownExtensions(MakeProject.getHeaderSuffixes(), this.headerExtensions)).size() > 0 && this.addNewExtensionDialog(set, "H")) {
            HDataLoader.getInstance().addExtensions(set);
        }
    }

    public void updateExtensions(Set<String> set, Set<String> set2, Set<String> set3) {
        this.cExtensions.clear();
        this.cExtensions.addAll(set);
        this.cppExtensions.clear();
        this.cppExtensions.addAll(set2);
        this.headerExtensions.clear();
        this.headerExtensions.addAll(set3);
        this.saveAdditionalExtensions();
    }

    private void saveAdditionalExtensions() {
        Element element = this.helper.getPrimaryConfigurationData(true);
        this.saveAdditionalHeaderExtensions(element, C_EXTENSIONS, this.cExtensions);
        this.saveAdditionalHeaderExtensions(element, CPP_EXTENSIONS, this.cppExtensions);
        this.saveAdditionalHeaderExtensions(element, HEADER_EXTENSIONS, this.headerExtensions);
        this.helper.putPrimaryConfigurationData(element, true);
    }

    private void saveAdditionalHeaderExtensions(Element element, String string, Set<String> set) {
        Object object;
        Element element2;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 1) {
            element2 = (Element)nodeList.item(0);
            object = element2.getChildNodes();
            while (object.getLength() > 0) {
                element2.removeChild(object.item(0));
            }
        } else {
            element2 = element.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/make-project/1", string);
            element.appendChild(element2);
        }
        object = new StringBuilder();
        for (String string2 : set) {
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append(',');
            }
            ((StringBuilder)object).append(string2);
        }
        element2.appendChild(element.getOwnerDocument().createTextNode(((StringBuilder)object).toString()));
    }

    private boolean addNewExtensionDialog(Set<String> set, String string) {
        String string2 = MakeProject.getString("ADD_EXTENSION_QUESTION" + string + (set.size() == 1 ? "" : "S"));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string3);
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(string2, stringBuilder.toString()), MakeProject.getString("ADD_EXTENSION_DIALOG_TITLE" + string + (set.size() == 1 ? "" : "S")), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION;
    }

    public static Set<String> createExtensionSet() {
        if (IpeUtils.isSystemCaseInsensitive()) {
            return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        }
        return new TreeSet<String>();
    }

    private static Set<String> getSourceSuffixes() {
        Set<String> set = MakeProject.createExtensionSet();
        MakeProject.addSuffices(set, CCDataLoader.getInstance().getExtensions());
        MakeProject.addSuffices(set, CDataLoader.getInstance().getExtensions());
        return set;
    }

    private static Set<String> getCSuffixes() {
        Set<String> set = MakeProject.createExtensionSet();
        MakeProject.addSuffices(set, CDataLoader.getInstance().getExtensions());
        return set;
    }

    private static Set<String> getCppSuffixes() {
        Set<String> set = MakeProject.createExtensionSet();
        MakeProject.addSuffices(set, CCDataLoader.getInstance().getExtensions());
        return set;
    }

    private static Set<String> getHeaderSuffixes() {
        Set<String> set = MakeProject.createExtensionSet();
        MakeProject.addSuffices(set, HDataLoader.getInstance().getExtensions());
        return set;
    }

    private static void addSuffices(Set<String> set, ExtensionList extensionList) {
        Enumeration enumeration = extensionList.extensions();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            set.add(string);
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(MakeProject.class, (String)string);
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element element = MakeProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/make-project/1", "name");
                if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    return ((Text)nodeList.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setName(final String string) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element element;
                Element element2 = MakeProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/make-project/1", "name");
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/make-project/1", "name");
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string));
                MakeProject.this.helper.putPrimaryConfigurationData(element2, true);
                return null;
            }
        });
    }

    public String getSourceEncodingFromProjectXml() {
        int n;
        Element element = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = element.getElementsByTagName("sourceEncoding");
        if (nodeList != null && nodeList.getLength() > 0 && (n = 0) < nodeList.getLength()) {
            Node node = nodeList.item(n);
            return node.getTextContent();
        }
        return null;
    }

    public String getSourceEncoding() {
        if (this.sourceEncoding == null) {
            this.projectDescriptorProvider.getConfigurationDescriptor();
        }
        if (this.sourceEncoding == null) {
            this.sourceEncoding = FileEncodingQuery.getDefaultEncoding().name();
        }
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String string) {
        this.sourceEncoding = string;
    }

    public void addOpenedTask(Runnable runnable) {
        if (this.openedTasks == null) {
            this.openedTasks = new ArrayList<Runnable>();
        }
        this.openedTasks.add(runnable);
    }

    class ToolchainProjectImpl
    implements ToolchainProject {
        ToolchainProjectImpl() {
        }

        public CompilerSet getCompilerSet() {
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
            MakeConfiguration makeConfiguration = (MakeConfiguration)makeConfigurationDescriptor.getConfs().getActive();
            if (makeConfiguration != null) {
                return makeConfiguration.getCompilerSet().getCompilerSet();
            }
            return null;
        }
    }

    class RemoteProjectImpl
    implements RemoteProject {
        RemoteProjectImpl() {
        }

        public String getDevelopmentHost() {
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
            MakeConfiguration makeConfiguration = (MakeConfiguration)makeConfigurationDescriptor.getConfs().getActive();
            return makeConfiguration.getDevelopmentHost().getName();
        }
    }

    class FolderSearchInfo
    implements SearchInfo {
        private ConfigurationDescriptorProvider projectDescriptorProvider;

        FolderSearchInfo(ConfigurationDescriptorProvider configurationDescriptorProvider) {
            this.projectDescriptorProvider = configurationDescriptorProvider;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator objectsToSearch() {
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)this.projectDescriptorProvider.getConfigurationDescriptor();
            Folder folder = makeConfigurationDescriptor.getLogicalFolders();
            return folder.getAllItemsAsDataObjectSet(false, "text/").iterator();
        }
    }

    private final class MakeArtifactProviderImpl
    implements MakeArtifactProvider {
        private MakeArtifactProviderImpl() {
        }

        public MakeArtifact[] getBuildArtifacts() {
            ArrayList<MakeArtifact> arrayList = new ArrayList<MakeArtifact>();
            MakeConfigurationDescriptor makeConfigurationDescriptor = (MakeConfigurationDescriptor)MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
            Configuration[] configurationArray = makeConfigurationDescriptor.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                MakeConfiguration makeConfiguration = (MakeConfiguration)configurationArray[i];
                arrayList.add(new MakeArtifact(makeConfigurationDescriptor, makeConfiguration));
            }
            return arrayList.toArray(new MakeArtifact[arrayList.size()]);
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            MakeProject.this.checkNeededExtensions();
            if (MakeProject.this.openedTasks != null) {
                for (Runnable runnable : MakeProject.this.openedTasks) {
                    runnable.run();
                }
                MakeProject.this.openedTasks.clear();
                MakeProject.this.openedTasks = null;
            }
        }

        protected void projectClosed() {
            if (MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor() != null) {
                MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor().save(NbBundle.getMessage(MakeProject.class, (String)"ProjectNotSaved"));
                MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor().closed();
            }
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String string) {
            this.pcs.firePropertyChange(string, null, null);
        }

        public String getName() {
            String string = PropertyUtils.getUsablePropertyName((String)MakeProject.this.getName());
            return string;
        }

        public String getDisplayName() {
            String string = MakeProject.this.getName();
            return string;
        }

        public Icon getIcon() {
            Icon icon = null;
            icon = MakeConfigurationDescriptor.MAKEFILE_ICON;
            return icon;
        }

        public Project getProject() {
            return MakeProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private class MakeSubprojectProvider
    implements SubprojectProvider {
        private MakeSubprojectProvider() {
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public Set getSubprojects() {
            String string;
            Object object;
            Object object2;
            HashSet<String> hashSet = new HashSet<String>();
            Set<Object> set = new HashSet();
            Element element = MakeProject.this.helper.getPrimaryConfigurationData(true);
            if (!MakeProject.this.projectDescriptorProvider.gotDescriptor() && element.getElementsByTagName("make-dep-projects").getLength() > 0) {
                object2 = element.getElementsByTagName("make-dep-project");
                if (object2.getLength() > 0) {
                    for (int i = 0; i < object2.getLength(); ++i) {
                        Object object3 = object2.item(i);
                        object = object3.getChildNodes();
                        for (int j = 0; j < object.getLength(); ++j) {
                            string = object.item(j).getNodeValue();
                            set.add(string);
                        }
                    }
                }
            } else {
                object2 = MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
                if (object2 == null) {
                    return hashSet;
                }
                set = ((MakeConfigurationDescriptor)object2).getSubprojectLocations();
            }
            object2 = FileUtil.toFile((FileObject)MakeProject.this.getProjectDirectory()).getPath();
            for (Object object3 : set) {
                object = IpeUtils.toAbsolutePath((String)object2, (String)object3);
                object = FilePathAdaptor.mapToLocal((String)object);
                try {
                    FileObject fileObject = FileUtil.toFileObject((File)new File((String)object).getCanonicalFile());
                    string = ProjectManager.getDefault().findProject(fileObject);
                    if (string == null) continue;
                    hashSet.add(string);
                }
                catch (Exception exception) {
                    System.err.println("Cannot find subproject in '" + (String)object + "' " + exception);
                }
            }
            return hashSet;
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] RECOMMENDED_TYPES = new String[]{"c-types", "cpp-types", "shell-types", "makefile-types", "c-types", "simple-files", "asm-types"};
        private static final String[] RECOMMENDED_TYPES_FORTRAN = new String[]{"c-types", "cpp-types", "shell-types", "makefile-types", "c-types", "simple-files", "fortran-types", "asm-types"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/class.cc", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};
        private static final String[] PRIVILEGED_NAMES_FORTRAN = new String[]{"Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/class.cc", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/fortranFiles/fortranFreeFormatFile.f90", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            if (CppSettings.getDefault().isFortranEnabled()) {
                return RECOMMENDED_TYPES_FORTRAN;
            }
            return RECOMMENDED_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            if (CppSettings.getDefault().isFortranEnabled()) {
                return PRIVILEGED_NAMES_FORTRAN;
            }
            return PRIVILEGED_NAMES;
        }
    }

    final class AntProjectHelperProvider {
        AntProjectHelperProvider() {
        }

        AntProjectHelper getAntProjectHelper() {
            return MakeProject.this.helper;
        }
    }
}

