/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.FauxRefactoringElement;
import org.netbeans.modules.xml.refactoring.XMLRefactoringPlugin;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.refactoring.RenameReferenceVisitor;
import org.netbeans.modules.xml.schema.refactoring.SchemaRefactoringElement;
import org.netbeans.modules.xml.schema.refactoring.SchemaRefactoringPlugin;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaRenameRefactoringPlugin
extends SchemaRefactoringPlugin {
    private RenameRefactoring request;

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        Referenceable referenceable = (Referenceable)this.request.getRefactoringSource().lookup(Referenceable.class);
        ErrorItem errorItem = null;
        if (referenceable instanceof Model) {
            errorItem = RefactoringUtil.precheck((Model)((Model)referenceable), (String)this.request.getNewName());
        } else if (referenceable instanceof Nameable) {
            errorItem = RefactoringUtil.precheck((Nameable)((Nameable)referenceable), (String)this.request.getNewName());
        }
        if (errorItem != null) {
            Problem problem = new Problem(true, errorItem.getMessage());
            return problem;
        }
        return null;
    }

    public SchemaRenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.request = renameRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        Referenceable referenceable = (Referenceable)this.request.getRefactoringSource().lookup(Referenceable.class);
        if (referenceable == null) {
            return null;
        }
        if (!(referenceable instanceof Model) && !(referenceable instanceof Nameable)) {
            return null;
        }
        Model model = SharedUtils.getModel((Referenceable)referenceable);
        ErrorItem errorItem = RefactoringUtil.precheckTarget((Model)model, (boolean)true);
        if (errorItem != null) {
            return new Problem(this.isFatal(errorItem), errorItem.getMessage());
        }
        if (referenceable instanceof Model) {
            errorItem = RefactoringUtil.precheck((Model)model, (String)this.request.getNewName());
        } else if (referenceable instanceof Nameable) {
            errorItem = RefactoringUtil.precheck((Nameable)((Nameable)referenceable), (String)this.request.getNewName());
        }
        if (errorItem != null) {
            return new Problem(this.isFatal(errorItem), errorItem.getMessage());
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Object object;
        Object object2;
        Referenceable referenceable = (Referenceable)this.request.getRefactoringSource().lookup(Referenceable.class);
        if (referenceable == null) {
            return null;
        }
        if (!(referenceable instanceof Model) && !(referenceable instanceof Nameable)) {
            return null;
        }
        this.fireProgressListenerStart(1, -1);
        XMLRefactoringTransaction xMLRefactoringTransaction = (XMLRefactoringTransaction)this.request.getContext().lookup(XMLRefactoringTransaction.class);
        Set<Object> set = new HashSet();
        this.findErrors = new ArrayList();
        if (xMLRefactoringTransaction.isLocal()) {
            set = SharedUtils.getLocalSearchRoots((Referenceable)referenceable);
        } else {
            object2 = (Component)this.request.getContext().lookup(Component.class);
            if (object2 == null) {
                set = this.getSearchRoots(referenceable);
            } else {
                set.add(object2);
            }
        }
        object2 = new ArrayList();
        Model model = set.iterator();
        while (model.hasNext()) {
            object = (Component)model.next();
            List<SchemaRefactoringElement> list = this.find(referenceable, (Component)object);
            if (list == null || list.size() <= 0) continue;
            object2.addAll(list);
        }
        if (object2.size() > 0 && (object = RefactoringUtil.precheckUsageModels((List)(model = this.getModels((List<SchemaRefactoringElement>)object2)), (boolean)true)) != null && object.size() > 0) {
            return this.processErrors((List<ErrorItem>)object);
        }
        xMLRefactoringTransaction.register((XMLRefactoringPlugin)this, (List)object2);
        refactoringElementsBag.registerTransaction((Transaction)xMLRefactoringTransaction);
        model = object2.iterator();
        while (model.hasNext()) {
            object = (SchemaRefactoringElement)((Object)model.next());
            ((SchemaRefactoringElement)((Object)object)).addTransactionObject(xMLRefactoringTransaction);
            refactoringElementsBag.add((AbstractRefactoring)this.request, (RefactoringElementImplementation)object);
            this.fireProgressListenerStep();
        }
        model = SharedUtils.getModel((Referenceable)referenceable);
        object = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        if ("application/x-schema+xml".equals(FileUtil.getMIMEType((FileObject)object))) {
            refactoringElementsBag.add((AbstractRefactoring)this.request, (RefactoringElementImplementation)new FauxRefactoringElement(referenceable, NbBundle.getMessage(SchemaRenameRefactoringPlugin.class, (String)"LBL_Rename")));
        }
        if (this.findErrors.size() > 0) {
            return this.processErrors(this.findErrors);
        }
        this.fireProgressListenerStop();
        return null;
    }

    public void doRefactoring(List<RefactoringElementImplementation> list) throws IOException {
        Map map = SharedUtils.getModelMap(list);
        Set set = map.keySet();
        Referenceable referenceable = (Referenceable)this.request.getRefactoringSource().lookup(Referenceable.class);
        for (Model model : set) {
            if (referenceable instanceof Nameable) {
                new RenameReferenceVisitor().rename(model, (Set)map.get(model), this.request);
                continue;
            }
            if (!(referenceable instanceof Model)) continue;
            this._refactorUsages(model, (Set)map.get(model), this.request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refactorUsages(Model model, Set<RefactoringElementImplementation> set, RenameRefactoring renameRefactoring) {
        if (model == null) {
            return;
        }
        if (!(model instanceof SchemaModel)) {
            return;
        }
        SchemaModel schemaModel = (SchemaModel)model;
        boolean bl = !schemaModel.isIntransaction();
        try {
            if (bl) {
                schemaModel.startTransaction();
            }
            for (RefactoringElementImplementation refactoringElementImplementation : set) {
                SchemaModelReference schemaModelReference;
                if (!(refactoringElementImplementation instanceof SchemaRefactoringElement) || (schemaModelReference = (SchemaModelReference)refactoringElementImplementation.getLookup().lookup(SchemaModelReference.class)) == null) continue;
                String string = SharedUtils.calculateNewLocationString((String)schemaModelReference.getSchemaLocation(), (RenameRefactoring)renameRefactoring);
                schemaModelReference.setSchemaLocation(string);
            }
        }
        finally {
            if (bl && schemaModel.isIntransaction()) {
                schemaModel.endTransaction();
            }
        }
    }

    @Override
    public String getModelReference(Component component) {
        if (component instanceof SchemaModelReference) {
            return ((SchemaModelReference)component).getSchemaLocation();
        }
        return null;
    }
}

