/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring;

import java.awt.event.ActionEvent;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.ui.actions.ShowSourceAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;

public class SchemaRefactoringElement
extends SimpleRefactoringElementImplementation {
    private FileObject source;
    SchemaComponent comp;
    Node node;
    XMLRefactoringTransaction transaction;

    public SchemaRefactoringElement(SchemaComponent schemaComponent) {
        this.comp = schemaComponent;
        CategorizedSchemaNodeFactory categorizedSchemaNodeFactory = new CategorizedSchemaNodeFactory(schemaComponent.getModel(), Lookups.singleton((Object)schemaComponent));
        this.node = categorizedSchemaNodeFactory.createNode(schemaComponent);
    }

    public Lookup getLookup() {
        return Lookups.singleton((Object)this.comp);
    }

    public FileObject getParentFile() {
        FileObject fileObject = (FileObject)this.comp.getModel().getModelSource().getLookup().lookup(FileObject.class);
        assert (fileObject != null) : "ModelSource should have FileObject in lookup";
        return fileObject;
    }

    public String getText() {
        return this.node.getName();
    }

    public String getDisplayText() {
        return this.node.getHtmlDisplayName();
    }

    public void performChange() {
    }

    public PositionBounds getPosition() {
        if (this.comp.getModel() instanceof AbstractDocumentModel) {
            CloneableEditorSupport cloneableEditorSupport;
            Document document = ((AbstractDocumentModel)this.comp.getModel()).getBaseDocument();
            DocumentModelAccess documentModelAccess = ((AbstractDocumentModel)this.comp.getModel()).getAccess();
            Element element = this.comp.getPeer();
            String string = documentModelAccess.getXmlFragmentInclusive(element);
            int n = this.comp.findPosition();
            int n2 = n + string.length();
            DataObject dataObject = null;
            try {
                cloneableEditorSupport = (FileObject)this.comp.getModel().getModelSource().getLookup().lookup(FileObject.class);
                dataObject = DataObject.find((FileObject)cloneableEditorSupport);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
            cloneableEditorSupport = SharedUtils.findCloneableEditorSupport(dataObject);
            if (cloneableEditorSupport == null) {
                return null;
            }
            PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
            PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
            PositionBounds positionBounds = new PositionBounds(positionRef, positionRef2);
            return positionBounds;
        }
        return null;
    }

    public void openInEditor() {
        SystemAction systemAction = SystemAction.get(ShowSourceAction.class);
        String string = (String)systemAction.getValue("ActionCommandKey");
        ActionEvent actionEvent = new ActionEvent(this.node, 0, string);
        systemAction.actionPerformed(actionEvent);
    }

    void addTransactionObject(XMLRefactoringTransaction xMLRefactoringTransaction) {
        this.transaction = xMLRefactoringTransaction;
    }

    protected String getNewFileContent() {
        if (this.comp.getModel() instanceof AbstractDocumentModel && this.transaction != null) {
            try {
                String string = this.transaction.refactorForPreview((Model)this.comp.getModel());
                return string;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return null;
    }
}

