/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.visualweb.project.jsf.ui.PhysicalView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private SourceGroup[] folders;
    private BeanTreeView btv;
    private Project project;
    private static JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private JPanel folderPanel;
    private JLabel jLabel1;

    public BrowseFolders(SourceGroup[] sourceGroupArray, Project project, String string) {
        this.initComponents();
        this.folders = sourceGroupArray;
        this.project = project;
        this.manager = new ExplorerManager();
        AbstractNode abstractNode = new AbstractNode((Children)new SourceGroupsChildren(sourceGroupArray, project));
        this.manager.setRootContext((Node)abstractNode);
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.setSelectionMode(1);
        this.btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        this.btv.setPopupAllowed(false);
        this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders_folderPanel"));
        this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_BrowseFolders_folderPanel"));
        this.expandSelection(string);
        this.folderPanel.add((Component)this.btv, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders"));
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage(BrowseFolders.class, (String)"MNE_BrowseFolders_jLabel1").charAt(0));
        this.jLabel1.setLabelFor(this.folderPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BrowseFolders.class, (String)"LBL_BrowseFolders_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders_jLabel1"));
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
    }

    public static FileObject showDialog(SourceGroup[] sourceGroupArray, Project project, String string) {
        BrowseFolders browseFolders = new BrowseFolders(sourceGroupArray, project, string);
        Object[] objectArray = new JButton[]{new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"BTN_BrowseFolders_Select_Option")), new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"BTN_BrowseFolders_Cancel_Option"))};
        OptionsListener optionsListener = new OptionsListener(browseFolders);
        objectArray[0].setActionCommand("SELECT");
        objectArray[0].addActionListener(optionsListener);
        objectArray[0].setMnemonic(NbBundle.getMessage(BrowseFolders.class, (String)"MNE_BrowseFolders_Select_Option").charAt(0));
        objectArray[0].getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders_Select_Option"));
        objectArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_BrowseFolders_Select_Option"));
        objectArray[1].setActionCommand("CANCEL");
        objectArray[1].addActionListener(optionsListener);
        objectArray[1].getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"ACSN_BrowseFolders_Cancel_Option"));
        objectArray[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_BrowseFolders_Cancel_Option"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)browseFolders, NbBundle.getMessage(BrowseFolders.class, (String)"LBL_BrowseFolders_Dialog"), true, objectArray, (Object)objectArray[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        return optionsListener.getResult();
    }

    private void expandSelection(String string) {
        int n;
        Node node = this.manager.getRootContext();
        Children children = node.getChildren();
        if (children == Children.LEAF) {
            return;
        }
        Node[] nodeArray = children.getNodes(true);
        Node node2 = null;
        if (string != null && string.length() > 0) {
            for (n = 0; n < nodeArray.length; ++n) {
                try {
                    node2 = NodeOp.findPath((Node)nodeArray[n], (Enumeration)new StringTokenizer(string, "/"));
                    break;
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    System.out.println(nodeNotFoundException.getMissingChildName());
                    continue;
                }
            }
        }
        if (node2 == null) {
            this.btv.expandNode(node);
            for (n = 0; n < nodeArray.length; ++n) {
                this.btv.expandNode(nodeArray[n]);
                if (n != 0) continue;
                node2 = nodeArray[n];
            }
        }
        if (node2 != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{node2});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private static final class OptionsListener
    implements ActionListener {
        public static final String COMMAND_SELECT = "SELECT";
        public static final String COMMAND_CANCEL = "CANCEL";
        private BrowseFolders browsePanel;
        private FileObject result;

        public OptionsListener(BrowseFolders browseFolders) {
            this.browsePanel = browseFolders;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileObject fileObject;
            DataObject dataObject;
            Node[] nodeArray;
            String string = actionEvent.getActionCommand();
            if (COMMAND_SELECT.equals(string) && (nodeArray = this.browsePanel.getExplorerManager().getSelectedNodes()) != null && nodeArray.length > 0 && (dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class)) != null && (fileObject = dataObject.getPrimaryFile()).isFolder()) {
                this.result = fileObject;
            }
        }

        public FileObject getResult() {
            return this.result;
        }
    }

    private static final class SourceGroupsChildren
    extends Children.Keys {
        private SourceGroup[] groups;
        private SourceGroup group;
        private FileObject fo;
        private Project project;

        public SourceGroupsChildren(SourceGroup[] sourceGroupArray, Project project) {
            this.groups = sourceGroupArray;
            this.project = project;
        }

        public SourceGroupsChildren(FileObject fileObject, SourceGroup sourceGroup) {
            this.fo = fileObject;
            this.group = sourceGroup;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = null;
            if (object instanceof SourceGroup) {
                fileObject = ((SourceGroup)object).getRootFolder();
                sourceGroup = (SourceGroup)object;
                FilterNode filterNode = new FilterNode((Node)new PhysicalView.GroupNode(this.project, sourceGroup, fileObject.equals(this.project.getProjectDirectory()), DataFolder.findFolder((FileObject)fileObject)), (Children)new SourceGroupsChildren(fileObject, sourceGroup));
                return new Node[]{filterNode};
            }
            if (object instanceof Key) {
                fileObject = ((Key)object).folder;
                sourceGroup = ((Key)object).group;
                FilterNode filterNode = new FilterNode(DataFolder.findFolder((FileObject)fileObject).getNodeDelegate(), (Children)new SourceGroupsChildren(fileObject, sourceGroup));
                return new Node[]{filterNode};
            }
            return new Node[0];
        }

        private Collection getKeys() {
            if (this.groups != null) {
                return Arrays.asList(this.groups);
            }
            FileObject[] fileObjectArray = this.fo.getChildren();
            ArrayList<Key> arrayList = new ArrayList<Key>(fileObjectArray.length);
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!fileObjectArray[i].isFolder() || !this.group.contains(fileObjectArray[i]) || !VisibilityQuery.getDefault().isVisible(fileObjectArray[i])) continue;
                arrayList.add(new Key(fileObjectArray[i], this.group));
            }
            return arrayList;
        }

        private static class Key {
            private FileObject folder;
            private SourceGroup group;

            private Key(FileObject fileObject, SourceGroup sourceGroup) {
                this.folder = fileObject;
                this.group = sourceGroup;
            }
        }
    }
}

