/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.libraries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfProjectLibrary {
    public static final String[] ALLTIME_LIBS_JSF11 = new String[]{"jsf12-support", "webui"};
    public static final String[] DESIGNTIME_LIBS_JSF11 = new String[0];
    public static final String[] RUNTIME_LIBS_JSF11 = new String[]{"exceptionhandler-runtime"};
    public static final String[] ALLTIME_LIBS_JSF12 = new String[]{"jsf12-support", "woodstock-components"};
    public static final String[] DESIGNTIME_LIBS_JSF12 = new String[0];
    public static final String[] RUNTIME_LIBS_JSF12 = new String[]{"exceptionhandler-runtime"};
    public static final String DEFAULT_JSF11_THEME = "theme-default";
    public static final String DEFAULT_JSF12_THEME = "woodstock-theme-default";

    public static void addLibrary(Project project) throws IOException {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String string;
        LibraryManager libraryManager = LibraryManager.getDefault();
        if (JsfProjectUtils.isJavaEE5Project(project)) {
            string = DEFAULT_JSF12_THEME;
            stringArray3 = ALLTIME_LIBS_JSF12;
            stringArray2 = DESIGNTIME_LIBS_JSF12;
            stringArray = RUNTIME_LIBS_JSF12;
        } else {
            string = DEFAULT_JSF11_THEME;
            stringArray3 = ALLTIME_LIBS_JSF11;
            stringArray2 = DESIGNTIME_LIBS_JSF11;
            stringArray = RUNTIME_LIBS_JSF11;
        }
        JsfProjectUtils.createProjectProperty(project, "jsf.project.libraries.dir", "lib");
        JsfProjectUtils.createProjectProperty(project, "jsf.current.theme", string);
        List<Library> list = JsfProjectLibrary.getLibraryList(stringArray3);
        list.addAll(JsfProjectLibrary.getLibraryList(new String[]{string}));
        List<Library> list2 = JsfProjectLibrary.getLibraryList(stringArray2);
        List<Library> list3 = JsfProjectLibrary.getLibraryList(stringArray);
        JsfProjectUtils.addLibraryReferences(project, list.toArray(new Library[list.size()]));
        JsfProjectUtils.addLibraryReferences(project, list2.toArray(new Library[list2.size()]), "classpath/compile");
        JsfProjectUtils.addLibraryReferences(project, list3.toArray(new Library[list3.size()]), "classpath/execute");
        JsfProjectLibrary.updateLocalizedRoots(project);
    }

    private static List<Library> getLibraryList(String[] stringArray) {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        for (String string : stringArray) {
            Library library = LibraryManager.getDefault().getLibrary(string);
            if (library == null) {
                JsfProjectLibrary.info(new NullPointerException("The library of name was not found, libraryName=" + string));
                continue;
            }
            arrayList.add(library);
        }
        return arrayList;
    }

    public static void updateLocalizedRoots(Project project) throws IOException {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        if (JsfProjectUtils.isJavaEE5Project(project)) {
            stringArray3 = ALLTIME_LIBS_JSF12;
            stringArray2 = DESIGNTIME_LIBS_JSF12;
            stringArray = RUNTIME_LIBS_JSF12;
        } else {
            stringArray3 = ALLTIME_LIBS_JSF11;
            stringArray2 = DESIGNTIME_LIBS_JSF11;
            stringArray = RUNTIME_LIBS_JSF11;
        }
        URL[] uRLArray = JsfProjectLibrary.getLocaleRoots(project, stringArray3);
        URL[] uRLArray2 = JsfProjectLibrary.getLocaleRoots(project, stringArray2);
        URL[] uRLArray3 = JsfProjectLibrary.getLocaleRoots(project, stringArray);
        JsfProjectUtils.addLocalizedRoots(project, uRLArray, "classpath/compile");
        JsfProjectUtils.addLocalizedRoots(project, uRLArray2, "classpath/compile");
        JsfProjectUtils.addLocalizedRoots(project, uRLArray3, "classpath/execute");
        String string = JsfProjectUtils.getProjectProperty(project, "jsf.current.theme");
        JsfProjectUtils.addLocalizedTheme(project, string);
    }

    public static URL getLocalizedThemeRoot(Project project, String string) {
        try {
            URL[] uRLArray = JsfProjectLibrary.getLocaleRoots(project, new String[]{string});
            if (uRLArray.length == 0) {
                return null;
            }
            return uRLArray[0];
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static URL[] getLocaleRoots(Project project, String[] stringArray) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string : stringArray) {
            Library library = LibraryManager.getDefault().getLibrary(string);
            if (library == null) continue;
            List list = library.getContent("classpath");
            for (URL uRL : list) {
                if (!"jar".equals(uRL.getProtocol())) continue;
                uRL = FileUtil.getArchiveFile((URL)uRL);
                String string2 = uRL.getPath();
                int n = string2.lastIndexOf("/");
                string2 = string2.substring(1, n) + "/locale" + string2.substring(n);
                File file = InstalledFileLocator.getDefault().locate(string2, null, true);
                if (file == null) continue;
                arrayList.add(FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)file)).getURL());
            }
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public static boolean isDesigntimeLib(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("${libs.") && string.endsWith("-designtime.classpath}");
    }

    private static void info(Exception exception) {
        Logger.getLogger(JsfProjectLibrary.class.getName()).log(Level.INFO, null, exception);
    }
}

