/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.actions;

import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.spi.project.ui.support.MainProjectSensitiveActions;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ImportFileAction
implements ProjectActionPerformer {
    private static final String JSP_EXT = ".jsp";
    private static final String JPG_EXT = ".jpg";
    private static final String JPE_EXT = ".jpe";
    private static final String GIF_EXT = ".gif";
    private static final String PNG_EXT = ".png";
    private static final String JPEG_EXT = ".jpeg";
    private static final String CSS_EXT = ".css";
    private static final String HTML_EXT = ".html";
    private static final String XML_EXT = ".xml";
    private static final String JAVA_EXT = ".java";
    private static final String JAR_EXT = ".jar";
    private static final String PROPERTIES_EXT = ".properties";
    private static File currDir;
    static final int TYPE_JSP = 0;
    static final int TYPE_IMAGE = 1;
    static final int TYPE_STYLESHEET = 2;
    static final int TYPE_JAVA = 3;
    static final int TYPE_OTHER = 4;
    private final int type;
    private static final String PACKAGE = "package";

    private ImportFileAction(int n) {
        this.type = n;
    }

    static Action createAction(int n) {
        String string;
        if (n == 0) {
            string = NbBundle.getMessage(ImportFileAction.class, (String)"LBL_ImportJspFileAction");
        } else if (n == 1) {
            string = NbBundle.getMessage(ImportFileAction.class, (String)"LBL_ImportImageFileAction");
        } else if (n == 2) {
            string = NbBundle.getMessage(ImportFileAction.class, (String)"LBL_ImportStylesheetFileAction");
        } else if (n == 3) {
            string = NbBundle.getMessage(ImportFileAction.class, (String)"LBL_ImportJavaFileAction");
        } else if (n == 4) {
            string = NbBundle.getMessage(ImportFileAction.class, (String)"LBL_ImportOtherFileAction");
        } else {
            throw new IllegalArgumentException("Unknown type=" + n);
        }
        return MainProjectSensitiveActions.mainProjectSensitiveAction((ProjectActionPerformer)new ImportFileAction(n), (String)string, null);
    }

    public boolean enable(Project project) {
        return project != null;
    }

    public void perform(Project project) {
        JFileChooser jFileChooser = null;
        File file = null;
        while (true) {
            if ((file = ImportFileAction.chooseFile(jFileChooser = this.prepareFileChooser())) == null) {
                return;
            }
            if (file.exists()) break;
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ImportFileAction.class, (String)"TXT_FileDoesntExist", (Object)file.getName())));
        }
        ImportFileAction.importFile(project, file);
        currDir = jFileChooser.getCurrentDirectory();
    }

    private JFileChooser prepareFileChooser() {
        JFileChooser jFileChooser = JsfProjectUtils.getJFileChooser(currDir);
        jFileChooser.setDialogTitle(NbBundle.getMessage(ImportFileAction.class, (String)"LBL_DialogTitle"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (this.type == 0) {
            Filter filter = new Filter(new String[]{JSP_EXT}, NbBundle.getMessage(ImportFileAction.class, (String)"TXT_JspFilter"));
            jFileChooser.addChoosableFileFilter(filter);
            jFileChooser.setFileFilter(filter);
        } else if (this.type == 1) {
            Filter filter = new Filter(new String[]{JPG_EXT, GIF_EXT, PNG_EXT, JPEG_EXT, JPE_EXT}, NbBundle.getMessage(ImportFileAction.class, (String)"TXT_ImageFilter"));
            jFileChooser.addChoosableFileFilter(filter);
            jFileChooser.setFileFilter(filter);
        } else if (this.type == 2) {
            Filter filter = new Filter(new String[]{CSS_EXT}, NbBundle.getMessage(ImportFileAction.class, (String)"TXT_CssFilter"));
            jFileChooser.addChoosableFileFilter(filter);
            jFileChooser.setFileFilter(filter);
        } else if (this.type == 3) {
            Filter filter = new Filter(new String[]{JAVA_EXT}, NbBundle.getMessage(ImportFileAction.class, (String)"TXT_JavaFilter"));
            jFileChooser.addChoosableFileFilter(filter);
            jFileChooser.setFileFilter(filter);
        } else {
            Filter filter = new Filter(new String[]{JAR_EXT}, NbBundle.getMessage(ImportFileAction.class, (String)"TXT_JarFilter"));
            jFileChooser.addChoosableFileFilter(filter);
            jFileChooser.setFileFilter(fileFilter);
        }
        return jFileChooser;
    }

    public static File chooseFile(JFileChooser jFileChooser) {
        File file;
        do {
            int n;
            if ((n = jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(ImportFileAction.class, (String)"LBL_ImportButton"))) != 0) {
                return null;
            }
            file = jFileChooser.getSelectedFile();
            if (file != null) {
                return file;
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ImportFileAction.class, (String)"MSG_noFileSelected"), 2));
        } while (file == null);
        return file;
    }

    public static void importFile(Project project, File file) {
        FileObject fileObject;
        FileObject fileObject2;
        FileObject fileObject3 = FileUtil.toFileObject((File)file);
        if (FileOwnerQuery.getOwner((FileObject)fileObject3) == project) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ImportFileAction.class, (String)"MSG_FileIsInProject", (Object)file.getName(), (Object)ProjectUtils.getInformation((Project)project).getDisplayName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        String string = file.getName().toLowerCase();
        if (string.endsWith(JSP_EXT) || string.endsWith(HTML_EXT) || string.endsWith(XML_EXT)) {
            fileObject2 = JsfProjectUtils.getDocumentRoot(project);
        } else if (string.endsWith(JAVA_EXT)) {
            fileObject = JsfProjectUtils.getPageBeanRoot(project);
            String string2 = ImportFileAction.findJavaPackage(file);
            if (string2 != null && string2.length() > 0) {
                String string3 = string2.replace('.', '/');
                try {
                    fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string3);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    fileObject2 = null;
                }
            } else {
                fileObject2 = fileObject;
            }
        } else if (string.endsWith(PROPERTIES_EXT)) {
            fileObject2 = JsfProjectUtils.getPageBeanRoot(project);
        } else if (string.endsWith(CSS_EXT) || string.endsWith(JPG_EXT) || string.endsWith(GIF_EXT) || string.endsWith(PNG_EXT) || string.endsWith(JPEG_EXT) || string.endsWith(JPE_EXT)) {
            try {
                fileObject2 = JsfProjectUtils.getResourcesDirectory(project);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                fileObject2 = JsfProjectUtils.getDocumentRoot(project);
            }
        } else {
            fileObject2 = string.endsWith(JAR_EXT) ? JsfProjectUtils.getPageBeanRoot(project) : JsfProjectUtils.getPageBeanRoot(project);
        }
        if (fileObject2 != null) {
            fileObject = ImportFileAction.copyFileToFolder(fileObject2, file);
            if (fileObject != null) {
                JsfProjectUtils.selectResourceInWindow(fileObject);
            }
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Cannot find import folder for file " + file.getName()));
        }
    }

    private static FileObject copyFileToFolder(FileObject fileObject, File file) {
        try {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            DataObject dataObject = DataObject.find((FileObject)ImportFileAction.getFileObjectFromFile(file));
            return dataObject.copy(dataFolder).getPrimaryFile();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    private static FileObject getFileObjectFromFile(File file) {
        File file2 = file.getParentFile();
        LocalFileSystem localFileSystem = new LocalFileSystem();
        try {
            localFileSystem.setRootDirectory(file2);
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
            return null;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
        return localFileSystem.findResource(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findJavaPackage(File file) {
        String string = "";
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new SourceReader(new FileInputStream(file)));
            bufferedReader.mark(2);
            char[] cArray = new char[2];
            bufferedReader.read(cArray, 0, 2);
            if (cArray[0] == '\u00ff' && cArray[1] == '\u00fe') {
                bufferedReader.close();
                bufferedReader = new BufferedReader(new SourceReader((InputStream)new FileInputStream(file), "Unicode"));
            } else {
                bufferedReader.reset();
            }
            while (!bl) {
                Object object;
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    bl = true;
                    object = string;
                    return object;
                }
                int n = string2.indexOf(PACKAGE);
                if (n == -1) continue;
                object = new StringTokenizer(string2, " \t;");
                boolean bl2 = false;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    Object object2;
                    String string3 = ((StringTokenizer)object).nextToken();
                    if (bl2) {
                        String string4;
                        object2 = new StringTokenizer(string3, ".");
                        boolean bl3 = ((StringTokenizer)object2).hasMoreTokens();
                        block22: while (((StringTokenizer)object2).hasMoreTokens()) {
                            string4 = ((StringTokenizer)object2).nextToken();
                            if (string4.length() == 0) {
                                bl3 = false;
                                break;
                            }
                            if (!Character.isJavaIdentifierStart(string4.charAt(0))) {
                                bl3 = false;
                                break;
                            }
                            for (int i = 1; i < string4.length(); ++i) {
                                if (Character.isJavaIdentifierPart(string4.charAt(i))) continue;
                                bl3 = false;
                                continue block22;
                            }
                        }
                        if (bl3) {
                            string = string3;
                            bl = true;
                            string4 = string;
                            return string4;
                        }
                        bl2 = false;
                        continue;
                    }
                    if (string3.equals(PACKAGE)) {
                        bl2 = true;
                        continue;
                    }
                    if (!string3.equals("{")) continue;
                    bl = true;
                    object2 = string;
                    return object2;
                }
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return null;
    }

    public static class SourceReader
    extends InputStreamReader {
        private int preRead = -1;
        private boolean inString = false;
        private boolean backslashLast = false;
        private boolean separatorLast = false;
        private static final char[] separators = new char[]{'.'};
        private static final char[] whitespaces = new char[]{' ', '\t', '\r', '\n'};

        public SourceReader(InputStream inputStream) {
            super(inputStream);
        }

        public SourceReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
            super(inputStream, string);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            char[] cArray2 = new char[1];
            while (n3 < n2) {
                int n4;
                if (this.preRead != -1) {
                    n4 = this.preRead;
                    this.preRead = -1;
                } else {
                    n4 = super.read(cArray2, 0, 1);
                    if (n4 == -1) {
                        return n3 > 0 ? n3 : -1;
                    }
                    n4 = cArray2[0];
                }
                if (n4 == 47 && !this.inString) {
                    this.preRead = super.read(cArray2, 0, 1);
                    if (this.preRead == 1) {
                        this.preRead = cArray2[0];
                    }
                    if (this.preRead != 42 && this.preRead != 47) {
                        cArray[n++] = (char)n4;
                        ++n3;
                        if (this.preRead != -1) continue;
                        return n3;
                    }
                    if (this.preRead == 42) {
                        this.preRead = -1;
                        do {
                            if ((n4 = this.moveToChar(42)) != 0) continue;
                            n4 = super.read(cArray2, 0, 1);
                            if (n4 == 1) {
                                n4 = cArray2[0];
                            }
                            if (n4 != 42) continue;
                            this.preRead = n4;
                        } while (n4 != 47 && n4 != -1);
                    } else {
                        this.preRead = -1;
                        n4 = this.moveToChar(10);
                        if (n4 == 0) {
                            this.preRead = 10;
                        }
                    }
                    if (n4 != -1) continue;
                    return -1;
                }
                if (!this.inString) {
                    block24: {
                        if (SourceReader.isWhitespace(n4)) {
                            do {
                                this.preRead = super.read(cArray2, 0, 1);
                                if (this.preRead == -1) {
                                    return n3 > 0 ? n3 : -1;
                                }
                                this.preRead = cArray2[0];
                                if (!SourceReader.isSeparator(this.preRead)) continue;
                                n4 = this.preRead;
                                this.preRead = -1;
                                break block24;
                            } while (SourceReader.isWhitespace(this.preRead));
                            if (this.separatorLast) {
                                n4 = this.preRead;
                                this.preRead = -1;
                            }
                        }
                    }
                    if (n4 == 34 || n4 == 39) {
                        this.inString = true;
                        this.separatorLast = false;
                    } else {
                        this.separatorLast = SourceReader.isSeparator(n4);
                    }
                } else if (n4 == 34 || n4 == 39) {
                    if (!this.backslashLast) {
                        this.inString = false;
                    } else {
                        this.backslashLast = false;
                    }
                } else {
                    this.backslashLast = n4 == 92;
                }
                cArray[n++] = (char)n4;
                ++n3;
            }
            return n3;
        }

        private int moveToChar(int n) throws IOException {
            int n2;
            char[] cArray = new char[1];
            if (this.preRead != -1) {
                n2 = this.preRead;
                this.preRead = -1;
            } else {
                n2 = super.read(cArray, 0, 1);
                if (n2 == 1) {
                    n2 = cArray[0];
                }
            }
            while (n2 != -1 && n2 != n) {
                n2 = super.read(cArray, 0, 1);
                if (n2 != 1) continue;
                n2 = cArray[0];
            }
            return n2 == -1 ? -1 : 0;
        }

        private static boolean isSeparator(int n) {
            for (int i = 0; i < separators.length; ++i) {
                if (n != separators[i]) continue;
                return true;
            }
            return false;
        }

        private static boolean isWhitespace(int n) {
            for (int i = 0; i < whitespaces.length; ++i) {
                if (n != whitespaces[i]) continue;
                return true;
            }
            return false;
        }
    }

    private static class Filter
    extends FileFilter {
        private String[] extensions;
        private String description;

        public Filter(String[] stringArray, String string) {
            this.extensions = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.extensions[i] = stringArray[i].toLowerCase();
            }
            this.description = string;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!file.getName().toLowerCase().endsWith(this.extensions[i])) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

