/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.element.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.gotodeclaration.element.spi.ElementDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.element.spi.ElementProvider;
import org.netbeans.modules.cnd.gotodeclaration.element.ui.GoToElementOptions;
import org.netbeans.modules.cnd.gotodeclaration.element.ui.GoToElementPanel;
import org.netbeans.modules.cnd.gotodeclaration.element.ui.Models;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class GoToElementAction
extends AbstractAction
implements GoToElementPanel.ContentProvider {
    static final boolean TRACE = Boolean.getBoolean("cnd.goto.fv.trace");
    private SearchType nameKind;
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("GoToFuncVarAction-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    private GoToElementPanel panel;
    private Dialog dialog;
    private JButton okButton;
    private Collection<? extends ElementProvider> elementProviders;
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\.|\\$)*){2,}");

    public GoToElementAction() {
        super(NbBundle.getMessage(GoToElementAction.class, (String)"TXT_GoToFunctionOrVariable"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            JEditorPane[] jEditorPaneArray;
            EditorCookie editorCookie;
            this.elementProviders = Lookup.getDefault().lookupAll(ElementProvider.class);
            this.panel = new GoToElementPanel(this);
            this.dialog = this.createDialog(this.panel);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GoToElementAction.this.dialog.setVisible(true);
                }
            });
            Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
            String string = null;
            if (nodeArray.length > 0 && (editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class)) != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && (string = Utilities.getSelectionOrIdentifier((JTextComponent)jEditorPaneArray[0])) != null && org.openide.util.Utilities.isJavaIdentifier((String)string)) {
                this.panel.setInitialText(string);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public boolean isEnabled() {
        if (CsmModelAccessor.getModelState() == CsmModelState.ON) {
            this.elementProviders = Lookup.getDefault().lookupAll(ElementProvider.class);
            if (OpenProjects.getDefault().getOpenProjects().length > 0) {
                for (ElementProvider elementProvider : this.elementProviders) {
                    if (!elementProvider.isSuitable()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Dialog createDialog(GoToElementPanel goToElementPanel) {
        this.okButton = new JButton(NbBundle.getMessage(GoToElementAction.class, (String)"CTL_OK"));
        this.okButton.setEnabled(false);
        goToElementPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GoToElementAction.class, (String)"AN_GoToElement"));
        goToElementPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GoToElementAction.class, (String)"AD_GoToElement"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)goToElementPanel, NbBundle.getMessage(GoToElementAction.class, (String)"DLG_GoToElement"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(goToElementPanel));
        dialogDescriptor.setClosingOptions(new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setPreferredSize(new Dimension(GoToElementOptions.GoToElementDialog.getWidth(), GoToElementOptions.GoToElementDialog.getHeight()));
        Rectangle rectangle = org.openide.util.Utilities.getUsableScreenBounds();
        int n = rectangle.width * 9 / 10;
        int n2 = rectangle.height * 9 / 10;
        Dimension dimension = dialog.getPreferredSize();
        dimension.width = Math.min(dimension.width, n);
        dimension.height = Math.min(dimension.height, n2);
        dialog.setBounds(org.openide.util.Utilities.findCenterBounds((Dimension)dimension));
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                GoToElementAction.this.cleanup();
            }
        });
        return dialog;
    }

    private void cleanup() {
        this.cancel();
        if (this.dialog != null) {
            GoToElementOptions.GoToElementDialog.setHeight(this.dialog.getHeight());
            GoToElementOptions.GoToElementDialog.setWidth(this.dialog.getWidth());
            this.dialog.dispose();
            this.dialog = null;
            for (ElementProvider elementProvider : this.elementProviders) {
                elementProvider.cleanup();
            }
        }
    }

    private void cancel() {
        RequestProcessor.Task task = this.task;
        if (task != null) {
            task.cancel();
        }
        Worker worker = this.running;
        this.running = null;
        if (worker != null) {
            worker.cancel();
        }
        for (ElementProvider elementProvider : this.elementProviders) {
            elementProvider.cancel();
        }
    }

    public ListCellRenderer getListCellRenderer(JList jList) {
        return new Renderer(jList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListModel(GoToElementPanel goToElementPanel, String string) {
        if (this.okButton != null) {
            this.okButton.setEnabled(false);
        }
        this.cancel();
        if (string == null) {
            goToElementPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        boolean bl = string.endsWith(" ");
        if ((string = string.trim()).length() == 0) {
            goToElementPanel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        if (!bl && (GoToElementAction.isAllUpper(string) && string.length() > 1 || GoToElementAction.isCamelCase(string))) {
            this.nameKind = SearchType.CAMEL_CASE;
        } else if (GoToElementAction.containsWildCard(string) != -1) {
            string = this.transformWildCardsToJavaStyle(string);
            this.nameKind = goToElementPanel.isCaseSensitive() ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP;
        } else {
            this.nameKind = bl ? (goToElementPanel.isCaseSensitive() ? SearchType.EXACT_NAME : SearchType.CASE_INSENSITIVE_EXACT_NAME) : (goToElementPanel.isCaseSensitive() ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX);
        }
        GoToElementAction goToElementAction = this;
        synchronized (goToElementAction) {
            this.running = new Worker(string);
            this.task = rp.post((Runnable)this.running, 220);
            if (goToElementPanel.time != -1L && TRACE) {
                System.err.printf("Worker posted after %d ms.\n", System.currentTimeMillis() - goToElementPanel.time);
            }
        }
    }

    public void closeDialog() {
        this.dialog.setVisible(false);
        this.cleanup();
    }

    public boolean hasValidContent() {
        return this.okButton != null && this.okButton.isEnabled();
    }

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isCamelCase(String string) {
        return camelCasePattern.matcher(string).matches();
    }

    private static int containsWildCard(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '?' && string.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    private String transformWildCardsToJavaStyle(String string) {
        StringBuilder stringBuilder = new StringBuilder("");
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '?') {
                stringBuilder.append(string.substring(n, i));
                stringBuilder.append('.');
                n = i + 1;
                continue;
            }
            if (string.charAt(i) != '*') continue;
            stringBuilder.append(string.substring(n, i));
            stringBuilder.append(".*");
            n = i + 1;
        }
        stringBuilder.append(string.substring(n, string.length()));
        return stringBuilder.toString();
    }

    private int compareStrings(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string.compareTo(string2);
    }

    private static class Renderer
    extends DefaultListCellRenderer
    implements ChangeListener {
        private JPanel rendererComponent;
        private JLabel jlName = new JLabel();
        private JLabel jlPkg = new JLabel();
        private JLabel jlPrj = new JLabel();
        private int DARKER_COLOR_COMPONENT = 5;
        private int LIGHTER_COLOR_COMPONENT = 80;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;
        private JList jList;

        public Renderer(JList jList) {
            this.jList = jList;
            Container container = jList.getParent();
            if (container instanceof JViewport) {
                ((JViewport)container).addChangeListener(this);
                this.stateChanged(new ChangeEvent(container));
            }
            this.rendererComponent = new JPanel();
            this.rendererComponent.setLayout(new BorderLayout());
            this.rendererComponent.add((Component)this.jlName, "West");
            this.rendererComponent.add((Component)this.jlPkg, "Center");
            this.rendererComponent.add((Component)this.jlPrj, "East");
            this.jlName.setOpaque(false);
            this.jlPkg.setOpaque(false);
            this.jlPrj.setOpaque(false);
            this.jlName.setFont(jList.getFont());
            this.jlPkg.setFont(jList.getFont());
            this.jlPrj.setFont(jList.getFont());
            this.jlPrj.setHorizontalAlignment(4);
            this.jlPrj.setHorizontalTextPosition(2);
            this.fgColor = jList.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getGreen() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getBlue() + this.LIGHTER_COLOR_COMPONENT));
            this.bgColor = jList.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - this.DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = jList.getSelectionBackground();
            this.fgSelectionColor = jList.getSelectionForeground();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2 = jList.getFixedCellHeight();
            int n3 = jList.getFixedCellWidth() - 1;
            n3 = n3 < 200 ? 200 : n3;
            Dimension dimension = new Dimension(n3, n2);
            this.rendererComponent.setMaximumSize(dimension);
            this.rendererComponent.setPreferredSize(dimension);
            if (bl) {
                this.jlName.setForeground(this.fgSelectionColor);
                this.jlPkg.setForeground(this.fgSelectionColor);
                this.jlPrj.setForeground(this.fgSelectionColor);
                this.rendererComponent.setBackground(this.bgSelectionColor);
            } else {
                this.jlName.setForeground(this.fgColor);
                this.jlPkg.setForeground(this.fgColorLighter);
                this.jlPrj.setForeground(this.fgColor);
                this.rendererComponent.setBackground(n % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (object instanceof ElementDescriptor) {
                ElementDescriptor elementDescriptor = (ElementDescriptor)object;
                this.jlName.setIcon(elementDescriptor.getIcon());
                this.jlName.setText(elementDescriptor.getDisplayName());
                this.jlPkg.setText(elementDescriptor.getContextName());
                this.jlPrj.setText(elementDescriptor.getProjectName());
                this.jlPrj.setIcon(elementDescriptor.getProjectIcon());
                this.rendererComponent.setToolTipText(elementDescriptor.getAbsoluteFileName());
            } else {
                this.jlName.setText(object.toString());
            }
            return this.rendererComponent;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            this.jlName.setText("Sample");
            this.jlName.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/modelutil/resources/types16x16/class_16.png")));
            this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
            this.jList.setFixedCellWidth(jViewport.getExtentSize().width);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeComparator
    implements Comparator<ElementDescriptor> {
        private TypeComparator() {
        }

        @Override
        public int compare(ElementDescriptor elementDescriptor, ElementDescriptor elementDescriptor2) {
            int n = GoToElementAction.this.compareStrings(elementDescriptor.getDisplayName(), elementDescriptor2.getDisplayName());
            if (n == 0 && (n = GoToElementAction.this.compareStrings(elementDescriptor.getContextName(), elementDescriptor2.getContextName())) == 0 && (n = GoToElementAction.this.compareStrings(elementDescriptor.getProjectName(), elementDescriptor2.getProjectName())) == 0) {
                n = GoToElementAction.this.compareStrings(elementDescriptor.getAbsoluteFileName(), elementDescriptor2.getAbsoluteFileName());
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private final String text;
        private final long createTime;

        public Worker(String string) {
            this.text = string;
            this.createTime = System.currentTimeMillis();
            if (TRACE) {
                System.err.printf("Worker for %s created after %d ms\n", string, System.currentTimeMillis() - ((GoToElementAction)GoToElementAction.this).panel.time);
            }
        }

        @Override
        public void run() {
            if (TRACE) {
                System.err.printf("Worker for %s started after %d ms\n", this.text, System.currentTimeMillis() - this.createTime);
            }
            List<? extends ElementDescriptor> list = this.getTypeNames();
            if (this.isCanceled) {
                if (TRACE) {
                    System.err.printf("Worker for %s cancelled after %d ms\n", this.text, System.currentTimeMillis() - this.createTime);
                }
                return;
            }
            ListModel listModel = Models.fromList(list);
            if (this.isCanceled) {
                if (TRACE) {
                    System.err.printf("Worker for %s cancelled after %d ms\n", this.text, System.currentTimeMillis() - this.createTime);
                }
                return;
            }
            if (!this.isCanceled && listModel != null) {
                if (TRACE) {
                    System.err.printf("Worker for %s exited after %d ms\n", this.text, System.currentTimeMillis() - this.createTime);
                }
                GoToElementAction.this.panel.setModel(listModel);
                if (GoToElementAction.this.okButton != null && !list.isEmpty()) {
                    GoToElementAction.this.okButton.setEnabled(true);
                }
            }
        }

        public void cancel() {
            if (TRACE) {
                System.err.printf("Worker.cancel() is called\n", new Object[0]);
            }
            this.isCanceled = true;
        }

        private List<? extends ElementDescriptor> getTypeNames() {
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            ArrayList<? extends ElementDescriptor> arrayList = null;
            for (ElementProvider elementProvider : GoToElementAction.this.elementProviders) {
                if (this.isCanceled) {
                    return null;
                }
                boolean bl = true;
                for (int i = 0; i < projectArray.length; ++i) {
                    Project project = projectArray[i];
                    Collection<? extends ElementDescriptor> collection = elementProvider.getElements(project, this.text, GoToElementAction.this.nameKind, bl);
                    bl = false;
                    if (collection == null) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<ElementDescriptor>(collection.size());
                    }
                    arrayList.addAll(collection);
                }
            }
            if (!this.isCanceled && arrayList != null) {
                long l = System.currentTimeMillis();
                Collections.sort(arrayList, new TypeComparator());
                if (TRACE) {
                    System.err.printf("Sorting took %d ms\n", System.currentTimeMillis() - l);
                }
                return arrayList;
            }
            return null;
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private GoToElementPanel panel;

        public DialogButtonListener(GoToElementPanel goToElementPanel) {
            this.panel = goToElementPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GoToElementAction.this.okButton) {
                this.panel.openSelectedItem();
            }
        }
    }
}

