/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.xml.wsdl.bindingsupport.spi.ValidationInfo;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplate;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplateGroup;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.netbeans.modules.xml.wsdl.ui.view.BindingConfigurationPanel;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.newtype.OperationPanel;
import org.netbeans.modules.xml.wsdl.ui.wizard.BindingGenerator;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;

public class WizardBindingConfigurationStep
implements WizardDescriptor.FinishablePanel {
    public static final String BINDING_NAME = "BINDING_NAME";
    public static final String BINDING_TYPE = "BINDING_TYPE";
    public static final String BINDING_SUBTYPE = "BINDING_SUBTYPE";
    public static final String SERVICE_NAME = "SERVICE_NAME";
    public static final String SERVICEPORT_NAME = "SERVICEPORT_NAME";
    public static final String BINDING = "BINDING";
    public static final String SERVICE = "SERVICE";
    public static final String PORT = "PORT";
    public static final String AUTO_CREATE_SERVICEPORT = "AUTO_CREATE_SERVICEPORT";
    private BindingConfigurationPanel mPanel;
    private String mErrorMessage;
    private String mBindingSubTypeError;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private WizardDescriptor wiz = null;
    private WSDLModel mTempModel;
    private PortType mPortType;
    private Binding mBinding;
    private Service mService;
    private Port mPort;

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public Component getComponent() {
        if (this.mPanel == null) {
            this.mPanel = new BindingConfigurationPanel();
            this.mPanel.setName(NbBundle.getMessage(WizardBindingConfigurationStep.class, (String)"LBL_WizardBindingConfigurationStep"));
            TextChangeListener textChangeListener = new TextChangeListener();
            this.mPanel.getBindingNameTextField().getDocument().addDocumentListener(textChangeListener);
            this.mPanel.getServiceNameTextField().getDocument().addDocumentListener(textChangeListener);
            this.mPanel.getServicePortTextField().getDocument().addDocumentListener(textChangeListener);
            BindingConfigurationListener bindingConfigurationListener = new BindingConfigurationListener();
            this.mPanel.addPropertyChangeListener(bindingConfigurationListener);
        }
        return this.mPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(WizardBindingConfigurationStep.class);
    }

    public boolean isValid() {
        this.wiz.putProperty("WizardPanel_errorMessage", (Object)this.mErrorMessage);
        return this.mErrorMessage == null;
    }

    public void readSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        this.wiz = templateWizard;
        String string = (String)templateWizard.getProperty("FILE_NAME");
        if (this.mPanel.getBindingName() == null || this.mPanel.getBindingName().trim().equals("")) {
            this.mPanel.setBindingName(string + "Binding");
        }
        if (this.mPanel.getServiceName() == null || this.mPanel.getServiceName().trim().equals("")) {
            this.mPanel.setServiceName(string + "Service");
        }
        if (this.mPanel.getServicePortName() == null || this.mPanel.getServicePortName().trim().equals("")) {
            this.mPanel.setServicePortName(string + "Port");
        }
        this.mPortType = (PortType)templateWizard.getProperty("PORTTYPE");
        this.mTempModel = (WSDLModel)templateWizard.getProperty("TEMP_WSDLMODEL");
        LocalizedTemplate localizedTemplate = this.mPanel.getBindingSubType();
        this.processBindingSubType(localizedTemplate, true);
    }

    public void storeSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        if (templateWizard.getValue() == NotifyDescriptor.CANCEL_OPTION) {
            this.cleanup();
            return;
        }
        if (templateWizard.getValue() == WizardDescriptor.PREVIOUS_OPTION) {
            this.mTempModel.startTransaction();
            this.cleanUpBindings();
            this.mTempModel.endTransaction();
            templateWizard.putProperty(BINDING_NAME, null);
            templateWizard.putProperty(BINDING_TYPE, null);
            templateWizard.putProperty(BINDING_SUBTYPE, null);
            templateWizard.putProperty(SERVICE_NAME, null);
            templateWizard.putProperty(SERVICEPORT_NAME, null);
            return;
        }
        String string = this.mPanel.getBindingName();
        LocalizedTemplateGroup localizedTemplateGroup = this.mPanel.getBindingType();
        LocalizedTemplate localizedTemplate = this.mPanel.getBindingSubType();
        String string2 = this.mPanel.getServiceName();
        String string3 = this.mPanel.getServicePortName();
        templateWizard.putProperty(BINDING_NAME, (Object)string);
        templateWizard.putProperty(BINDING_TYPE, (Object)localizedTemplateGroup);
        templateWizard.putProperty(BINDING_SUBTYPE, (Object)localizedTemplate);
        templateWizard.putProperty(SERVICE_NAME, (Object)string2);
        templateWizard.putProperty(SERVICEPORT_NAME, (Object)string3);
        this.processBindingSubType(localizedTemplate);
    }

    void cleanup() {
        DataObject dataObject = ActionHelper.getDataObject((Model)this.mTempModel);
        if (dataObject != null) {
            dataObject.setModified(false);
            try {
                dataObject.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cleanUpBindings() {
        if (this.mBinding != null) {
            this.mTempModel.getDefinitions().removeBinding(this.mBinding);
        }
        if (this.mService != null) {
            this.mTempModel.getDefinitions().removeService(this.mService);
        }
        this.mBinding = null;
        this.mService = null;
    }

    private boolean isValidName(Document document) {
        try {
            String string = document.getText(0, document.getLength());
            boolean bl = Utils.isValidNCName((String)string);
            this.mErrorMessage = !bl ? NbBundle.getMessage(OperationPanel.class, (String)"ERR_MSG_INVALID_NAME", (Object)string) : null;
            this.fireChangeEvent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.mErrorMessage == null;
    }

    private void validate() {
        boolean bl = this.isValidName(this.mPanel.getBindingNameTextField().getDocument());
        if (!bl) {
            this.fireChangeEvent();
            return;
        }
        boolean bl2 = this.isValidName(this.mPanel.getServiceNameTextField().getDocument());
        if (!bl2) {
            this.fireChangeEvent();
            return;
        }
        boolean bl3 = this.isValidName(this.mPanel.getServicePortTextField().getDocument());
        if (!bl3) {
            this.fireChangeEvent();
            return;
        }
        if (this.mBindingSubTypeError != null) {
            this.mErrorMessage = this.mBindingSubTypeError;
            this.fireChangeEvent();
            return;
        }
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ChangeListener changeListener = iterator.next();
            changeListener.stateChanged(changeEvent);
        }
    }

    public boolean isFinishPanel() {
        return true;
    }

    private void processBindingSubType(LocalizedTemplate localizedTemplate) {
        this.processBindingSubType(localizedTemplate, false);
    }

    private void processBindingSubType(LocalizedTemplate localizedTemplate, boolean bl) {
        if (localizedTemplate != null) {
            String string = this.mPanel.getBindingName();
            LocalizedTemplateGroup localizedTemplateGroup = this.mPanel.getBindingType();
            String string2 = this.mPanel.getServiceName();
            String string3 = this.mPanel.getServicePortName();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(BINDING_NAME, string);
            hashMap.put(BINDING_TYPE, (String)localizedTemplateGroup);
            hashMap.put(BINDING_SUBTYPE, (String)localizedTemplate);
            hashMap.put(SERVICE_NAME, string2);
            hashMap.put(SERVICEPORT_NAME, string3);
            this.mTempModel.startTransaction();
            this.cleanUpBindings();
            BindingGenerator bindingGenerator = new BindingGenerator(this.mTempModel, this.mPortType, hashMap);
            bindingGenerator.execute();
            this.mBinding = bindingGenerator.getBinding();
            this.mService = bindingGenerator.getService();
            this.mPort = bindingGenerator.getPort();
            if (this.mBinding != null) {
                List list;
                String string4 = (String)this.wiz.getProperty("WSDL_TARGETNAMESPACE");
                ArrayList arrayList = new ArrayList();
                List list2 = localizedTemplate.getMProvider().validate(this.mBinding);
                if (list2 != null) {
                    arrayList.addAll(list2);
                }
                if (this.mPort != null && (list = localizedTemplate.getMProvider().validate(this.mPort)) != null) {
                    arrayList.addAll(list);
                }
                if (arrayList.size() > 0) {
                    list = (ValidationInfo)arrayList.get(0);
                    this.mBindingSubTypeError = list.getDescription();
                    IOProvider.getDefault().getStdOut().print(this.mBindingSubTypeError);
                    this.validate();
                } else {
                    this.mBindingSubTypeError = null;
                    this.validate();
                    if (this.mBinding != null) {
                        localizedTemplate.getMProvider().postProcess(string4, this.mBinding);
                    }
                    if (this.mPort != null) {
                        localizedTemplate.getMProvider().postProcess(string4, this.mPort);
                    }
                    this.wiz.putProperty(BINDING, (Object)this.mBinding);
                    this.wiz.putProperty(SERVICE, (Object)this.mService);
                    this.wiz.putProperty(PORT, (Object)this.mPort);
                }
            }
            if (bl) {
                this.mTempModel.rollbackTransaction();
                this.mBinding = null;
                this.mService = null;
                this.mPort = null;
            } else {
                this.mTempModel.endTransaction();
            }
        }
    }

    class BindingConfigurationListener
    implements PropertyChangeListener {
        BindingConfigurationListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("PROP_BINDING_SUBTYPE".equals(string)) {
                LocalizedTemplate localizedTemplate = (LocalizedTemplate)propertyChangeEvent.getNewValue();
                WizardBindingConfigurationStep.this.processBindingSubType(localizedTemplate, true);
            } else if ("PROP_BINDING_TYPE".equals(string)) {
                WizardBindingConfigurationStep.this.processBindingSubType(WizardBindingConfigurationStep.this.mPanel.getBindingSubType(), true);
            }
        }
    }

    class TextChangeListener
    implements DocumentListener {
        TextChangeListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            WizardBindingConfigurationStep.this.validate();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            WizardBindingConfigurationStep.this.validate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            WizardBindingConfigurationStep.this.validate();
        }
    }
}

