/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.namespace.QName;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.ui.view.common.CommonMessagePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AttributePanel
extends JPanel {
    private static final long serialVersionUID = 1680305470367882467L;
    public static String STATE_CHANGED = "STATE_CHANGED";
    private CommonMessagePanel mErrorPanel;
    private String mNamespace;
    private String mAttributeName;
    private Vector mNamespaces;
    private boolean isNamespaceRequired = false;
    private WSDLComponent mComponent;
    private JLabel mAttrNameLabel;
    private JTextField mAttrNameTextField;
    private JComboBox mAttrNamespaceComboBox;
    private JLabel mAttrNamespaceLabel;
    private JPanel mCommonMsgPanel;

    public AttributePanel(boolean bl, Vector vector, WSDLComponent wSDLComponent) {
        this.isNamespaceRequired = bl;
        this.mNamespaces = vector;
        this.mComponent = wSDLComponent;
        this.initComponents();
        this.initCommonMessagePanel();
    }

    private void initCommonMessagePanel() {
        this.mErrorPanel = new CommonMessagePanel();
        this.mCommonMsgPanel.add((Component)this.mErrorPanel, "Center");
        AttributeDocumentListener attributeDocumentListener = new AttributeDocumentListener();
        this.mAttrNameTextField.getDocument().addDocumentListener(attributeDocumentListener);
        ((JTextField)this.mAttrNamespaceComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(attributeDocumentListener);
    }

    private void initComponents() {
        this.mAttrNameLabel = new JLabel();
        this.mAttrNamespaceLabel = new JLabel();
        this.mAttrNameTextField = new JTextField();
        this.mAttrNamespaceComboBox = new JComboBox();
        this.mCommonMsgPanel = new JPanel();
        this.setName("Form");
        this.mAttrNameLabel.setLabelFor(this.mAttrNameTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/xml/wsdl/ui/view/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.mAttrNameLabel, (String)resourceBundle.getString("LBL_AttributePanel_NAME"));
        this.mAttrNameLabel.setToolTipText(NbBundle.getMessage(AttributePanel.class, (String)"AttributePanel.mAttrNameLabel.toolTipText"));
        this.mAttrNameLabel.setName("mAttrNameLabel");
        this.mAttrNamespaceLabel.setLabelFor(this.mAttrNamespaceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.mAttrNamespaceLabel, (String)resourceBundle.getString("LBL_AttributePanel_NAMESPACE"));
        this.mAttrNamespaceLabel.setToolTipText(NbBundle.getMessage(AttributePanel.class, (String)"AttributePanel.mAttrNamespaceLabel.toolTipText"));
        this.mAttrNamespaceLabel.setName("mAttrNamespaceLabel");
        this.mAttrNameTextField.setToolTipText(NbBundle.getMessage(AttributePanel.class, (String)"AttributePanel.mAttrNameTextField.toolTipText"));
        this.mAttrNameTextField.setName("mAttrNameTextField");
        this.mAttrNamespaceComboBox.setEditable(true);
        this.mAttrNamespaceComboBox.setModel(new DefaultComboBoxModel(this.mNamespaces));
        this.mAttrNamespaceComboBox.setToolTipText(NbBundle.getMessage(AttributePanel.class, (String)"AttributePanel.mAttrNamespaceComboBox.toolTipText"));
        this.mAttrNamespaceComboBox.setName("mAttrNamespaceComboBox");
        this.mCommonMsgPanel.setToolTipText(NbBundle.getMessage(AttributePanel.class, (String)"AttributePanel.mCommonMsgPanel.toolTipText"));
        this.mCommonMsgPanel.setName("mCommonMsgPanel");
        this.mCommonMsgPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.mCommonMsgPanel, -1, 380, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.mAttrNameLabel).add((Component)this.mAttrNamespaceLabel)).add(16, 16, 16).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.mAttrNameTextField, -1, 305, Short.MAX_VALUE).add((Component)this.mAttrNamespaceComboBox, 0, 305, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.mAttrNameLabel).add((Component)this.mAttrNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.mAttrNamespaceLabel).add((Component)this.mAttrNamespaceComboBox, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.mCommonMsgPanel, -2, 49, -2).addContainerGap()));
        this.mCommonMsgPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttributePanel.class, (String)"AttributePanel.mCommonMsgPanel.toolTipText"));
    }

    public String getAttributeNamespace() {
        JTextField jTextField = (JTextField)this.mAttrNamespaceComboBox.getEditor().getEditorComponent();
        return jTextField.getText();
    }

    public String getAttributeNameFromTextField() {
        return this.mAttrNameTextField.getText();
    }

    public JTextField getAttributeNameTextField() {
        return this.mAttrNameTextField;
    }

    public JComboBox getNamespaceComboBox() {
        return this.mAttrNamespaceComboBox;
    }

    public boolean isStateValid() {
        return this.mErrorPanel.isStateValid();
    }

    private boolean validateAttributeNameAndNamespace() {
        boolean bl = true;
        String string = this.getAttributeNameFromTextField();
        String string2 = this.getAttributeNamespace();
        if (string == null || string.trim().equals("")) {
            bl = false;
            this.mErrorPanel.setErrorMessage(NbBundle.getMessage(this.getClass(), (String)"AttributeView_COMMON_MSG_ERROR_ATTRIBUTE_NAME_NOT_VALID", (Object)string));
            this.firePropertyChange(STATE_CHANGED, true, false);
        } else if (this.isNamespaceRequired && (string2 == null || string2.trim().equals(""))) {
            bl = false;
            this.mErrorPanel.setErrorMessage(NbBundle.getMessage(this.getClass(), (String)"AttributeView_COMMON_MSG_ERROR_NAMESPACE_IS_NOT_VALID", (Object)string2));
            this.firePropertyChange(STATE_CHANGED, true, false);
        } else {
            this.mNamespace = string2;
            QName qName = new QName(string2, string);
            if (this.mComponent.getAttributeMap().get(qName) != null) {
                bl = false;
                this.mErrorPanel.setErrorMessage(NbBundle.getMessage(this.getClass(), (String)"AttributeView_COMMON_MSG_ERROR_ATTRIBUTE_ALREADY_EXIST", (Object)qName.toString()));
                this.firePropertyChange(STATE_CHANGED, true, false);
            } else {
                this.mAttributeName = string;
            }
        }
        if (bl) {
            this.mErrorPanel.setMessage("");
            this.firePropertyChange(STATE_CHANGED, false, true);
        }
        return bl;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public String getAttributeName() {
        return this.mAttributeName;
    }

    class AttributeDocumentListener
    implements DocumentListener {
        AttributeDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AttributePanel.this.validateAttributeNameAndNamespace();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AttributePanel.this.validateAttributeNameAndNamespace();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AttributePanel.this.validateAttributeNameAndNamespace();
        }
    }
}

