/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.netbeans.module;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.search.api.SearchManager;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.validation.ValidateAction;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.cookies.RefreshExtensibilityElementNodeCookie;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLColumnsCategory;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLDataObject;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLEditorSupport;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLMultiViewFactory;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLSettings;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLTreeCategory;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLTreeViewMultiViewDesc;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.category.Category;
import org.netbeans.modules.xml.xam.ui.category.CategoryPane;
import org.netbeans.modules.xml.xam.ui.category.DefaultCategoryPane;
import org.netbeans.modules.xml.xam.ui.multiview.ActivatedNodesMediator;
import org.netbeans.modules.xml.xam.ui.multiview.CookieProxyLookup;
import org.openide.actions.FindAction;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class WSDLTreeViewMultiViewElement
extends TopComponent
implements MultiViewElement,
ExplorerManager.Provider,
PropertyChangeListener {
    private static final long serialVersionUID = -655912409997381426L;
    private static final String ACTIVATED_NODES = "activatedNodes";
    private ExplorerManager manager;
    private WSDLDataObject mObj;
    private CategoryPane categoryPane;
    private transient MultiViewElementCallback multiViewObserver;
    private transient JLabel errorLabel = new JLabel();
    private transient JToolBar mToolbar;
    private ActivatedNodesMediator nodesMediator;
    private CookieProxyLookup cpl;
    private WSDLModel wsdlModel;

    public WSDLTreeViewMultiViewElement() {
    }

    public WSDLTreeViewMultiViewElement(WSDLDataObject wSDLDataObject) {
        this.mObj = wSDLDataObject;
        this.initialize();
    }

    private void initialize() {
        this.manager = new ExplorerManager();
        CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(FindAction.class);
        Object object = callbackSystemAction.getActionMapKey();
        WSDLFindAction wSDLFindAction = new WSDLFindAction();
        ActionMap actionMap = this.getActionMap();
        actionMap.put(object, wSDLFindAction);
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)false));
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = (KeyStroke)callbackSystemAction.getValue("AcceleratorKey");
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke("control F");
        }
        inputMap.put(keyStroke, object);
        ShowCookie showCookie = new ShowCookie(){

            public void show(Validator.ResultItem resultItem) {
                Component component = resultItem.getComponents();
                if (WSDLTreeViewMultiViewElement.this.categoryPane != null && component instanceof DocumentComponent) {
                    WSDLTreeViewMultiViewElement.this.categoryPane.getCategory().showComponent(component);
                }
            }
        };
        RefreshExtensibilityElementNodeCookie refreshExtensibilityElementNodeCookie = new RefreshExtensibilityElementNodeCookie(){

            public void refresh() {
                if (WSDLTreeViewMultiViewElement.this.categoryPane != null) {
                    Collection collection = WSDLTreeViewMultiViewElement.this.categoryPane.getCategory().getLookup().lookupAll(RefreshExtensibilityElementNodeCookie.class);
                    for (RefreshExtensibilityElementNodeCookie refreshExtensibilityElementNodeCookie : collection) {
                        if (refreshExtensibilityElementNodeCookie == null || refreshExtensibilityElementNodeCookie == this) continue;
                        refreshExtensibilityElementNodeCookie.refresh();
                    }
                }
            }
        };
        Node node = this.mObj.getNodeDelegate();
        this.nodesMediator = new ActivatedNodesMediator(node);
        this.nodesMediator.setExplorerManager((ExplorerManager.Provider)this);
        this.cpl = new CookieProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{actionMap, this.mObj, showCookie, refreshExtensibilityElementNodeCookie}), this.nodesMediator.getLookup(), node.getLookup()}, node);
        this.associateLookup((Lookup)this.cpl);
        this.addPropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.nodesMediator);
        this.addPropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.cpl);
        this.setLayout(new BorderLayout());
    }

    private WSDLModel getWSDLModel() {
        if (this.wsdlModel != null) {
            return this.wsdlModel;
        }
        this.wsdlModel = this.mObj.getWSDLEditorSupport().getModel();
        this.wsdlModel.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.wsdlModel));
        return this.wsdlModel;
    }

    private void cleanup() {
        try {
            this.manager.setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.removePropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.nodesMediator);
        this.removePropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.cpl);
        this.nodesMediator.setExplorerManager(null);
        this.nodesMediator = null;
        this.cpl = null;
        this.categoryPane = null;
        if (this.mToolbar != null) {
            this.mToolbar.removeAll();
        }
        this.mToolbar = null;
        this.removeAll();
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        this.manager = null;
        this.multiViewObserver = null;
        this.setActivatedNodes(new Node[0]);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Model.State state;
        if ("state".equals(propertyChangeEvent.getPropertyName()) && (state = (Model.State)propertyChangeEvent.getNewValue()) != null) {
            this.initUIInAWTThread();
        }
    }

    private void initUIInAWTThread() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    WSDLTreeViewMultiViewElement.this.initUI();
                }
            });
        } else {
            this.initUI();
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public int getPersistenceType() {
        return 2;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewObserver = multiViewElementCallback;
    }

    public CloseOperationState canCloseElement() {
        if (!WSDLEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_TEXT_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public UndoRedo getUndoRedo() {
        return this.mObj.getWSDLEditorSupport().getUndoManager();
    }

    public void componentHidden() {
        Category category;
        super.componentHidden();
        if (this.categoryPane != null && (category = this.categoryPane.getCategory()) != null) {
            category.componentHidden();
        }
    }

    public void componentClosed() {
        super.componentClosed();
        this.cleanup();
    }

    public void componentOpened() {
        super.componentOpened();
        this.initUI();
    }

    public void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
        WSDLMultiViewFactory.updateGroupVisibility("wsdl-treeview");
        if (this.categoryPane != null) {
            this.categoryPane.getComponent().requestFocusInWindow();
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        if (this.manager != null) {
            ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        }
        WSDLMultiViewFactory.updateGroupVisibility("wsdl-treeview");
    }

    public void componentShowing() {
        Category category;
        super.componentShowing();
        if (this.categoryPane != null && (category = this.categoryPane.getCategory()) != null) {
            category.componentShown();
        }
    }

    public void requestActive() {
        super.requestActive();
        if (this.categoryPane != null) {
            this.categoryPane.getComponent().requestFocus();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WSDLTreeViewMultiViewDesc.class);
    }

    protected String preferredID() {
        return "WSDLTreeViewMultiViewElementTC";
    }

    private void initUI() {
        WSDLModel wSDLModel = this.getWSDLModel();
        if (this.mToolbar != null) {
            this.mToolbar.removeAll();
            this.mToolbar = null;
        }
        if (wSDLModel != null && wSDLModel.getState() == Model.State.VALID) {
            if (this.categoryPane == null) {
                Lookup lookup = this.getLookup();
                this.categoryPane = new DefaultCategoryPane();
                WSDLTreeCategory wSDLTreeCategory = new WSDLTreeCategory(wSDLModel, lookup);
                this.categoryPane.addCategory((Category)wSDLTreeCategory);
                WSDLColumnsCategory wSDLColumnsCategory = new WSDLColumnsCategory(wSDLModel, lookup);
                this.categoryPane.addCategory((Category)wSDLColumnsCategory);
                WSDLSettings.ViewMode viewMode = WSDLSettings.getDefault().getViewMode();
                switch (viewMode) {
                    case COLUMN: {
                        this.categoryPane.setCategory((Category)wSDLColumnsCategory);
                        break;
                    }
                    case TREE: {
                        this.categoryPane.setCategory((Category)wSDLTreeCategory);
                    }
                }
            }
            this.removeAll();
            this.add(this.categoryPane.getComponent(), "Center");
            return;
        }
        String string = null;
        if (wSDLModel == null || wSDLModel.getState() == Model.State.NOT_WELL_FORMED) {
            string = NbBundle.getMessage(WSDLTreeViewMultiViewElement.class, (String)"MSG_NotWellformedWsdl");
        }
        this.removeAll();
        this.errorLabel.setText("<" + string + ">");
        this.errorLabel.setHorizontalAlignment(0);
        this.errorLabel.setHorizontalTextPosition(0);
        this.errorLabel.setEnabled(false);
        Color color = UIManager.getColor("window");
        this.errorLabel.setBackground(color != null ? color : Color.white);
        this.errorLabel.setOpaque(true);
        this.add(this.errorLabel, "Center");
    }

    public JComponent getToolbarRepresentation() {
        if (this.mToolbar == null) {
            this.mToolbar = new JToolBar();
            this.mToolbar.setFloatable(false);
            WSDLModel wSDLModel = this.getWSDLModel();
            if (wSDLModel != null && wSDLModel.getState() == Model.State.VALID) {
                if (this.categoryPane != null) {
                    this.mToolbar.addSeparator();
                    this.categoryPane.populateToolbar(this.mToolbar);
                }
                this.mToolbar.addSeparator();
                this.mToolbar.add(SearchManager.getDefault().getSearchAction());
                this.mToolbar.addSeparator();
                this.mToolbar.add((Action)new ValidateAction((Model)wSDLModel));
            }
        }
        return this.mToolbar;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    private class WSDLFindAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            WSDLTreeViewMultiViewElement wSDLTreeViewMultiViewElement = WSDLTreeViewMultiViewElement.this;
            if (wSDLTreeViewMultiViewElement.categoryPane != null) {
                CategoryPane categoryPane = wSDLTreeViewMultiViewElement.categoryPane;
                categoryPane.getSearchComponent().showComponent();
            }
        }
    }
}

