/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.WhenNode;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditList;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.PreviewableFix;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.ruby.hints.Deprecations;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonToThen
extends RubyAstRule {
    private static final int INSERT_THEN = 1;
    private static final int INSERT_NEWLINE = 2;
    private static final int INSERT_SEMICOLON = 3;

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.WHENNODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        Node node = rubyRuleContext.node;
        CompilationInfo compilationInfo = rubyRuleContext.compilationInfo;
        WhenNode whenNode = (WhenNode)node;
        Node node2 = whenNode.getBodyNode();
        if (node2 == null) {
            return;
        }
        BaseDocument baseDocument = rubyRuleContext.doc;
        try {
            String string;
            Object object;
            Object object2;
            TokenSequence tokenSequence;
            int n = whenNode.getPosition().getStartOffset();
            int n2 = node2.getPosition().getStartOffset();
            int n3 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)n);
            int n4 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)n2);
            if (n3 == -1 || n4 == -1) {
                return;
            }
            int n5 = baseDocument.getLength();
            if (n3 > n5 || n4 > n5) {
                return;
            }
            if (Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4) != Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3)) {
                return;
            }
            int n6 = -1;
            try {
                baseDocument.readLock();
                tokenSequence = LexUtilities.getRubyTokenSequence((BaseDocument)baseDocument, (int)n4);
                if (tokenSequence == null) {
                    return;
                }
                tokenSequence.move(n4);
                while (tokenSequence.movePrevious()) {
                    object2 = tokenSequence.token();
                    object = object2.id();
                    if (object == RubyTokenId.WHITESPACE) continue;
                    if (object == RubyTokenId.NONUNARY_OP) {
                        string = ((Object)object2.text()).toString();
                        if (":".equals(string)) {
                            n6 = tokenSequence.offset();
                            break;
                        }
                        return;
                    }
                    return;
                }
            }
            finally {
                baseDocument.readUnlock();
            }
            if (n6 == -1) {
                return;
            }
            tokenSequence = new OffsetRange(n6, n6 + 1);
            object2 = NbBundle.getMessage(ColonToThen.class, (String)"ColonToThenGutter");
            object = new ArrayList(2);
            object.add(new ColonFix(baseDocument, n6, 1));
            object.add(new ColonFix(baseDocument, n6, 3));
            object.add(new ColonFix(baseDocument, n6, 2));
            string = new Hint((Rule)this, (String)object2, compilationInfo.getFileObject(), (OffsetRange)tokenSequence, (List)object, 150);
            list.add((Hint)string);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public String getId() {
        return "ColonToThen";
    }

    public String getDescription() {
        return NbBundle.getMessage(ColonToThen.class, (String)"ColonToThenDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ColonToThen.class, (String)"ColonToThen");
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private static class ColonFix
    implements PreviewableFix {
        private BaseDocument doc;
        private int offset;
        private int mode;

        public ColonFix(BaseDocument baseDocument, int n, int n2) {
            this.doc = baseDocument;
            this.offset = n;
            this.mode = n2;
        }

        public String getDescription() {
            switch (this.mode) {
                case 3: {
                    return NbBundle.getMessage(Deprecations.class, (String)"ColonToThenFixSemi");
                }
                case 1: {
                    return NbBundle.getMessage(Deprecations.class, (String)"ColonToThenFix");
                }
            }
            return NbBundle.getMessage(Deprecations.class, (String)"ColonToThenFixNewline");
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            EditList editList = new EditList(this.doc);
            switch (this.mode) {
                case 2: {
                    editList.setFormatAll(false);
                    editList.replace(this.offset, 1, "\n", true, 0);
                    break;
                }
                case 1: {
                    String string = this.doc.getText(this.offset, 3);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!Character.isWhitespace(this.doc.getText(this.offset - 1, 1).charAt(0))) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append("then");
                    if (this.offset < this.doc.getLength() - 2 && !Character.isWhitespace(this.doc.getText(this.offset + 1, 1).charAt(0))) {
                        stringBuilder.append(' ');
                    }
                    editList.replace(this.offset, 1, stringBuilder.toString(), false, 0);
                    break;
                }
                case 3: {
                    editList.replace(this.offset, 1, ";", false, 0);
                }
            }
            return editList;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

