/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.base.ui.customizer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.compapp.projects.base.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.compapp.projects.base.ui.customizer.VisualClassPathItem;
import org.openide.util.Utilities;

public final class VisualClasspathSupport {
    final Project master;
    final JList classpathList;
    final JButton addArtifactButton;
    final JButton removeButton;
    final JButton upButton;
    final JButton downButton;
    private final DefaultListModel classpathModel;
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>();

    public VisualClasspathSupport(Project project, JList jList, JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4) {
        this.master = project;
        this.classpathList = jList;
        this.classpathModel = new DefaultListModel();
        this.classpathList.setModel(this.classpathModel);
        this.classpathList.setCellRenderer(new ClassPathCellRenderer());
        this.addArtifactButton = jButton;
        this.removeButton = jButton2;
        this.upButton = jButton3;
        this.downButton = jButton4;
        ClasspathSupportListener classpathSupportListener = new ClasspathSupportListener();
        jButton.addActionListener(classpathSupportListener);
        jButton2.addActionListener(classpathSupportListener);
        jButton3.addActionListener(classpathSupportListener);
        jButton4.addActionListener(classpathSupportListener);
        jList.getSelectionModel().addListSelectionListener(classpathSupportListener);
        classpathSupportListener.valueChanged(null);
    }

    public void setVisualClassPathItems(List list) {
        this.classpathModel.clear();
        for (VisualClassPathItem visualClassPathItem : list) {
            this.classpathModel.addElement(visualClassPathItem);
        }
    }

    public List getVisualClassPathItems() {
        ArrayList<VisualClassPathItem> arrayList = new ArrayList<VisualClassPathItem>();
        Enumeration enumeration = this.classpathModel.elements();
        while (enumeration.hasMoreElements()) {
            VisualClassPathItem visualClassPathItem = (VisualClassPathItem)enumeration.nextElement();
            arrayList.add(visualClassPathItem);
        }
        return arrayList;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed() {
        ArrayList<ActionListener> arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList<ActionListener>(this.actionListeners);
        }
        object = new ActionEvent(this, 0, null);
        for (ActionListener actionListener : arrayList) {
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    private URI getArtifactLocation(AntArtifact antArtifact) {
        URI[] uRIArray = antArtifact.getArtifactLocations();
        if (uRIArray != null && uRIArray.length > 0) {
            return uRIArray[0];
        }
        return null;
    }

    private void addArtifacts(AntArtifact[] antArtifactArray) {
        int[] nArray = this.classpathList.getSelectedIndices();
        int n = nArray == null || nArray.length == 0 ? -1 : nArray[nArray.length - 1];
        int[] nArray2 = new int[antArtifactArray.length];
        for (int i = 0; i < antArtifactArray.length; ++i) {
            int n2 = n + 1 + i;
            this.classpathModel.add(n2, new VisualClassPathItem(antArtifactArray[i], 2, null, this.getArtifactLocation(antArtifactArray[i]).toString(), true));
            nArray2[i] = n2;
        }
        this.classpathList.setSelectedIndices(nArray2);
        this.fireActionPerformed();
    }

    private void removeElements() {
        int n;
        int[] nArray = this.classpathList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) assert (false) : "Remove button should be disabled";
        for (n = nArray.length - 1; n >= 0; --n) {
            this.classpathModel.remove(nArray[n]);
        }
        if (!this.classpathModel.isEmpty()) {
            n = nArray[nArray.length - 1] - nArray.length + 1;
            if (n > this.classpathModel.size() - 1) {
                n = this.classpathModel.size() - 1;
            }
            this.classpathList.setSelectedIndex(n);
        }
        this.fireActionPerformed();
    }

    private void moveUp() {
        int n;
        int[] nArray = this.classpathList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) assert (false) : "MoveUp button should be disabled";
        for (n = 0; n < nArray.length; ++n) {
            Object e = this.classpathModel.get(nArray[n]);
            this.classpathModel.remove(nArray[n]);
            this.classpathModel.add(nArray[n] - 1, e);
        }
        n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        this.classpathList.setSelectedIndices(nArray);
        this.fireActionPerformed();
    }

    private void moveDown() {
        int n;
        int[] nArray = this.classpathList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) assert (false) : "MoveDown button should be disabled";
        for (n = nArray.length - 1; n >= 0; --n) {
            Object e = this.classpathModel.get(nArray[n]);
            this.classpathModel.remove(nArray[n]);
            this.classpathModel.add(nArray[n] + 1, e);
        }
        n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        this.classpathList.setSelectedIndices(nArray);
        this.fireActionPerformed();
    }

    private static class ClassPathCellRenderer
    extends DefaultListCellRenderer {
        private ClassPathCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setIcon(((VisualClassPathItem)object).getIcon());
            this.setToolTipText(object.toString());
            return this;
        }
    }

    private class ClasspathSupportListener
    implements ActionListener,
    ListSelectionListener {
        private ClasspathSupportListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == VisualClasspathSupport.this.addArtifactButton) {
                AntArtifact[] antArtifactArray = AntArtifactChooser.showDialog("CAPS.asa", VisualClasspathSupport.this.classpathModel, VisualClasspathSupport.this.master);
                if (antArtifactArray != null) {
                    VisualClasspathSupport.this.addArtifacts(antArtifactArray);
                }
            } else if (object == VisualClasspathSupport.this.removeButton) {
                VisualClasspathSupport.this.removeElements();
            } else if (object == VisualClasspathSupport.this.upButton) {
                VisualClasspathSupport.this.moveUp();
            } else if (object == VisualClasspathSupport.this.downButton) {
                VisualClasspathSupport.this.moveDown();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            boolean bl;
            int[] nArray = VisualClasspathSupport.this.classpathList.getSelectedIndices();
            boolean bl2 = nArray != null && nArray.length > 0;
            boolean bl3 = bl = nArray != null && nArray.length > 0;
            if (bl) {
                for (n = 0; n < nArray.length; ++n) {
                    assert (nArray[n] < VisualClasspathSupport.this.classpathModel.getSize()) : "The selected indices " + Arrays.asList(Utilities.toObjectArray((Object)nArray)) + " at " + n + " must fit into size of classpathModel" + VisualClasspathSupport.access$200(VisualClasspathSupport.this).getSize();
                    VisualClassPathItem visualClassPathItem = (VisualClassPathItem)VisualClasspathSupport.this.classpathModel.get(nArray[n]);
                    if (visualClassPathItem.canDelete()) continue;
                    bl = false;
                    break;
                }
            }
            n = nArray != null && nArray.length > 0 && nArray[0] != 0 ? 1 : 0;
            boolean bl4 = nArray != null && nArray.length > 0 && nArray[nArray.length - 1] != VisualClasspathSupport.this.classpathModel.size() - 1;
            VisualClasspathSupport.this.removeButton.setEnabled(bl);
            VisualClasspathSupport.this.upButton.setEnabled(n != 0);
            VisualClasspathSupport.this.downButton.setEnabled(bl4);
        }
    }
}

