/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.glassfish.eecommon.api.ProgressEventSupport;
import org.netbeans.modules.glassfish.eecommon.api.Utils;
import org.netbeans.modules.j2ee.common.DatasourceHelper;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDriverDeployHelper {
    public static ProgressObject getProgressObject(File file, List list) {
        return new JDBCDriversProgressObject(file, list);
    }

    public static List getMissingDrivers(File[] fileArray, Set<Datasource> set) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (Datasource datasource : set) {
            Object object;
            String string = datasource.getDriverClassName();
            boolean bl = false;
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                object = Arrays.asList(file.listFiles(new Utils.JarFileFilter()));
                try {
                    bl = Util.containsClass(object, (String)string);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                if (bl) break;
            }
            if (bl) continue;
            for (File file : DatasourceHelper.findDatabaseConnections((Datasource)datasource)) {
                JDBCDriver[] jDBCDriverArray;
                object = file.getDriverClass();
                for (JDBCDriver jDBCDriver : jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers((String)object)) {
                    URL[] uRLArray = jDBCDriver.getURLs();
                    for (int i = 0; i < uRLArray.length; ++i) {
                        URL uRL = uRLArray[i];
                        String string2 = uRL.toString();
                        if (string2.contains("nbinst:/")) {
                            URL uRL2;
                            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                            if (fileObject == null || (uRL2 = URLMapper.findURL((FileObject)fileObject, (int)1)) == null) continue;
                            arrayList.add(uRL2);
                            continue;
                        }
                        arrayList.add(uRL);
                    }
                }
            }
        }
        return arrayList;
    }

    private static class JDBCDriversProgressObject
    implements ProgressObject,
    Runnable {
        private final ProgressEventSupport eventSupport = new ProgressEventSupport(this);
        private final File driverLoc;
        private List jdbcDriverURLs;

        public JDBCDriversProgressObject(File file, List list) {
            String string = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"MSG_CheckMissingDrivers");
            this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, StateType.RUNNING));
            this.driverLoc = file;
            this.jdbcDriverURLs = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.jdbcDriverURLs.size() > 0) {
                String string;
                boolean bl = true;
                for (int i = 0; i < this.jdbcDriverURLs.size(); ++i) {
                    URL uRL = (URL)this.jdbcDriverURLs.get(i);
                    File file = this.driverLoc;
                    try {
                        File file2 = new File(file, new File(uRL.toURI()).getName());
                        try {
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
                            try {
                                string = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"MSG_DeployDriver", (Object)file2.getPath());
                                this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, StateType.RUNNING));
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                                try {
                                    FileUtil.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
                                }
                                finally {
                                    bufferedOutputStream.close();
                                }
                            }
                            finally {
                                bufferedInputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.FINER, "", iOException);
                            string = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"ERR_DeployDriver", (Object)file2.getPath(), (Object)file.getPath());
                            this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, StateType.FAILED));
                            bl = false;
                        }
                        continue;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINER, "", uRISyntaxException);
                        string = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"ERR_DeployDriver", (Object)uRL, (Object)file.getPath());
                        this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, StateType.FAILED));
                        bl = false;
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINER, "", runtimeException);
                        string = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"ERR_DeployDriver", (Object)uRL, (Object)file.getPath());
                        this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, StateType.FAILED));
                        bl = false;
                    }
                }
                string = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"MSG_DeployDriverComplete");
                if (!bl) {
                    string = NbBundle.getMessage(JDBCDriverDeployHelper.class, (String)"ERR_DeployDriverFailed");
                }
                this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, string, bl ? StateType.COMPLETED : StateType.FAILED));
            } else {
                this.eventSupport.fireHandleProgressEvent(null, ProgressEventSupport.createStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, "", StateType.COMPLETED));
            }
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.eventSupport.getDeploymentStatus();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return new TargetModuleID[0];
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Cancel is not supported");
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Stop is not supported");
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.eventSupport.addProgressListener(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.eventSupport.removeProgressListener(progressListener);
        }
    }
}

