/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wsdlextensions.file.validator;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.wsdlextensions.file.model.FileAddress;
import org.netbeans.modules.wsdlextensions.file.model.FileBinding;
import org.netbeans.modules.wsdlextensions.file.model.FileComponent;
import org.netbeans.modules.wsdlextensions.file.model.FileMessage;
import org.netbeans.modules.wsdlextensions.file.model.FileOperation;
import org.netbeans.modules.wsdlextensions.file.validator.FileNamePatternType;
import org.netbeans.modules.wsdlextensions.file.validator.Utils;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileComponentValidator
implements Validator,
FileComponent.Visitor {
    public static final String NUMBER_MARKER = "%d";
    public static final String TIMESTAMP_MARKER = "%t";
    public static final String GUID_MARKER = "%u";
    public static final String SEQ_REF_EXP = "%\\{([0-9_\\-\\.a-zA-Z]+)\\}";
    public static final String UUID_REGEX = "[0-9[abcdef]]{8}-[0-9[abcdef]]{4}-[0-9[abcdef]]{4}-[0-9[abcdef]]{4}-[0-9[abcdef]]{12}";
    public static final Pattern SEQ_REF_EXP_PATT = Pattern.compile("%\\{([0-9_\\-\\.a-zA-Z]+)\\}");
    public static final String TIMESTAMP_REGEX = "[0-9]{4,4}(0[1-9]|1[0-2])([0-2][0-9]|3[0-1])(\\-(1[0-9]|2[0-3])\\-[0-5][0-9]\\-[0-5][0-9]\\-[0-9]{0,3})?";
    private static final ResourceBundle mMessages = ResourceBundle.getBundle("org.netbeans.modules.wsdlextensions.file.validator.Bundle");
    private Validation mValidation;
    private Validation.ValidationType mValidationType;
    private ValidationResult mValidationResult;
    public static final ValidationResult EMPTY_RESULT = new ValidationResult((Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET);

    public String getName() {
        return this.getClass().getName();
    }

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        this.mValidation = validation;
        this.mValidationType = validationType;
        HashSet<Validator.ResultItem> hashSet = new HashSet<Validator.ResultItem>();
        HashSet<Model> hashSet2 = new HashSet<Model>();
        hashSet2.add(model);
        this.mValidationResult = new ValidationResult(hashSet, hashSet2);
        if (model instanceof WSDLModel) {
            Object object;
            int n;
            Object object22;
            WSDLModel wSDLModel = (WSDLModel)model;
            if (model.getState() == Model.State.NOT_WELL_FORMED) {
                return EMPTY_RESULT;
            }
            Definitions definitions = wSDLModel.getDefinitions();
            for (Object object22 : definitions.getBindings()) {
                int n2;
                if (object22.getType() == null || object22.getType().get() == null || (n2 = object22.getExtensibilityElements(FileBinding.class).size()) == 0) continue;
                if (n2 > 0 && n2 != 1) {
                    hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object22, mMessages.getString("FileBindingValidation.only_one_binding_allowed")));
                }
                Object object3 = object22.getBindingOperations().iterator();
                boolean bl = false;
                n = 0;
                while (object3.hasNext()) {
                    Iterator iterator;
                    Object object4;
                    object = (BindingOperation)object3.next();
                    List list = object.getExtensibilityElements(FileOperation.class);
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        ((FileOperation)iterator2.next()).accept(this);
                    }
                    if (list.size() <= 0) continue;
                    bl = true;
                    BindingInput bindingInput = object.getBindingInput();
                    if (bindingInput != null) {
                        n = 0;
                        object4 = bindingInput.getExtensibilityElements(FileMessage.class).iterator();
                        if (object4 != null) {
                            while (object4.hasNext()) {
                                ++n;
                                iterator = (FileMessage)object4.next();
                                iterator.accept(this);
                                this.additionalFileMessageValidation((BindingOperation)object, (OperationParameter)bindingInput.getInput().get(), (FileMessage)((Object)iterator));
                            }
                            if (n > 1) {
                                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object, this.getMessage("FileInputValidation.only_one_message_allowed", object.getName()) + n));
                            }
                        }
                    }
                    if ((object4 = object.getBindingOutput()) == null) continue;
                    n = 0;
                    iterator = object4.getExtensibilityElements(FileMessage.class).iterator();
                    if (iterator == null) continue;
                    while (iterator.hasNext()) {
                        ++n;
                        FileMessage fileMessage = (FileMessage)iterator.next();
                        fileMessage.accept(this);
                        this.additionalFileMessageValidation((BindingOperation)object, (OperationParameter)object4.getOutput().get(), fileMessage);
                    }
                    if (n <= 1) continue;
                    hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object, this.getMessage("FileOutputValidation.only_one_message_allowed", object.getName()) + n));
                }
                if (n2 > 0 && !bl) {
                    hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object22, this.getMessage("FileOperationValidation.no_operation_defined", object22.getName())));
                }
                if (n2 != 0 || !bl) continue;
                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object22, this.getMessage("FileBindingValidation.no_binding_defined", object22.getName())));
            }
            object22 = definitions.getServices().iterator();
            while (object22.hasNext()) {
                for (Object object3 : ((Service)object22.next()).getPorts()) {
                    Binding binding;
                    if (object3.getBinding() == null || (binding = (Binding)object3.getBinding().get()) == null) continue;
                    n = binding.getExtensibilityElements(FileBinding.class).size();
                    object = object3.getExtensibilityElements(FileAddress.class).iterator();
                    if (n > 0 && !object.hasNext()) {
                        hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object3, this.getMessage("FileAddressValidation.no_file_address", object3.getName())));
                    }
                    if (object3.getExtensibilityElements(FileAddress.class).size() > 1) {
                        hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)object3, this.getMessage("FileAddressValidation.only_one_address_allowed", object3.getName())));
                    }
                    while (object.hasNext()) {
                        ((FileAddress)object.next()).accept(this);
                    }
                }
            }
        }
        this.mValidation = null;
        this.mValidationType = null;
        return this.mValidationResult;
    }

    @Override
    public void visit(FileAddress fileAddress) {
        Collection collection = this.mValidationResult.getValidationResult();
        if (fileAddress.getRelativePath()) {
            if (fileAddress.getPathRelativeTo() == null) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileAddress, this.getMessage("FileAddressValidation.missing_root_path")));
            } else if (!(fileAddress.getPathRelativeTo().equals("User Home") || fileAddress.getPathRelativeTo().equals("Current Working Dir") || fileAddress.getPathRelativeTo().equals("Default System Temp Dir"))) {
                try {
                    if (!Utils.hasMigrationEnvVarRef(fileAddress.getPathRelativeTo())) {
                        collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileAddress, this.getMessage("FileAddressValidation.invalid_root_path", fileAddress.getPathRelativeTo())));
                    }
                }
                catch (Exception exception) {
                    collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileAddress, this.getMessage("FileAddressValidation.Exception_when_searching_varref_in_root_path", new Object[]{fileAddress.getPathRelativeTo(), exception})));
                }
            }
        } else if (fileAddress.getFileDirectory() == null || fileAddress.getFileDirectory().trim().equals("")) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileAddress, this.getMessage("FileAddressValidation.missing_file_directory")));
        }
    }

    @Override
    public void visit(FileBinding fileBinding) {
    }

    @Override
    public void visit(FileOperation fileOperation) {
    }

    @Override
    public void visit(FileMessage fileMessage) {
        Collection collection = this.mValidationResult.getValidationResult();
        if (fileMessage.getFileName() == null || fileMessage.getFileName().trim().equals("")) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.missing_file_name")));
        }
        if (fileMessage.getFileUseType() != null && fileMessage.getFileUseType().equals("encoded") && (fileMessage.getFileEncodingStyle() == null || fileMessage.getFileEncodingStyle().trim().equals(""))) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.no_encoding_style")));
        }
        if (fileMessage.getFileNameIsPattern()) {
            boolean bl = false;
            try {
                bl = Utils.hasMigrationEnvVarRef(fileMessage.getFileName());
            }
            catch (Exception exception) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Exception_searching_varref_in_file_name_pattern", new Object[]{fileMessage.getFileName(), exception})));
            }
            String[] stringArray = new String[3];
            FileNamePatternType fileNamePatternType = this.validatePattern(fileMessage.getFileName(), stringArray, collection, fileMessage);
            if (fileNamePatternType == FileNamePatternType.NAME_INVALID && !bl) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.invalid_file_name_pattern", fileMessage.getFileName())));
            }
        }
        if (fileMessage.getFileType() != null) {
            String string = fileMessage.getFileType();
            boolean bl = false;
            try {
                bl = Utils.hasMigrationEnvVarRef(string);
            }
            catch (Exception exception) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Exception_when_searching_varref_in_file_type", new Object[]{fileMessage.getFileType(), exception})));
            }
            if (!(fileMessage.getFileType().equals("text") || fileMessage.getFileType().equals("binary") || bl)) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.invalid_file_type", fileMessage.getFileType())));
            }
            if (fileMessage.getFileType().equals("binary")) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)fileMessage, this.getMessage("FileMessageValidation.unsupported_file_type", fileMessage.getFileType())));
            }
        }
        if (fileMessage.getMultipleRecordsPerFile() && fileMessage.getRecordDelimiter() == null) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)fileMessage, this.getMessage("FileMessageValidation.no_delimiter_defined")));
        }
        if (fileMessage.getMaxBytesPerRecord() != null && fileMessage.getMaxBytesPerRecord() < 0L) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.invalid_max_bytes", "" + fileMessage.getMaxBytesPerRecord())));
        }
        if (fileMessage.getPollingInterval() != null && fileMessage.getPollingInterval() < 0L) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.invalid_polling_interval", "" + fileMessage.getPollingInterval())));
        }
    }

    private void additionalFileMessageValidation(BindingOperation bindingOperation, OperationParameter operationParameter, FileMessage fileMessage) {
        Collection collection = this.mValidationResult.getValidationResult();
        String string = fileMessage.getPart();
        if (string != null && !this.matchesValidMessagePart((NamedComponentReference<Message>)operationParameter.getMessage(), string)) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.part_name_not_matching", new Object[]{bindingOperation.getName(), operationParameter instanceof Input ? "input" : "output", string, operationParameter.getMessage().getQName()})));
        }
    }

    private String getMessage(String string) {
        return mMessages.getString(string);
    }

    private String getMessage(String string, String string2) {
        return this.getMessage(string, new Object[]{string2});
    }

    private String getMessage(String string, Object[] objectArray) {
        String string2 = mMessages.getString(string);
        if (objectArray != null) {
            return MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    private boolean matchesValidMessagePart(NamedComponentReference<Message> namedComponentReference, String string) {
        boolean bl = false;
        for (Part part : ((Message)namedComponentReference.get()).getParts()) {
            if (!part.getName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private FileNamePatternType validatePattern(String string, String[] stringArray, Collection<Validator.ResultItem> collection, FileMessage fileMessage) {
        Matcher matcher;
        if (string == null || string.trim().length() == 0) {
            collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Invalid_pattern_blank")));
        }
        FileNamePatternType fileNamePatternType = FileNamePatternType.NAME_INVALID;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        String string3 = "";
        String string4 = null;
        n = string.indexOf(NUMBER_MARKER);
        if (n >= 0) {
            n2 = string.lastIndexOf(NUMBER_MARKER);
            if (n < n2) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Invalid_pattern_only_1_seq_allowed", string)));
            }
            ++n3;
            fileNamePatternType = FileNamePatternType.NAME_WITH_SEQ;
            string4 = NUMBER_MARKER;
            string2 = n == 0 ? "" : string.substring(0, n);
            String string5 = string3 = n + 2 >= string.length() ? "" : string.substring(n + 2);
        }
        if ((n = string.indexOf(GUID_MARKER)) >= 0) {
            n2 = string.lastIndexOf(GUID_MARKER);
            if (n < n2) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Invalid_pattern_only_1_uuid_allowed", string)));
            }
            if (n3 > 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Invalid_pattern_only_1_pattern_allowed", string)));
            }
            ++n3;
            fileNamePatternType = FileNamePatternType.NAME_WITH_UUID;
            string4 = GUID_MARKER;
            string2 = n == 0 ? "" : string.substring(0, n);
            String string6 = string3 = n + 2 >= string.length() ? "" : string.substring(n + 2);
        }
        if ((n = string.indexOf(TIMESTAMP_MARKER)) >= 0) {
            n2 = string.lastIndexOf(TIMESTAMP_MARKER);
            if (n < n2) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Invalid_pattern_only_1_timestamp_allowed", string)));
            }
            if (n3 > 0) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Invalid_pattern_only_1_pattern_allowed", string)));
            }
            ++n3;
            fileNamePatternType = FileNamePatternType.NAME_WITH_TIMESTAMP;
            string4 = TIMESTAMP_MARKER;
            string2 = n == 0 ? "" : string.substring(0, n);
            String string7 = string3 = n + 2 >= string.length() ? "" : string.substring(n + 2);
        }
        if ((n = string.indexOf("%{")) >= 0 && (matcher = SEQ_REF_EXP_PATT.matcher(string)).find()) {
            string4 = matcher.group(1);
            String string8 = matcher.group();
            if (n3 > 0 || matcher.find()) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Invalid_pattern_only_1_pattern_allowed", string)));
            }
            n = string.indexOf(string8);
            ++n3;
            fileNamePatternType = FileNamePatternType.NAME_WITH_PERSISTED_SEQ;
            string2 = n == 0 ? "" : string.substring(0, n);
            String string9 = string3 = n + string8.length() >= string.length() ? "" : string.substring(n + string8.length());
        }
        if (n3 == 0) {
            boolean bl = false;
            try {
                bl = Utils.hasMigrationEnvVarRef(string);
            }
            catch (Exception exception) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Exception_when_searching_varref_in_pattern", new Object[]{string, exception})));
            }
            if (!bl) {
                collection.add(new Validator.ResultItem((Validator)this, Validator.ResultType.ERROR, (Component)fileMessage, this.getMessage("FileMessageValidation.Invalid_pattern_no_marker_found", string)));
            }
        }
        stringArray[0] = string2;
        stringArray[1] = string4;
        stringArray[2] = string3;
        return fileNamePatternType;
    }
}

