/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.m2g.SVGImage;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.EncodingInputStream;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewTopComponent;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParsingTask
extends Thread
implements HyperlinkListener {
    private static final String HTML_BEGIN = "<html><body><font face=\"Monospaced\" size=\"4\" color=\"black\">";
    private static final String HTML_END = "</font></body><html>";
    private static final String PARSE_TOKEN = "parse";
    private static final Logger LOG = Logger.getLogger(ParsingTask.class.getName());
    private final SVGDataObject m_dObj;
    private final JPanel m_panel;
    private final JEditorPane m_textPane;
    private final SVGViewTopComponent m_svgView;

    public ParsingTask(SVGDataObject sVGDataObject, SVGViewTopComponent sVGViewTopComponent) throws Exception {
        this.m_dObj = sVGDataObject;
        this.m_svgView = sVGViewTopComponent;
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.setBackground(Color.WHITE);
        StringBuilder stringBuilder = new StringBuilder(HTML_BEGIN);
        stringBuilder.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"MSG_Parsing"));
        stringBuilder.append(HTML_END);
        this.m_textPane = new JEditorPane("text/html", stringBuilder.toString());
        this.m_textPane.setBackground(Color.WHITE);
        this.m_textPane.setEditable(false);
        this.m_textPane.addHyperlinkListener(this);
        this.m_panel.add((Component)new JScrollPane(this.m_textPane), "Center");
        this.setPriority(1);
        this.setDaemon(true);
        if (this.m_svgView.getBasePanel().getComponentCount() == 0) {
            this.initializeReportView();
            this.m_svgView.repaint();
        }
    }

    public JComponent getPanel() {
        return this.m_panel;
    }

    public void cancel() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                SVGFileModel sVGFileModel = this.m_dObj.getModel();
                try {
                    this.m_dObj.getSceneManager().setBusyState(PARSE_TOKEN, true);
                    System.setErr(new PrintStream(new OutputStream(){

                        public void write(int n) throws IOException {
                        }
                    }));
                    if (!Thread.currentThread().isInterrupted()) {
                        final SVGImage sVGImage = sVGFileModel.parseSVGImage();
                        assert (sVGImage != null);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ParsingTask.this.m_svgView.showImage(sVGImage);
                                ParsingTask.this.m_svgView.enableImageContext();
                            }
                        });
                        break block11;
                    }
                    throw new InterruptedException();
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.INFO, null, interruptedException);
                }
                catch (Exception exception) {
                    this.showParsingErrors(sVGFileModel.getModel().getDocument(), exception);
                }
                finally {
                    this.m_dObj.getSceneManager().setBusyState(PARSE_TOKEN, false);
                    System.setErr(System.err);
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, null, exception);
            }
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        int[] nArray;
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && hyperlinkEvent.getDescription() != null && (nArray = ParsingTask.string2position(hyperlinkEvent.getDescription())) != null) {
            SVGFileModel sVGFileModel = this.m_dObj.getModel();
            int n = sVGFileModel.getOffsetByPosition(nArray[0], nArray[1]);
            SVGSourceMultiViewElement.selectPosition(this.m_dObj, n, true);
        }
    }

    private String composeMessageText(List<ErrorDescription> list) {
        StringBuilder stringBuilder = new StringBuilder(HTML_BEGIN);
        stringBuilder.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"ERR_NotSvgTiny"));
        stringBuilder.append("<font size=\"4\" color=\"blue\">");
        int[] nArray = new int[3];
        for (ErrorDescription errorDescription : list) {
            int n = errorDescription.m_severity;
            nArray[n] = nArray[n] + 1;
            stringBuilder.append("<br>");
            if (errorDescription.m_line != -1) {
                stringBuilder.append("<a href=\"");
                stringBuilder.append(ParsingTask.position2string(errorDescription.m_line, errorDescription.m_column));
                stringBuilder.append("\">");
                stringBuilder.append(errorDescription.getSeverity());
                stringBuilder.append(": ");
                stringBuilder.append(errorDescription.m_line);
                stringBuilder.append(",");
                stringBuilder.append(errorDescription.m_column);
                stringBuilder.append(":");
                stringBuilder.append(errorDescription.m_text);
                stringBuilder.append("</a>");
                continue;
            }
            stringBuilder.append("<font color=\"black\">");
            stringBuilder.append(errorDescription.getSeverity());
            stringBuilder.append(": ");
            stringBuilder.append(errorDescription.m_text);
            stringBuilder.append("</font>");
        }
        stringBuilder.append("</font>");
        stringBuilder.append("<br>");
        stringBuilder.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"ERR_ErrorWarnings", (Object)Integer.toString(nArray[0]), (Object)Integer.toString(nArray[1]), (Object)Integer.toString(nArray[2])));
        stringBuilder.append(HTML_END);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showParsingErrors(Document document, Exception exception) {
        final ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        arrayList.add(new ErrorDescription(exception));
        ErrorHandler errorHandler = new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) throws SAXException {
                this.addError(new ErrorDescription(sAXParseException, 2));
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                this.addError(new ErrorDescription(sAXParseException, 0));
            }

            public void error(SAXParseException sAXParseException) throws SAXException {
                this.addError(new ErrorDescription(sAXParseException, 1));
            }

            private void addError(ErrorDescription errorDescription) {
                for (ErrorDescription errorDescription2 : arrayList) {
                    if (!errorDescription2.m_text.equals(errorDescription.m_text)) continue;
                    if (errorDescription2.m_line == -1 && errorDescription.m_line != -1) {
                        errorDescription2.m_line = errorDescription.m_line;
                        errorDescription2.m_column = errorDescription.m_column;
                    }
                    return;
                }
                arrayList.add(errorDescription);
            }
        };
        EncodingInputStream encodingInputStream = new EncodingInputStream((BaseDocument)document, this.m_dObj.getEncodingHelper().getEncoding());
        try {
            InputSource inputSource = new InputSource(encodingInputStream);
            XMLUtil.parse((InputSource)inputSource, (boolean)true, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)EntityCatalog.getDefault());
        }
        catch (SAXException sAXException) {
        }
        catch (ConnectException connectException) {
        }
        catch (Exception exception2) {
            SceneManager.error("Error during document parse", exception2);
        }
        finally {
            try {
                encodingInputStream.close();
            }
            catch (IOException iOException) {
                SceneManager.error("Could not close stream", iOException);
            }
        }
        for (ErrorDescription errorDescription : arrayList) {
            errorDescription.fillNumbers(this.m_dObj.getModel());
        }
        this.updateText(this.composeMessageText(arrayList));
    }

    private void initializeReportView() {
        JPanel jPanel = this.m_svgView.getBasePanel();
        if (jPanel.getComponentCount() > 0) {
            if (jPanel.getComponent(0) == this.m_panel) {
                return;
            }
            jPanel.removeAll();
        }
        jPanel.add((Component)this.m_panel, "Center");
        jPanel.invalidate();
    }

    private void updateText(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ParsingTask.this.initializeReportView();
                ParsingTask.this.m_textPane.setText(string);
                ParsingTask.this.m_textPane.invalidate();
                ParsingTask.this.m_svgView.validate();
                ParsingTask.this.m_svgView.repaint();
            }
        });
    }

    private static String position2string(int n, int n2) {
        return n + "_" + n2;
    }

    private static int[] string2position(String string) {
        int[] nArray = null;
        String[] stringArray = string.split("_");
        if (stringArray.length == 2) {
            try {
                nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])};
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return nArray;
    }

    private static final class ErrorDescription {
        private static final int SEVERITY_FATAL = 0;
        private static final int SEVERITY_ERROR = 1;
        private static final int SEVERITY_WARNING = 2;
        private static final String[] SEVERITIES = new String[]{"Fatal Error", "Error", "Warning"};
        final String m_text;
        final int m_severity;
        int m_line;
        int m_column;

        public ErrorDescription(SAXParseException sAXParseException, int n) {
            assert (sAXParseException != null);
            this.m_text = ErrorDescription.getMessage(sAXParseException);
            this.m_severity = n;
            this.m_line = sAXParseException.getLineNumber();
            this.m_column = sAXParseException.getColumnNumber();
        }

        public ErrorDescription(Exception exception) {
            this.m_text = ErrorDescription.getMessage(exception);
            this.m_severity = 0;
            this.m_column = -1;
            this.m_line = -1;
        }

        public String getSeverity() {
            return SEVERITIES[this.m_severity];
        }

        public void fillNumbers(SVGFileModel sVGFileModel) {
            int[] nArray;
            String string;
            int n;
            int n2;
            if (this.m_line == -1 && (n2 = this.m_text.indexOf(34)) != -1 && this.m_text.indexOf("\" is missing on element") == -1 && (n = this.m_text.lastIndexOf(34)) > n2 && (n = sVGFileModel.firstIndexOf(string = this.m_text.substring(n2, n + 1))) != -1 && (nArray = sVGFileModel.getPositionByOffset(n)) != null) {
                this.m_line = nArray[0];
                this.m_column = nArray[1];
            }
        }

        private static String getMessage(Exception exception) {
            String string = exception.getLocalizedMessage();
            if (string == null) {
                string = exception.getClass().getName();
            }
            return string;
        }
    }
}

