/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewTopComponent;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGLocatableElement;

public final class HighlightAction
extends AbstractComposerAction {
    private final SVGObject m_highlighted;

    public HighlightAction(ComposerActionFactory composerActionFactory, SVGObject sVGObject) {
        super(composerActionFactory);
        assert (sVGObject != null) : "Null object for highlight";
        this.m_highlighted = sVGObject;
        this.getScreenManager().getAnimatorView().setToolTipText(this.getTooltipText());
        this.m_highlighted.repaint(5);
    }

    public boolean consumeEvent(AWTEvent aWTEvent, boolean bl) {
        SceneManager sceneManager = this.m_factory.getSceneManager();
        assert (sceneManager.containsAction(HighlightAction.class));
        if (!bl) {
            if (aWTEvent.getID() == 503) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                SVGObject[] sVGObjectArray = sceneManager.getPerseusController().getObjectsAt(mouseEvent.getX(), mouseEvent.getY());
                if (sVGObjectArray == null || sVGObjectArray.length == 0 || sVGObjectArray[0] != this.m_highlighted) {
                    this.actionCompleted();
                }
            } else if (aWTEvent.getID() == 505) {
                this.actionCompleted();
            }
        }
        return false;
    }

    public void paint(Graphics graphics, int n, int n2, boolean bl) {
        if (!this.m_highlighted.isDeleted()) {
            if (!this.m_isCompleted && this.getScreenManager().getHighlightObject()) {
                this.m_highlighted.getOutline().highlight(graphics, n, n2);
            }
        } else {
            this.actionCompleted();
        }
    }

    public void actionCompleted() {
        super.actionCompleted();
        this.getScreenManager().getAnimatorView().setToolTipText("");
        this.m_highlighted.repaint(5);
    }

    private String getTooltipText() {
        String string = "";
        String string2 = this.m_highlighted.getElementId();
        if (this.getScreenManager().getShowTooltip()) {
            SVGLocatableElement sVGLocatableElement = this.m_highlighted.getSVGElement();
            String string3 = this.getPerseusController().getSVGDocument().toPrefix(sVGLocatableElement.getNamespaceURI(), (Element)sVGLocatableElement);
            if (string3 == null || string3.length() == 0) {
                string3 = sVGLocatableElement.getLocalName();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>&nbsp;");
            stringBuilder.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_Type", (Object)string3));
            stringBuilder.append("<br>&nbsp;");
            String string4 = sVGLocatableElement.getId();
            if (string4 != null) {
                stringBuilder.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_Id", (Object)string4));
                stringBuilder.append("<br>");
            }
            stringBuilder.append(this.getDataObject().getModel().describeElement(string2));
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
        return string;
    }
}

