/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.nbprefuse.render;

import org.netbeans.modules.xml.nbprefuse.render.NbLabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.visual.AggregateItem;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class FindUsagesRendererFactory
implements RendererFactory {
    private NbLabelRenderer nodeRenderer;
    private NbLabelRenderer fileNodeRenderer;
    private NbLabelRenderer queryNodeRenderer;
    private Renderer generalizationRenderer;
    private Renderer compositionRenderer;
    private Renderer referenceRenderer;
    private Renderer fileEdgeRenderer;
    private Renderer aggregateRenderer;

    public FindUsagesRendererFactory(NbLabelRenderer nbLabelRenderer, NbLabelRenderer nbLabelRenderer2, Renderer renderer, Renderer renderer2, Renderer renderer3, Renderer renderer4) {
        this(nbLabelRenderer, nbLabelRenderer2, renderer, renderer2, renderer3, renderer4, null);
    }

    public FindUsagesRendererFactory(NbLabelRenderer nbLabelRenderer, NbLabelRenderer nbLabelRenderer2, Renderer renderer, Renderer renderer2, Renderer renderer3, Renderer renderer4, Renderer renderer5) {
        this.nodeRenderer = nbLabelRenderer;
        nbLabelRenderer.setVerticalPadding(5);
        nbLabelRenderer.setHorizontalPadding(5);
        this.fileNodeRenderer = nbLabelRenderer2;
        this.aggregateRenderer = renderer5;
        nbLabelRenderer2.setRoundedCorner(10, 10);
        nbLabelRenderer2.setVerticalPadding(5);
        nbLabelRenderer2.setHorizontalPadding(5);
        this.queryNodeRenderer = new NbLabelRenderer();
        this.queryNodeRenderer.setRoundedCorner(20, 20);
        this.queryNodeRenderer.setVerticalPadding(10);
        this.queryNodeRenderer.setHorizontalPadding(10);
        this.generalizationRenderer = renderer;
        this.compositionRenderer = renderer2;
        this.referenceRenderer = renderer3;
        this.fileEdgeRenderer = renderer4;
    }

    public Renderer getRenderer(VisualItem visualItem) {
        if (visualItem instanceof AggregateItem) {
            return this.aggregateRenderer;
        }
        if (visualItem instanceof NodeItem) {
            if (visualItem.canGetBoolean("is-file-node") && visualItem.getBoolean("is-file-node")) {
                return this.fileNodeRenderer;
            }
            if (visualItem.canGetBoolean("is-query-node") && visualItem.getBoolean("is-query-node")) {
                return this.queryNodeRenderer;
            }
            return this.nodeRenderer;
        }
        if (visualItem instanceof EdgeItem) {
            String string = visualItem.getString("edge-type");
            if (string != null && string.equals("generalization")) {
                return this.generalizationRenderer;
            }
            if (string != null && string.equals("composition")) {
                return this.compositionRenderer;
            }
            if (string != null && string.equals("reference")) {
                return this.referenceRenderer;
            }
            if (visualItem.getString("edge-type") != null && visualItem.getString("edge-type").equals("file-edge-type")) {
                return this.fileEdgeRenderer;
            }
        }
        return this.fileEdgeRenderer;
    }
}

