/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.nbprefuse.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.Visualization;
import prefuse.action.layout.Layout;
import prefuse.util.GraphicsLib;
import prefuse.visual.AggregateItem;
import prefuse.visual.AggregateTable;
import prefuse.visual.VisualItem;

public class AggregateLayout
extends Layout {
    private int m_margin = 5;
    private double[] m_pts;
    private Visualization m_vis;

    public AggregateLayout(Visualization visualization, String string) {
        super(string);
        this.m_vis = visualization;
    }

    public void run(double d) {
        AggregateTable aggregateTable = (AggregateTable)this.m_vis.getGroup(this.m_group);
        int n = aggregateTable.getTupleCount();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        Iterator iterator = aggregateTable.tuples();
        while (iterator.hasNext()) {
            n2 = Math.max(n2, 8 * ((AggregateItem)iterator.next()).getAggregateSize());
        }
        if (this.m_pts == null || n2 > this.m_pts.length) {
            this.m_pts = new double[n2];
        }
        iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            AggregateItem aggregateItem = (AggregateItem)iterator.next();
            int n3 = 0;
            if (aggregateItem.getAggregateSize() == 0) continue;
            VisualItem visualItem = null;
            Iterator iterator2 = aggregateItem.items();
            while (iterator2.hasNext()) {
                visualItem = (VisualItem)iterator2.next();
                if (!visualItem.isVisible()) continue;
                AggregateLayout.addPoint(this.m_pts, n3, visualItem, this.m_margin);
                n3 += 8;
            }
            if (n3 == 0) continue;
            double[] dArray = GraphicsLib.convexHull((double[])this.m_pts, (int)n3);
            float[] fArray = (float[])aggregateItem.get(VisualItem.POLYGON);
            if (fArray == null || fArray.length < dArray.length) {
                fArray = new float[dArray.length];
            } else if (fArray.length > dArray.length) {
                fArray[dArray.length] = Float.NaN;
            }
            for (int i = 0; i < dArray.length; ++i) {
                fArray[i] = (float)dArray[i];
            }
            aggregateItem.set(VisualItem.POLYGON, (Object)fArray);
            aggregateItem.setValidated(false);
        }
    }

    private static void addPoint(double[] dArray, int n, VisualItem visualItem, int n2) {
        Rectangle2D rectangle2D = visualItem.getBounds();
        double d = rectangle2D.getMinX() - (double)n2;
        double d2 = rectangle2D.getMinY() - (double)n2;
        double d3 = rectangle2D.getMaxX() + (double)n2;
        double d4 = rectangle2D.getMaxY() + (double)n2;
        dArray[n] = d;
        dArray[n + 1] = d2;
        dArray[n + 2] = d;
        dArray[n + 3] = d4;
        dArray[n + 4] = d3;
        dArray[n + 5] = d2;
        dArray[n + 6] = d3;
        dArray[n + 7] = d4;
    }
}

