/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.HprofInstanceValue;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;

class InstanceDump
extends HprofObject
implements Instance {
    final ClassDump dumpClass;

    InstanceDump(ClassDump classDump, long l) {
        super(l);
        this.dumpClass = classDump;
    }

    public List getFieldValues() {
        long l = this.fileOffset + (long)this.getInstanceFieldValuesOffset();
        List list = this.dumpClass.getAllInstanceFields();
        ArrayList<HprofInstanceValue> arrayList = new ArrayList<HprofInstanceValue>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HprofField hprofField = (HprofField)iterator.next();
            if (hprofField.getVauleType() == 2) {
                arrayList.add(new HprofInstanceObjectValue(this, hprofField, l));
            } else {
                arrayList.add(new HprofInstanceValue(this, hprofField, l));
            }
            l += (long)hprofField.getValueSize();
        }
        return arrayList;
    }

    public boolean isGCRoot() {
        return this.dumpClass.getHprof().getGCRoot(this) != null;
    }

    public long getInstanceId() {
        return this.dumpClass.getHprofBuffer().getID(this.fileOffset + 1L);
    }

    public int getInstanceNumber() {
        return this.dumpClass.getHprof().idToOffsetMap.get(this.getInstanceId()).getIndex();
    }

    public JavaClass getJavaClass() {
        return this.dumpClass;
    }

    public Instance getNearestGCRootPointer() {
        return this.dumpClass.getHprof().nearestGCRoot.getNearestGCRootPointer(this);
    }

    public int getReachableSize() {
        return 0;
    }

    public List getReferences() {
        return this.dumpClass.getHprof().findReferencesFor(this.getInstanceId());
    }

    public int getRetainedSize() {
        return 0;
    }

    public int getSize() {
        return this.dumpClass.getInstanceSize();
    }

    public List getStaticFieldValues() {
        return this.dumpClass.getStaticFieldValues();
    }

    public Object getValueOfField(String string) {
        Iterator iterator = this.getFieldValues().iterator();
        FieldValue fieldValue = null;
        while (iterator.hasNext()) {
            FieldValue fieldValue2 = (FieldValue)iterator.next();
            if (!fieldValue2.getField().getName().equals(string)) continue;
            fieldValue = fieldValue2;
        }
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof HprofInstanceObjectValue) {
            return ((HprofInstanceObjectValue)fieldValue).getInstance();
        }
        return ((HprofInstanceValue)fieldValue).getTypeValue();
    }

    private int getInstanceFieldValuesOffset() {
        int n = this.dumpClass.getHprofBuffer().getIDSize();
        return 1 + n + 4 + n + 4;
    }
}

