/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBMetaDataFactory;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class InsertRecordDialog
extends JDialog {
    private final DataView dataView;
    JTextField[] colValueTextField;
    private JButton cancelBtn;
    private JButton clearBtn;
    private JButton executeBtn;
    private JEditorPane jEditorPane1;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextArea jTextArea1;
    private JButton previewBtn;

    public InsertRecordDialog(DataView dataView) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.dataView = dataView;
        this.initComponents();
        this.addInputFields();
        this.colValueTextField[0].requestFocus();
        this.jSplitPane1.setBottomComponent(null);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTextArea1 = new JTextArea();
        this.jPanel4 = new JPanel();
        this.executeBtn = new JButton();
        this.previewBtn = new JButton();
        this.clearBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.title"));
        this.setModal(true);
        this.setResizable(false);
        this.jPanel1.setFont(this.jPanel1.getFont());
        this.jPanel1.setPreferredSize(new Dimension(550, 450));
        this.jPanel1.setRequestFocusEnabled(false);
        this.jPanel1.setLayout(new BorderLayout());
        this.jTextArea1.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setFont(this.jTextArea1.getFont());
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(3);
        this.jTextArea1.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setAutoscrolls(false);
        this.jTextArea1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel1.add((Component)this.jTextArea1, "North");
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"insertRecodrDialog.jTextArea"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"insertRecord.textarea.desc"));
        this.jPanel4.setFont(this.jPanel4.getFont());
        this.jPanel4.setPreferredSize(new Dimension(520, 33));
        this.jPanel4.setLayout(new FlowLayout(2));
        this.executeBtn.setFont(this.executeBtn.getFont());
        this.executeBtn.setMnemonic('O');
        this.executeBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.executeBtn.text"));
        this.executeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.executeBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.executeBtn);
        this.executeBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.executeBtn.text"));
        this.executeBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.executeBtn.text"));
        this.previewBtn.setFont(this.previewBtn.getFont());
        this.previewBtn.setMnemonic('S');
        this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.previewBtn.text"));
        this.previewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.previewBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.previewBtn);
        this.previewBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.previewBtn.text"));
        this.previewBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.previewBtn.text"));
        this.clearBtn.setFont(this.clearBtn.getFont());
        this.clearBtn.setMnemonic('L');
        this.clearBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.clearBtn.text"));
        this.clearBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.clearBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.clearBtn);
        this.clearBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.clearBtn.text"));
        this.clearBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.clearBtn.text"));
        this.cancelBtn.setFont(this.cancelBtn.getFont());
        this.cancelBtn.setMnemonic('C');
        this.cancelBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.cancelBtn.text"));
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InsertRecordDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel4.add(this.cancelBtn);
        this.cancelBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.cancelBtn.text"));
        this.cancelBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.cancelBtn.text"));
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setLastDividerLocation(250);
        this.jSplitPane1.setRequestFocusEnabled(false);
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 255)));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setFont(this.jScrollPane1.getFont());
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setForeground(new Color(204, 204, 255));
        this.jPanel3.setFont(this.jPanel3.getFont().deriveFont((float)this.jPanel3.getFont().getSize() + 1.0f));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanel3);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.jScrollPane2.setFont(this.jScrollPane2.getFont());
        this.jEditorPane1.setContentType(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.jEditorPane1.contentType"));
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-sql"));
        this.jEditorPane1.setFont(this.jEditorPane1.getFont());
        this.jEditorPane1.setToolTipText(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.jEditorPane1.toolTipText"));
        this.jEditorPane1.setOpaque(false);
        this.jScrollPane2.setViewportView(this.jEditorPane1);
        this.jEditorPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecord.JEditorpane.AccessibleName"));
        this.jEditorPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.jEditorPane1.AccessibleContext.accessibleDescription"));
        this.jSplitPane1.setBottomComponent(this.jScrollPane2);
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleParent(null);
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void executeBtnActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = null;
        try {
            Object[] objectArray = this.getInsertValues();
            SQLStatementGenerator sQLStatementGenerator = this.dataView.getSQLStatementGenerator();
            stringArray = sQLStatementGenerator.generateInsertStatement(objectArray);
            SQLExecutionHelper sQLExecutionHelper = this.dataView.getSQLExecutionHelper();
            sQLExecutionHelper.executeInsertRow(stringArray, objectArray);
        }
        catch (DBException dBException) {
            if (this.jSplitPane1.getBottomComponent() == null) {
                this.jSplitPane1.setDividerLocation(250);
                this.jSplitPane1.setBottomComponent(this.jScrollPane2);
                this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_hide_sql"));
            }
            this.jEditorPane1.setForeground(Color.red);
            this.jEditorPane1.setContentType("text/plain");
            this.jEditorPane1.setText(dBException.getMessage());
            return;
        }
        this.dispose();
    }

    private void clearBtnActionPerformed(ActionEvent actionEvent) {
        int n = this.dataView.getDataViewDBTable().getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (this.dataView.getDataViewDBTable().getColumn(i).isGenerated()) {
                this.colValueTextField[i].setText("<GENERATED>");
                this.colValueTextField[i].setEditable(false);
                continue;
            }
            this.colValueTextField[i].setText("");
            this.colValueTextField[i].setEditable(true);
        }
        this.refreshSQL();
    }

    private void previewBtnActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_show_sql"))) {
            this.jSplitPane1.setDividerLocation(250);
            this.jSplitPane1.setBottomComponent(this.jScrollPane2);
            this.refreshSQL();
            this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_hide_sql"));
        } else {
            this.jSplitPane1.setBottomComponent(null);
            this.previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class, (String)"LBL_show_sql"));
        }
    }

    private void refreshSQL() {
        try {
            if (this.jSplitPane1.getBottomComponent() != null) {
                SQLStatementGenerator sQLStatementGenerator = this.dataView.getSQLStatementGenerator();
                String string = sQLStatementGenerator.generateInsertStatement(this.getInsertValues())[1];
                this.jEditorPane1.setContentType("text/x-sql");
                this.jEditorPane1.setText(string);
            }
        }
        catch (DBException dBException) {
            this.jEditorPane1.setContentType("text/plain");
            this.jEditorPane1.setForeground(Color.red);
            this.jEditorPane1.setText(dBException.getMessage());
            return;
        }
    }

    private void addInputFields() {
        Connection connection = DBConnectionFactory.getInstance().getConnection(this.dataView.getDatabaseConnection());
        Map<Object, Object> map = Collections.emptyMap();
        try {
            if (connection != null) {
                DBMetaDataFactory dBMetaDataFactory = new DBMetaDataFactory(connection);
                map = dBMetaDataFactory.buildDBSpecificDatatypeMap();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        int n = this.dataView.getDataViewDBTable().getColumnCount();
        JLabel[] jLabelArray = new JLabel[n];
        JLabel[] jLabelArray2 = new JLabel[n];
        this.colValueTextField = new JTextField[n];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 0;
        int n3 = 0;
        int n4 = 5;
        int n5 = 10;
        for (int i = 0; i < n; ++i) {
            DBColumn dBColumn = this.dataView.getDataViewDBTable().getColumn(i);
            jLabelArray[i] = new JLabel();
            jLabelArray[i].setText(dBColumn.getName());
            jLabelArray[i].setHorizontalAlignment(4);
            jLabelArray[i].setPreferredSize(new Dimension(120, 20));
            jLabelArray[i].setFont(jLabelArray[i].getFont());
            jLabelArray[i].getAccessibleContext().setAccessibleName(jLabelArray[i].getName());
            jLabelArray[i].getAccessibleContext().setAccessibleDescription(jLabelArray[i].getName());
            gridBagConstraints.gridx = n2;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.insets = new Insets(0, 0, n4, n5);
            this.jPanel3.add((Component)jLabelArray[i], gridBagConstraints);
            this.colValueTextField[i] = new JTextField();
            this.addColValueChangeListeners(i, dBColumn);
            this.colValueTextField[i].setText("");
            this.colValueTextField[i].setToolTipText(DataViewUtils.getColumnToolTip(dBColumn));
            this.colValueTextField[i].setHorizontalAlignment(2);
            this.colValueTextField[i].setMinimumSize(new Dimension(250, 20));
            this.colValueTextField[i].setPreferredSize(new Dimension(250, 20));
            this.colValueTextField[i].getAccessibleContext().setAccessibleName(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecordDialog.AccessibleContext.accessibleName"));
            this.colValueTextField[i].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InsertRecordDialog.class, (String)"InsertRecord.JTextField.AccessibleDescription"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n2 + 2;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.insets = new Insets(0, 0, n4, n5);
            this.jPanel3.add((Component)this.colValueTextField[i], gridBagConstraints);
            if (dBColumn.isGenerated()) {
                this.colValueTextField[i].setText("<GENERATED>");
                this.colValueTextField[i].setEditable(false);
            }
            jLabelArray2[i] = new JLabel();
            jLabelArray2[i].setPreferredSize(new Dimension(90, 20));
            jLabelArray2[i].setHorizontalAlignment(2);
            jLabelArray2[i].setFont(jLabelArray2[i].getFont());
            jLabelArray2[i].getAccessibleContext().setAccessibleName(jLabelArray2[i].getName());
            jLabelArray2[i].getAccessibleContext().setAccessibleDescription(jLabelArray2[i].getName());
            Integer n6 = new Integer(dBColumn.getJdbcType());
            String string = map.containsKey(n6) ? (String)map.get(n6) : DataViewUtils.getStdSqlType(dBColumn.getJdbcType());
            jLabelArray2[i].setText(string);
            jLabelArray2[i].setDisplayedMnemonicIndex(-1);
            jLabelArray[i].setLabelFor(this.colValueTextField[i]);
            jLabelArray2[i].setLabelFor(this.colValueTextField[i]);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n2 + 4;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.insets = new Insets(0, 0, n4, n5);
            this.jPanel3.add((Component)jLabelArray2[i], gridBagConstraints);
            n3 += 2;
        }
    }

    private void addColValueChangeListeners(int n, final DBColumn dBColumn) {
        final int n2 = n;
        this.colValueTextField[n].addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '0') {
                    if (dBColumn.isGenerated() || !dBColumn.isNullable()) {
                        Toolkit.getDefaultToolkit().beep();
                    } else if (InsertRecordDialog.this.colValueTextField[n2].isEditable()) {
                        InsertRecordDialog.this.colValueTextField[n2].setText("<NULL>");
                        InsertRecordDialog.this.colValueTextField[n2].setEditable(false);
                    } else if (!InsertRecordDialog.this.colValueTextField[n2].isEditable()) {
                        InsertRecordDialog.this.colValueTextField[n2].setText("");
                        InsertRecordDialog.this.colValueTextField[n2].setEditable(true);
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                InsertRecordDialog.this.refreshSQL();
            }
        });
        this.colValueTextField[n].addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    if (dBColumn.isGenerated() || !dBColumn.isNullable()) {
                        Toolkit.getDefaultToolkit().beep();
                    } else if (!InsertRecordDialog.this.colValueTextField[n2].isEditable()) {
                        InsertRecordDialog.this.colValueTextField[n2].setText("");
                        InsertRecordDialog.this.colValueTextField[n2].setEditable(true);
                        InsertRecordDialog.this.colValueTextField[n2].requestFocus();
                    }
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
    }

    private Object[] getInsertValues() throws DBException {
        Object[] objectArray = new Object[this.colValueTextField.length];
        for (int i = 0; i < this.colValueTextField.length; ++i) {
            JTextField jTextField = this.colValueTextField[i];
            DBColumn dBColumn = this.dataView.getDataViewDBTable().getColumn(i);
            Object object = (dBColumn.isNullable() || dBColumn.isGenerated()) && !jTextField.isEditable() ? null : DBReadWriteHelper.validate(jTextField.getText(), dBColumn);
            objectArray[i] = object;
        }
        return objectArray;
    }
}

