/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsfloader;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.visualweb.api.insync.InSyncService;
import org.netbeans.modules.visualweb.palette.api.CodeClipDragAndDropHandler;
import org.netbeans.modules.visualweb.palette.api.CodeClipPaletteActions;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJavaEditorSupport;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataObject;
import org.netbeans.modules.visualweb.project.jsfloader.Utils;
import org.netbeans.modules.web.core.jsploader.api.TagLibParseCookie;
import org.netbeans.spi.palette.DragAndDropHandler;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public final class JsfJspEditorSupport
extends DataEditorSupport
implements EditorCookie.Observable,
PrintCookie {
    private String encoding = null;
    private static final String defaultEncoding = "UTF-8";
    private static final int AUTO_PARSING_DELAY = 2000;
    private Timer timer;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            JsfJspEditorSupport.this.saveDocument();
            JsfJspEditorSupport.this.getDataObject().setModified(false);
        }
    };

    JsfJspEditorSupport(JsfJspDataObject jsfJspDataObject) {
        super((DataObject)jsfJspDataObject, (CloneableEditorSupport.Env)new Environment(jsfJspDataObject));
        this.setMIMEType("text/x-jsp");
        this.initialize();
    }

    private void initialize() {
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final TagLibParseCookie tagLibParseCookie = (TagLibParseCookie)JsfJspEditorSupport.this.getDataObject().getCookie(TagLibParseCookie.class);
                if (tagLibParseCookie != null) {
                    tagLibParseCookie.autoParse().addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            if (tagLibParseCookie.isDocumentDirty()) {
                                JsfJspEditorSupport.this.restartTimer(false);
                            }
                        }
                    });
                }
            }
        });
        this.timer.setInitialDelay(2000);
        this.timer.setRepeats(false);
        final DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            private void change(DocumentEvent documentEvent) {
                JsfJspEditorSupport.this.restartTimer(false);
                TagLibParseCookie tagLibParseCookie = (TagLibParseCookie)JsfJspEditorSupport.this.getDataObject().getCookie(TagLibParseCookie.class);
                if (tagLibParseCookie != null) {
                    tagLibParseCookie.setDocumentDirty(true);
                }
            }
        };
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (JsfJspEditorSupport.this.isDocumentLoaded() && JsfJspEditorSupport.this.getDocument() != null) {
                    JsfJspEditorSupport.this.getDocument().addDocumentListener(documentListener);
                }
            }
        });
    }

    private void restartTimer(boolean bl) {
        if (bl && !this.timer.isRunning()) {
            return;
        }
        int n = 2000;
        if (n > 0) {
            this.timer.setInitialDelay(n);
            this.timer.restart();
        }
    }

    public void openDesigner() {
        JsfJavaEditorSupport jsfJavaEditorSupport = this.getJsfJavaEditorSupport(false);
        if (jsfJavaEditorSupport == null) {
            return;
        }
        jsfJavaEditorSupport.openDesigner();
    }

    protected boolean canClose() {
        return super.canClose();
    }

    protected void notifyClosed() {
        super.notifyClosed();
        JsfJspDataObject jsfJspDataObject = (JsfJspDataObject)this.getDataObject();
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        this.updateMultiViewDisplayName();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
        this.updateMultiViewDisplayName();
    }

    private void addSaveCookie() {
        JsfJspDataObject jsfJspDataObject = (JsfJspDataObject)this.getDataObject();
        if (jsfJspDataObject.getPureCookie(SaveCookie.class) == null) {
            jsfJspDataObject.getCookieSet0().add((Node.Cookie)this.saveCookie);
            jsfJspDataObject.setModified(true);
        }
    }

    private void removeSaveCookie() {
        JsfJspDataObject jsfJspDataObject = (JsfJspDataObject)this.getDataObject();
        SaveCookie saveCookie = jsfJspDataObject.getPureCookie(SaveCookie.class);
        if (saveCookie != null && saveCookie.equals(this.saveCookie)) {
            jsfJspDataObject.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            jsfJspDataObject.setModified(false);
        }
    }

    public void saveDocument() throws IOException {
        this.saveDocument(true);
    }

    private void saveDocument(boolean bl) throws IOException {
        if (bl || this.isModified()) {
            ((JsfJspDataObject)this.getDataObject()).updateFileEncoding(true);
            this.encoding = ((JsfJspDataObject)this.getDataObject()).getFileEncoding();
            if (!JsfJspEditorSupport.isSupportedEncoding(this.encoding)) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JsfJspEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding, defaultEncoding}), 0, 2);
                confirmation.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    return;
                }
            } else {
                try {
                    CharsetEncoder charsetEncoder = Charset.forName(this.encoding).newEncoder();
                    StyledDocument styledDocument = this.getDocument();
                    if (charsetEncoder != null && styledDocument != null && !charsetEncoder.canEncode(styledDocument.getText(0, styledDocument.getLength()))) {
                        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JsfJspEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding}), 0, 2);
                        confirmation.setValue(NotifyDescriptor.NO_OPTION);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                        if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                            return;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                }
            }
            super.saveDocument();
        }
    }

    public void open() {
        ((JsfJspDataObject)this.getDataObject()).updateFileEncoding(false);
        this.encoding = ((JsfJspDataObject)this.getDataObject()).getFileEncoding();
        if (!JsfJspEditorSupport.isSupportedEncoding(this.encoding)) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JsfJspEditorSupport.class, (String)"MSG_BadEncodingDuringLoad", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding, defaultEncoding}), 0, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
        }
        super.open();
    }

    protected void editJsp() {
        JsfJavaEditorSupport jsfJavaEditorSupport;
        ((JsfJspDataObject)this.getDataObject()).updateFileEncoding(false);
        this.encoding = ((JsfJspDataObject)this.getDataObject()).getFileEncoding();
        if (!JsfJspEditorSupport.isSupportedEncoding(this.encoding)) {
            jsfJavaEditorSupport = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JsfJspEditorSupport.class, (String)"MSG_BadEncodingDuringLoad", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), this.encoding, defaultEncoding}), 0, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)jsfJavaEditorSupport);
            if (jsfJavaEditorSupport.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
        }
        if ((jsfJavaEditorSupport = this.getJsfJavaEditorSupport(false)) == null) {
            return;
        }
        jsfJavaEditorSupport.openJsp();
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        ((JsfJspDataObject)this.getDataObject()).updateFileEncoding(false);
        super.loadFromStreamToKit(styledDocument, inputStream, editorKit);
    }

    private static boolean isSupportedEncoding(String string) {
        if (string == null) {
            return false;
        }
        try {
            return Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }

    protected CloneableEditor createCloneableEditor() {
        return new JspEditorTopComponent((JsfJspDataObject)this.getDataObject());
    }

    private final Object getLock() {
        return this.allEditors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiViewElement createMultiViewElement() {
        Object object = this.getLock();
        synchronized (object) {
            CloneableTopComponent cloneableTopComponent = this.createCloneableTopComponent();
            cloneableTopComponent.setReference(this.allEditors);
            return (MultiViewElement)cloneableTopComponent;
        }
    }

    protected String messageName() {
        DataObject dataObject = this.getDataObject();
        if (!dataObject.isValid()) {
            return "";
        }
        String string = dataObject.getPrimaryFile().getName();
        return this.addFlagsToName(string, dataObject);
    }

    private String addFlagsToName(String string, DataObject dataObject) {
        JsfJavaEditorSupport jsfJavaEditorSupport = this.getJsfJavaEditorSupport(dataObject.getPrimaryFile(), true);
        int n = 3;
        if (this.isModified() || jsfJavaEditorSupport != null && jsfJavaEditorSupport.isModified()) {
            n = !dataObject.getPrimaryFile().canWrite() ? 2 : 1;
        } else if (!dataObject.getPrimaryFile().canWrite()) {
            n = 0;
        }
        return NbBundle.getMessage(DataObject.class, (String)"LAB_EditorName", (Object)new Integer(n), (Object)string);
    }

    protected String messageToolTip() {
        return super.messageToolTip();
    }

    DataEditorSupport.Env env() {
        return (DataEditorSupport.Env)this.env;
    }

    protected JsfJavaEditorSupport getJsfJavaEditorSupport(boolean bl) {
        return this.getJsfJavaEditorSupport(this.getDataObject().getPrimaryFile(), bl);
    }

    protected JsfJavaEditorSupport getJsfJavaEditorSupport(FileObject fileObject, boolean bl) {
        JsfJavaEditorSupport jsfJavaEditorSupport = Utils.findCorrespondingJsfJavaEditorSupport(fileObject, bl);
        return jsfJavaEditorSupport;
    }

    public void updateMultiViewDisplayName() {
        JsfJavaEditorSupport jsfJavaEditorSupport;
        CloneableTopComponent cloneableTopComponent = this.allEditors.getArbitraryComponent();
        if (cloneableTopComponent != null) {
            cloneableTopComponent.toString();
        }
        if ((jsfJavaEditorSupport = this.getJsfJavaEditorSupport(true)) == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jsfJavaEditorSupport.updateMultiViewDisplayName();
            }
        });
    }

    private static class JspEditorTopComponent
    extends CloneableEditor
    implements MultiViewElement {
        private static final long serialVersionUID = -3126744316624172415L;
        private transient MultiViewElementCallback multiViewElementCallback;
        private transient JComponent toolbar;
        private JsfJspDataObject jsfJspDataObject;
        private PaletteController jspPaletteController;
        private WeakReference<Lookup> lookupWRef = new WeakReference<Object>(null);

        public JspEditorTopComponent() {
        }

        public JspEditorTopComponent(JsfJspDataObject jsfJspDataObject) {
            super((CloneableEditorSupport)jsfJspDataObject.getCookie(JsfJspEditorSupport.class));
            this.jsfJspDataObject = jsfJspDataObject;
            this.initialize();
        }

        public void open(Workspace workspace) {
            if (this.discard()) {
                JsfJspEditorSupport jsfJspEditorSupport = this.jsfJspDataObject.getCookie(JsfJspEditorSupport.class);
                ErrorManager.getDefault().log(16, "Can not open " + (Object)((Object)this) + " component," + " its support environment is not valid" + " [support=" + (Object)((Object)jsfJspEditorSupport) + ", env=" + (jsfJspEditorSupport == null ? null : jsfJspEditorSupport.env()) + "]");
            } else {
                JsfJavaEditorSupport jsfJavaEditorSupport = Utils.findCorrespondingJsfJavaEditorSupport(this.jsfJspDataObject.getPrimaryFile(), false);
                if (jsfJavaEditorSupport == null) {
                    ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Can't find JsfJavaEditorSupport for " + (Object)((Object)this.jsfJspDataObject)));
                } else {
                    jsfJavaEditorSupport.doOpenDesigner();
                }
            }
        }

        private boolean discard() {
            JsfJspEditorSupport jsfJspEditorSupport = this.jsfJspDataObject.getCookie(JsfJspEditorSupport.class);
            return jsfJspEditorSupport == null || !jsfJspEditorSupport.env().isValid();
        }

        private void initialize() {
            if (this.jsfJspDataObject != null) {
                this.setActivatedNodes(new Node[]{this.jsfJspDataObject.getNodeDelegate()});
            }
            this.initializePalette();
        }

        private void initializePalette() {
            PaletteController paletteController;
            String string = "CreatorJspPalette";
            try {
                paletteController = PaletteFactory.createPalette((String)string, (PaletteActions)new CodeClipPaletteActions(string, (CloneableEditor)this), null, (DragAndDropHandler)new CodeClipDragAndDropHandler());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                paletteController = null;
            }
            this.jspPaletteController = paletteController;
        }

        public CloseOperationState canCloseElement() {
            if (!JspEditorTopComponent.isLastView(this.multiViewElementCallback.getTopComponent())) {
                return CloseOperationState.STATE_OK;
            }
            return MultiViewFactory.createUnsafeCloseState((String)"ID_CLOSING_JSP", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
        }

        public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
            JsfJavaEditorSupport jsfJavaEditorSupport;
            this.multiViewElementCallback = multiViewElementCallback;
            JsfJspEditorSupport jsfJspEditorSupport = this.jsfJspDataObject.getCookie(JsfJspEditorSupport.class);
            if (jsfJspEditorSupport != null && (jsfJavaEditorSupport = jsfJspEditorSupport.getJsfJavaEditorSupport(false)) != null) {
                jsfJavaEditorSupport.updateMultiViewDisplayName();
                jsfJavaEditorSupport.updateMultiViewToolTip();
            }
        }

        public JComponent getToolbarRepresentation() {
            if (this.toolbar == null) {
                Document document;
                JEditorPane jEditorPane = this.getEditorPane();
                if (jEditorPane != null && (document = jEditorPane.getDocument()) instanceof NbDocument.CustomToolbar) {
                    this.toolbar = ((NbDocument.CustomToolbar)document).createToolbar(jEditorPane);
                }
                if (this.toolbar == null) {
                    this.toolbar = new JPanel();
                }
            }
            return this.toolbar;
        }

        public JComponent getVisualRepresentation() {
            return this;
        }

        public void componentDeactivated() {
            super.componentDeactivated();
        }

        public void componentActivated() {
            super.componentActivated();
            if (this.pane != null) {
                this.pane.requestFocusInWindow();
            }
            InSyncService.getProvider().jspDataObjectTopComponentActivated((DataObject)this.jsfJspDataObject);
        }

        public void componentHidden() {
            super.componentHidden();
            InSyncService.getProvider().jspDataObjectTopComponentHidden((DataObject)this.jsfJspDataObject);
        }

        public void componentShowing() {
            super.componentShowing();
            InSyncService.getProvider().jspDataObjectTopComponentShown((DataObject)this.jsfJspDataObject);
        }

        public void componentClosed() {
            super.componentClosed();
        }

        public void componentOpened() {
            super.componentOpened();
        }

        public void requestVisible() {
            if (this.multiViewElementCallback != null) {
                this.multiViewElementCallback.requestVisible();
            } else {
                super.requestVisible();
            }
        }

        public void requestActive() {
            if (this.multiViewElementCallback != null) {
                this.multiViewElementCallback.requestActive();
            } else {
                super.requestActive();
            }
        }

        public Action[] getActions() {
            return this.multiViewElementCallback != null ? this.multiViewElementCallback.createDefaultActions() : super.getActions();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeObject((Object)this.jsfJspDataObject);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.jsfJspDataObject = (JsfJspDataObject)((Object)objectInput.readObject());
            this.initialize();
        }

        private static boolean isLastView(TopComponent topComponent) {
            if (!(topComponent instanceof CloneableTopComponent)) {
                return false;
            }
            boolean bl = true;
            Enumeration enumeration = ((CloneableTopComponent)topComponent).getReference().getComponents();
            if (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                if (enumeration.hasMoreElements()) {
                    bl = false;
                }
            }
            return bl;
        }

        public Lookup getLookup() {
            Lookup lookup = (Lookup)this.lookupWRef.get();
            if (lookup == null) {
                Lookup lookup2 = super.getLookup();
                lookup = this.jspPaletteController == null ? new ProxyLookup(new Lookup[]{lookup2}) : new ProxyLookup(new Lookup[]{lookup2, Lookups.singleton((Object)this.jspPaletteController)});
                this.lookupWRef = new WeakReference<Lookup>(lookup);
            }
            return lookup;
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(JsfJspDataObject jsfJspDataObject) {
            super((DataObject)jsfJspDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JsfJspDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (JsfJspEditorSupport)this.getDataObject().getCookie(JsfJspEditorSupport.class);
        }
    }
}

