/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.gsf.api.CodeCompletionContext;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CodeCompletionResult;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;

public class RhtmlCompleter
extends RubyCodeCompleter {
    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        CompilationInfo compilationInfo = codeCompletionContext.getInfo();
        int n = codeCompletionContext.getCaretOffset();
        Document document = compilationInfo.getDocument();
        if (document != null && RhtmlCompleter.isWithinRuby(document, n)) {
            return super.complete(codeCompletionContext);
        }
        return CodeCompletionResult.NONE;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        int n;
        Document document = jTextComponent.getDocument();
        if (RhtmlCompleter.isWithinRuby(document, n = jTextComponent.getCaret().getDot())) {
            return super.getAutoQuery(jTextComponent, string);
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    static boolean isWithinRuby(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == RhtmlTokenId.RUBY || tokenId == RhtmlTokenId.RUBY_EXPR) {
                return true;
            }
            if (tokenId == RhtmlTokenId.DELIMITER) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == RhtmlTokenId.RUBY || tokenSequence.token().id() == RhtmlTokenId.RUBY_EXPR) {
                    return true;
                }
            }
        }
        return false;
    }
}

