/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.navigation;

import java.awt.Image;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.GsfHtmlFormatter;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsfret.navigation.ClassMemberFilters;
import org.netbeans.modules.gsfret.navigation.ClassMemberPanelUI;
import org.netbeans.modules.gsfret.navigation.ElementScanningTask;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.modules.gsfret.navigation.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

public class ElementNode
extends AbstractNode {
    private static Node WAIT_NODE;
    private OpenAction openAction;
    private StructureItem description;
    private ClassMemberPanelUI ui;
    private FileObject fileObject;
    private static NavigatorFormatter FORMATTER;

    public ElementNode(StructureItem structureItem, ClassMemberPanelUI classMemberPanelUI, FileObject fileObject) {
        super((Children)(structureItem.isLeaf() ? Children.LEAF : new ElementChildren(structureItem.getNestedItems(), classMemberPanelUI.getFilters(), classMemberPanelUI, fileObject)));
        this.description = structureItem;
        this.setDisplayName(structureItem.getName());
        this.ui = classMemberPanelUI;
        this.fileObject = fileObject;
    }

    public Image getIcon(int n) {
        if (this.description.getCustomIcon() != null) {
            return ImageUtilities.icon2Image((Icon)this.description.getCustomIcon());
        }
        ImageIcon imageIcon = Icons.getElementIcon(this.description.getKind(), this.description.getModifiers());
        if (imageIcon != null) {
            return ImageUtilities.icon2Image((Icon)imageIcon);
        }
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getDisplayName() {
        return this.description.getName();
    }

    public String getHtmlDisplayName() {
        FORMATTER.reset();
        return this.description.getHtml((HtmlFormatter)FORMATTER);
    }

    public Action[] getActions(boolean bl) {
        if (bl || this.description.getName() == null) {
            return this.ui.getActions();
        }
        Action[] actionArray = this.ui.getActions();
        Action[] actionArray2 = new Action[2 + actionArray.length];
        actionArray2[0] = this.getOpenAction();
        actionArray2[1] = null;
        for (int i = 0; i < actionArray.length; ++i) {
            actionArray2[2 + i] = actionArray[i];
        }
        return actionArray2;
    }

    public Action getPreferredAction() {
        return this.getOpenAction();
    }

    private synchronized Action getOpenAction() {
        if (this.openAction == null) {
            FileObject fileObject = this.ui.getFileObject();
            this.openAction = new OpenAction(this.description.getElementHandle(), fileObject, this.description.getPosition());
        }
        return this.openAction;
    }

    static synchronized Node getWaitNode() {
        if (WAIT_NODE == null) {
            WAIT_NODE = new WaitNode();
        }
        return WAIT_NODE;
    }

    public void refreshRecursively() {
        Children children = this.getChildren();
        if (children instanceof ElementChildren) {
            ((ElementChildren)children).resetKeys(this.description.getNestedItems(), this.ui.getFilters());
            for (Node node : children.getNodes()) {
                this.ui.expandNode(node);
                ((ElementNode)node).refreshRecursively();
            }
        }
    }

    public ElementNode getMimeRootNodeForOffset(CompilationInfo compilationInfo, int n) {
        Children children;
        if (this.getDescription().getPosition() > (long)n) {
            return null;
        }
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return null;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
        if (list.size() > 0 && (children = this.getChildren()) instanceof ElementChildren) {
            Node[] nodeArray = children.getNodes();
            for (Language language : list) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    ElementNode elementNode = (ElementNode)nodeArray[i];
                    if (!(elementNode.getDescription() instanceof ElementScanningTask.MimetypeRootNode)) continue;
                    ElementScanningTask.MimetypeRootNode mimetypeRootNode = (ElementScanningTask.MimetypeRootNode)elementNode.getDescription();
                    if (mimetypeRootNode.language != language) continue;
                    return elementNode.getNodeForOffset(n);
                }
            }
        }
        return this.getNodeForOffset(n);
    }

    public ElementNode getNodeForOffset(int n) {
        if (this.getDescription().getPosition() > (long)n) {
            return null;
        }
        Children children = this.getChildren();
        if (children instanceof ElementChildren) {
            Node[] nodeArray = children.getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                long l;
                ElementNode elementNode = (ElementNode)nodeArray[i];
                long l2 = elementNode.getDescription().getPosition();
                if (l2 > (long)n || (l = elementNode.getDescription().getEndPosition()) < (long)n) continue;
                return elementNode.getNodeForOffset(n);
            }
        }
        return this;
    }

    public void updateRecursively(StructureItem structureItem) {
        Object object;
        Object object2;
        Object object3;
        Children children = this.getChildren();
        if (children instanceof ElementChildren) {
            object3 = new HashSet(this.description.getNestedItems());
            object2 = children.getNodes(true);
            object = new HashMap();
            for (Object object4 : object2) {
                ((HashMap)object).put(((ElementNode)((Object)object4)).description, (ElementNode)((Object)object4));
            }
            ((ElementChildren)children).resetKeys(structureItem.getNestedItems(), this.ui.getFilters());
            object2 = children.getNodes(true);
            for (StructureItem structureItem2 : structureItem.getNestedItems()) {
                ElementNode elementNode = (ElementNode)((Object)((HashMap)object).get(structureItem2));
                if (elementNode == null) continue;
                if (!((HashSet)object3).contains(structureItem2) && elementNode.getChildren() != Children.LEAF) {
                    this.ui.expandNode((Node)elementNode);
                }
                elementNode.updateRecursively(structureItem2);
            }
        }
        object3 = this.description;
        this.description = structureItem;
        FORMATTER.reset();
        object2 = object3.getHtml((HtmlFormatter)FORMATTER);
        FORMATTER.reset();
        object = this.description.getHtml((HtmlFormatter)FORMATTER);
        if (object2 != null && !((String)object2).equals(object)) {
            this.fireDisplayNameChange((String)object2, (String)object);
        }
        if (object3.getModifiers() != null && !((Object)object3.getModifiers()).equals(structureItem.getModifiers())) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
    }

    public StructureItem getDescription() {
        return this.description;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    static {
        FORMATTER = new NavigatorFormatter();
    }

    private static class NavigatorFormatter
    extends GsfHtmlFormatter {
        private NavigatorFormatter() {
        }

        public void name(ElementKind elementKind, boolean bl) {
        }
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/gsfret/navigation/resources/wait.gif");

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int n) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getDisplayName() {
            return "Please Wait...";
        }
    }

    static class Description {
        public static final Comparator<StructureItem> ALPHA_COMPARATOR = new DescriptionComparator(true);
        public static final Comparator<StructureItem> POSITION_COMPARATOR = new DescriptionComparator(false);
        ClassMemberPanelUI ui;
        String name;
        ElementHandle elementHandle;
        ElementKind kind;
        Set<Modifier> modifiers;
        List<Description> subs;
        String htmlHeader;
        long pos;

        Description(ClassMemberPanelUI classMemberPanelUI) {
            this.ui = classMemberPanelUI;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Description)) {
                return false;
            }
            Description description = (Description)object;
            if (this.kind != description.kind) {
                return false;
            }
            return this.name.equals(description.name);
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.name != null ? this.name.hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            return n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DescriptionComparator
        implements Comparator<StructureItem> {
            boolean alpha;

            DescriptionComparator(boolean bl) {
                this.alpha = bl;
            }

            @Override
            public int compare(StructureItem structureItem, StructureItem structureItem2) {
                if (this.alpha) {
                    if (this.k2i(structureItem.getKind()) != this.k2i(structureItem2.getKind())) {
                        return this.k2i(structureItem.getKind()) - this.k2i(structureItem2.getKind());
                    }
                    return structureItem.getSortText().compareTo(structureItem2.getSortText());
                }
                return structureItem.getPosition() == structureItem2.getPosition() ? 0 : (structureItem.getPosition() < structureItem2.getPosition() ? -1 : 1);
            }

            int k2i(ElementKind elementKind) {
                switch (elementKind) {
                    case CONSTRUCTOR: {
                        return 1;
                    }
                    case METHOD: 
                    case DB: {
                        return 2;
                    }
                    case FIELD: {
                        return 3;
                    }
                }
                return 100;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementChildren
    extends Children.Keys<StructureItem> {
        private ClassMemberPanelUI ui;
        private FileObject fileObject;

        public ElementChildren(List<StructureItem> list, ClassMemberFilters classMemberFilters, ClassMemberPanelUI classMemberPanelUI, FileObject fileObject) {
            this.resetKeys(list, classMemberFilters);
            this.ui = classMemberPanelUI;
            this.fileObject = fileObject;
        }

        protected Node[] createNodes(StructureItem structureItem) {
            return new Node[]{new ElementNode(structureItem, this.ui, this.fileObject)};
        }

        void resetKeys(List<StructureItem> list, ClassMemberFilters classMemberFilters) {
            this.setKeys(classMemberFilters.filter(list));
        }
    }
}

