/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.EmbeddingModel;
import org.netbeans.modules.gsf.api.GsfLanguage;
import org.netbeans.modules.gsf.api.IncrementalEmbeddingModel;
import org.netbeans.modules.gsf.api.IncrementalParser;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.PathResourceImplementation;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageRegistry
implements Iterable<Language> {
    private static LanguageRegistry instance;
    private static final String STRUCTURE = "structure.instance";
    private static final String LANGUAGE = "language.instance";
    private static final String ICON_BASE = "iconBase";
    private static final String PARSER = "parser.instance";
    private static final String COMPLETION = "completion.instance";
    private static final String RENAMER = "renamer.instance";
    private static final String FORMATTER = "formatter.instance";
    private static final String BRACKET_COMPLETION = "bracket.instance";
    private static final String DECLARATION_FINDER = "declarationfinder.instance";
    private static final String INDEXER = "indexer.instance";
    private static final String HINTS = "hints.instance";
    private static final String SEMANTIC = "semantic.instance";
    private static final String OCCURRENCES = "occurrences.instance";
    private static final String INDEX_SEARCHER = "index_searcher.instance";
    private static final String FOLDER = "GsfPlugins";
    private List<Language> languages;
    private Map<String, Language> mimeToLanguage;
    private Collection<? extends EmbeddingModel> embeddingModels;
    private Map<String, List<Language>> applicableLanguages = new HashMap<String, List<Language>>();
    private Map<String, Boolean> possiblyIncremental = new HashMap<String, Boolean>();
    private Map<String, Map<String, Boolean>> relevantMimes = new HashMap<String, Map<String, Boolean>>();
    private ClassPath libraryPath;
    private List<URL> urls;

    public LanguageRegistry() {
        this.initialize();
    }

    public void addLanguages(List<Language> list) {
        if (this.languages != null && this.languages.size() > 0) {
            throw new RuntimeException("This is for testing purposes only!!!");
        }
        this.languages = list;
        this.mimeToLanguage = new HashMap<String, Language>(2 * this.languages.size());
        for (Language language : this.languages) {
            String string = language.getMimeType();
            assert (string.equals(string.toLowerCase())) : string;
            this.mimeToLanguage.put(string, language);
        }
    }

    public static synchronized LanguageRegistry getInstance() {
        if (instance == null) {
            instance = new LanguageRegistry();
        }
        return instance;
    }

    public Language getLanguageByMimeType(@NonNull String string) {
        if (this.mimeToLanguage == null) {
            return null;
        }
        return this.mimeToLanguage.get(string);
    }

    @CheckForNull
    public EmbeddingModel getEmbedding(@NonNull String string, @NonNull String string2) {
        Collection<? extends EmbeddingModel> collection = this.getEmbeddingModels();
        for (EmbeddingModel embeddingModel : collection) {
            if (!embeddingModel.getTargetMimeType().equals(string) || !embeddingModel.getSourceMimeTypes().contains(string2)) continue;
            return embeddingModel;
        }
        return null;
    }

    private Collection<? extends EmbeddingModel> getEmbeddingModels() {
        if (this.embeddingModels == null) {
            this.embeddingModels = Lookup.getDefault().lookupAll(EmbeddingModel.class);
        }
        return this.embeddingModels;
    }

    public boolean isRelevantFor(FileObject fileObject, String string) {
        Boolean bl;
        String string2 = fileObject.getMIMEType();
        if (string.equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.relevantMimes.get(string);
        if (map == null) {
            map = new HashMap<String, Boolean>();
            this.relevantMimes.put(string, map);
        }
        if ((bl = map.get(string2)) == null) {
            bl = Boolean.FALSE;
            Collection<? extends EmbeddingModel> collection = this.getEmbeddingModels();
            for (EmbeddingModel embeddingModel : collection) {
                if (!embeddingModel.getTargetMimeType().equals(string) || !embeddingModel.getSourceMimeTypes().contains(string2)) continue;
                bl = Boolean.TRUE;
                break;
            }
            map.put(string2, bl);
        }
        return bl;
    }

    @NonNull
    public List<Language> getApplicableLanguages(String string) {
        List<Language> list = this.applicableLanguages.get(string);
        if (list == null) {
            list = new ArrayList<Language>(5);
            Collection<? extends EmbeddingModel> collection = this.getEmbeddingModels();
            Language language = this.getLanguageByMimeType(string);
            if (language != null) {
                list.add(language);
            }
            for (EmbeddingModel embeddingModel : collection) {
                Language language2;
                if (!embeddingModel.getSourceMimeTypes().contains(string) || (language2 = this.getLanguageByMimeType(embeddingModel.getTargetMimeType())) == null || list.contains(language2)) continue;
                list.add(language2);
            }
            this.applicableLanguages.put(string, list);
        }
        return list;
    }

    public boolean isIncremental(String string) {
        Boolean bl = this.possiblyIncremental.get(string);
        if (bl == null) {
            List<Language> list = this.getApplicableLanguages(string);
            boolean bl2 = false;
            for (Language language : list) {
                EmbeddingModel embeddingModel;
                Parser parser = language.getParser();
                if (parser instanceof IncrementalParser) {
                    bl2 = true;
                }
                if (language.getMimeType().equals(string) || !((embeddingModel = this.getEmbedding(language.getMimeType(), string)) instanceof IncrementalEmbeddingModel)) continue;
                bl2 = true;
                break;
            }
            bl = bl2 ? Boolean.TRUE : Boolean.FALSE;
            this.possiblyIncremental.put(string, bl);
        }
        return bl == Boolean.TRUE;
    }

    public List<URL> getLibraryUrls() {
        if (this.urls == null) {
            this.urls = new ArrayList<URL>();
            for (Language language : this) {
                GsfLanguage gsfLanguage = language.getGsfLanguage();
                if (gsfLanguage == null) continue;
                for (FileObject fileObject : gsfLanguage.getCoreLibraries()) {
                    try {
                        if (fileObject == null) continue;
                        URL uRL = FileUtil.toFile((FileObject)fileObject).toURI().toURL();
                        this.urls.add(uRL);
                        ClassIndexManager.get(language).addBootRoot(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            }
        }
        return this.urls;
    }

    public List<FileObject> getLibraryFos() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (Language language : this) {
            GsfLanguage gsfLanguage = language.getGsfLanguage();
            if (gsfLanguage == null) continue;
            for (FileObject fileObject : gsfLanguage.getCoreLibraries()) {
                arrayList.add(fileObject);
            }
        }
        return arrayList;
    }

    public ClassPath getLibraryPaths() {
        if (this.libraryPath == null) {
            List<URL> list = this.getLibraryUrls();
            final URL[] uRLArray = list.toArray(new URL[list.size()]);
            this.libraryPath = ClassPathFactory.createClassPath((ClassPathImplementation)new ClassPathImplementation(){

                public List<? extends PathResourceImplementation> getResources() {
                    return Collections.singletonList(new PathResourceImplementation(){

                        public URL[] getRoots() {
                            return uRLArray;
                        }

                        public ClassPathImplementation getContent() {
                            return null;
                        }

                        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                        }

                        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                        }
                    });
                }

                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }
            });
        }
        return this.libraryPath;
    }

    private void addLanguages(List<Language> list, TokenSequence tokenSequence, int n) {
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            String string;
            Language language;
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 != null) {
                this.addLanguages(list, tokenSequence2, n);
            }
            if ((language = this.getLanguageByMimeType(string = tokenSequence.language().mimeType())) != null) {
                list.add(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Language> getEmbeddedLanguages(BaseDocument baseDocument, int n) {
        Language language;
        Object object;
        ArrayList<Language> arrayList = new ArrayList<Language>();
        baseDocument.readLock();
        try {
            object = TokenHierarchy.get((Document)baseDocument).tokenSequence();
            if (object != null) {
                this.addLanguages((List<Language>)arrayList, (TokenSequence)object, n);
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        object = (String)baseDocument.getProperty((Object)"mimeType");
        if (object != null && (language = this.getLanguageByMimeType((String)object)) != null && (arrayList.size() == 0 || arrayList.get(arrayList.size() - 1) != language)) {
            arrayList.add(language);
        }
        return arrayList;
    }

    public boolean isSupported(@NonNull String string) {
        if (string == null) {
            return false;
        }
        return this.getLanguageByMimeType(string) != null;
    }

    public String getLanguagesDisplayName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Language language : this) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(language.getDisplayName());
        }
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Language> iterator() {
        if (this.languages == null) {
            return new Iterator<Language>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Language next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.languages.iterator();
    }

    private synchronized void initialize() {
        if (this.languages == null) {
            this.userdirCleanup();
            this.readSfs();
            if (this.languages != null) {
                this.mimeToLanguage = new HashMap<String, Language>(2 * this.languages.size());
                for (Language language : this.languages) {
                    String string = language.getMimeType();
                    assert (string.equals(string.toLowerCase())) : string;
                    this.mimeToLanguage.put(string, language);
                }
            }
        }
    }

    private void readSfs() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(FOLDER);
        if (fileObject == null) {
            return;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        this.languages = new ArrayList<Language>();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            FileObject[] fileObjectArray2 = fileObject2.getChildren();
            for (int j = 0; j < fileObjectArray2.length; ++j) {
                String string;
                FileObject fileObject3;
                FileObject fileObject4 = fileObjectArray2[j];
                String string2 = fileObject2.getName() + "/" + fileObject4.getName();
                Integer n = (Integer)fileObject4.getAttribute("genver");
                if (n == null) {
                    Logger.getLogger("global").log(Level.SEVERE, "Language " + string2 + " has not been preprocessed during jar module creation");
                }
                Language language = new Language(string2);
                this.languages.add(language);
                Boolean bl = (Boolean)fileObject4.getAttribute("useCustomEditorKit");
                if (bl != null && bl.booleanValue()) {
                    language.setUseCustomEditorKit(true);
                }
                if ((fileObject3 = fileSystem.findResource("Loaders/" + string2)) != null && (string = (String)fileObject3.getAttribute(ICON_BASE)) != null && string.length() > 0) {
                    language.setIconBase(string);
                }
                boolean bl2 = false;
                for (FileObject fileObject5 : fileObject4.getChildren()) {
                    String string3 = fileObject5.getNameExt();
                    if (LANGUAGE.equals(string3)) {
                        bl2 = true;
                        language.setGsfLanguageFile(fileObject5);
                        continue;
                    }
                    if (HINTS.equals(string3)) {
                        language.setHintsProviderFile(fileObject5);
                        continue;
                    }
                    if (STRUCTURE.equals(string3)) {
                        language.setStructureFile(fileObject5);
                        continue;
                    }
                    if (PARSER.equals(string3)) {
                        language.setParserFile(fileObject5);
                        continue;
                    }
                    if (COMPLETION.equals(string3)) {
                        language.setCompletionProviderFile(fileObject5);
                        continue;
                    }
                    if (RENAMER.equals(string3)) {
                        language.setInstantRenamerFile(fileObject5);
                        continue;
                    }
                    if (FORMATTER.equals(string3)) {
                        language.setFormatterFile(fileObject5);
                        continue;
                    }
                    if (DECLARATION_FINDER.equals(string3)) {
                        language.setDeclarationFinderFile(fileObject5);
                        continue;
                    }
                    if (BRACKET_COMPLETION.equals(string3)) {
                        language.setBracketCompletionFile(fileObject5);
                        continue;
                    }
                    if (INDEXER.equals(string3)) {
                        language.setIndexerFile(fileObject5);
                        continue;
                    }
                    if (SEMANTIC.equals(string3)) {
                        language.setSemanticAnalyzer(fileObject5);
                        continue;
                    }
                    if (OCCURRENCES.equals(string3)) {
                        language.setOccurrencesFinderFile(fileObject5);
                        continue;
                    }
                    if (!INDEX_SEARCHER.equals(string3)) continue;
                    language.setIndexSearcher(fileObject5);
                }
                if (bl2) continue;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "No GSF language registered for mime type " + string2);
            }
        }
    }

    private void userdirCleanup() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!bl) {
            return;
        }
        String string = System.getProperty("netbeans.user");
        if (string == null) {
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)new File(string, "config"));
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject("Navigator/Panels/text/javascript/org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance");
        if (fileObject2 == null) {
            return;
        }
        try {
            Object object;
            FileObject fileObject3;
            FileObject fileObject4 = fileObject.getFileObject("Navigator");
            if (fileObject4 != null && (fileObject3 = fileObject4.getFileObject("Panels")) != null) {
                for (FileObject fileObject5 : fileObject3.getChildren()) {
                    for (FileObject fileObject6 : fileObject5.getChildren()) {
                        object = fileObject6.getFileObject("org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance");
                        if (object != null) {
                            object.delete();
                            if (fileObject6.getChildren().length == 0) {
                                fileObject6.delete();
                            }
                        }
                        if (fileObject5.getChildren().length != 0) continue;
                        fileObject5.delete();
                    }
                }
                if (fileObject3.getChildren().length == 0) {
                    fileObject3.delete();
                    if (fileObject4.getChildren().length == 0) {
                        fileObject4.delete();
                    }
                }
            }
            if ((fileObject3 = fileObject.getFileObject("Editors")) != null) {
                for (FileObject fileObject5 : fileObject3.getChildren()) {
                    for (FileObject fileObject6 : fileObject5.getChildren()) {
                        FileObject fileObject7;
                        String string2;
                        FileObject fileObject8;
                        Object object2;
                        FileObject fileObject9;
                        FileObject fileObject10;
                        FileObject fileObject11;
                        FileObject fileObject12;
                        object = fileObject5.getName() + "/" + fileObject6.getName();
                        FileObject fileObject13 = fileObject6;
                        FileObject fileObject14 = fileObject13.getFileObject("Settings.settings");
                        if (fileObject14 != null) {
                            fileObject14.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("SideBar/org-netbeans-modules-editor-gsfret-GsfCodeFoldingSideBarFactory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("SideBar")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("FoldManager/org-netbeans-modules-gsfret-editor-fold-GsfFoldManagerFactory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("FoldManager")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((((String)object).equals("text/x-yaml") || ((String)object).equals("text/x-json")) && (fileObject11 = fileObject13.getFileObject("Popup/generate-fold-popup")) != null) {
                            fileObject11.delete();
                            fileObject11 = fileObject13.getFileObject("ToolTips/org-netbeans-modules-languages-features-ToolTipAnnotation.instance");
                            if (fileObject11 != null) {
                                fileObject11.delete();
                            }
                            if ((fileObject11 = fileObject13.getFileObject("Popup/org-netbeans-modules-languages-features-GoToDeclarationAction.instance")) != null) {
                                fileObject11.delete();
                            }
                            if ((fileObject11 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance")) != null) {
                                fileObject11.delete();
                            }
                            if ((fileObject11 = fileObject13.getFileObject("run_script.instance")) != null) {
                                fileObject11.delete();
                            }
                        }
                        if ((fileObject11 = fileObject13.getFileObject("SideBar/org-netbeans-modules-editor-retouche-GsfCodeFoldingSideBarFactory.instance")) != null) {
                            fileObject11.delete();
                            fileObject11 = fileObject13.getFileObject("FoldManager/org-netbeans-modules-retouche-editor-fold-GsfFoldManagerFactory.instance");
                            if (fileObject11 != null) {
                                fileObject11.delete();
                            }
                        }
                        if ((fileObject10 = fileObject13.getFileObject("HyperlinkProviders/GsfHyperlinkProvider.instance")) != null) {
                            fileObject10.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("HyperlinkProviders")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((fileObject9 = fileObject13.getFileObject("Popup")) != null) {
                            object2 = fileObject9.getFileObject("in-place-refactoring");
                            if (object2 != null) {
                                object2.delete();
                            }
                            if ((fileObject8 = fileObject9.getFileObject("goto")) != null) {
                                fileObject12 = fileObject8.getFileObject("goto-declaration");
                                if (fileObject12 != null) {
                                    fileObject12.delete();
                                }
                                if ((fileObject12 = fileObject8.getFileObject("goto")) != null) {
                                    fileObject12.delete();
                                }
                                if (fileObject8.getChildren().length == 0) {
                                    fileObject8.delete();
                                }
                            }
                            if ((fileObject12 = fileObject9.getFileObject("SeparatorBeforeCut.instance")) != null) {
                                fileObject12.delete();
                            }
                            if ((fileObject12 = fileObject9.getFileObject("format")) != null) {
                                fileObject12.delete();
                            }
                            if ((fileObject12 = fileObject9.getFileObject("SeparatorAfterFormat.instance")) != null) {
                                fileObject12.delete();
                            }
                            if ((fileObject12 = fileObject9.getFileObject("pretty-print")) != null) {
                                fileObject12.delete();
                            }
                            if ((fileObject12 = fileObject9.getFileObject("generate-goto-popup")) != null) {
                                fileObject12.delete();
                            }
                            if (fileObject9.getChildren().length == 0) {
                                fileObject9.delete();
                            }
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-hints-GsfUpToDateStateProviderFactory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-hints-GsfUpToDateStateProviderFactory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-editor-semantic-OccurrencesMarkProviderCreator.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-editor-semantic-OccurrencesMarkProviderCreator.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("org-netbeans-modules-gsfret-editor-semantic-HighlightsLayerFactoryImpl.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject8 = fileObject13.getFileObject((String)(object2 = "CompletionProviders"))) != null) {
                            FileObject fileObject15;
                            string2 = "org-netbeans-lib-editor-codetemplates-CodeTemplateCompletionProvider.instance";
                            fileObject7 = fileObject13.getFileObject((String)object2 + "/" + string2);
                            if (fileObject7 != null) {
                                fileObject7.delete();
                            }
                            String string3 = "org-netbeans-modules-gsfret-editor-completion-GsfCompletionProvider.instance";
                            FileObject fileObject16 = fileObject13.getFileObject((String)object2 + "/" + string3);
                            if (fileObject16 != null) {
                                fileObject16.delete();
                            }
                            if ((fileObject15 = fileObject8.getFileObject("org-netbeans-modules-retouche-editor-completion-GsfCompletionProvider.instance")) != null) {
                                fileObject15.delete();
                            }
                            if (fileObject8.getChildren().length == 0) {
                                fileObject8.delete();
                            }
                        }
                        if ((fileObject12 = fileObject13.getFileObject("Toolbars/Default/comment")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("Toolbars/Default/uncomment")) != null) {
                            fileObject12.delete();
                        }
                        if ((string2 = fileObject13.getFileObject("Toolbars/Default/Separator-before-comment.instance")) != null) {
                            string2.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("Toolbars/Default")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                            fileObject12 = fileObject13.getFileObject("Toolbars");
                            if (fileObject12 != null && fileObject12.getChildren().length == 0) {
                                fileObject12.delete();
                            }
                        }
                        if ((fileObject12 = fileObject13.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject7 = fileObject13.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance")) != null) {
                            fileObject7.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("CodeTemplateProcessorFactories")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject7 = fileObject13.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance")) != null) {
                            fileObject7.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("CodeTemplateFilterFactories")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if (fileObject6.getChildren().length != 0) continue;
                        fileObject6.delete();
                    }
                    if (fileObject5.getChildren().length != 0) continue;
                    fileObject5.delete();
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

