/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.refactoring.php.findusages.RefactoringUtils;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class FindUsages {
    private static final Logger LOG = Logger.getLogger(FindUsages.class.getName());

    private FindUsages() {
    }

    public static boolean canFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (editorCookie == null || editorCookie.getOpenedPanes() == null) {
            return false;
        }
        Collection collection = lookup.lookupAll(Node.class);
        if (collection.size() != 1) {
            return false;
        }
        Node node = (Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        return RefactoringUtils.isRefactorable(fileObject) ? !RefactoringUtils.isOutsidePhp(lookup, fileObject) : false;
    }

    public static void doFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (RefactoringUtils.isFromEditor(editorCookie)) {
            FindUsagesTask.start(editorCookie);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindUsagesTask
    implements CancellableTask<CompilationController> {
        private JTextComponent textC;
        private int caret;
        private RefactoringUI ui;

        private FindUsagesTask(EditorCookie editorCookie) {
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            assert (this.caret != -1);
        }

        public static void start(EditorCookie editorCookie) {
            Source source;
            FindUsagesTask findUsagesTask = new FindUsagesTask(editorCookie);
            try {
                source = RefactoringUtils.getSource(findUsagesTask.textC.getDocument());
                source.runUserActionTask((CancellableTask)findUsagesTask, false);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
            source = TopComponent.getRegistry().getActivated();
            if (findUsagesTask.ui != null) {
                UI.openRefactoringUI((RefactoringUI)findUsagesTask.ui, (TopComponent)source);
            }
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(Phase.RESOLVED);
            Program program = RefactoringUtils.getRoot((org.netbeans.modules.gsf.api.CompilationInfo)compilationController);
            if (program == null) {
                LOG.log(Level.FINE, "FAILURE - can't refactor uncompileable sources");
                return;
            }
            WhereUsedSupport whereUsedSupport = WhereUsedSupport.getInstance((org.netbeans.modules.gsf.api.CompilationInfo)compilationController, this.caret);
            if (whereUsedSupport != null && whereUsedSupport.getName() != null) {
                this.ui = new WhereUsedQueryUI(whereUsedSupport, (CompilationInfo)compilationController);
            }
        }
    }
}

