/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Dispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InstanceOfExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.refactoring.php.findusages.RefactoringUtils;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedElement;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedNodes
extends DefaultVisitor {
    private static final List<String> SUPERGLOBALS = Arrays.asList("GLOBALS", "_SERVER", "_GET", "_POST", "_FILES", "_COOKIE", "_SESSION", "_REQUEST", "_ENV");
    public DefinitionScope global;
    private Stack<DefinitionScope> scopes = new Stack();
    private Map<ASTNode, AttributedElement> node2Element = new HashMap<ASTNode, AttributedElement>();
    private int offset;
    private CompilationInfo info;
    private Stack<ASTNode> nodes = new Stack();
    private Collection<IndexedElement> name2ElementCache;
    private static Map<CompilationInfo, AttributedNodes> info2Attr = new WeakHashMap<CompilationInfo, AttributedNodes>();

    public AttributedNodes(CompilationInfo compilationInfo) {
        this(compilationInfo, -1);
    }

    public AttributedNodes(CompilationInfo compilationInfo, int n) {
        this.offset = n;
        this.info = compilationInfo;
        this.global = new DefinitionScope();
        this.scopes.push(this.global);
    }

    public static AttributedNodes getInstance(CompilationInfo compilationInfo) {
        AttributedNodes attributedNodes = info2Attr.get(compilationInfo);
        if (attributedNodes == null) {
            long l = System.currentTimeMillis();
            attributedNodes = new AttributedNodes(compilationInfo);
            attributedNodes.scan((ASTNode)RefactoringUtils.getRoot(compilationInfo));
            attributedNodes.info = null;
            info2Attr.put(compilationInfo, attributedNodes);
            long l2 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "SemiAttribute global instance", new Object[]{compilationInfo.getFileObject(), attributedNodes});
            Logger.getLogger("TIMER").log(Level.FINE, "SemiAttribute global time", new Object[]{compilationInfo.getFileObject(), l2 - l});
        }
        return attributedNodes;
    }

    public static AttributedNodes getInstance(CompilationInfo compilationInfo, int n) {
        AttributedNodes attributedNodes = new AttributedNodes(compilationInfo, n);
        try {
            attributedNodes.scan((ASTNode)RefactoringUtils.getRoot(compilationInfo));
        }
        catch (Stop stop) {
            // empty catch block
        }
        return attributedNodes;
    }

    public Map<ASTNode, AttributedElement> findDirectSubclasses(AttributedElement attributedElement) {
        HashMap<ASTNode, AttributedElement> hashMap = new HashMap<ASTNode, AttributedElement>();
        for (Map.Entry<ASTNode, AttributedElement> entry : this.node2Element.entrySet()) {
            AttributedElement attributedElement2 = entry.getValue();
            ASTNode aSTNode = entry.getKey();
            if (!WhereUsedSupport.matchDirectSubclass(attributedElement, aSTNode, attributedElement2) || WhereUsedSupport.isAlreadyInResults(aSTNode, hashMap.keySet())) continue;
            hashMap.put(aSTNode, attributedElement2);
        }
        return hashMap;
    }

    public Map<ASTNode, AttributedElement> findUsages(AttributedElement attributedElement) {
        HashMap<ASTNode, AttributedElement> hashMap = new HashMap<ASTNode, AttributedElement>();
        for (Map.Entry<ASTNode, AttributedElement> entry : this.node2Element.entrySet()) {
            AttributedElement attributedElement2 = entry.getValue();
            ASTNode aSTNode = entry.getKey();
            if (!WhereUsedSupport.match(attributedElement, attributedElement2) || WhereUsedSupport.isAlreadyInResults(aSTNode, hashMap.keySet())) continue;
            hashMap.put(aSTNode, attributedElement2);
        }
        return hashMap;
    }

    public void scan(ASTNode aSTNode) {
        if (aSTNode == null) {
            return;
        }
        if (this.offset != -1 && this.offset <= aSTNode.getStartOffset()) {
            throw new Stop();
        }
        this.nodes.push(aSTNode);
        super.scan(aSTNode);
        this.nodes.pop();
        if (this.offset != -1 && this.offset <= aSTNode.getEndOffset()) {
            throw new Stop();
        }
    }

    public void visit(Program program) {
        this.performEnterPass(this.global, program.getStatements());
        super.visit(program);
    }

    public void visit(Assignment assignment) {
        VariableBase variableBase = assignment.getLeftHandSide();
        if (variableBase instanceof Variable) {
            Variable variable;
            String string;
            Object object;
            ClassType classType = null;
            Expression expression = assignment.getRightHandSide();
            if (expression instanceof Reference) {
                expression = ((Reference)expression).getExpression();
            }
            if (expression instanceof ClassInstanceCreation) {
                Identifier identifier;
                ClassElement classElement;
                object = (ClassInstanceCreation)expression;
                Expression expression2 = object.getClassName().getName();
                if (expression2 instanceof Identifier && (classElement = (ClassElement)this.lookup((identifier = (Identifier)expression2).getName(), AttributedElement.Kind.CLASS)) != null) {
                    classType = new ClassType(classElement);
                }
            } else if (expression instanceof FieldAccess && (string = AttributedNodes.extractVariableName(variable = (object = (FieldAccess)expression).getField())) != null) {
                this.node2Element.put((ASTNode)variableBase, this.scopes.peek().enterWrite(string, AttributedElement.Kind.VARIABLE, (ASTNode)object, classType));
            }
            object = AttributedNodes.extractVariableName((Variable)variableBase);
            if (object != null) {
                this.node2Element.put((ASTNode)variableBase, this.scopes.peek().enterWrite((String)object, AttributedElement.Kind.VARIABLE, (ASTNode)variableBase, classType));
            }
        }
        super.visit(assignment);
    }

    public void visit(FunctionDeclaration functionDeclaration) {
        String string = functionDeclaration.getFunctionName().getName();
        FunctionElement functionElement = (FunctionElement)this.global.enterWrite(string, AttributedElement.Kind.FUNC, (ASTNode)functionDeclaration);
        DefinitionScope definitionScope = this.scopes.peek();
        if (!this.node2Element.containsKey(functionDeclaration)) {
            assert (!definitionScope.classScope);
            this.node2Element.put((ASTNode)functionDeclaration, functionElement);
        }
        this.scopes.push(functionElement.enclosedElements);
        if (definitionScope.classScope) {
            assert (definitionScope.thisVar != null);
            this.scopes.peek().enter(definitionScope.thisVar.name, definitionScope.thisVar.getKind(), definitionScope.thisVar);
        }
        super.visit(functionDeclaration);
        this.scopes.pop();
    }

    public void visit(InstanceOfExpression instanceOfExpression) {
        Collection<AttributedElement> collection;
        String string;
        Expression expression;
        ClassName className = instanceOfExpression.getClassName();
        if (className != null) {
            expression = className.getName();
            String string2 = string = expression instanceof Identifier ? ((Identifier)expression).getName() : null;
            if (string != null) {
                collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, string);
                if (!collection.isEmpty()) {
                    this.node2Element.put((ASTNode)expression, this.lookup(string, AttributedElement.Kind.CLASS));
                } else {
                    this.node2Element.put((ASTNode)expression, this.lookup(string, AttributedElement.Kind.IFACE));
                }
            }
        }
        if ((expression = instanceOfExpression.getExpression()) instanceof Variable) {
            string = (Variable)expression;
            collection = AttributedNodes.extractVariableName((Variable)string);
            if (string != null && collection != null) {
                this.node2Element.put((ASTNode)string, this.scopes.peek().enterWrite((String)((Object)collection), AttributedElement.Kind.VARIABLE, (ASTNode)string));
            }
        }
        super.visit(instanceOfExpression);
    }

    public void visit(CatchClause catchClause) {
        Collection<AttributedElement> collection;
        String string;
        Identifier identifier = catchClause.getClassName();
        AttributedElement attributedElement = null;
        if (identifier != null) {
            string = identifier.getName();
            collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, string);
            if (!collection.isEmpty()) {
                attributedElement = this.lookup(string, AttributedElement.Kind.CLASS);
                this.node2Element.put((ASTNode)identifier, attributedElement);
            } else {
                attributedElement = this.lookup(string, AttributedElement.Kind.IFACE);
                this.node2Element.put((ASTNode)identifier, attributedElement);
            }
        }
        string = catchClause.getVariable();
        collection = AttributedNodes.extractVariableName((Variable)string);
        if (string != null && collection != null) {
            this.node2Element.put((ASTNode)string, this.scopes.peek().enterWrite((String)((Object)collection), AttributedElement.Kind.VARIABLE, (ASTNode)string));
        }
        super.visit(catchClause);
    }

    public void visit(FormalParameter formalParameter) {
        Object object;
        Object object2;
        Variable variable = null;
        if (formalParameter.getParameterName() instanceof Reference) {
            object2 = (Reference)formalParameter.getParameterName();
            object = object2.getExpression();
            if (object instanceof Variable) {
                variable = (Variable)object;
            }
        } else if (formalParameter.getParameterName() instanceof Variable) {
            variable = (Variable)formalParameter.getParameterName();
        }
        if (variable != null && (object2 = AttributedNodes.extractVariableName(variable)) != null) {
            this.scopes.peek().enterWrite((String)object2, AttributedElement.Kind.VARIABLE, (ASTNode)variable);
        }
        if ((object2 = formalParameter.getParameterType()) != null && (object = object2.getName()) != null) {
            Collection<AttributedElement> collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, new String[]{object});
            if (!collection.isEmpty()) {
                this.node2Element.put((ASTNode)object2, this.lookup((String)object, AttributedElement.Kind.CLASS));
            } else {
                this.node2Element.put((ASTNode)object2, this.lookup((String)object, AttributedElement.Kind.IFACE));
            }
        }
        super.visit(formalParameter);
    }

    public void visit(Variable variable) {
        String string;
        if (!this.node2Element.containsKey(variable) && (string = AttributedNodes.extractVariableName(variable)) != null) {
            this.node2Element.put((ASTNode)variable, this.lookup(string, AttributedElement.Kind.VARIABLE));
        }
        super.visit(variable);
    }

    public void visit(FunctionInvocation functionInvocation) {
        Object object;
        Expression expression = functionInvocation.getFunctionName().getName();
        String string = null;
        if (expression instanceof Identifier) {
            string = ((Identifier)expression).getName();
        }
        if (expression instanceof Variable && (object = ((Variable)expression).getName()) instanceof Identifier) {
            string = ((Identifier)object).getName();
        }
        if (string != null) {
            Collection<AttributedElement> collection;
            ClassElement classElement;
            object = null;
            ASTNode aSTNode = this.nodes.pop();
            ASTNode aSTNode2 = this.nodes.peek();
            this.nodes.push(aSTNode);
            if (aSTNode2 instanceof MethodInvocation) {
                classElement = this.resolveTypeSimple((Dispatch)aSTNode2);
                if (classElement != null) {
                    object = classElement.lookup(string, AttributedElement.Kind.FUNC);
                }
            } else if (aSTNode2 instanceof StaticMethodInvocation) {
                classElement = (StaticMethodInvocation)aSTNode2;
                collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, classElement.getClassName().getName());
                if (!collection.isEmpty()) {
                    String string2 = classElement.getClassName().getName();
                    if ("parent".equals(classElement.getClassName().getName())) {
                        string2 = this.getContextSuperClassName();
                    } else if ("self".equals(classElement.getClassName().getName())) {
                        string2 = this.getContextClassName();
                    }
                    for (AttributedElement attributedElement : collection) {
                        ClassElement classElement2 = (ClassElement)attributedElement;
                        if (classElement2 == null || string2 != null && !string2.equals(classElement2.getName()) || (object = classElement2.lookup(string, AttributedElement.Kind.FUNC)) == null) continue;
                        this.node2Element.put((ASTNode)classElement.getClassName(), classElement2);
                        this.node2Element.put((ASTNode)classElement, (AttributedElement)object);
                        this.node2Element.put((ASTNode)classElement.getMethod(), (AttributedElement)object);
                        break;
                    }
                }
            } else {
                object = this.lookup(string, AttributedElement.Kind.FUNC);
            }
            this.node2Element.put((ASTNode)functionInvocation, (AttributedElement)object);
            if ("define".equals(string) && functionInvocation.getParameters().size() == 2 && (classElement = (Expression)functionInvocation.getParameters().get(0)) instanceof Scalar && ((Scalar)classElement).getScalarType() == Scalar.Type.STRING && RefactoringUtils.isQuoted((String)((Object)(collection = ((Scalar)classElement).getStringValue())))) {
                this.node2Element.put((ASTNode)classElement, this.global.enterWrite(RefactoringUtils.dequote((String)((Object)collection)), AttributedElement.Kind.CONST, (ASTNode)classElement));
            }
        }
        if (this.node2Element.containsKey(functionInvocation)) {
            this.scan(functionInvocation.getParameters());
        } else {
            super.visit(functionInvocation);
        }
    }

    public void visit(InterfaceDeclaration interfaceDeclaration) {
        String string = interfaceDeclaration.getName().getName();
        ClassElement classElement = (ClassElement)this.global.enterWrite(string, AttributedElement.Kind.IFACE, (ASTNode)interfaceDeclaration);
        this.node2Element.put((ASTNode)interfaceDeclaration, classElement);
        List list = interfaceDeclaration.getInterfaes();
        for (Identifier identifier : list) {
            ClassElement classElement2 = (ClassElement)this.lookup(identifier.getName(), AttributedElement.Kind.IFACE);
            classElement.ifaces.add(classElement2);
            this.node2Element.put((ASTNode)identifier, classElement2);
        }
        this.scopes.push(classElement.enclosedElements);
        if (interfaceDeclaration.getBody() != null) {
            this.performEnterPass(classElement.enclosedElements, interfaceDeclaration.getBody().getStatements());
        }
        super.visit(interfaceDeclaration);
        this.scopes.pop();
    }

    public void visit(ClassDeclaration classDeclaration) {
        String string = classDeclaration.getName().getName();
        ClassElement classElement = (ClassElement)this.global.enterWrite(string, AttributedElement.Kind.CLASS, (ASTNode)classDeclaration);
        this.node2Element.put((ASTNode)classDeclaration, classElement);
        if (classDeclaration.getSuperClass() != null) {
            classElement.superClass = (ClassElement)this.lookup(classDeclaration.getSuperClass().getName(), AttributedElement.Kind.CLASS);
        }
        List list = classDeclaration.getInterfaes();
        for (Identifier identifier : list) {
            ClassElement classElement2 = (ClassElement)this.lookup(identifier.getName(), AttributedElement.Kind.IFACE);
            classElement.ifaces.add(classElement2);
            this.node2Element.put((ASTNode)identifier, classElement2);
        }
        this.scopes.push(classElement.enclosedElements);
        if (classDeclaration.getBody() != null) {
            this.performEnterPass(classElement.enclosedElements, classDeclaration.getBody().getStatements());
        }
        super.visit(classDeclaration);
        this.scopes.pop();
    }

    public void visit(ClassInstanceCreation classInstanceCreation) {
        Expression expression = classInstanceCreation.getClassName().getName();
        if (expression instanceof Identifier) {
            this.node2Element.put((ASTNode)classInstanceCreation, this.lookup(((Identifier)expression).getName(), AttributedElement.Kind.CLASS));
        }
        super.visit(classInstanceCreation);
    }

    public void visit(GlobalStatement globalStatement) {
        for (Variable variable : globalStatement.getVariables()) {
            String string = AttributedNodes.extractVariableName(variable);
            if (string == null) continue;
            this.enterGlobalVariable(string);
        }
        super.visit(globalStatement);
    }

    public void visit(Scalar scalar) {
        if (scalar.getScalarType() == Scalar.Type.STRING && !RefactoringUtils.isQuoted(scalar.getStringValue())) {
            AttributedElement attributedElement = this.global.lookup(scalar.getStringValue(), AttributedElement.Kind.CONST);
            this.node2Element.put((ASTNode)scalar, attributedElement);
        }
        super.visit(scalar);
    }

    public void visit(FieldAccess fieldAccess) {
        this.scan((ASTNode)fieldAccess.getDispatcher());
        ClassElement classElement = this.resolveTypeSimple((Dispatch)fieldAccess);
        String string = AttributedNodes.extractVariableName(fieldAccess.getField());
        if (classElement != null && string != null) {
            AttributedElement attributedElement = classElement.lookup(string, AttributedElement.Kind.VARIABLE);
            this.node2Element.put((ASTNode)fieldAccess, attributedElement);
            Variable variable = fieldAccess.getField();
            this.node2Element.put((ASTNode)variable, attributedElement);
            if (variable instanceof ArrayAccess) {
                Expression expression = variable.getName();
                if (expression instanceof Variable) {
                    this.node2Element.put((ASTNode)expression, attributedElement);
                }
                super.visit(fieldAccess);
            }
        } else {
            this.scan((ASTNode)fieldAccess.getField());
        }
    }

    private ClassElement getCurrentClassElement() {
        ClassElement classElement = null;
        for (int i = this.scopes.size() - 1; i >= 0; --i) {
            DefinitionScope definitionScope = (DefinitionScope)this.scopes.get(i);
            if (definitionScope == null || definitionScope.enclosingClass == null) continue;
            classElement = definitionScope.enclosingClass;
            break;
        }
        return classElement;
    }

    public void visit(StaticConstantAccess staticConstantAccess) {
        Object object;
        String string = staticConstantAccess.getClassName().getName();
        if (string.equals("self")) {
            object = this.getCurrentClassElement();
            if (object != null) {
                string = ((AttributedElement)object).getName();
            }
        } else if (string.equals("parent") && (object = this.getCurrentClassElement()) != null && (object = ((ClassElement)object).getSuperClass()) != null) {
            string = ((AttributedElement)object).getName();
        }
        object = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, string);
        if (!object.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                AttributedElement attributedElement = (AttributedElement)iterator.next();
                ClassElement classElement = (ClassElement)attributedElement;
                if (classElement == null || !classElement.getName().equals(string)) continue;
                String string2 = staticConstantAccess.getConstant().getName();
                AttributedElement attributedElement2 = classElement.lookup(string2, AttributedElement.Kind.CONST);
                this.node2Element.put((ASTNode)staticConstantAccess.getClassName(), classElement);
                this.node2Element.put((ASTNode)staticConstantAccess, attributedElement2);
                this.node2Element.put((ASTNode)staticConstantAccess.getConstant(), attributedElement2);
                break;
            }
        }
        super.visit(staticConstantAccess);
    }

    public void visit(StaticFieldAccess staticFieldAccess) {
        Collection<AttributedElement> collection = this.getNamedGlobalElements(AttributedElement.Kind.CLASS, staticFieldAccess.getClassName().getName());
        if (!collection.isEmpty()) {
            String string = staticFieldAccess.getClassName().getName();
            if ("parent".equals(staticFieldAccess.getClassName().getName())) {
                string = this.getContextSuperClassName();
            } else if ("self".equals(staticFieldAccess.getClassName().getName())) {
                string = this.getContextClassName();
            }
            for (AttributedElement attributedElement : collection) {
                Expression expression;
                AttributedElement attributedElement2;
                String string2;
                ClassElement classElement = (ClassElement)attributedElement;
                if (classElement == null || string != null && !string.equals(classElement.getName()) || (string2 = AttributedNodes.extractVariableName(staticFieldAccess.getField())) == null || (attributedElement2 = classElement.lookup(string2, AttributedElement.Kind.VARIABLE)) == null) continue;
                Variable variable = staticFieldAccess.getField();
                this.node2Element.put((ASTNode)staticFieldAccess.getClassName(), classElement);
                this.node2Element.put((ASTNode)staticFieldAccess, attributedElement2);
                this.node2Element.put((ASTNode)variable, attributedElement2);
                if (!(variable instanceof ArrayAccess) || !((expression = variable.getName()) instanceof Variable)) break;
                this.node2Element.put((ASTNode)expression, attributedElement2);
                break;
            }
        }
        super.visit(staticFieldAccess);
    }

    private AttributedElement enterGlobalVariable(String string) {
        AttributedElement attributedElement = this.global.lookup(string, AttributedElement.Kind.VARIABLE);
        if (attributedElement == null) {
            attributedElement = this.global.enterWrite(string, AttributedElement.Kind.VARIABLE, (ASTNode)null);
        }
        this.scopes.peek().enter(string, AttributedElement.Kind.VARIABLE, attributedElement);
        return attributedElement;
    }

    public void visit(ArrayAccess arrayAccess) {
        String string;
        Scalar scalar;
        String string2;
        if (arrayAccess.getName() instanceof Variable && arrayAccess.getIndex() instanceof Scalar && (string2 = AttributedNodes.extractVariableName((Variable)arrayAccess.getName())) != null && "GLOBALS".equals(string2) && (scalar = (Scalar)arrayAccess.getIndex()).getScalarType() == Scalar.Type.STRING && RefactoringUtils.isQuoted(string = scalar.getStringValue())) {
            this.node2Element.put((ASTNode)arrayAccess, this.enterGlobalVariable(RefactoringUtils.dequote(string)));
        }
        super.visit(arrayAccess);
    }

    private String getContextClassName() {
        String string = null;
        Enumeration enumeration = this.scopes.elements();
        while (enumeration.hasMoreElements()) {
            DefinitionScope definitionScope = (DefinitionScope)enumeration.nextElement();
            if (definitionScope.enclosingClass == null) continue;
            string = definitionScope.enclosingClass.getName();
        }
        return string;
    }

    private String getContextSuperClassName() {
        String string = null;
        Enumeration enumeration = this.scopes.elements();
        while (enumeration.hasMoreElements()) {
            DefinitionScope definitionScope = (DefinitionScope)enumeration.nextElement();
            if (definitionScope.enclosingClass == null || definitionScope.enclosingClass.superClass == null) continue;
            string = definitionScope.enclosingClass.superClass.getName();
        }
        return string;
    }

    private CompilationInfo getInfo() {
        return this.info;
    }

    private AttributedElement lookup(String string, AttributedElement.Kind kind) {
        AttributedElement attributedElement;
        DefinitionScope definitionScope = this.scopes.peek();
        switch (kind) {
            case FUNC: 
            case IFACE: 
            case CLASS: {
                attributedElement = this.global.lookup(string, kind);
                break;
            }
            default: {
                attributedElement = definitionScope.lookup(string, kind);
            }
        }
        if (attributedElement != null) {
            return attributedElement;
        }
        switch (kind) {
            case FUNC: 
            case IFACE: 
            case CLASS: {
                return this.global.enterWrite(string, kind, (ASTNode)null);
            }
        }
        return definitionScope.enterWrite(string, kind, (ASTNode)null);
    }

    public Collection<AttributedElement> getGlobalElements(AttributedElement.Kind kind) {
        return this.global.getElements(kind);
    }

    public Collection<AttributedElement> getNamedGlobalElements(AttributedElement.Kind kind, String ... stringArray) {
        Map map = (Map)this.global.name2Writes.get((Object)kind);
        ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
        for (String string : stringArray) {
            Object object;
            ClassElement classElement;
            Object object2;
            Object object3;
            Object object4;
            if (string.equals("self") && (object4 = this.getContextClassName()) != null) {
                string = object4;
            }
            if (AttributedElement.Kind.CLASS.equals((Object)kind) && string.equals("parent")) {
                object4 = map.values();
                if (map == null) continue;
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (AttributedElement)object3.next();
                    if (!(object2 instanceof ClassElement) || (classElement = ((ClassElement)(object = (ClassElement)object2)).getSuperClass()) == null) continue;
                    arrayList.add(classElement);
                }
                continue;
            }
            Object object5 = object4 = map != null ? (AttributedElement)map.get(string) : null;
            if (object4 != null) {
                arrayList.add((AttributedElement)object4);
                continue;
            }
            object3 = this.getInfo().getIndex("text/x-php5");
            object2 = PHPIndex.get((Index)object3);
            object = object2.getClasses(null, string, NameKind.PREFIX).iterator();
            while (object.hasNext()) {
                classElement = (IndexedClass)object.next();
                String string2 = classElement.getName();
                object4 = this.global.enterWrite(string2, AttributedElement.Kind.CLASS, (IndexedElement)classElement);
                arrayList.add((AttributedElement)object4);
            }
        }
        return arrayList;
    }

    public AttributedElement getElement(ASTNode aSTNode) {
        return this.node2Element.get(aSTNode);
    }

    public void enterAllIndexedClasses() {
        if (this.name2ElementCache == null) {
            Index index = this.getInfo().getIndex("text/x-php5");
            PHPIndex pHPIndex = PHPIndex.get((Index)index);
            this.name2ElementCache = new LinkedList<IndexedElement>();
            this.name2ElementCache.addAll(pHPIndex.getClasses(null, "", NameKind.PREFIX));
        }
        for (IndexedElement indexedElement : this.name2ElementCache) {
            if (!(indexedElement instanceof IndexedClass)) continue;
            this.global.enterWrite(indexedElement.getName(), AttributedElement.Kind.CLASS, indexedElement);
        }
    }

    private void performEnterPass(DefinitionScope definitionScope, Collection<? extends ASTNode> collection) {
        for (ASTNode aSTNode : collection) {
            Object object;
            Object object222;
            Object object3;
            if (aSTNode instanceof MethodDeclaration) {
                object3 = ((MethodDeclaration)aSTNode).getFunction();
                object222 = object3.getFunctionName().getName();
                this.node2Element.put(aSTNode, definitionScope.enterWrite((String)object222, AttributedElement.Kind.FUNC, aSTNode));
                this.node2Element.put((ASTNode)object3, definitionScope.enterWrite((String)object222, AttributedElement.Kind.FUNC, aSTNode));
                continue;
            }
            if (aSTNode instanceof FunctionDeclaration) {
                object3 = ((FunctionDeclaration)aSTNode).getFunctionName().getName();
                this.node2Element.put(aSTNode, definitionScope.enterWrite((String)object3, AttributedElement.Kind.FUNC, aSTNode));
            }
            if (aSTNode instanceof FieldsDeclaration) {
                for (Object object222 : ((FieldsDeclaration)aSTNode).getFields()) {
                    object = AttributedNodes.extractVariableName(object222.getName());
                    if (object == null) continue;
                    this.node2Element.put(aSTNode, definitionScope.enterWrite((String)object, AttributedElement.Kind.VARIABLE, aSTNode));
                }
            }
            if (aSTNode instanceof ClassDeclaration) {
                object3 = (ClassDeclaration)aSTNode;
                object222 = object3.getName().getName();
                object = (ClassElement)this.global.enterWrite((String)object222, AttributedElement.Kind.CLASS, (ASTNode)object3);
                this.node2Element.put((ASTNode)object3, (AttributedElement)object);
                if (object3.getSuperClass() != null) {
                    ((ClassElement)object).superClass = (ClassElement)this.lookup(object3.getSuperClass().getName(), AttributedElement.Kind.CLASS);
                    this.node2Element.put((ASTNode)object3.getSuperClass(), ((ClassElement)object).superClass);
                }
                List list = object3.getInterfaes();
                for (Identifier identifier : list) {
                }
                if (object3.getBody() != null) {
                    this.performEnterPass(((ClassElement)object).enclosedElements, object3.getBody().getStatements());
                }
            }
            if (!(aSTNode instanceof ClassConstantDeclaration)) continue;
            object3 = ((ClassConstantDeclaration)aSTNode).getNames();
            object222 = object3.iterator();
            while (object222.hasNext()) {
                object = (Identifier)object222.next();
                this.node2Element.put(aSTNode, definitionScope.enterWrite(object.getName(), AttributedElement.Kind.CONST, aSTNode));
            }
        }
    }

    public static AttributedNodes AttributedNodes(CompilationInfo compilationInfo) {
        AttributedNodes attributedNodes = info2Attr.get(compilationInfo);
        if (attributedNodes == null) {
            long l = System.currentTimeMillis();
            attributedNodes = new AttributedNodes(compilationInfo);
            attributedNodes.scan((ASTNode)RefactoringUtils.getRoot(compilationInfo));
            attributedNodes.info = null;
            info2Attr.put(compilationInfo, attributedNodes);
            long l2 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "AttributedNodes global instance", new Object[]{compilationInfo.getFileObject(), attributedNodes});
            Logger.getLogger("TIMER").log(Level.FINE, "AttributedNodes global time", new Object[]{compilationInfo.getFileObject(), l2 - l});
        }
        return attributedNodes;
    }

    public static AttributedNodes AttributedNodes(CompilationInfo compilationInfo, int n) {
        AttributedNodes attributedNodes = new AttributedNodes(compilationInfo, n);
        try {
            attributedNodes.scan((ASTNode)RefactoringUtils.getRoot(compilationInfo));
        }
        catch (Stop stop) {
            // empty catch block
        }
        return attributedNodes;
    }

    private static String name(ASTNode aSTNode) {
        if (aSTNode instanceof Identifier) {
            return ((Identifier)aSTNode).getName();
        }
        return null;
    }

    @CheckForNull
    public static String extractVariableName(Variable variable) {
        String string = WhereUsedElement.extractVariableName(variable);
        if (string != null && string.startsWith("$")) {
            return string.substring(1);
        }
        return string;
    }

    private ClassElement resolveTypeSimple(Dispatch dispatch) {
        AttributedType attributedType;
        ClassElement classElement = null;
        AttributedElement attributedElement = this.node2Element.get(dispatch.getDispatcher());
        if (attributedElement != null && (attributedType = (AttributedType)attributedElement.writesTypes.get(attributedElement.getWrites().size() - 1)) instanceof ClassType) {
            classElement = ((ClassType)attributedType).getElement();
        }
        return classElement;
    }

    public Collection<AttributedElement> getFunctions() {
        Collection<AttributedElement> collection = null;
        collection = this.global != null ? this.global.getFunctions() : Collections.emptyList();
        return collection;
    }

    public Collection<AttributedElement> getConstants() {
        Collection<AttributedElement> collection = null;
        collection = this.global != null ? this.global.getConstants() : Collections.emptyList();
        return collection;
    }

    public Collection<AttributedElement> getGlobalVariables() {
        Collection<AttributedElement> collection = null;
        collection = this.global != null ? this.global.getVariables() : Collections.emptyList();
        return collection;
    }

    public Collection<ClassElement> getClasses() {
        Collection<ClassElement> collection = null;
        collection = this.global != null ? this.global.getClasses() : Collections.emptyList();
        return collection;
    }

    public boolean hasGlobalVisibility(AttributedElement attributedElement) {
        if (attributedElement.isClassMember()) {
            ClassMemberElement classMemberElement = (ClassMemberElement)attributedElement;
            boolean bl = (classMemberElement.getModifier() == -1 || !classMemberElement.isPrivate()) && this.hasGlobalVisibility(classMemberElement.getClassElement());
            return bl;
        }
        return this.global != null ? this.global.getElements(attributedElement.getKind()).contains(attributedElement) : false;
    }

    public static class FunctionType
    extends AttributedType {
        private FunctionElement element;

        public FunctionType(FunctionElement functionElement) {
            this.element = functionElement;
        }

        public FunctionElement getElement() {
            return this.element;
        }

        public String getTypeName() {
            return this.getElement().getName();
        }
    }

    public static class ClassType
    extends AttributedType {
        private ClassElement element;

        public ClassType(ClassElement classElement) {
            this.element = classElement;
        }

        public ClassElement getElement() {
            return this.element;
        }

        public String getTypeName() {
            return this.getElement().getName();
        }
    }

    public static abstract class AttributedType {
        public abstract String getTypeName();
    }

    private static final class Stop
    extends Error {
        private Stop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefinitionScope {
        private final Map<AttributedElement.Kind, Map<String, AttributedElement>> name2Writes = new HashMap<AttributedElement.Kind, Map<String, AttributedElement>>();
        private boolean classScope;
        private boolean functionScope;
        private AttributedElement thisVar;
        private ClassElement enclosingClass;
        private FunctionElement enclosingFunction;

        public DefinitionScope() {
        }

        public DefinitionScope(ClassElement classElement) {
            this.enclosingClass = classElement;
            boolean bl = this.classScope = classElement != null;
            if (this.classScope) {
                this.thisVar = this.enterWrite("this", AttributedElement.Kind.VARIABLE, (ASTNode)null, (AttributedType)new ClassType(classElement));
            }
        }

        public DefinitionScope(FunctionElement functionElement) {
            this.enclosingFunction = functionElement;
            this.functionScope = functionElement != null;
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, ASTNode aSTNode) {
            return this.enterWrite(string, kind, aSTNode, null);
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, ASTNode aSTNode, AttributedType attributedType) {
            return this.enterWrite(string, kind, (Union2<ASTNode, IndexedElement>)Union2.createFirst((Object)aSTNode), attributedType);
        }

        public AttributedElement enterWrite(String string, AttributedElement.Kind kind, IndexedElement indexedElement) {
            return this.enterWrite(string, kind, (Union2<ASTNode, IndexedElement>)Union2.createSecond((Object)indexedElement), null);
        }

        private AttributedElement enterWrite(String string, AttributedElement.Kind kind, Union2<ASTNode, IndexedElement> union2, AttributedType attributedType) {
            AttributedElement attributedElement;
            block15: {
                block11: {
                    Map<String, AttributedElement> map;
                    block13: {
                        block14: {
                            block12: {
                                if (kind == AttributedElement.Kind.VARIABLE && this != AttributedNodes.this.global && SUPERGLOBALS.contains(string)) {
                                    return AttributedNodes.this.enterGlobalVariable(string);
                                }
                                map = this.name2Writes.get((Object)kind);
                                if (map == null) {
                                    map = new HashMap<String, AttributedElement>();
                                    this.name2Writes.put(kind, map);
                                }
                                if ((attributedElement = map.get(string)) != null) break block11;
                                if (kind != AttributedElement.Kind.CLASS && kind != AttributedElement.Kind.IFACE) break block12;
                                attributedElement = new ClassElement(union2, string, kind);
                                break block13;
                            }
                            if (!this.classScope || Arrays.asList("this").contains(string)) break block14;
                            switch (kind) {
                                case FUNC: 
                                case CONST: 
                                case VARIABLE: {
                                    attributedElement = new ClassMemberElement(union2, this.enclosingClass, string, kind);
                                    break block13;
                                }
                                default: {
                                    assert (false);
                                    break block13;
                                }
                            }
                        }
                        if (kind == AttributedElement.Kind.FUNC) {
                            attributedElement = new FunctionElement(union2, string, kind);
                        } else if (kind == AttributedElement.Kind.VARIABLE) {
                            if (attributedType == null && this.functionScope && this.enclosingFunction != null) {
                                attributedType = new FunctionType(this.enclosingFunction);
                            }
                            attributedElement = new AttributedElement(union2, string, kind, attributedType);
                        } else {
                            attributedElement = new AttributedElement(union2, string, kind, attributedType);
                        }
                    }
                    map.put(string, attributedElement);
                    break block15;
                }
                attributedElement.addWrite(union2, attributedType);
            }
            return attributedElement;
        }

        public AttributedElement enter(String string, AttributedElement.Kind kind, AttributedElement attributedElement) {
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map == null) {
                map = new HashMap<String, AttributedElement>();
                this.name2Writes.put(kind, map);
            }
            map.put(string, attributedElement);
            return attributedElement;
        }

        public AttributedElement lookup(String string, AttributedElement.Kind kind) {
            AttributedElement attributedElement = null;
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map != null) {
                attributedElement = map.get(string);
            }
            if (attributedElement == null) {
                Index index = AttributedNodes.this.getInfo().getIndex("text/x-php5");
                PHPIndex pHPIndex = PHPIndex.get((Index)index);
                switch (kind) {
                    case CONST: {
                        for (IndexedConstant indexedConstant : pHPIndex.getConstants(null, string, NameKind.PREFIX)) {
                            String string2 = indexedConstant.getName();
                            attributedElement = this.enterWrite(string2, AttributedElement.Kind.CONST, (IndexedElement)indexedConstant);
                        }
                        break;
                    }
                }
            }
            return attributedElement;
        }

        public Collection<AttributedElement> getElements(AttributedElement.Kind kind) {
            Map<String, AttributedElement> map = this.name2Writes.get((Object)kind);
            if (map != null) {
                return Collections.unmodifiableCollection(map.values());
            }
            return Collections.emptyList();
        }

        public Collection<AttributedElement> getFunctions() {
            return this.getElements(AttributedElement.Kind.FUNC);
        }

        public Collection<AttributedElement> getVariables() {
            return this.getElements(AttributedElement.Kind.VARIABLE);
        }

        private Collection<AttributedElement> getConstants() {
            return this.getElements(AttributedElement.Kind.CONST);
        }

        public Collection<ClassElement> getClasses() {
            LinkedHashSet<ClassElement> linkedHashSet = new LinkedHashSet<ClassElement>();
            Collection<AttributedElement> collection = this.getElements(AttributedElement.Kind.CLASS);
            for (AttributedElement attributedElement : collection) {
                assert (attributedElement instanceof ClassElement);
                linkedHashSet.add((ClassElement)attributedElement);
            }
            return linkedHashSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FunctionElement
    extends AttributedElement {
        private final DefinitionScope enclosedElements;
        private boolean initialized;

        public FunctionElement(Union2<ASTNode, IndexedElement> union2, String string, AttributedElement.Kind kind) {
            super(union2, string, kind);
            this.enclosedElements = new DefinitionScope(this);
        }

        public AttributedElement lookup(String string, AttributedElement.Kind kind) {
            return this.enclosedElements.lookup(string, kind);
        }

        public Collection<AttributedElement> getElements(AttributedElement.Kind kind) {
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            this.getElements0(arrayList, kind);
            return Collections.unmodifiableList(arrayList);
        }

        public Collection<AttributedElement> getNamedElements(AttributedElement.Kind kind, String ... stringArray) {
            Collection<AttributedElement> collection = this.getElements(kind);
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            for (String string : stringArray) {
                for (AttributedElement attributedElement : collection) {
                    if (!attributedElement.getName().equals(string)) continue;
                    arrayList.add(attributedElement);
                }
            }
            return arrayList;
        }

        public Collection<AttributedElement> getVariables() {
            return this.getElements(AttributedElement.Kind.VARIABLE);
        }

        private void getElements0(List<AttributedElement> list, AttributedElement.Kind kind) {
            list.addAll(this.enclosedElements.getElements(kind));
        }

        boolean isInitialized() {
            return this.initialized;
        }

        void initialized() {
            this.initialized = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClassElement
    extends AttributedElement {
        private final DefinitionScope enclosedElements;
        private ClassElement superClass;
        private Set<ClassElement> ifaces;
        private boolean initialized;

        public ClassElement(Union2<ASTNode, IndexedElement> union2, String string, AttributedElement.Kind kind) {
            super(union2, string, kind);
            this.ifaces = new HashSet<ClassElement>();
            this.enclosedElements = new DefinitionScope(this);
        }

        public AttributedElement lookup(String string, AttributedElement.Kind kind) {
            AttributedElement attributedElement = this.enclosedElements.lookup(string, kind);
            if (attributedElement != null) {
                return attributedElement;
            }
            Index index = AttributedNodes.this.getInfo().getIndex("text/x-php5");
            PHPIndex pHPIndex = PHPIndex.get((Index)index);
            int n = -1;
            switch (kind) {
                case CONST: {
                    for (IndexedConstant indexedConstant : pHPIndex.getAllClassConstants(null, this.getName(), string, NameKind.PREFIX)) {
                        String string2 = indexedConstant.getName();
                        string2 = string2.startsWith("$") ? string2.substring(1) : string2;
                        this.enclosedElements.enterWrite(string2, AttributedElement.Kind.CONST, (IndexedElement)indexedConstant);
                    }
                    break;
                }
                case FUNC: {
                    for (IndexedFunction indexedFunction : pHPIndex.getAllMethods(null, this.getName(), string, NameKind.PREFIX, n)) {
                        this.enclosedElements.enterWrite(indexedFunction.getName(), AttributedElement.Kind.FUNC, (IndexedElement)indexedFunction);
                    }
                    break;
                }
                case VARIABLE: {
                    for (IndexedConstant indexedConstant : pHPIndex.getAllFields(null, this.getName(), string, NameKind.PREFIX, n)) {
                        String string3 = indexedConstant.getName();
                        string3 = string3.startsWith("$") ? string3.substring(1) : string3;
                        this.enclosedElements.enterWrite(string3, AttributedElement.Kind.VARIABLE, (IndexedElement)indexedConstant);
                    }
                    break;
                }
            }
            return this.enclosedElements.lookup(string, kind);
        }

        public Collection<AttributedElement> getElements(AttributedElement.Kind kind) {
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            this.getElements0(arrayList, kind);
            return Collections.unmodifiableList(arrayList);
        }

        public Collection<AttributedElement> getNamedElements(AttributedElement.Kind kind, String ... stringArray) {
            Collection<AttributedElement> collection = this.getElements(kind);
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            for (String string : stringArray) {
                for (AttributedElement attributedElement : collection) {
                    if (!attributedElement.getName().equals(string)) continue;
                    arrayList.add(attributedElement);
                }
            }
            return arrayList;
        }

        public Collection<AttributedElement> getMethods() {
            return this.getElements(AttributedElement.Kind.FUNC);
        }

        public Collection<AttributedElement> getFields() {
            Collection<AttributedElement> collection = this.getElements(AttributedElement.Kind.VARIABLE);
            ArrayList<AttributedElement> arrayList = new ArrayList<AttributedElement>();
            for (AttributedElement attributedElement : collection) {
                if (attributedElement.getName().equals("this")) continue;
                arrayList.add(attributedElement);
            }
            return arrayList;
        }

        public ClassElement getSuperClass() {
            return this.superClass;
        }

        private void getElements0(List<AttributedElement> list, AttributedElement.Kind kind) {
            list.addAll(this.enclosedElements.getElements(kind));
            if (this.superClass != null) {
                this.superClass.getElements0(list, kind);
            }
        }

        boolean isInitialized() {
            return this.initialized;
        }

        void initialized() {
            this.initialized = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassMemberElement
    extends AttributedElement {
        private ClassElement classElement;
        int modifier = -1;

        public ClassMemberElement(Union2<ASTNode, IndexedElement> union2, ClassElement classElement, String string, AttributedElement.Kind kind) {
            super(union2, string, kind);
            this.classElement = classElement;
            this.setModifiers(union2, string);
            assert (classElement != null);
        }

        public String getClassName() {
            return this.getClassElement().getName();
        }

        @Override
        public String getScopeName() {
            return this.getClassName();
        }

        public int getModifier() {
            return this.modifier;
        }

        public boolean isPublic() {
            return BodyDeclaration.Modifier.isPublic((int)this.getModifier());
        }

        public boolean isPrivate() {
            return BodyDeclaration.Modifier.isPrivate((int)this.getModifier());
        }

        public boolean isProtected() {
            return BodyDeclaration.Modifier.isProtected((int)this.getModifier());
        }

        public boolean isStatic() {
            return BodyDeclaration.Modifier.isStatic((int)this.getModifier());
        }

        public ClassElement getClassElement() {
            return this.classElement;
        }

        @Override
        public boolean isClassMember() {
            return true;
        }

        public ClassMemberKind getClassMemberKind() {
            ClassMemberKind classMemberKind = null;
            switch (this.getKind()) {
                case CONST: {
                    classMemberKind = ClassMemberKind.CONST;
                    break;
                }
                case FUNC: {
                    classMemberKind = ClassMemberKind.METHOD;
                    break;
                }
                case VARIABLE: {
                    classMemberKind = ClassMemberKind.FIELD;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (classMemberKind != null);
            return classMemberKind;
        }

        private void setModifiers(Union2<ASTNode, IndexedElement> union2, String string) {
            IndexedElement indexedElement;
            if (union2.hasFirst()) {
                ASTNode aSTNode = (ASTNode)union2.first();
                if (aSTNode instanceof BodyDeclaration) {
                    this.modifier = ((BodyDeclaration)aSTNode).getModifier();
                } else if (string.equals("this")) {
                    assert (false);
                } else if (aSTNode instanceof ClassConstantDeclaration) {
                    this.modifier |= 1;
                } else assert (false) : string;
            } else if (union2.hasSecond() && (indexedElement = (IndexedElement)union2.second()) != null) {
                Set set = indexedElement.getModifiers();
                for (Modifier modifier : set) {
                    switch (modifier) {
                        case PRIVATE: {
                            this.modifier |= 2;
                            break;
                        }
                        case PROTECTED: {
                            this.modifier |= 4;
                            break;
                        }
                        case PUBLIC: {
                            this.modifier |= 1;
                            break;
                        }
                        case STATIC: {
                            this.modifier |= 8;
                        }
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ClassMemberKind {
            FIELD,
            METHOD,
            CONST;

        }
    }

    private static class Types {
        private AttributedElement el;

        Types(AttributedElement attributedElement) {
            this.el = attributedElement;
        }

        int size() {
            return this.el.writesTypes.size();
        }

        AttributedType getType(int n) {
            return (AttributedType)this.el.writesTypes.get(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributedElement {
        private List<Union2<ASTNode, IndexedElement>> writes = new LinkedList<Union2<ASTNode, IndexedElement>>();
        private List<AttributedType> writesTypes = new LinkedList<AttributedType>();
        private String name;
        private Kind k;

        public AttributedElement(Union2<ASTNode, IndexedElement> union2, String string, Kind kind) {
            this(union2, string, kind, null);
        }

        public AttributedElement(Union2<ASTNode, IndexedElement> union2, String string, Kind kind, AttributedType attributedType) {
            this.writes.add(union2);
            this.writesTypes.add(attributedType);
            this.name = string;
            this.k = kind;
        }

        public boolean isClassMember() {
            return false;
        }

        public List<Union2<ASTNode, IndexedElement>> getWrites() {
            return this.writes;
        }

        public Kind getKind() {
            return this.k;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AttributedElement)) {
                return false;
            }
            AttributedElement attributedElement = (AttributedElement)object;
            return this.name.equals(attributedElement.name) && this.k.equals((Object)attributedElement.k);
        }

        void addWrite(Union2<ASTNode, IndexedElement> union2, AttributedType attributedType) {
            this.writes.add(union2);
            this.writesTypes.add(attributedType);
        }

        Types getTypes() {
            return new Types(this);
        }

        public String getScopeName() {
            String string = "";
            Types types = this.getTypes();
            for (int i = 0; i < types.size(); ++i) {
                AttributedType attributedType = types.getType(i);
                if (attributedType == null) continue;
                string = attributedType.getTypeName();
                break;
            }
            return string;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            VARIABLE,
            FUNC,
            CLASS,
            CONST,
            IFACE;

        }
    }
}

