/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbLogger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbMiDefinitions;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxyEngine;
import org.netbeans.modules.cnd.debugger.gdb.utils.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbProxy
implements GdbMiDefinitions {
    private final GdbDebugger debugger;
    private final GdbProxyEngine engine;
    private final GdbLogger gdbLogger;
    private final Logger log = Logger.getLogger("gdb.gdbproxy.logger");
    private final Map<Integer, CommandBuffer> map = new HashMap<Integer, CommandBuffer>();
    public static final int MEMORY_READ_WIDTH = 16;

    public GdbProxy(GdbDebugger gdbDebugger, String string, String[] stringArray, String string2, String string3, String string4) throws IOException {
        this.debugger = gdbDebugger;
        this.log.setLevel(Level.FINE);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add("--nw");
        arrayList.add("--silent");
        arrayList.add("--interpreter=mi");
        this.gdbLogger = new GdbLogger(gdbDebugger, this);
        this.engine = new GdbProxyEngine(gdbDebugger, this, arrayList, stringArray, string2, string3, string4);
    }

    public GdbProxyEngine getProxyEngine() {
        return this.engine;
    }

    public GdbLogger getLogger() {
        return this.gdbLogger;
    }

    public CommandBuffer getCommandBuffer(Integer n) {
        return this.map.get(n);
    }

    public void removeCB(int n) {
        this.map.remove(n);
    }

    public void putCB(int n, CommandBuffer commandBuffer) {
        this.map.put(n, commandBuffer);
    }

    public int file_exec_and_symbols(String string) {
        return this.engine.sendCommand("-file-exec-and-symbols " + string);
    }

    public int addSymbolFile(String string, String string2) {
        return this.engine.sendCommand("add-symbol-file " + string + " " + string2);
    }

    public int target_attach(CommandBuffer commandBuffer, String string) {
        return this.engine.sendCommand(commandBuffer, "attach " + string);
    }

    public int target_detach() {
        return this.engine.sendCommand("detach");
    }

    public int file_symbol_file(String string) {
        return this.engine.sendCommand("-file-symbol-file " + string);
    }

    public int gdb_version() {
        return this.engine.sendCommand("-gdb-version");
    }

    public int gdb_show(String string) {
        return this.engine.sendCommand("-gdb-show " + string);
    }

    public int environment_cd(String string) {
        double d = this.debugger.getGdbVersion();
        if (d > 6.3) {
            return this.engine.sendCommand("-environment-cd  \"" + string + "\"");
        }
        return this.engine.sendCommand("cd \"" + string + "\"");
    }

    public int environment_directory(String string) {
        double d = this.debugger.getGdbVersion();
        if (d > 6.3 || this.debugger.getPlatform() == 4) {
            return this.engine.sendCommand("-environment-directory  \"" + string + "\"");
        }
        return this.engine.sendCommand("directory \"" + string + "\"");
    }

    public int environment_directory(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        double d = this.debugger.getGdbVersion();
        assert (list.size() > 0);
        if (d > 6.3 || this.debugger.getPlatform() == 4) {
            stringBuilder.append("-environment-directory");
        } else {
            stringBuilder.append("directory");
        }
        for (String string : list) {
            stringBuilder.append(" \"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        return this.engine.sendCommand(stringBuilder.toString());
    }

    public int info_threads(CommandBuffer commandBuffer) {
        return this.engine.sendCommand(commandBuffer, "info threads");
    }

    public int info_threads() {
        return this.engine.sendCommand("info threads");
    }

    public int info_files(CommandBuffer commandBuffer) {
        return this.engine.sendCommand(commandBuffer, "info files");
    }

    public int thread_select(String string) {
        return this.engine.sendCommand("-thread-select " + string);
    }

    public int info_proc() {
        return this.engine.sendCommand("info proc");
    }

    public int info_share() {
        return this.engine.sendCommand("info share");
    }

    public int info_share(CommandBuffer commandBuffer) {
        return this.engine.sendCommand(commandBuffer, "info share");
    }

    public int data_evaluate_expression(CommandBuffer commandBuffer, String string) {
        return this.engine.sendCommand(commandBuffer, "-data-evaluate-expression " + string);
    }

    public int data_evaluate_expression(String string) {
        return this.engine.sendCommand("-data-evaluate-expression " + string);
    }

    public int data_list_register_names(String string) {
        return this.engine.sendCommand("-data-list-register-names " + string);
    }

    public int data_list_register_values(CommandBuffer commandBuffer, String string) {
        return this.engine.sendCommand(commandBuffer, "-data-list-register-values x " + string);
    }

    public int data_list_changed_registers(CommandBuffer commandBuffer) {
        return this.engine.sendCommand(commandBuffer, "-data-list-changed-registers");
    }

    public int data_disassemble(String string, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        return this.engine.sendCommand("-data-disassemble -f " + string + " -l " + n + " -- " + n2);
    }

    public int data_disassemble(int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        return this.engine.sendCommand("-data-disassemble -s $pc -e \"$pc+" + n + "\" -- " + n2);
    }

    public int data_read_memory(CommandBuffer commandBuffer, String string, int n) {
        return this.engine.sendCommand(commandBuffer, "-data-read-memory " + string + " x 1 " + n + " " + 16 + " .");
    }

    public int print(CommandBuffer commandBuffer, String string) {
        return this.engine.sendCommand(commandBuffer, "print " + string);
    }

    public int file_list_exec_source_file() {
        return this.engine.sendCommand("-file-list-exec-source-file");
    }

    public int exec_run(String string) {
        return this.engine.sendCommand("-exec-run " + string);
    }

    public int exec_run() {
        return this.exec_run("");
    }

    public int exec_step() {
        this.debugger.setLastGo(GdbDebugger.LAST_GO_WAS_STEP);
        return this.engine.sendCommand("-exec-step");
    }

    public int exec_next() {
        this.debugger.setLastGo(GdbDebugger.LAST_GO_WAS_NEXT);
        return this.engine.sendCommand("-exec-next");
    }

    public int exec_step_instruction() {
        return this.engine.sendCommand("-exec-step-instruction");
    }

    public int exec_next_instruction() {
        return this.engine.sendCommand("-exec-next-instruction");
    }

    public int exec_finish() {
        this.debugger.setLastGo(GdbDebugger.LAST_GO_WAS_FINISH);
        return this.engine.sendCommand("-exec-finish");
    }

    public int exec_continue() {
        this.debugger.setLastGo(GdbDebugger.LAST_GO_WAS_CONTINUE);
        return this.engine.sendCommand("-exec-continue");
    }

    public int exec_interrupt() {
        if (this.debugger.getState().equals("state_running") || this.debugger.getState().equals("state_silent_stop")) {
            if (Utilities.isWindows()) {
                this.debugger.kill(18);
            } else {
                this.debugger.kill(2);
            }
        }
        return 0;
    }

    public int exec_abort() {
        String string = this.debugger.getGdbVersion() > 6.6 ? "-exec-abort " : "kill ";
        return this.engine.sendCommand(string);
    }

    public int break_insert(int n, boolean bl, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (GdbUtils.isMultiByte(string)) {
            if (bl) {
                stringBuilder.append("tbreak ");
            } else {
                stringBuilder.append("break ");
            }
        } else {
            stringBuilder.append("-break-insert ");
            if (bl) {
                stringBuilder.append("-t ");
            } else if (this.debugger.getGdbVersion() >= 6.8) {
                stringBuilder.append("-f ");
            }
        }
        if (Utilities.isWindows() && string.indexOf(47) == 0 && string.indexOf(58) == 2) {
            string = string.substring(1);
        } else if (this.debugger.getPlatform() == 4) {
            stringBuilder.append("-l 1 ");
        }
        if (n == 1) {
            stringBuilder.append("-p " + string2 + " ");
        }
        stringBuilder.append(string);
        return this.engine.sendCommand(stringBuilder.toString());
    }

    public int break_insert(String string) {
        return this.break_insert(0, false, string, null);
    }

    public int break_insert_temporary(String string) {
        return this.break_insert(0, true, string, null);
    }

    public int break_delete(int n) {
        return this.engine.sendCommand("-break-delete " + Integer.toString(n));
    }

    public int break_enable(Integer ... integerArray) {
        StringBuilder stringBuilder = new StringBuilder("-break-enable");
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            stringBuilder.append(" " + n2);
        }
        return this.engine.sendCommand(stringBuilder.toString());
    }

    public int break_disable(Integer ... integerArray) {
        StringBuilder stringBuilder = new StringBuilder("-break-disable");
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            stringBuilder.append(" " + n2);
        }
        return this.engine.sendCommand(stringBuilder.toString());
    }

    public int break_condition(int n, String string) {
        return this.engine.sendCommand("-break-condition " + Integer.toString(n) + " " + string);
    }

    public int break_after(int n, int n2) {
        return this.engine.sendCommand("-break-after " + Integer.toString(n) + " " + Integer.toString(n2));
    }

    public int stack_list_locals() {
        return this.stack_list_locals("");
    }

    public int stack_list_locals(String string) {
        return this.engine.sendCommand("-stack-list-locals " + string);
    }

    public int stack_list_arguments(int n, int n2, int n3) {
        return this.engine.sendCommand("-stack-list-arguments " + n + " " + n2 + " " + n3);
    }

    public int stack_select_frame(int n) {
        return this.engine.sendCommand("-stack-select-frame " + Integer.valueOf(n));
    }

    public int stack_info_frame() {
        return this.engine.sendCommand("-stack-info-frame ");
    }

    public int stack_list_frames() {
        return this.engine.sendCommand("-stack-list-frames ");
    }

    public int stack_list_frames(CommandBuffer commandBuffer) {
        return this.engine.sendCommand(commandBuffer, "-stack-list-frames ");
    }

    public int gdb_set(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-gdb-set ");
        stringBuilder.append(string);
        stringBuilder.append(' ');
        stringBuilder.append(string2);
        return this.engine.sendCommand(stringBuilder.toString());
    }

    public int set_new_console() {
        return this.engine.sendCommand("set new-console");
    }

    public int set_unwindonsignal(String string) {
        return this.engine.sendCommand("set unwindonsignal " + string);
    }

    public int symbol_type(CommandBuffer commandBuffer, String string) {
        return this.engine.sendCommand(commandBuffer, "ptype " + string);
    }

    public int whatis(CommandBuffer commandBuffer, String string) {
        return this.engine.sendCommand(commandBuffer, "whatis " + string);
    }

    public int gdb_exit() {
        int n = this.engine.sendCommand("-gdb-exit ");
        this.engine.stopSending();
        return n;
    }
}

