/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.utils.FieldTokenizer;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo {
    private GdbDebugger debugger;
    private String resolvedType;
    private String rawInfo;
    private Map<String, Object> map;
    private Map<String, TypeInfo> ticache;
    private static Map<String, Map<String, Object>> mcache = new HashMap<String, Map<String, Object>>();
    protected static Logger log = Logger.getLogger("gdb.logger");
    private static final boolean disable_ti_cache = true;
    private static final boolean disable_map_cache = true;

    public static TypeInfo getTypeInfo(GdbDebugger gdbDebugger, AbstractVariable abstractVariable) {
        String string;
        Map<String, TypeInfo> map = gdbDebugger.getTypeInfoCache();
        TypeInfo typeInfo = map.get(abstractVariable.getType());
        if (typeInfo != null) {
            return typeInfo;
        }
        String string2 = abstractVariable.getName().equals(NbBundle.getMessage(AbstractVariable.class, (String)"LBL_BaseClass")) ? gdbDebugger.requestSymbolType(abstractVariable.getType()) : gdbDebugger.requestSymbolType(abstractVariable.getFullName(false));
        log.fine("TI.getTypeInfo[rawInfo]: " + abstractVariable.getType() + " ==> [" + string2 + "]");
        if (string2 != null && string2.length() > 0) {
            int n = (string2 = string2.replace("\\n", "").trim()).indexOf(123);
            if (n == -1) {
                string = string2;
            } else {
                string = string2.substring(0, n).trim();
                int n2 = string.indexOf(" : ");
                if (n2 != -1) {
                    string = string.substring(0, n2);
                }
                if ((n2 = GdbUtils.findMatchingCurly(string2, n)) != -1) {
                    string = string + string2.substring(n2 + 1);
                }
            }
            typeInfo = map.get(string);
            if (typeInfo != null) {
                return typeInfo;
            }
        } else {
            string = null;
        }
        return new TypeInfo(gdbDebugger, abstractVariable.getType(), string, string2);
    }

    public TypeInfo(GdbDebugger gdbDebugger, String string, String string2, String string3) {
        this.debugger = gdbDebugger;
        this.resolvedType = string2;
        this.rawInfo = string3;
        this.map = null;
        if (string2 == null || string2.length() > 0) {
            // empty if block
        }
    }

    public String getResolvedType(AbstractVariable abstractVariable) {
        if (this.resolvedType == null) {
            if (this.rawInfo == null) {
                this.rawInfo = this.debugger.requestSymbolType(abstractVariable.getFullName(false));
            }
            if (this.rawInfo != null) {
                this.rawInfo = this.rawInfo.replace("\\n", "").trim();
                int n = this.rawInfo.indexOf(123);
                if (n == -1) {
                    this.resolvedType = this.rawInfo;
                } else {
                    this.resolvedType = this.rawInfo.substring(0, n).trim();
                    int n2 = this.resolvedType.indexOf(" : ");
                    if (n2 != -1) {
                        this.resolvedType = this.resolvedType.substring(0, n2);
                    }
                    if ((n2 = GdbUtils.findMatchingCurly(this.rawInfo, n)) != -1) {
                        this.resolvedType = this.resolvedType + this.rawInfo.substring(n2 + 1);
                    }
                }
            }
        }
        return this.resolvedType;
    }

    public String getDetailedType(AbstractVariable abstractVariable) {
        if (this.rawInfo == null) {
            this.rawInfo = this.debugger.requestSymbolType(abstractVariable.getFullName(false));
        }
        return this.rawInfo;
    }

    public Map<String, Object> getMap() {
        if (this.map == null) {
            this.map = this.getCachedMap();
            if (this.map == null) {
                this.map = this.createMap();
            }
        }
        return this.map;
    }

    private Map<String, Object> getCachedMap() {
        if (this.resolvedType != null) {
            Map<String, Object> map = mcache.get(this.resolvedType);
            if (map != null) {
                log.fine("TI.getCachedMap: Got Map for " + this.resolvedType);
            }
            return map;
        }
        return null;
    }

    private Map<String, Object> createMap() {
        if (this.resolvedType != null) {
            Map<String, Object> map = this.createFieldMap();
            return map;
        }
        return null;
    }

    private Map<String, Object> createFieldMap() {
        Map<String, Object> map = new HashMap<String, Object>();
        int n = this.rawInfo.indexOf(123);
        int n2 = GdbUtils.findMatchingCurly(this.rawInfo, n);
        String string = null;
        if (n != -1) {
            int n3 = this.getSuperclassColon(this.rawInfo.substring(0, n));
            if (n3 != -1) {
                map = this.addSuperclassEntries(map, this.rawInfo.substring(n3 + 1, n));
            }
            String string2 = n3 == -1 ? this.rawInfo.substring(0, n).trim() : this.rawInfo.substring(0, n3).trim();
            map.put("<name>", string2.startsWith("class ") ? string2.substring(5).trim() : string2);
        }
        String string3 = this.rawInfo;
        if (n == -1 && n2 == -1) {
            if (GdbUtils.isPointer(this.rawInfo)) {
                string3 = string3.replace('*', ' ').trim();
            }
        } else if (n != -1 && n2 != -1 && n2 > n + 1) {
            string = string3.substring(n + 1, n2);
        }
        if (string != null && (map = this.parseFields(map, this.shortenType(this.resolvedType), string)).isEmpty()) {
            map.put("<" + string3.substring(0, n) + ">", "<No data fields>");
        }
        return map;
    }

    private int getSuperclassColon(String string) {
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c2;
            char c3 = string.charAt(i);
            char c4 = c2 = i + 1 < string.length() ? string.charAt(i + 1) : (char)'\u0000';
            if (c3 == ':' && c2 != ':' && c != ':') {
                return i;
            }
            if (c3 == '<') {
                i = GdbUtils.findMatchingLtGt(string, i);
            }
            c = c3;
        }
        return -1;
    }

    private Map<String, Object> addSuperclassEntries(Map<String, Object> map, String string) {
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.substring(i).startsWith("public ")) {
                n = i += 7;
            } else if (string.substring(i).startsWith("private ")) {
                n = i += 8;
            } else if (string.substring(i).startsWith("protected ")) {
                n = i += 10;
            }
            if (i >= string.length()) continue;
            char c = string.charAt(i);
            if (c == '<') {
                int n3 = GdbUtils.findMatchingLtGt(string, i);
                if (n3 == -1) continue;
                i = n3;
                continue;
            }
            if (c != ',') continue;
            map.put("<super" + n2++ + ">", string.substring(n, i).trim());
            if (i + 1 >= string.length()) continue;
            string = string.substring(i + 1);
            i = 0;
            n = 0;
        }
        map.put("<super" + n2++ + ">", string.substring(n).trim());
        return map;
    }

    private Map<String, Object> parseFields(Map<String, Object> map, String string, String string2) {
        if (string2 != null) {
            if (map.get("<name>") == null) {
                map.put("<name>", string);
            }
            FieldTokenizer fieldTokenizer = new FieldTokenizer(string2);
            while (fieldTokenizer.hasMoreFields()) {
                Object object;
                int n;
                String[] stringArray = fieldTokenizer.nextField();
                if (stringArray[0] == null) continue;
                if (this.isNonAnonymousCSUDef(stringArray)) {
                    n = stringArray[0].indexOf(123);
                    int n2 = stringArray[0].lastIndexOf(125);
                    object = new HashMap<String, Object>();
                    map = this.parseFields((Map<String, Object>)object, this.shortenType(stringArray[0]), stringArray[0].substring(n + 1, n2).trim());
                    map.put(stringArray[1], object);
                    continue;
                }
                if (stringArray[1].startsWith("<anonymous") || stringArray[0].endsWith("}")) {
                    n = stringArray[0].indexOf(123);
                    object = stringArray[0].substring(n + 1, stringArray[0].length() - 1).trim();
                    Map<String, Object> map2 = this.parseFields(new HashMap<String, Object>(), this.shortenType(stringArray[0]), (String)object);
                    map.put(stringArray[1], map2);
                    continue;
                }
                n = stringArray[1].indexOf(91);
                if (n == -1) {
                    map.put(stringArray[1], stringArray[0]);
                    continue;
                }
                map.put(stringArray[1].substring(0, n), stringArray[0] + stringArray[1].substring(n));
            }
        }
        return map;
    }

    private String shortenType(String string) {
        if (string.startsWith("class ")) {
            return string.charAt(6) == '{' ? "class {...}" : string.substring(6);
        }
        if (string.startsWith("struct ")) {
            return string.charAt(7) == '{' ? "struct {...}" : string.substring(7);
        }
        if (string.startsWith("union {")) {
            return string.charAt(6) == '{' ? "union {...}" : string.substring(6);
        }
        return string;
    }

    private boolean isNonAnonymousCSUDef(String[] stringArray) {
        String string = stringArray[0];
        if (!stringArray[1].startsWith("<anonymous") && (string.startsWith("class {") || string.startsWith("struct {") || string.startsWith("union {"))) {
            int n = string.indexOf(123);
            int n2 = GdbUtils.findMatchingCurly(string, n) + 1;
            if (n != -1 && n2 != 0 && !string.substring(n, n2).equals("{...}") && n2 != string.length()) {
                return true;
            }
        }
        return false;
    }
}

