/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.ws.wadl2java;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Grammars;
import com.sun.research.ws.wadl.Include;
import com.sun.research.ws.wadl.Method;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.RepresentationType;
import com.sun.research.ws.wadl.Request;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.ResourceType;
import com.sun.research.ws.wadl.Resources;
import com.sun.research.ws.wadl.Response;
import com.sun.research.ws.wadl2java.JavaDocUtil;
import com.sun.research.ws.wadl2java.ResourceClassGenerator;
import com.sun.research.ws.wadl2java.Wadl2JavaMessages;
import com.sun.research.ws.wadl2java.ast.FaultNode;
import com.sun.research.ws.wadl2java.ast.MethodNode;
import com.sun.research.ws.wadl2java.ast.RepresentationNode;
import com.sun.research.ws.wadl2java.ast.ResourceNode;
import com.sun.research.ws.wadl2java.ast.ResourceTypeNode;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.impl.s2j.SchemaCompilerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wadl2Java {
    private File outputDir;
    private String pkg;
    private JPackage jPkg;
    private S2JJAXBModel s2jModel;
    private JCodeModel codeModel;
    private Map<String, Object> idMap;
    private Map<String, ResourceTypeNode> ifaceMap;
    private List<String> processedDocs;
    private JavaDocUtil javaDoc;
    private Unmarshaller u;
    private SchemaCompiler s2j;
    private ErrorListener errorListener;

    public Wadl2Java(File outputDir, String pkg) {
        this.outputDir = outputDir;
        this.pkg = pkg;
        this.javaDoc = new JavaDocUtil();
        this.processedDocs = new ArrayList<String>();
    }

    public void process(URI rootDesc) throws JAXBException, IOException, JClassAlreadyExistsException {
        JAXBContext jbc = JAXBContext.newInstance((String)"com.sun.research.ws.wadl", (ClassLoader)this.getClass().getClassLoader());
        this.u = jbc.createUnmarshaller();
        this.s2j = new SchemaCompilerImpl();
        this.errorListener = new SchemaCompilerErrorListener();
        this.s2j.setDefaultPackageName(this.pkg);
        this.s2j.setErrorListener(this.errorListener);
        this.idMap = new HashMap<String, Object>();
        this.ifaceMap = new HashMap<String, ResourceTypeNode>();
        Application a = this.processDescription(rootDesc);
        ResourceNode r = this.buildAst(a, rootDesc);
        this.s2jModel = this.s2j.bind();
        if (this.s2jModel != null) {
            this.codeModel = this.s2jModel.generateCode(null, this.errorListener);
            this.jPkg = this.codeModel._package(this.pkg);
            this.generateResourceTypeInterfaces();
            this.generateEndpointClass(r);
            this.codeModel.build(this.outputDir);
        }
    }

    public Application processDescription(URI desc) throws JAXBException, IOException {
        if (this.processedDocs.contains(desc.toString())) {
            return null;
        }
        this.processedDocs.add(desc.toString());
        System.out.println(Wadl2JavaMessages.PROCESSING(desc.toString()));
        Application a = (Application)this.u.unmarshal(desc.toURL());
        Grammars g = a.getGrammars();
        if (g != null) {
            for (Include i : g.getInclude()) {
                URI incl = desc.resolve(i.getHref());
                if (this.processedDocs.contains(incl.toString())) continue;
                this.processedDocs.add(incl.toString());
                System.out.println(Wadl2JavaMessages.PROCESSING(incl.toString()));
                InputSource input = new InputSource(incl.toURL().openStream());
                input.setSystemId(incl.toString());
                this.s2j.parseSchema(input);
            }
            int embeddedSchemaNo = 0;
            for (Object any : g.getAny()) {
                if (!(any instanceof Element)) continue;
                Element element = (Element)any;
                this.s2j.parseSchema(desc.toString() + "#schema" + Integer.toString(embeddedSchemaNo), element);
                ++embeddedSchemaNo;
            }
        }
        this.buildIDMap(a, desc);
        return a;
    }

    protected void buildIDMap(Application a, URI desc) throws JAXBException, IOException {
        for (Object child : a.getResourceTypeOrMethodOrRepresentation()) {
            if (child instanceof Method) {
                this.extractMethodIds((Method)child, desc);
                continue;
            }
            if (child instanceof ResourceType) {
                this.extractResourceTypeIds((ResourceType)child, desc);
                continue;
            }
            JAXBElement repOrFault = (JAXBElement)child;
            this.extractRepresentationId((RepresentationType)repOrFault.getValue(), desc);
        }
        if (a.getResources() != null) {
            for (Resource r : a.getResources().getResource()) {
                this.extractResourceIds(r, desc);
            }
        }
    }

    protected String processIDHref(URI desc, String id, String href, Object o) throws JAXBException, IOException {
        String uniqueId = null;
        if (id != null && id.length() > 0) {
            uniqueId = desc.toString() + "#" + id;
            this.idMap.put(uniqueId, o);
        } else if (href != null && !href.startsWith("#")) {
            this.processDescription(Wadl2Java.getReferencedFile(desc, href));
        }
        return uniqueId;
    }

    protected void extractRepresentationId(RepresentationType r, URI file) throws JAXBException, IOException {
        this.processIDHref(file, r.getId(), r.getHref(), r);
    }

    protected void extractMethodIds(Method m, URI file) throws JAXBException, IOException {
        this.processIDHref(file, m.getId(), m.getHref(), m);
        if (m.getRequest() != null) {
            for (RepresentationType representationType : m.getRequest().getRepresentation()) {
                this.extractRepresentationId(representationType, file);
            }
        }
        if (m.getResponse() != null) {
            for (JAXBElement jAXBElement : m.getResponse().getRepresentationOrFault()) {
                this.extractRepresentationId((RepresentationType)jAXBElement.getValue(), file);
            }
        }
    }

    protected void extractResourceIds(Resource r, URI file) throws JAXBException, IOException {
        this.processIDHref(file, r.getId(), null, r);
        for (String type : r.getType()) {
            this.processIDHref(file, null, type, r);
        }
        for (Object child : r.getMethodOrResource()) {
            if (child instanceof Method) {
                this.extractMethodIds((Method)child, file);
                continue;
            }
            if (!(child instanceof Resource)) continue;
            this.extractResourceIds((Resource)child, file);
        }
    }

    protected void extractResourceTypeIds(ResourceType r, URI file) throws JAXBException, IOException {
        String id = this.processIDHref(file, r.getId(), null, r);
        if (id != null) {
            this.ifaceMap.put(id, null);
        }
        for (Method child : r.getMethod()) {
            this.extractMethodIds(child, file);
        }
    }

    protected void generateResourceTypeInterfaces() throws JClassAlreadyExistsException {
        for (String id : this.ifaceMap.keySet()) {
            ResourceTypeNode n = this.ifaceMap.get(id);
            JDefinedClass iface = this.jPkg._class(1, n.getClassName(), ClassType.INTERFACE);
            n.setGeneratedInterface(iface);
            this.javaDoc.generateClassDoc(n, iface);
            ResourceClassGenerator rcGen = new ResourceClassGenerator(this.s2jModel, this.codeModel, this.jPkg, this.javaDoc, iface);
            for (MethodNode m : n.getMethods()) {
                rcGen.generateMethodDecls(m, true);
            }
        }
    }

    protected void generateEndpointClass(ResourceNode root) throws JClassAlreadyExistsException {
        JDefinedClass impl = this.jPkg._class(1, root.getClassName());
        this.javaDoc.generateClassDoc(root, impl);
        for (ResourceNode r : root.getChildResources()) {
            this.generateSubClass(impl, r);
        }
    }

    protected void generateSubClass(JDefinedClass parent, ResourceNode resource) throws JClassAlreadyExistsException {
        ResourceClassGenerator rcGen = new ResourceClassGenerator(this.s2jModel, this.codeModel, this.jPkg, this.javaDoc, resource);
        JDefinedClass impl = rcGen.generateClass(parent);
        for (MethodNode m : resource.getMethods()) {
            rcGen.generateMethodDecls(m, false);
        }
        for (ResourceNode r : resource.getChildResources()) {
            this.generateSubClass(impl, r);
        }
    }

    protected ResourceNode buildAst(Application a, URI rootFile) {
        for (String ifaceId : this.ifaceMap.keySet()) {
            this.buildResourceTypes(ifaceId, a);
        }
        Resources r = a.getResources();
        ResourceNode n = new ResourceNode(a, r);
        if (r != null) {
            for (Resource child : r.getResource()) {
                this.buildResourceTree(n, child, rootFile);
            }
        }
        return n;
    }

    protected void buildResourceTypes(String ifaceId, Application a) {
        try {
            URI file = new URI(ifaceId.substring(0, ifaceId.indexOf(35)));
            ResourceType type = (ResourceType)this.idMap.get(ifaceId);
            ResourceTypeNode node = new ResourceTypeNode(type);
            for (Method m : type.getMethod()) {
                this.addMethodToResourceType(node, m, file);
            }
            this.ifaceMap.put(ifaceId, node);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
    }

    protected void buildResourceTree(ResourceNode parent, Resource resource, URI file) {
        if (resource != null) {
            ResourceNode n = parent.addChild(resource);
            for (String type : resource.getType()) {
                this.addTypeToResource(n, type, file);
            }
            for (Object child : resource.getMethodOrResource()) {
                if (child instanceof Resource) {
                    Resource childResource = (Resource)child;
                    this.buildResourceTree(n, childResource, file);
                    continue;
                }
                if (!(child instanceof Method)) continue;
                Method m = (Method)child;
                this.addMethodToResource(n, m, file);
            }
        }
    }

    protected void addTypeToResource(ResourceNode resource, String href, URI file) {
        ResourceTypeNode n;
        if (!href.startsWith("#")) {
            file = Wadl2Java.getReferencedFile(file, href);
        }
        if ((n = this.ifaceMap.get(file.toString() + href.substring(href.indexOf(35)))) != null) {
            resource.addResourceType(n);
        } else {
            System.err.println(Wadl2JavaMessages.SKIPPING_REFERENCE(href, file.toString()));
        }
    }

    protected void addMethodToResourceType(ResourceTypeNode resource, Method method, URI file) {
        String href = method.getHref();
        if (href != null && href.length() > 0) {
            if (!href.startsWith("#")) {
                file = Wadl2Java.getReferencedFile(file, href);
            }
            method = this.dereferenceLocalHref(file, href, Method.class);
        }
        if (method != null) {
            Response response;
            MethodNode n = new MethodNode(method, resource);
            Request request = method.getRequest();
            if (request != null) {
                for (Param p : request.getParam()) {
                    n.getQueryParameters().add(p);
                }
                for (RepresentationType r : request.getRepresentation()) {
                    this.addRepresentation(n.getSupportedInputs(), r, file);
                }
            }
            if ((response = method.getResponse()) != null) {
                for (JAXBElement<RepresentationType> o : response.getRepresentationOrFault()) {
                    if (o.getName().getLocalPart().equals("representation")) {
                        this.addRepresentation(n.getSupportedOutputs(), (RepresentationType)o.getValue(), file);
                        continue;
                    }
                    if (!o.getName().getLocalPart().equals("fault")) continue;
                    FaultNode fn = new FaultNode((RepresentationType)o.getValue());
                    n.getFaults().add(fn);
                }
            }
        }
    }

    protected void addMethodToResource(ResourceNode resource, Method method, URI file) {
        String href = method.getHref();
        if (href != null && href.length() > 0) {
            if (!href.startsWith("#")) {
                file = Wadl2Java.getReferencedFile(file, href);
            }
            method = this.dereferenceLocalHref(file, href, Method.class);
        }
        if (method != null) {
            Response response;
            MethodNode n = new MethodNode(method, resource);
            Request request = method.getRequest();
            if (request != null) {
                for (Param p : request.getParam()) {
                    n.getQueryParameters().add(p);
                }
                for (RepresentationType r : request.getRepresentation()) {
                    this.addRepresentation(n.getSupportedInputs(), r, file);
                }
            }
            if ((response = method.getResponse()) != null) {
                for (JAXBElement<RepresentationType> o : response.getRepresentationOrFault()) {
                    if (o.getName().getLocalPart().equals("representation")) {
                        this.addRepresentation(n.getSupportedOutputs(), (RepresentationType)o.getValue(), file);
                        continue;
                    }
                    if (!o.getName().getLocalPart().equals("fault")) continue;
                    FaultNode fn = new FaultNode((RepresentationType)o.getValue());
                    n.getFaults().add(fn);
                }
            }
        }
    }

    protected void addRepresentation(List<RepresentationNode> list, RepresentationType representation, URI file) {
        String href = representation.getHref();
        if (href != null && href.length() > 0) {
            if (!href.startsWith("#")) {
                file = Wadl2Java.getReferencedFile(file, href);
            }
            representation = this.dereferenceLocalHref(file, href, RepresentationType.class);
        }
        if (representation != null) {
            RepresentationNode n = new RepresentationNode(representation);
            list.add(n);
        }
    }

    protected static URI getReferencedFile(URI currentFile, String href) {
        if (href.startsWith("#")) {
            return currentFile;
        }
        URI ref = currentFile.resolve(href.substring(0, href.indexOf(35)));
        return ref;
    }

    protected <T> T dereferenceLocalHref(URI file, String href, Class<T> clazz) {
        Object o = null;
        String id = file.toString() + href.substring(href.indexOf(35));
        o = this.idMap.get(id);
        if (o == null) {
            System.err.println(Wadl2JavaMessages.SKIPPING_REFERENCE(href, file.toString()));
            return null;
        }
        if (!clazz.isInstance(o)) {
            System.err.println(Wadl2JavaMessages.SKIPPING_REFERENCE_TYPE(href, file.toString()));
            return null;
        }
        return (T)o;
    }

    protected class SchemaCompilerErrorListener
    implements ErrorListener {
        protected SchemaCompilerErrorListener() {
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println(Wadl2JavaMessages.WARNING(sAXParseException.getMessage()));
        }

        public void info(SAXParseException sAXParseException) {
            System.err.println(Wadl2JavaMessages.INFO(sAXParseException.getMessage()));
        }

        public void fatalError(SAXParseException sAXParseException) {
            System.err.println(Wadl2JavaMessages.ERROR_FATAL(sAXParseException.getMessage()));
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println(Wadl2JavaMessages.ERROR(sAXParseException.getMessage()));
        }
    }
}

