/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.impl.NbBuildLogger;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.Redirector;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputWriter;

public class ForkedJavaOverride
extends Java {
    private static final RequestProcessor PROCESSOR = new RequestProcessor(ForkedJavaOverride.class.getName(), Integer.MAX_VALUE);
    private static final Pattern STACK_TRACE = Pattern.compile("(?:\t|\\[catch\\] )at ((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)");

    public ForkedJavaOverride() {
        this.redirector = new NbRedirector((Task)this);
        super.setFork(true);
    }

    public void setFork(boolean fork) {
    }

    private class Copier
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        private final Integer logLevel;
        private final String encoding;
        private final RequestProcessor.Task flusher;
        private final ByteArrayOutputStream currentLine;
        private OutputWriter ow = null;

        public Copier(InputStream in, OutputStream out, Integer logLevel, String encoding) {
            this.in = in;
            this.out = out;
            this.logLevel = logLevel;
            this.encoding = encoding;
            if (logLevel != null) {
                this.flusher = PROCESSOR.create(new Runnable(){

                    public void run() {
                        Copier.this.maybeFlush();
                    }
                });
                this.currentLine = new ByteArrayOutputStream();
            } else {
                this.flusher = null;
                this.currentLine = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (this.ow == null && this.logLevel != null) {
                Vector v = ForkedJavaOverride.this.getProject().getBuildListeners();
                for (Object o : v) {
                    if (!(o instanceof NbBuildLogger)) continue;
                    NbBuildLogger l = (NbBuildLogger)o;
                    this.ow = this.logLevel == 2 ? l.out : l.err;
                    break;
                }
            }
            try {
                try {
                    int c;
                    while ((c = this.in.read()) != -1) {
                        if (this.logLevel == null) {
                            this.out.write(c);
                            this.out.flush();
                            continue;
                        }
                        Copier copier = this;
                        synchronized (copier) {
                            if (c == 10) {
                                String str = this.currentLine.toString(this.encoding);
                                int len = str.length();
                                if (len > 0 && str.charAt(len - 1) == '\r') {
                                    str = str.substring(0, len - 1);
                                }
                                if (!STACK_TRACE.matcher(str).matches()) {
                                    this.ow.println(str);
                                }
                                ForkedJavaOverride.this.log(str, this.logLevel);
                                this.currentLine.reset();
                            } else {
                                this.currentLine.write(c);
                                this.flusher.schedule(250);
                            }
                        }
                    }
                    return;
                }
                finally {
                    if (this.logLevel != null) {
                        this.maybeFlush();
                    }
                }
            }
            catch (IOException x) {
                return;
            }
            catch (ThreadDeath d) {
                return;
            }
        }

        private synchronized void maybeFlush() {
            try {
                if (this.currentLine.size() > 0) {
                    this.currentLine.writeTo(this.out);
                    this.out.flush();
                    String str = this.currentLine.toString(this.encoding);
                    this.ow.write(str);
                }
            }
            catch (IOException x) {
            }
            catch (ThreadDeath threadDeath) {
                // empty catch block
            }
            this.currentLine.reset();
        }
    }

    private class NbRedirector
    extends Redirector {
        private String outEncoding;
        private String errEncoding;

        public NbRedirector(Task task) {
            super(task);
            this.outEncoding = System.getProperty("file.encoding");
            this.errEncoding = System.getProperty("file.encoding");
        }

        public ExecuteStreamHandler createHandler() throws BuildException {
            this.createStreams();
            return new NbOutputStreamHandler();
        }

        public synchronized void setOutputEncoding(String outputEncoding) {
            this.outEncoding = outputEncoding;
            super.setOutputEncoding(outputEncoding);
        }

        public synchronized void setErrorEncoding(String errorEncoding) {
            this.errEncoding = errorEncoding;
            super.setErrorEncoding(errorEncoding);
        }

        private class NbOutputStreamHandler
        implements ExecuteStreamHandler {
            private RequestProcessor.Task outTask;
            private RequestProcessor.Task errTask;

            NbOutputStreamHandler() {
            }

            public void start() throws IOException {
            }

            public void stop() {
                if (this.errTask != null) {
                    this.errTask.waitFinished();
                }
                if (this.outTask != null) {
                    this.outTask.waitFinished();
                }
            }

            public void setProcessOutputStream(InputStream inputStream) throws IOException {
                OutputStream os = NbRedirector.this.getOutputStream();
                Integer logLevel = null;
                if (os == null || os instanceof LogOutputStream) {
                    os = AntBridge.delegateOutputStream((boolean)false);
                    logLevel = 2;
                }
                this.outTask = PROCESSOR.post((Runnable)new Copier(inputStream, os, logLevel, NbRedirector.this.outEncoding));
            }

            public void setProcessErrorStream(InputStream inputStream) throws IOException {
                OutputStream os = NbRedirector.this.getErrorStream();
                Integer logLevel = null;
                if (os == null || os instanceof LogOutputStream) {
                    os = AntBridge.delegateOutputStream((boolean)true);
                    logLevel = 1;
                }
                this.errTask = PROCESSOR.post((Runnable)new Copier(inputStream, os, logLevel, NbRedirector.this.errEncoding));
            }

            public void setProcessInputStream(OutputStream outputStream) throws IOException {
                InputStream is = NbRedirector.this.getInputStream();
                if (is == null) {
                    is = AntBridge.delegateInputStream();
                }
                PROCESSOR.post((Runnable)new Copier(is, outputStream, null, null));
            }
        }
    }
}

