/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalogsupport.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.xml.catalogsupport.util.ProjectReferenceUtility;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class CustomizerProjectReferences
extends JPanel
implements HelpCtx.Provider {
    private ReferenceHelper refHelper;
    private Project owner;
    private SubprojectProvider subprojectProvider;
    private Project newlyAddedProject;
    private JButton addButton;
    private JScrollPane jScrollPane1;
    private JList projectList;
    private JLabel refLabel;
    private JButton removeButton;

    public CustomizerProjectReferences(Project project, ReferenceHelper referenceHelper) {
        this.owner = project;
        this.refHelper = referenceHelper;
        this.subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        this.initComponents();
        this.projectList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (CustomizerProjectReferences.this.projectList.getSelectedIndices().length == 0) {
                    CustomizerProjectReferences.this.removeButton.setEnabled(false);
                } else {
                    CustomizerProjectReferences.this.removeButton.setEnabled(true);
                }
            }
        });
        this.refreshProjectList();
    }

    private void refreshProjectList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.projectList.getModel();
        defaultListModel.clear();
        ReferenceHelper.RawReference[] rawReferenceArray = this.getRefHelper().getRawReferences();
        Set set = this.getSubprojectProvider().getSubprojects();
        ReferenceHelper.RawReference[] rawReferenceArray2 = set.iterator();
        while (rawReferenceArray2.hasNext()) {
            Object object = rawReferenceArray2.next();
            Project project = (Project)object;
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
            defaultListModel.addElement(projectInformation);
        }
        for (ReferenceHelper.RawReference rawReference : rawReferenceArray2 = this.getRefHelper().getRawReferences()) {
            if (rawReference.toAntArtifact(this.getRefHelper()) != null) continue;
            if (this.newlyAddedProject == null) {
                defaultListModel.addElement(new MissingProjectInformation(rawReference));
                continue;
            }
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.newlyAddedProject);
            defaultListModel.addElement(projectInformation);
        }
    }

    private Project getProject() {
        return this.owner;
    }

    private ReferenceHelper getRefHelper() {
        return this.refHelper;
    }

    private SubprojectProvider getSubprojectProvider() {
        return this.subprojectProvider;
    }

    private void initComponents() {
        this.refLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.projectList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.refLabel.setLabelFor(this.projectList);
        Mnemonics.setLocalizedText((JLabel)this.refLabel, (String)NbBundle.getMessage(CustomizerProjectReferences.class, (String)"LBL_CustomizerProjectReferences_ProjectReferences"));
        this.refLabel.setToolTipText(NbBundle.getMessage(CustomizerProjectReferences.class, (String)"HINT_CustomizerProjectReferences_ProjectReferences"));
        this.projectList.setModel(new DefaultListModel());
        this.projectList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                ProjectInformation projectInformation = (ProjectInformation)object;
                super.getListCellRendererComponent((JList<?>)CustomizerProjectReferences.this.projectList, projectInformation, n, bl, bl2);
                this.setIcon(projectInformation.getIcon());
                this.setText(projectInformation.getDisplayName());
                this.setToolTipText(projectInformation.getDisplayName());
                return this;
            }
        });
        this.jScrollPane1.setViewportView(this.projectList);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(CustomizerProjectReferences.class, (String)"LBL_CustomizerProjectReferences_AddProject"));
        this.addButton.setToolTipText(NbBundle.getMessage(CustomizerProjectReferences.class, (String)"HINT_CustomizerProjectReferences_AddProject"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerProjectReferences.this.showProjectDialog(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerProjectReferences.class, (String)"LBL_CustomizerProjectReferences_RemoveProject"));
        this.removeButton.setToolTipText(NbBundle.getMessage(CustomizerProjectReferences.class, (String)"HINT_CustomizerProjectReferences_RemoveProject"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerProjectReferences.this.removeProject(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 273, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.addButton).add((Component)this.removeButton))).add((Component)this.refLabel)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addButton, this.removeButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.refLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton)).add((Component)this.jScrollPane1, -1, 258, Short.MAX_VALUE)).addContainerGap()));
    }

    private void removeProject(ActionEvent actionEvent) {
        Object[] objectArray;
        for (Object object : objectArray = this.projectList.getSelectedValues()) {
            ReferenceHelper.RawReference rawReference;
            ProjectInformation projectInformation = (ProjectInformation)object;
            Project project = projectInformation.getProject();
            if (projectInformation instanceof MissingProjectInformation) {
                rawReference = ((MissingProjectInformation)projectInformation).getRawReference();
                this.getRefHelper().removeRawReference(rawReference.getForeignProjectName(), rawReference.getID());
                continue;
            }
            if (ProjectReferenceUtility.hasProjectReferenceInCatalog(this.getProject(), project)) {
                rawReference = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CustomizerProjectReferences.class, (String)"MSG_DeleteRefProject", (Object)projectInformation.getName()), 0, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)rawReference);
                if (rawReference.getValue() != NotifyDescriptor.YES_OPTION) {
                    return;
                }
            }
            ProjectReferenceUtility.removeProjectReference(this.getRefHelper(), project);
        }
        this.refreshProjectList();
    }

    private void showProjectDialog(ActionEvent actionEvent) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage(CustomizerProjectReferences.class, (String)"LBL_CustomizerProjectReferences_ProjectChooserTitle"));
        jFileChooser.setApproveButtonText(NbBundle.getMessage(CustomizerProjectReferences.class, (String)"LBL_CustomizerProjectReferences_ProjectChooserButton"));
        jFileChooser.setPreferredSize(new Dimension(650, 380));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file != null && file.isDirectory();
            }

            public String getDescription() {
                return "Directories/Project roots only.";
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.addProjectReference(jFileChooser.getSelectedFile());
        }
    }

    private void addProjectReference(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project != null) {
                    if (project == this.getProject()) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerProjectReferences.class, (String)"MSG_RefToItself")));
                        return;
                    }
                    if (ProjectUtils.hasSubprojectCycles((Project)this.getProject(), (Project)project)) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerProjectReferences.class, (String)"MSG_Cycles")));
                        return;
                    }
                    ProjectReferenceUtility.addProjectReference(this.getRefHelper(), project);
                    this.newlyAddedProject = project;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.refreshProjectList();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerProjectReferences.class);
    }

    private static final class MissingProjectInformation
    implements ProjectInformation {
        ReferenceHelper.RawReference missingRef;
        static Icon icon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/brokenProjectBadge.gif"));

        public MissingProjectInformation(ReferenceHelper.RawReference rawReference) {
            this.missingRef = rawReference;
        }

        ReferenceHelper.RawReference getRawReference() {
            return this.missingRef;
        }

        public String getName() {
            return this.missingRef.getForeignProjectName();
        }

        public String getDisplayName() {
            return NbBundle.getMessage(CustomizerProjectReferences.class, (String)"LBL_MISSING_PROJECT", (Object)this.missingRef.getForeignProjectName());
        }

        public Icon getIcon() {
            return icon;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public Project getProject() {
            return null;
        }
    }
}

