/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageStylesPanel
extends JPanel
implements ListSelectionListener,
KeyListener,
MouseListener {
    private CodeStyle.Language language;
    private Map<String, PreviewPreferences> preferences;
    private JButton duplicateButton;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JButton newButton;
    private JButton removeButton;
    private JList stylesList;

    public ManageStylesPanel(CodeStyle.Language language, Map<String, PreviewPreferences> map) {
        this.language = language;
        this.preferences = map;
        this.initComponents();
        this.initList();
    }

    private void initList() {
        this.initListModel();
        this.stylesList.addListSelectionListener(this);
        this.stylesList.addKeyListener(this);
        this.stylesList.addMouseListener(this);
        this.stylesList.getSelectionModel().setSelectionMode(0);
        this.stylesList.setSelectedIndex(0);
        this.stylesList.requestFocus();
        this.checkSelection();
    }

    private void initListModel() {
        ArrayList<MyListItem> arrayList = new ArrayList<MyListItem>();
        for (String string : this.preferences.keySet()) {
            arrayList.add(new MyListItem(string, EditorOptions.getStyleDisplayName(this.language, string)));
        }
        Collections.sort(arrayList);
        this.stylesList.setModel(new MyListModel(arrayList));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.stylesList = new JList();
        this.jSeparator1 = new JSeparator();
        this.newButton = new JButton();
        this.duplicateButton = new JButton();
        this.removeButton = new JButton();
        this.setMinimumSize(new Dimension(200, 150));
        this.setPreferredSize(new Dimension(250, 150));
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.stylesList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSeparator1.setForeground(SystemColor.activeCaptionBorder);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(ManageStylesPanel.class, (String)"ManageStylesPanel.newButton.text"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageStylesPanel.this.newButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.newButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getMessage(ManageStylesPanel.class, (String)"ManageStylesPanel.duplicateButton.text"));
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageStylesPanel.this.duplicateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.duplicateButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ManageStylesPanel.class, (String)"ManageStylesPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageStylesPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        PreviewPreferences previewPreferences = this.preferences.get("Default");
        String string = this.nextId();
        String string2 = string + "_Style_Name";
        String string3 = ManageStylesPanel.getString("Custom_Name");
        if ((string3 = this.getDisplayName(string3)) != null && this.checkUniqueStyleName(string3)) {
            NbPreferences.forModule(CodeStyle.class).node("CodeStyle").put(string2, string3);
            PreviewPreferences previewPreferences2 = new PreviewPreferences(previewPreferences, this.language, string);
            previewPreferences2.makeAllKeys(previewPreferences);
            this.preferences.put(string, previewPreferences2);
            this.initListModel();
        }
    }

    private void duplicateButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.stylesList.getSelectedIndex();
        if (n >= 0) {
            MyListItem myListItem = (MyListItem)this.stylesList.getModel().getElementAt(n);
            PreviewPreferences previewPreferences = this.preferences.get(myListItem.id);
            String string = this.nextId();
            String string2 = string + "_Style_Name";
            String string3 = NbBundle.getMessage(ManageStylesPanel.class, (String)"CopyOfStyle", (Object)myListItem.name);
            if ((string3 = this.getDisplayName(string3)) != null && this.checkUniqueStyleName(string3)) {
                NbPreferences.forModule(CodeStyle.class).node("CodeStyle").put(string2, string3);
                PreviewPreferences previewPreferences2 = new PreviewPreferences(previewPreferences, this.language, string);
                previewPreferences2.makeAllKeys(previewPreferences);
                this.preferences.put(string, previewPreferences2);
                this.initListModel();
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.stylesList.getSelectedIndex();
        if (n >= 0) {
            MyListItem myListItem = (MyListItem)this.stylesList.getModel().getElementAt(n);
            this.preferences.remove(myListItem.id);
            this.initListModel();
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ManageStylesPanel.class, (String)string);
    }

    private String getDisplayName(String string) {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ManageStylesPanel.getString("EDIT_DIALOG_LABEL_TXT"), ManageStylesPanel.getString("EDIT_DIALOG_TITLE_TXT"));
        inputLine.setInputText(string);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        if (inputLine.getValue() == NotifyDescriptor.OK_OPTION) {
            return inputLine.getInputText();
        }
        return null;
    }

    private String nextId() {
        int n = 0;
        try {
            for (String string : NbPreferences.forModule(ManageStylesPanel.class).node("CodeStyle").keys()) {
                if (!string.endsWith("_Style_Name") || !string.startsWith("Style_")) continue;
                String string2 = string.substring(6, string.length() - 11);
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                if (n > n2) continue;
                n = n2 + 1;
            }
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
        return "Style_" + n;
    }

    private boolean checkUniqueStyleName(String string) {
        for (String string2 : this.preferences.keySet()) {
            String string3 = EditorOptions.getStyleDisplayName(this.language, string2);
            if (!string3.equals(string)) continue;
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ManageStylesPanel.class, (String)"Duplicate_Style_Warning", (Object)string), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
        return true;
    }

    private void checkSelection() {
        int n = this.stylesList.getSelectedIndex();
        if (n >= 0) {
            MyListItem myListItem = (MyListItem)this.stylesList.getModel().getElementAt(n);
            this.newButton.setEnabled(true);
            this.duplicateButton.setEnabled(true);
            this.removeButton.setEnabled(!myListItem.isPredefined());
        } else {
            this.duplicateButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.checkSelection();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.processKeyEvent(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object[] objectArray = this.stylesList.getSelectedValues();
        if (objectArray.length != 1) {
            return;
        }
        if (mouseEvent.getClickCount() == 2) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListItem
    implements Comparable<MyListItem> {
        private String id;
        private String name;

        private MyListItem(String string, String string2) {
            this.id = string;
            this.name = string2;
        }

        private boolean isPredefined() {
            for (String string : EditorOptions.PREDEFINED_STYLES) {
                if (!string.equals(this.id)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(MyListItem myListItem) {
            return this.name.compareTo(myListItem.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListModel
    extends AbstractListModel {
        private List<MyListItem> objects;

        private MyListModel(List<MyListItem> list) {
            this.objects = list;
        }

        @Override
        public int getSize() {
            return this.objects.size();
        }

        @Override
        public MyListItem getElementAt(int n) {
            return this.objects.get(n);
        }
    }
}

