/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CppBracesMatcher
implements BracesMatcher,
BracesMatcherFactory {
    private static final char[] PAIRS = new char[]{'(', ')', '[', ']', '{', '}'};
    private static final CppTokenId[] PAIR_TOKEN_IDS = new CppTokenId[]{CppTokenId.LPAREN, CppTokenId.RPAREN, CppTokenId.LBRACKET, CppTokenId.RBRACKET, CppTokenId.LBRACE, CppTokenId.RBRACE};
    private final MatcherContext context;
    private int originOffset;
    private char originChar;
    private char matchingChar;
    private boolean backward;
    private List<TokenSequence<?>> sequences;

    public CppBracesMatcher() {
        this(null);
    }

    private CppBracesMatcher(MatcherContext matcherContext) {
        this.context = matcherContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws BadLocationException, InterruptedException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            int[] nArray = BracesMatcherSupport.findChar((Document)this.context.getDocument(), (int)this.context.getSearchOffset(), (int)this.context.getLimitOffset(), (char[])PAIRS);
            if (nArray != null) {
                Object object;
                this.originOffset = nArray[0];
                this.originChar = PAIRS[nArray[1]];
                this.matchingChar = PAIRS[nArray[1] + nArray[2]];
                this.backward = nArray[2] < 0;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
                this.sequences = tokenHierarchy.embeddedTokenSequences(this.originOffset, this.backward);
                if (!this.sequences.isEmpty() && (object = this.getTokenSequence()) == null) {
                    int[] nArray2 = null;
                    return nArray2;
                }
                object = new int[]{this.originOffset, this.originOffset + 1};
                return object;
            }
            int[] nArray3 = null;
            return nArray3;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TokenSequence<?> getTokenSequence() {
        if (this.sequences.isEmpty()) {
            return null;
        }
        TokenSequence<?> tokenSequence = this.sequences.get(this.sequences.size() - 1);
        tokenSequence.move(this.originOffset);
        if (!tokenSequence.moveNext()) {
            if (this.sequences.size() <= 1) return null;
            tokenSequence = this.sequences.get(this.sequences.size() - 2);
            tokenSequence.move(this.originOffset);
            if (!tokenSequence.moveNext() || tokenSequence.token().id() != CppTokenId.BLOCK_COMMENT && tokenSequence.token().id() != CppTokenId.LINE_COMMENT) return tokenSequence;
            return null;
        }
        if (tokenSequence.token().id() != CppTokenId.BLOCK_COMMENT && tokenSequence.token().id() != CppTokenId.LINE_COMMENT) return tokenSequence;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            TokenSequence<?> tokenSequence = this.getTokenSequence();
            if (tokenSequence == null) {
                int[] nArray = null;
                return nArray;
            }
            tokenSequence.move(this.originOffset);
            if (tokenSequence.moveNext() && tokenSequence.token().id() == CppTokenId.STRING_LITERAL) {
                int n = BracesMatcherSupport.matchChar((Document)this.context.getDocument(), (int)(this.backward ? this.originOffset : this.originOffset + 1), (int)(this.backward ? tokenSequence.offset() : tokenSequence.offset() + tokenSequence.token().length()), (char)this.originChar, (char)this.matchingChar);
                if (n != -1) {
                    int[] nArray = new int[]{n, n + 1};
                    return nArray;
                }
                int[] nArray = null;
                return nArray;
            }
            CppTokenId cppTokenId = this.getTokenId(this.originChar);
            CppTokenId cppTokenId2 = this.getTokenId(this.matchingChar);
            tokenSequence.move(this.originOffset);
            int n = 0;
            if (this.backward) {
                while (tokenSequence.movePrevious()) {
                    if (cppTokenId == tokenSequence.token().id()) {
                        ++n;
                        continue;
                    }
                    if (cppTokenId2 != tokenSequence.token().id()) continue;
                    if (n == 0) {
                        int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length()};
                        return nArray;
                    }
                    --n;
                }
            } else {
                tokenSequence.moveNext();
                while (tokenSequence.moveNext()) {
                    if (cppTokenId == tokenSequence.token().id()) {
                        ++n;
                        continue;
                    }
                    if (cppTokenId2 != tokenSequence.token().id()) continue;
                    if (n == 0) {
                        int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length()};
                        return nArray;
                    }
                    --n;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private CppTokenId getTokenId(char c) {
        for (int i = 0; i < PAIRS.length; ++i) {
            if (PAIRS[i] != c) continue;
            return PAIR_TOKEN_IDS[i];
        }
        return null;
    }

    public BracesMatcher createMatcher(MatcherContext matcherContext) {
        return new CppBracesMatcher(matcherContext);
    }
}

