/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibPackage;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.ExtensionComplib;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.ui.CompLibManagerPanel;
import org.netbeans.modules.visualweb.complib.ui.ComplibOptionsPanel;
import org.netbeans.modules.visualweb.extension.openide.awt.JFileChooser_RAVE;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImportComplibPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton browseButton;
    private JLabel errorLabel;
    private JLabel packageLabel;
    private JTextField packageTextField;
    private JLabel previewLabel;
    private JScrollPane previewScrollPane;
    private JTree previewTree;
    private static File savedCurDir = ComplibOptionsPanel.getImportStartDir();
    private static DefaultTreeModel EMPTY_TREE_MODEL = new DefaultTreeModel(new DefaultMutableTreeNode("/emptyPaletteRoot"));
    private DialogDescriptor descriptor;
    private ComplibPackage complibPackage;

    private void initComponents() {
        this.packageLabel = new JLabel();
        this.packageTextField = new JTextField();
        this.browseButton = new JButton();
        this.previewLabel = new JLabel();
        this.previewScrollPane = new JScrollPane();
        this.previewTree = new JTree();
        this.errorLabel = new JLabel();
        this.packageLabel.setLabelFor(this.packageTextField);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getBundle(ImportComplibPanel.class).getString("import.packageLabel"));
        this.packageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportComplibPanel.class, (String)"ACSN_import.packageLabel"));
        this.packageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportComplibPanel.class, (String)"ACSD_import.packageLabel"));
        this.packageTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportComplibPanel.class, (String)"ACSN_import.packageLabel"));
        this.packageTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportComplibPanel.class, (String)"ACSD_import.packageLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ImportComplibPanel.class, (String)"import.browseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportComplibPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportComplibPanel.class, (String)"ACSN_import.browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportComplibPanel.class, (String)"ACSD_import.browseButton"));
        this.previewLabel.setLabelFor(this.previewTree);
        this.previewLabel.setText(NbBundle.getMessage(ImportComplibPanel.class, (String)"import.previewLabel"));
        this.previewLabel.getAccessibleContext().setAccessibleDescription(this.previewLabel.getText());
        this.previewTree.setRootVisible(false);
        this.previewTree.setSelectionModel(null);
        this.previewScrollPane.setViewportView(this.previewTree);
        this.errorLabel.setForeground(Color.red);
        this.errorLabel.setText("Error");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.previewScrollPane, -1, 401, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.packageTextField, -1, 316, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseButton)).add(1, (Component)this.previewLabel).add(1, (Component)this.packageLabel).add(1, (Component)this.errorLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.packageLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.packageTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.previewLabel).addPreferredGap(0).add((Component)this.previewScrollPane, -1, 117, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.errorLabel, -2, 14, -2)));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = JFileChooser_RAVE.getJFileChooser();
        CompLibFileFilter compLibFileFilter = new CompLibFileFilter();
        jFileChooser.setFileFilter(compLibFileFilter);
        jFileChooser.setCurrentDirectory(savedCurDir);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file;
            File file2 = jFileChooser.getSelectedFile();
            if (file2 != null && (file = file2.getParentFile()) != null) {
                savedCurDir = file;
            }
            this.packageTextField.setText(file2.getAbsolutePath());
        }
    }

    public void showDialog(final CompLibManagerPanel compLibManagerPanel) {
        this.initComponents();
        this.packageTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ImportComplibPanel.this.packageFileChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ImportComplibPanel.this.packageFileChanged();
            }
        });
        this.previewTree.setModel(EMPTY_TREE_MODEL);
        this.previewTree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Icon getLeafIcon() {
                return this.getClosedIcon();
            }
        });
        this.clearErrorMessage();
        this.setValid(false);
        String string = NbBundle.getMessage(ImportComplibPanel.class, (String)"import.dialogTitle");
        HelpCtx helpCtx = new HelpCtx("projrave_ui_elements_dialogs_import_components_db");
        this.descriptor = new DialogDescriptor((Object)this, string, true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        dialog.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/visualweb/complib/ui/Bundle").getString("ACSN_import.dialog"));
        dialog.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/visualweb/complib/ui/Bundle").getString("ACSD_import.dialog"));
        this.descriptor.setValid(false);
        dialog.setVisible(true);
        if (!this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            return;
        }
        final Dialog dialog2 = this.showProgressBar("import.progressImport");
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ExtensionComplib extensionComplib = null;
                try {
                    extensionComplib = ImportComplibPanel.this.doImportLibrary();
                }
                catch (Exception exception) {
                    IdeUtil.logError(exception);
                    String string = NbBundle.getMessage(ImportComplibPanel.class, (String)"import.importFailed");
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                dialog2.dispose();
                compLibManagerPanel.notifyImportComplete(extensionComplib);
            }
        });
    }

    private Dialog showProgressBar(String string) {
        String string2 = NbBundle.getMessage(ImportComplibPanel.class, (String)string);
        String string3 = NbBundle.getMessage(ImportComplibPanel.class, (String)"global.progressTitle");
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.setStringPainted(false);
        jPanel.setLayout(new GridBagLayout());
        jLabel.setText(string2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 11);
        jPanel.add((Component)jProgressBar, gridBagConstraints);
        String string4 = NbBundle.getMessage(ImportComplibPanel.class, (String)"global.labelClose");
        Object[] objectArray = new Object[]{string4};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, string3, false, objectArray, (Object)string4, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return dialog;
    }

    private ExtensionComplib doImportLibrary() throws Exception {
        assert (this.descriptor.isValid());
        ComplibServiceProvider complibServiceProvider = ComplibServiceProvider.getInstance();
        if (complibServiceProvider.isInstalled(this.complibPackage)) {
            String string = NbBundle.getMessage(ImportComplibPanel.class, (String)"import.libraryExists");
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 0);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.YES_OPTION != object) {
                return null;
            }
        }
        return complibServiceProvider.installComplibPackage(this.complibPackage);
    }

    private void clearErrorMessage() {
        this.errorLabel.setText(" ");
    }

    private void setValid(boolean bl) {
        if (this.descriptor != null) {
            this.descriptor.setValid(bl);
        }
    }

    private ComplibPackage validatePackageFile() {
        ComplibPackage complibPackage;
        File file = this.validatePackageName();
        if (file == null) {
            return null;
        }
        try {
            complibPackage = new ComplibPackage(file);
        }
        catch (Exception exception) {
            IdeUtil.logError(exception);
            this.setErrorMessage("import.notReadable");
            return null;
        }
        return complibPackage;
    }

    private void packageFileChanged() {
        this.complibPackage = this.validatePackageFile();
        if (this.complibPackage == null) {
            this.previewTree.setModel(EMPTY_TREE_MODEL);
            return;
        }
        this.updatePreviewTreeModel();
        this.clearErrorMessage();
        this.setValid(true);
    }

    private void updatePreviewTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("/paletteRoot");
        List<Complib.InitialPaletteFolder> list = this.complibPackage.getInitialPaletteFolders();
        if (list.isEmpty()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.complibPackage.getTitle()));
        } else {
            for (Complib.InitialPaletteFolder initialPaletteFolder : list) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(initialPaletteFolder.getName());
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.previewTree.setModel(defaultTreeModel);
    }

    private File validatePackageName() {
        String string = this.packageTextField.getText().trim();
        File file = this.validateFileName(string);
        if (file == null) {
            return null;
        }
        if (new CompLibFileFilter().accept(file)) {
            return file;
        }
        this.setErrorMessage("import.notCompLib");
        return null;
    }

    private void setErrorMessage(String string) {
        this.errorLabel.setText(NbBundle.getMessage(ImportComplibPanel.class, (String)string));
        this.setValid(false);
    }

    private File validateFileName(String string) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(savedCurDir, string);
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                this.setErrorMessage("import.isDirectory");
                return null;
            }
            return file;
        }
        this.setErrorMessage("import.noSuchFile");
        return null;
    }

    private static class CompLibFileFilter
    extends FileFilter {
        public static final String compLibExtension = "complib";

        private CompLibFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null) {
                return string.equals(compLibExtension);
            }
            return false;
        }

        public String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }

        public String getDescription() {
            return NbBundle.getMessage(CompLibFileFilter.class, (String)"import.compLibFileFilter");
        }
    }
}

