/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib.ui;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.ExtensionComplib;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.api.ComplibEvent;
import org.netbeans.modules.visualweb.complib.api.ComplibListener;
import org.netbeans.modules.visualweb.complib.ui.ComplibChooser;
import org.netbeans.modules.visualweb.complib.ui.SharedComplibAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ComplibsRootNode
extends AbstractNode {
    private static final String IMAGE_PATH_BADGE = "org/netbeans/modules/visualweb/complib/ui/images/libraries_badge.png";
    private Project project;

    public ComplibsRootNode(Project project) {
        super((Children)new ComplibsChildren(project));
        this.project = project;
        this.setName("Complibs");
        this.setDisplayName(NbBundle.getMessage(ComplibsRootNode.class, (String)"ComplibsRootNode.displayName"));
        this.setShortDescription(NbBundle.getMessage(ComplibsRootNode.class, (String)"ComplibsRootNode.tooltip"));
        this.setValue("propertiesHelpID", "projrave_ui_elements_project_nav_node_complib_node");
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new AddComplibAction(this.project));
        String string = System.getProperty("complib.sharedCompLibs");
        if ("true".equalsIgnoreCase(string)) {
            arrayList.add((Object)new SharedComplibAction());
        }
        return arrayList.toArray(new Action[0]);
    }

    public Image getIcon(int n) {
        return ComplibsRootNode.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return ComplibsRootNode.computeIcon(true, n);
    }

    private static Image computeIcon(boolean bl, int n) {
        Node node = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        Image image = bl ? node.getOpenedIcon(n) : node.getIcon(n);
        Image image2 = ImageUtilities.loadImage((String)IMAGE_PATH_BADGE, (boolean)true);
        return ImageUtilities.mergeImages((Image)image, (Image)image2, (int)7, (int)7);
    }

    private static class RemoveComplibAction
    extends AbstractAction {
        private ExtensionComplib complib;
        private Project project;

        public RemoveComplibAction(ExtensionComplib extensionComplib, Project project) {
            super(NbBundle.getMessage(RemoveComplibAction.class, (String)"ComplibsRootNode.removeComplibAction"));
            this.complib = extensionComplib;
            this.project = project;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = NbBundle.getMessage(RemoveComplibAction.class, (String)"ComplibsRootNode.confirmRemoveComplib");
            string = MessageFormat.format(string, this.complib.getVersionedTitle());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
            confirmation.setMessageType(2);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.OK_OPTION == object) {
                try {
                    ComplibServiceProvider.getInstance().removeComplibFromProject(this.project, this.complib);
                }
                catch (IOException iOException) {
                    IdeUtil.logError("Unable to remove embedded complib from project", iOException);
                }
            }
        }
    }

    private static class UpgradeComplibAction
    extends ReplaceComplibAction {
        public UpgradeComplibAction(ExtensionComplib extensionComplib, Project project) {
            super(extensionComplib, project);
        }

        public JMenuItem getPopupPresenter() {
            String string = NbBundle.getMessage(UpgradeComplibAction.class, (String)"ComplibsRootNode.upgradeComplib");
            JMenu jMenu = new JMenu(string);
            ComplibServiceProvider.RelatedComplibs relatedComplibs = csp.getRelatedComplibs(this.origComplib);
            List<ExtensionComplib> list = relatedComplibs.getNewerComplibs();
            if (list.isEmpty()) {
                string = NbBundle.getMessage(ReplaceComplibAction.class, (String)"ComplibsRootNode.noUpgradableComplibs");
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setEnabled(false);
                jMenuItem.setToolTipText(UpgradeComplibAction.getComplibManagerToolTip());
                jMenu.add(jMenuItem);
                return jMenu;
            }
            for (ExtensionComplib extensionComplib : list) {
                UpgradeComplibAction upgradeComplibAction = new UpgradeComplibAction(this.origComplib, this.project);
                String string2 = extensionComplib.getVersionedTitle();
                upgradeComplibAction.putValue("Name", string2);
                upgradeComplibAction.putValue("NEW_COMPLIB", extensionComplib);
                upgradeComplibAction.putValue("ShortDescription", UpgradeComplibAction.getComplibManagerToolTip());
                JMenuItem jMenuItem = new JMenuItem(upgradeComplibAction);
                jMenu.add(jMenuItem);
            }
            return jMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExtensionComplib extensionComplib = UpgradeComplibAction.getNewComplib(actionEvent);
            if (extensionComplib == null) {
                return;
            }
            String string = NbBundle.getMessage(UpgradeComplibAction.class, (String)"ComplibsRootNode.confirmUpgradeComplib");
            string = MessageFormat.format(string, this.origComplib.getVersionedTitle(), extensionComplib.getVersionedTitle());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.OK_OPTION == object) {
                try {
                    csp.replaceProjectComplib(this.project, this.origComplib, extensionComplib);
                }
                catch (Exception exception) {
                    IdeUtil.logError("Unable to upgrade embedded complib in project", exception);
                }
            }
        }
    }

    private static class ReplaceComplibAction
    extends AbstractAction
    implements Presenter.Popup {
        protected static final String NEW_COMPLIB = "NEW_COMPLIB";
        protected static final ComplibServiceProvider csp = ComplibServiceProvider.getInstance();
        protected Project project;
        protected ExtensionComplib origComplib;

        public ReplaceComplibAction(ExtensionComplib extensionComplib, Project project) {
            this.project = project;
            this.origComplib = extensionComplib;
        }

        public JMenuItem getPopupPresenter() {
            String string = NbBundle.getMessage(ReplaceComplibAction.class, (String)"ComplibsRootNode.replaceComplib");
            JMenu jMenu = new JMenu(string);
            ComplibServiceProvider.RelatedComplibs relatedComplibs = csp.getRelatedComplibs(this.origComplib);
            List<ExtensionComplib> list = relatedComplibs.getOlderComplibs();
            if (list.isEmpty()) {
                string = NbBundle.getMessage(ReplaceComplibAction.class, (String)"ComplibsRootNode.noOlderComplibs");
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setEnabled(false);
                jMenuItem.setToolTipText(ReplaceComplibAction.getComplibManagerToolTip());
                jMenu.add(jMenuItem);
            } else {
                for (ExtensionComplib extensionComplib : list) {
                    ReplaceComplibAction replaceComplibAction = new ReplaceComplibAction(this.origComplib, this.project);
                    String string2 = extensionComplib.getVersionedTitle();
                    replaceComplibAction.putValue("Name", string2);
                    replaceComplibAction.putValue(NEW_COMPLIB, extensionComplib);
                    replaceComplibAction.putValue("ShortDescription", ReplaceComplibAction.getComplibManagerToolTip());
                    JMenuItem jMenuItem = new JMenuItem(replaceComplibAction);
                    jMenu.add(jMenuItem);
                }
            }
            return jMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExtensionComplib extensionComplib = ReplaceComplibAction.getNewComplib(actionEvent);
            if (extensionComplib == null) {
                return;
            }
            String string = NbBundle.getMessage(ReplaceComplibAction.class, (String)"ComplibsRootNode.confirmReplaceComplib");
            string = MessageFormat.format(string, this.origComplib.getVersionedTitle(), extensionComplib.getVersionedTitle());
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
            confirmation.setMessageType(2);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.OK_OPTION == object) {
                try {
                    csp.replaceProjectComplib(this.project, this.origComplib, extensionComplib);
                }
                catch (Exception exception) {
                    IdeUtil.logError("Unable to replace embedded complib in project", exception);
                }
            }
        }

        static ExtensionComplib getNewComplib(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof JMenuItem)) {
                return null;
            }
            JMenuItem jMenuItem = (JMenuItem)object;
            Action action = jMenuItem.getAction();
            if (!(action instanceof ReplaceComplibAction)) {
                return null;
            }
            ReplaceComplibAction replaceComplibAction = (ReplaceComplibAction)action;
            ExtensionComplib extensionComplib = (ExtensionComplib)replaceComplibAction.getValue(NEW_COMPLIB);
            if (extensionComplib == null) {
                return null;
            }
            return extensionComplib;
        }

        static String getComplibManagerToolTip() {
            return NbBundle.getMessage(ReplaceComplibAction.class, (String)"ComplibsRootNode.useComplibManager");
        }
    }

    private static class AddComplibAction
    extends AbstractAction {
        protected static final String NEW_COMPLIB = "NEW_COMPLIB";
        protected static final ComplibServiceProvider csp = ComplibServiceProvider.getInstance();
        protected Project project;

        public AddComplibAction(Project project) {
            super(NbBundle.getMessage(AddComplibAction.class, (String)"ComplibsRootNode.addComplibAction"));
            this.project = project;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = new JButton();
            String string = NbBundle.getMessage(ComplibsRootNode.class, (String)"ComplibsRootNode.addComplibBtn");
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)string);
            jButton.getAccessibleContext().setAccessibleDescription(string);
            jButton.setEnabled(false);
            Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
            ComplibChooser complibChooser = new ComplibChooser(jButton, this.project);
            String string2 = NbBundle.getMessage(ComplibsRootNode.class, (String)"ComplibsRootNode.addComplibTitle");
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)complibChooser, string2, true, objectArray, objectArray[0], 0, null, null);
            dialogDescriptor.setHelpCtx(new HelpCtx("projrave_ui_elements_dialogs_add_complib"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == objectArray[0]) {
                ArrayList<ExtensionComplib> arrayList = complibChooser.getSelectedComplibs();
                for (ExtensionComplib extensionComplib : arrayList) {
                    try {
                        csp.addProjectComplib(this.project, extensionComplib);
                    }
                    catch (Exception exception) {
                        IdeUtil.logError("Unable to embedded a complib into project", exception);
                    }
                }
            }
            dialog.dispose();
        }
    }

    private static class ComplibNode
    extends AbstractNode {
        private static final String COMPLIB_ICON_BASE = ComplibNode.class.getPackage().getName().replace('.', '/') + "/images/library.png";
        private Project project;
        private ExtensionComplib complib;

        public ComplibNode(ExtensionComplib extensionComplib, Project project) {
            super(Children.LEAF);
            this.complib = extensionComplib;
            this.project = project;
            this.setIconBaseWithExtension(COMPLIB_ICON_BASE);
            this.setName("complib");
            this.setDisplayName(extensionComplib.getVersionedTitle());
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{new UpgradeComplibAction(this.complib, this.project), new ReplaceComplibAction(this.complib, this.project), new RemoveComplibAction(this.complib, this.project)};
        }

        public boolean canCopy() {
            return false;
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = Sheet.createPropertiesSet();
            Node.Property property = this.getProperty("title", this.complib.getTitle());
            set.put(property);
            property = this.getProperty("namespaceUri", this.complib.getIdentifier().getNamespaceUriString());
            set.put(property);
            property = this.getProperty("version", this.complib.getIdentifier().getVersionString());
            set.put(property);
            sheet.put(set);
            return sheet;
        }

        private Node.Property getProperty(String string, final String string2) {
            String string3 = NbBundle.getMessage(ComplibNode.class, (String)("ComplibsRootNode." + string));
            PropertySupport.ReadOnly readOnly = new PropertySupport.ReadOnly(string, String.class, string3, null){

                public Object getValue() {
                    return string2;
                }
            };
            return readOnly;
        }
    }

    private static class ComplibsChildren
    extends Children.Keys
    implements ComplibListener {
        private static final ComplibServiceProvider csp = ComplibServiceProvider.getInstance();
        private Project project;

        ComplibsChildren(Project project) {
            this.project = project;
        }

        protected void addNotify() {
            csp.addComplibListener(this);
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            csp.removeComplibListener(this);
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            ExtensionComplib extensionComplib = (ExtensionComplib)object;
            ComplibNode complibNode = new ComplibNode(extensionComplib, this.project);
            return new Node[]{complibNode};
        }

        private List getKeys() {
            Set<ExtensionComplib> set = csp.getComplibsForProject(this.project);
            return new ArrayList<ExtensionComplib>(set);
        }

        public void paletteChanged(ComplibEvent complibEvent) {
            this.setKeys(this.getKeys());
        }
    }
}

