/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestProjectActionBase
extends NodeAction {
    protected static final boolean TEST_XREF = Boolean.getBoolean("test.xref.action");
    private boolean running;
    private JMenuItem presenter;
    private boolean inited = false;

    protected abstract void performAction(Collection<NativeProject> var1);

    public JMenuItem getMenuPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    private JMenuItem getPresenter() {
        if (!this.inited) {
            this.presenter = new JMenuItem();
            Actions.connect((JMenuItem)this.presenter, (Action)((Object)this), (boolean)true);
            this.inited = true;
        }
        Collection<NativeProject> collection = this.getNativeProjects(this.getActivatedNodes());
        if (TEST_XREF) {
            if (collection == null) {
                this.setEnabled(!this.running);
                this.presenter.setVisible(false);
            } else {
                try {
                    this.presenter.setVisible(true);
                    this.setEnabled(!this.running);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.setEnabled(false);
                }
            }
        } else {
            this.presenter.setVisible(false);
        }
        return this.presenter;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] nodeArray) {
        if (!TEST_XREF) {
            return false;
        }
        if (this.running) {
            return false;
        }
        Collection<NativeProject> collection = this.getNativeProjects(this.getActivatedNodes());
        if (collection == null) {
            return false;
        }
        return this.getState(collection) != State.Indeterminate;
    }

    public void performAction(Node[] nodeArray) {
        this.running = true;
        CsmModelAccessor.getModel().enqueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TestProjectActionBase.this.performAction(TestProjectActionBase.this.getNativeProjects(TestProjectActionBase.this.getActivatedNodes()));
                }
                finally {
                    TestProjectActionBase.this.running = false;
                }
            }
        }, (CharSequence)"Testing xRef");
    }

    protected boolean asynchronous() {
        return false;
    }

    protected Collection<NativeProject> getNativeProjects(Node[] nodeArray) {
        ArrayList<NativeProject> arrayList = new ArrayList<NativeProject>();
        for (int i = 0; i < nodeArray.length; ++i) {
            Object object = nodeArray[i].getValue("Project");
            if (!(object instanceof Project)) {
                return null;
            }
            NativeProject nativeProject = (NativeProject)((Project)object).getLookup().lookup(NativeProject.class);
            if (nativeProject == null) {
                return null;
            }
            arrayList.add(nativeProject);
        }
        return arrayList;
    }

    protected State getState(Collection<NativeProject> collection) {
        CsmModel csmModel = CsmModelAccessor.getModel();
        if (csmModel == null || csmModel.getState() != CsmModelState.ON) {
            return State.Indeterminate;
        }
        State state = State.Indeterminate;
        for (NativeProject nativeProject : collection) {
            State state2 = this.getState(nativeProject);
            if (state == State.Indeterminate) {
                state = state2;
                continue;
            }
            if (state == state2) continue;
            return State.Indeterminate;
        }
        return state;
    }

    private State getState(NativeProject nativeProject) {
        CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)nativeProject);
        return csmProject != null && csmProject.isStable(null) ? State.Enabled : State.Disabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        Enabled,
        Disabled,
        Indeterminate;

    }
}

