/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.jdbcwizard.wizards.BrowseFolders;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class SimpleTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private static final String NEW_FILE_PREFIX = NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_SimpleTargetChooserPanelGUI_NewFilePrefix");
    private final ListCellRenderer CELL_RENDERER = new GroupCellRenderer();
    private Project project;
    private String expectedExtension;
    private final List listeners = new ArrayList();
    private SourceGroup[] folders;
    private boolean isFolder;
    private FileObject mFolderRoot = null;
    private static final String mFolderText = "";
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;

    public SimpleTargetChooserPanelGUI(Project project, SourceGroup[] sourceGroupArray, Component component, boolean bl) {
        this.project = project;
        this.folders = sourceGroupArray;
        this.isFolder = bl;
        this.initComponents();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (component != null) {
            this.bottomPanelContainer.add(component, "Center");
        }
        this.initValues(null, null);
        this.browseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
    }

    public void initValues(FileObject fileObject, FileObject fileObject2) {
        assert (this.project != null);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.folders = sources.getSourceGroups("generic");
        if (this.folders == null || this.folders.length < 1) {
            this.folders = sources.getSourceGroups("generic");
        }
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup sourceGroup = this.getPreselectedGroup(this.folders, fileObject2);
        this.locationComboBox.setSelectedItem(sourceGroup);
        this.folderTextField.setText(this.getRelativeNativeName(sourceGroup.getRootFolder(), fileObject2));
        this.mFolderRoot = fileObject2;
        String string = fileObject == null ? mFolderText : fileObject.getExt();
        this.expectedExtension = string.length() == 0 ? mFolderText : "." + string;
        String string2 = null;
        try {
            if (fileObject != null) {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                string2 = dataObject.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string2 = fileObject.getName();
        }
        this.putClientProperty("NewDtelWizard_Title", string2);
        if (fileObject != null) {
            this.documentNameTextField.setText(NEW_FILE_PREFIX + fileObject.getName());
            this.documentNameTextField.selectAll();
        }
        if (this.isFolder) {
            this.jLabel3.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_FolderName_Label"));
            this.jLabel3.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_FileName_Label").charAt(0));
            this.jLabel2.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_ParentFolder_Label"));
            this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_ParentFolder_Label").charAt(0));
            this.jLabel4.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_CreatedFolder_Label"));
            this.jLabel4.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_CreatedFolder_Label").charAt(0));
        } else {
            this.jLabel3.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_FileName_Label"));
            this.jLabel2.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_Folder_Label"));
            this.jLabel4.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_CreatedFile_Label"));
            this.jLabel3.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_FileName_Label").charAt(0));
            this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_Folder_Label").charAt(0));
            this.jLabel4.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_CreatedFile_Label").charAt(0));
        }
    }

    public SourceGroup getTargetGroup() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getTargetFolder() {
        String string = this.folderTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String string = this.documentNameTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.listeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((ChangeListener)object.next()).stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel3.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_FileName_Label").charAt(0));
        this.jLabel3.setLabelFor(this.documentNameTextField);
        this.jLabel3.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_FileName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_Project_Label").charAt(0));
        this.jLabel1.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_Project_Label"));
        this.jLabel1.setLabelFor(this.projectTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_projectTextField"));
        this.locationLabel.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_Location_Label").charAt(0));
        this.locationLabel.setLabelFor(this.locationComboBox);
        this.locationLabel.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.locationComboBox, gridBagConstraints);
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_locationComboBox"));
        this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_ParentFolder_Label").charAt(0));
        this.jLabel2.setLabelFor(this.folderTextField);
        this.jLabel2.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_folderTextField"));
        this.browseButton.setMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_Browse_Button").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_browseButton"));
        this.jLabel4.setDisplayedMnemonic(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"MNE_TargetChooser_CreatedFile_Label").charAt(0));
        this.jLabel4.setText(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LABEL_TargetChooser_CreatedFile_Label"));
        this.jLabel4.setLabelFor(this.fileTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        for (int i = 0; fileObject != null && i < sourceGroupArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
            return sourceGroupArray[i];
        }
        return sourceGroupArray[0];
    }

    private String getRelativeNativeName(FileObject fileObject, FileObject fileObject2) {
        if (fileObject == null) {
            throw new IllegalArgumentException("null root passed to getRelativeNativeName");
        }
        String string = fileObject2 == null ? mFolderText : FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
        return string == null ? mFolderText : string.replace('/', File.separatorChar);
    }

    private void updateCreatedFolder() {
        FileObject fileObject = ((SourceGroup)this.locationComboBox.getSelectedItem()).getRootFolder();
        String string = this.folderTextField.getText().trim();
        String string2 = this.documentNameTextField.getText().trim();
        String string3 = FileUtil.getFileDisplayName((FileObject)fileObject) + (string.startsWith("/") || string.startsWith(File.separator) ? mFolderText : "/") + string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? mFolderText : "/") + string2 + this.expectedExtension;
        this.fileTextField.setText(string3.replace('/', File.separatorChar));
        this.fireChange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
            fileObject = BrowseFolders.showDialog(new SourceGroup[]{sourceGroup}, this.project, this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fileObject != null && fileObject.isFolder()) {
                String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
                this.folderTextField.setText(string.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == actionEvent.getSource()) {
            this.updateCreatedFolder();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFolder();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFolder();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFolder();
    }

    private class GroupCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public GroupCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof SourceGroup) {
                String string;
                SourceGroup sourceGroup = (SourceGroup)object;
                String string2 = ProjectUtils.getInformation((Project)SimpleTargetChooserPanelGUI.this.project).getDisplayName();
                if (string2.equals(string = sourceGroup.getDisplayName())) {
                    this.setText(string);
                } else {
                    this.setText(MessageFormat.format(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"FMT_TargetChooser_GroupProjectNameBadge"), string, string2));
                }
                this.setIcon(sourceGroup.getIcon(false));
            } else {
                this.setText(object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

