/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.dbmodel.impl;

import java.util.logging.Logger;
import org.netbeans.modules.jdbcwizard.builder.DBMetaData;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;

public class DBColumnImpl
implements DBColumn,
Cloneable,
Comparable {
    public static final String UNKNOWN_TYPE = "unknown";
    public static final int NOT_ASSIGNED = -562471;
    private static final String LOG_CATEGORY = DBColumnImpl.class.getName();
    protected String name;
    protected boolean pkFlag;
    protected boolean fkFlag;
    protected boolean indexed;
    protected boolean nullable;
    protected boolean editable = true;
    protected boolean insertEditable = true;
    protected boolean insertSelected = true;
    protected boolean updateSelected = true;
    protected boolean chooseSelected = true;
    protected boolean pollSelected = true;
    protected int jdbcType;
    protected int precision;
    protected int scale;
    protected DBTable parent;
    protected String javaName;
    protected String javaType;
    protected String defaultValue;
    protected int cardinalPosition;
    protected String sqlType;
    private static final Logger mLogger = Logger.getLogger(LOG_CATEGORY);

    public void setName(String string) {
        this.name = string;
    }

    public void setSqlType(String string) {
        this.sqlType = string;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public DBColumnImpl(String string, int n, int n2, int n3, boolean bl) {
        this.name = string;
        this.jdbcType = n;
        this.precision = n3;
        this.scale = n2;
        this.nullable = bl;
    }

    public DBColumnImpl(String string, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, n, n2, n3, bl4);
        this.pkFlag = bl;
        this.fkFlag = bl2;
        this.indexed = bl3;
    }

    public DBColumnImpl() {
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimaryKey() {
        return this.pkFlag;
    }

    public boolean isForeignKey() {
        return this.fkFlag;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public DBTable getParent() {
        return this.parent;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getJdbcTypeString() {
        return DBMetaData.getSQLTypeDescription(this.jdbcType);
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public void setJdbcType(int n) {
        this.jdbcType = n;
    }

    public void setPrimaryKey(boolean bl) {
        this.pkFlag = bl;
    }

    public void setForeignKey(boolean bl) {
        this.fkFlag = bl;
    }

    public void setIndexed(boolean bl) {
        this.indexed = bl;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public void setParent(DBTable dBTable) {
        this.parent = dBTable;
    }

    public Object clone() {
        try {
            DBColumnImpl dBColumnImpl = (DBColumnImpl)super.clone();
            return dBColumnImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DBColumn)) {
            return false;
        }
        DBColumnImpl dBColumnImpl = (DBColumnImpl)object;
        boolean bl = this.name != null ? this.name.equals(dBColumnImpl.name) : dBColumnImpl.name == null;
        bl &= this.jdbcType == dBColumnImpl.jdbcType && this.pkFlag == dBColumnImpl.pkFlag && this.fkFlag == dBColumnImpl.fkFlag && this.indexed == dBColumnImpl.indexed && this.nullable == dBColumnImpl.nullable && this.scale == dBColumnImpl.scale && this.precision == dBColumnImpl.precision;
        return bl &= this.parent != null ? this.parent.equals(dBColumnImpl.parent) : dBColumnImpl.parent == null;
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n += this.jdbcType + 10 * this.scale + 100 * this.precision;
        n += this.pkFlag ? 1 : 0;
        n += this.fkFlag ? 2 : 0;
        n += this.indexed ? 4 : 0;
        n += this.nullable ? 8 : 0;
        return n += this.parent != null ? this.parent.hashCode() : 0;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        if (object == this) {
            return 0;
        }
        String string = ((DBColumn)object).getName();
        return this.name != null ? this.name.compareTo(string) : (string != null ? 1 : -1);
    }

    public void copyFrom(DBColumn dBColumn) {
        this.name = dBColumn.getName();
        this.jdbcType = dBColumn.getJdbcType();
        this.scale = dBColumn.getScale();
        this.precision = dBColumn.getPrecision();
        this.pkFlag = dBColumn.isPrimaryKey();
        this.fkFlag = dBColumn.isForeignKey();
        this.indexed = dBColumn.isIndexed();
        this.nullable = dBColumn.isNullable();
        this.parent = dBColumn.getParent();
    }

    public String getJavaName() {
        return this.javaName != null ? this.javaName : this.name;
    }

    public void setJavaName(String string) {
        this.javaName = string;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String string) {
        this.javaType = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getOrdinalPosition() {
        return this.cardinalPosition;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setOrdinalPosition(int n) {
        this.cardinalPosition = n;
    }

    public boolean isInsertSelected() {
        return this.insertSelected;
    }

    public boolean isUpdateSelected() {
        return this.updateSelected;
    }

    public boolean isChooseSelected() {
        return this.chooseSelected;
    }

    public boolean isPollSelected() {
        return this.pollSelected;
    }

    public boolean isSelected() {
        return this.insertSelected && this.updateSelected && this.chooseSelected && this.pollSelected;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isInsertEditable() {
        return this.insertEditable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setInsertEditable(boolean bl) {
        this.insertEditable = bl;
    }

    public void setInsertSelected(boolean bl) {
        this.insertSelected = bl;
    }

    public void setUpdateSelected(boolean bl) {
        this.updateSelected = bl;
    }

    public void setChooseSelected(boolean bl) {
        this.chooseSelected = bl;
    }

    public void setPollSelected(boolean bl) {
        this.pollSelected = bl;
    }

    public void setSelected(boolean bl) {
        this.setInsertSelected(bl);
        this.setUpdateSelected(bl);
        this.setChooseSelected(bl);
        this.setPollSelected(bl);
    }
}

