/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.modules.project.rake.UserQuestionHandler;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

public final class GeneratedFilesHelper {
    public static final String BUILD_XML_PATH = "build.xml";
    public static final String BUILD_IMPL_XML_PATH = "nbproject/build-impl.xml";
    static final String GENFILES_PROPERTIES_PATH = "nbproject/genfiles.properties";
    private static final String KEY_SUFFIX_DATA_CRC = ".data.CRC32";
    private static final String KEY_SUFFIX_STYLESHEET_CRC = ".stylesheet.CRC32";
    private static final String KEY_SUFFIX_SCRIPT_CRC = ".script.CRC32";
    public static final int FLAG_MISSING = 2;
    public static final int FLAG_MODIFIED = 4;
    public static final int FLAG_OLD_PROJECT_XML = 8;
    public static final int FLAG_OLD_STYLESHEET = 16;
    public static final int FLAG_UNKNOWN = 32;
    private final RakeProjectHelper h;
    private final FileObject dir;
    private static final Map<URL, String> crcCache = new HashMap<URL, String>();
    private static final Map<URL, Long> crcCacheTimestampsXorSizes = new HashMap<URL, Long>();

    public GeneratedFilesHelper(RakeProjectHelper rakeProjectHelper) {
        this.h = rakeProjectHelper;
        this.dir = rakeProjectHelper.getProjectDirectory();
    }

    public GeneratedFilesHelper(FileObject fileObject) {
        if (fileObject == null || !fileObject.isFolder() || fileObject.getFileObject("nbproject/project.xml") == null) {
            throw new IllegalArgumentException("Does not look like an Ant-based project: " + fileObject);
        }
        this.h = null;
        this.dir = fileObject;
    }

    public void generateBuildScriptFromStylesheet(final String string, final URL uRL) throws IOException, IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (uRL == null) {
            throw new IllegalArgumentException("Null stylesheet");
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    if (GeneratedFilesHelper.this.h != null && GeneratedFilesHelper.this.h.isProjectXmlModified()) {
                        throw new IllegalStateException("Cannot generate build scripts from a modified project");
                    }
                    GeneratedFilesHelper.this.dir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            byte[] byArray;
                            Object object;
                            Object object2;
                            Transformer transformer;
                            Object object3;
                            byte[] byArray2;
                            byte[] byArray3;
                            FileObject fileObject = GeneratedFilesHelper.this.dir.getFileObject("nbproject/project.xml");
                            final FileObject fileObject2 = FileUtil.createData((FileObject)GeneratedFilesHelper.this.dir, (String)string);
                            InputStream inputStream = fileObject.getInputStream();
                            try {
                                byArray3 = GeneratedFilesHelper.load(inputStream);
                            }
                            finally {
                                inputStream.close();
                            }
                            inputStream = uRL.openStream();
                            try {
                                byArray2 = GeneratedFilesHelper.load(inputStream);
                            }
                            finally {
                                inputStream.close();
                            }
                            TransformerFactory transformerFactory = TransformerFactory.newInstance();
                            try {
                                object3 = new StreamSource(new ByteArrayInputStream(byArray2), uRL.toExternalForm());
                                transformer = transformerFactory.newTransformer((Source)object3);
                                object2 = FileUtil.toFile((FileObject)fileObject);
                                assert (object2 != null);
                                object = new StreamSource(new ByteArrayInputStream(byArray3), ((File)object2).toURI().toString());
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                transformer.transform((Source)object, new StreamResult(byteArrayOutputStream));
                                byArray = byteArrayOutputStream.toByteArray();
                            }
                            catch (TransformerException transformerException) {
                                throw (IOException)new IOException(transformerException.toString()).initCause(transformerException);
                            }
                            object3 = new EditableProperties(true);
                            transformer = GeneratedFilesHelper.this.dir.getFileObject(GeneratedFilesHelper.GENFILES_PROPERTIES_PATH);
                            if (transformer != null && transformer.isVirtual()) {
                                transformer = null;
                            }
                            if (transformer != null) {
                                inputStream = transformer.getInputStream();
                                try {
                                    ((EditableProperties)object3).load(inputStream);
                                }
                                finally {
                                    inputStream.close();
                                }
                            }
                            ((EditableProperties)object3).setProperty(string + GeneratedFilesHelper.KEY_SUFFIX_DATA_CRC, GeneratedFilesHelper.getCrc32(new ByteArrayInputStream(byArray3), fileObject));
                            if (transformer == null) {
                                ((EditableProperties)object3).setComment(string + GeneratedFilesHelper.KEY_SUFFIX_DATA_CRC, new String[]{"# " + NbBundle.getMessage(GeneratedFilesHelper.class, (String)"COMMENT_genfiles.properties_1"), "# " + NbBundle.getMessage(GeneratedFilesHelper.class, (String)"COMMENT_genfiles.properties_2")}, false);
                            }
                            ((EditableProperties)object3).setProperty(string + GeneratedFilesHelper.KEY_SUFFIX_STYLESHEET_CRC, GeneratedFilesHelper.getCrc32(new ByteArrayInputStream(byArray2), uRL));
                            ((EditableProperties)object3).setProperty(string + GeneratedFilesHelper.KEY_SUFFIX_SCRIPT_CRC, GeneratedFilesHelper.computeCrc32(new ByteArrayInputStream(byArray)));
                            if (transformer == null) {
                                transformer = FileUtil.createData((FileObject)GeneratedFilesHelper.this.dir, (String)GeneratedFilesHelper.GENFILES_PROPERTIES_PATH);
                            }
                            object2 = transformer;
                            object = new FileSystem.AtomicAction((FileObject)object2, byArray, (EditableProperties)object3){
                                final /* synthetic */ FileObject val$_genfiles;
                                final /* synthetic */ byte[] val$resultData;
                                final /* synthetic */ EditableProperties val$p;
                                {
                                    this.val$_genfiles = fileObject22;
                                    this.val$resultData = byArray;
                                    this.val$p = editableProperties;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() throws IOException {
                                    FileLock fileLock = fileObject2.lock();
                                    try {
                                        FileLock fileLock2 = this.val$_genfiles.lock();
                                        try {
                                            EolFilterOutputStream eolFilterOutputStream = new EolFilterOutputStream(fileObject2.getOutputStream(fileLock));
                                            try {
                                                OutputStream outputStream = this.val$_genfiles.getOutputStream(fileLock2);
                                                try {
                                                    ((OutputStream)eolFilterOutputStream).write(this.val$resultData);
                                                    this.val$p.store(outputStream);
                                                }
                                                finally {
                                                    outputStream.close();
                                                }
                                            }
                                            finally {
                                                ((OutputStream)eolFilterOutputStream).close();
                                            }
                                        }
                                        finally {
                                            fileLock2.releaseLock();
                                        }
                                    }
                                    finally {
                                        fileLock.releaseLock();
                                    }
                                }
                            };
                            try {
                                object.run();
                            }
                            catch (UserQuestionException userQuestionException) {
                                UserQuestionHandler.handle(userQuestionException, new UserQuestionHandler.Callback((FileSystem.AtomicAction)object){
                                    final /* synthetic */ FileSystem.AtomicAction val$body;
                                    {
                                        this.val$body = atomicAction;
                                    }

                                    public void accepted() {
                                        try {
                                            this.val$body.run();
                                        }
                                        catch (UserQuestionException userQuestionException) {
                                            UserQuestionHandler.handle(userQuestionException, new UserQuestionHandler.Callback(){

                                                public void accepted() {
                                                    try {
                                                        val$body.run();
                                                    }
                                                    catch (IOException iOException) {
                                                        ErrorManager.getDefault().notify((Throwable)iOException);
                                                    }
                                                }

                                                public void denied() {
                                                }

                                                public void error(IOException iOException) {
                                                    ErrorManager.getDefault().notify((Throwable)iOException);
                                                }
                                            });
                                        }
                                        catch (IOException iOException) {
                                            ErrorManager.getDefault().notify((Throwable)iOException);
                                        }
                                    }

                                    public void denied() {
                                    }

                                    public void error(IOException iOException) {
                                        ErrorManager.getDefault().notify((Throwable)iOException);
                                    }
                                });
                            }
                        }
                    });
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static byte[] load(InputStream inputStream) throws IOException {
        int n;
        int n2 = Math.max(1024, inputStream.available());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getBuildScriptState(final String string, final URL uRL) throws IllegalStateException {
        try {
            return (Integer)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Integer run() throws IOException {
                    String string2;
                    if (GeneratedFilesHelper.this.h != null && GeneratedFilesHelper.this.h.isProjectXmlModified()) {
                        throw new IllegalStateException("Cannot generate build scripts from a modified project");
                    }
                    FileObject fileObject = GeneratedFilesHelper.this.dir.getFileObject(string);
                    if (fileObject == null || fileObject.isVirtual()) {
                        return 2;
                    }
                    int n = 0;
                    Properties properties = new Properties();
                    FileObject fileObject2 = GeneratedFilesHelper.this.dir.getFileObject(GeneratedFilesHelper.GENFILES_PROPERTIES_PATH);
                    if (fileObject2 == null || fileObject2.isVirtual()) {
                        return 60;
                    }
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject2.getInputStream());
                    try {
                        properties.load(bufferedInputStream);
                    }
                    finally {
                        ((InputStream)bufferedInputStream).close();
                    }
                    FileObject fileObject3 = GeneratedFilesHelper.this.dir.getFileObject("nbproject/project.xml");
                    if (fileObject3 != null && !fileObject3.isVirtual()) {
                        string2 = GeneratedFilesHelper.getCrc32(fileObject3);
                        if (!string2.equals(properties.getProperty(string + GeneratedFilesHelper.KEY_SUFFIX_DATA_CRC))) {
                            n |= 8;
                        }
                    } else {
                        n |= 8;
                    }
                    string2 = GeneratedFilesHelper.getCrc32(uRL);
                    if (!string2.equals(properties.getProperty(string + GeneratedFilesHelper.KEY_SUFFIX_STYLESHEET_CRC))) {
                        n |= 0x10;
                    }
                    if (!(string2 = GeneratedFilesHelper.getCrc32(fileObject)).equals(properties.getProperty(string + GeneratedFilesHelper.KEY_SUFFIX_SCRIPT_CRC))) {
                        n |= 4;
                    }
                    return n;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify(1, (Throwable)((IOException)mutexException.getException()));
            return 60;
        }
    }

    static String computeCrc32(InputStream inputStream) throws IOException {
        int n;
        CRC32 cRC32 = new CRC32();
        int n2 = -1;
        while ((n = inputStream.read()) != -1) {
            if (n != 10 && n2 == 13) {
                cRC32.update(10);
            }
            if (n != 13) {
                cRC32.update(n);
            }
            n2 = n;
        }
        if (n2 == 13) {
            cRC32.update(10);
        }
        int n3 = (int)cRC32.getValue();
        String string = Integer.toHexString(n3);
        while (string.length() < 8) {
            string = "0" + string;
        }
        return string;
    }

    private static synchronized String findCachedCrc32(URL uRL, long l) {
        String string = crcCache.get(uRL);
        if (string != null) {
            Long l2 = crcCacheTimestampsXorSizes.get(uRL);
            assert (l2 != null);
            if (l2 == l) {
                return string;
            }
        }
        return null;
    }

    private static synchronized void cacheCrc32(String string, URL uRL, long l) {
        crcCache.put(uRL, string);
        crcCacheTimestampsXorSizes.put(uRL, l);
    }

    private static String getCrc32(InputStream inputStream, FileObject fileObject) throws IOException {
        URL uRL = fileObject.getURL();
        fileObject.refresh();
        long l = fileObject.lastModified().getTime() ^ fileObject.getSize();
        String string = GeneratedFilesHelper.findCachedCrc32(uRL, l);
        if (string == null) {
            string = GeneratedFilesHelper.computeCrc32(inputStream);
            GeneratedFilesHelper.cacheCrc32(string, uRL, l);
        }
        return string;
    }

    private static long checkFootprint(URL uRL) {
        URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
        if (uRL2 != null) {
            uRL = uRL2;
        }
        if (uRL.getProtocol().equals("file")) {
            File file = new File(URI.create(uRL.toExternalForm()));
            return file.lastModified() ^ file.length();
        }
        return 0L;
    }

    private static String getCrc32(InputStream inputStream, URL uRL) throws IOException {
        long l = GeneratedFilesHelper.checkFootprint(uRL);
        String string = null;
        if (l != 0L) {
            string = GeneratedFilesHelper.findCachedCrc32(uRL, l);
        }
        if (string == null) {
            string = GeneratedFilesHelper.computeCrc32(inputStream);
            if (l != 0L) {
                GeneratedFilesHelper.cacheCrc32(string, uRL, l);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCrc32(FileObject fileObject) throws IOException {
        URL uRL = fileObject.getURL();
        fileObject.refresh();
        long l = fileObject.lastModified().getTime() ^ fileObject.getSize();
        String string = GeneratedFilesHelper.findCachedCrc32(uRL, l);
        if (string == null) {
            InputStream inputStream = fileObject.getInputStream();
            try {
                string = GeneratedFilesHelper.computeCrc32(new BufferedInputStream(inputStream));
                GeneratedFilesHelper.cacheCrc32(string, uRL, l);
            }
            finally {
                inputStream.close();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCrc32(URL uRL) throws IOException {
        long l = GeneratedFilesHelper.checkFootprint(uRL);
        String string = null;
        if (l != 0L) {
            string = GeneratedFilesHelper.findCachedCrc32(uRL, l);
        }
        if (string == null) {
            InputStream inputStream = uRL.openStream();
            try {
                string = GeneratedFilesHelper.computeCrc32(new BufferedInputStream(inputStream));
                if (l != 0L) {
                    GeneratedFilesHelper.cacheCrc32(string, uRL, l);
                }
            }
            finally {
                inputStream.close();
            }
        }
        return string;
    }

    public boolean refreshBuildScript(final String string, final URL uRL, final boolean bl) throws IOException, IllegalStateException {
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    int n = GeneratedFilesHelper.this.getBuildScriptState(string, uRL);
                    if (GeneratedFilesHelper.shouldGenerateBuildScript(n, bl)) {
                        GeneratedFilesHelper.this.generateBuildScriptFromStylesheet(string, uRL);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static boolean shouldGenerateBuildScript(int n, boolean bl) {
        if ((n & 2) != 0) {
            return true;
        }
        if ((n & 4) != 0) {
            return false;
        }
        if (!bl) {
            return true;
        }
        return (n & 0x18) != 0;
    }

    private static class EolFilterOutputStream
    extends BufferedOutputStream {
        private boolean isActive = Utilities.isWindows();
        private int last = -1;

        public EolFilterOutputStream(OutputStream outputStream) {
            super(outputStream, 4096);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.isActive) {
                for (int i = n; i < n + n2; ++i) {
                    this.write(byArray[i]);
                }
            } else {
                super.write(byArray, n, n2);
            }
        }

        public void write(int n) throws IOException {
            if (this.isActive) {
                if (n == 10 && this.last != 13) {
                    super.write(13);
                }
                this.last = n;
            }
            super.write(n);
        }
    }
}

