/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticEntitiesProvider {
    private List<SemanticEntity> list = new ArrayList<SemanticEntity>();

    public List<SemanticEntity> get() {
        return this.list;
    }

    private SemanticEntity getInactiveCode() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.INACTIVE_CODE){

            public String getName() {
                return "inactive";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.getInactiveCodeBlocks(csmFile);
            }
        };
    }

    private SemanticEntity getFields() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.CLASS_FIELD){

            public String getName() {
                return "class-fields";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.collect(csmFile, this.getCollector());
            }

            @Override
            public ReferenceCollector getCollector() {
                return new ModelUtils.FieldReferenceCollector();
            }
        };
    }

    private SemanticEntity getFunctions() {
        return new AbstractSemanticEntity(){

            public String getName() {
                return "functions-names";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.collect(csmFile, this.getCollector());
            }

            @Override
            public ReferenceCollector getCollector() {
                return new ModelUtils.FunctionReferenceCollector();
            }

            @Override
            public void updateFontColors(FontColorProvider fontColorProvider) {
                this.color = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Bold, Boolean.TRUE});
            }
        };
    }

    private SemanticEntity getMacros() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.USER_MACRO){
            protected AttributeSet sysMacroColors;

            public String getName() {
                return "macros";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.getMacroBlocks(csmFile);
            }

            @Override
            public AttributeSet getAttributes(CsmOffsetable csmOffsetable) {
                CsmMacro csmMacro = (CsmMacro)((CsmReference)csmOffsetable).getReferencedObject();
                return csmMacro == null || !csmMacro.isSystem() ? this.color : this.sysMacroColors;
            }

            @Override
            public void updateFontColors(FontColorProvider fontColorProvider) {
                super.updateFontColors(fontColorProvider);
                this.sysMacroColors = 4.getFontColor(fontColorProvider, FontColorProvider.Entity.SYSTEM_MACRO);
            }
        };
    }

    private SemanticEntity getTypedefs() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.TYPEDEF){

            public String getName() {
                return "typedefs";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.collect(csmFile, this.getCollector());
            }

            @Override
            public ReferenceCollector getCollector() {
                return new ModelUtils.TypedefReferenceCollector();
            }
        };
    }

    private SemanticEntity getUnusedVariables() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.UNUSED_VARIABLES){
            private final AttributeSet UNUSED_TOOLTIP;
            {
                this.UNUSED_TOOLTIP = AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"UNUSED_VARIABLE_TOOLTIP")});
            }

            public String getName() {
                return "unused-variables";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.collect(csmFile, this.getCollector());
            }

            @Override
            public ReferenceCollector getCollector() {
                return new ModelUtils.UnusedVariableCollector();
            }

            @Override
            public void updateFontColors(FontColorProvider fontColorProvider) {
                super.updateFontColors(fontColorProvider);
                this.color = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.UNUSED_TOOLTIP, this.color});
            }
        };
    }

    private SemanticEntitiesProvider() {
        this.list.add(this.getInactiveCode());
        if (!HighlighterBase.MINIMAL) {
            this.list.add(this.getMacros());
            this.list.add(this.getFields());
            this.list.add(this.getFunctions());
            this.list.add(this.getTypedefs());
            this.list.add(this.getUnusedVariables());
        }
    }

    public static SemanticEntitiesProvider instance() {
        return Instantiator.instance;
    }

    private static class Instantiator {
        static SemanticEntitiesProvider instance = new SemanticEntitiesProvider();

        private Instantiator() {
        }
    }

    private static abstract class AbstractSemanticEntity
    implements SemanticEntity {
        protected AttributeSet color;
        private final FontColorProvider.Entity entity;
        private static final AttributeSet cleanUp = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, null, StyleConstants.StrikeThrough, null, StyleConstants.Background, null, EditorStyleConstants.WaveUnderlineColor, null, EditorStyleConstants.Tooltip, null});

        public AbstractSemanticEntity() {
            this.entity = null;
        }

        public AbstractSemanticEntity(FontColorProvider.Entity entity) {
            this.entity = entity;
        }

        public void updateFontColors(FontColorProvider fontColorProvider) {
            assert (this.entity != null);
            this.color = AbstractSemanticEntity.getFontColor(fontColorProvider, this.entity);
        }

        protected static AttributeSet getFontColor(FontColorProvider fontColorProvider, FontColorProvider.Entity entity) {
            AttributeSet attributeSet = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{fontColorProvider.getColor(entity), cleanUp});
            return attributeSet;
        }

        public AttributeSet getAttributes(CsmOffsetable csmOffsetable) {
            return this.color;
        }

        public ReferenceCollector getCollector() {
            return null;
        }

        public boolean isEnabledByDefault() {
            return true;
        }
    }
}

